#ifndef _EFFECT_CALC_POS_H
#define _EFFECT_CALC_POS_H

#ifdef __cplusplus
extern "C"
{
#endif
#include "EffectEngine.h"
#include "zcore_type.h"
/********************************************************************************************
    :  GetSinValueByDegree
   ˵ :  ָǶȶӦsinֵ
        :  degree :Ƕֵ
        :  ָǶȶӦsinֵ
       ע :  0.0001
*********************************************************************************************/
ZDOUBLE GetSinValueByDegree(ZSINT32 degree);

/********************************************************************************************
    :  GetCosValueByDegree
   ˵ :  ָǶȶӦcosֵ
        :  degree :Ƕֵ
        :  ָǶȶӦcosֵ
       ע :  0.0001
*********************************************************************************************/
ZDOUBLE GetCosValueByDegree(ZSINT32 degree);

typedef ZSINT32 (*pFuncCalcRelativePos) (ZSINT32 fStartPos, ZSINT32 fEndPos,
                                 ZSINT32 *pfpos, ZSINT32 iCount);
/********************************************************************************************
    :CalcRelativePos_Linear
   ˵ : ˶ĵĹ켣
        :fStartPos : ʼλ
   			 fEndPos   : λ
   			 iCount    : ˶ʱ
        :pfPos     : 飬洢
       ע : ˴Թ켣Ϊ˱⸡㣬߼ٶȣ˴ļ1024
   			 pfposiCount+1Ԫ
*********************************************************************************************/
ZSINT32 CalcRelativePos_Linear(ZSINT32 fStartPos, ZSINT32 fEndPos, ZSINT32*pfPos, ZSINT32 iCount);

/********************************************************************************************
    :CalcRelativePos_Sinus
   ˵ : sin˶ĵĹ켣
        :fStartPos : ʼλ
   			 fEndPos   : λ
   			 iCount    : ˶ʱ
        :pfPos     : 飬洢
       ע : ˴Թ켣Ϊ˱⸡㣬߼ٶȣ˴ļ1024
   			 pfposiCount+1Ԫ
*********************************************************************************************/
ZSINT32 CalcRelativePos_Sinus(ZSINT32 fStartPos, ZSINT32 fEndPos,ZSINT32 *pfpos, ZSINT32 iCount);

/********************************************************************************************
    :CalcRelativePos_Accelerate
   ˵ : ȼ˶ĵĹ켣
        :fStartPos : ʼλ
   			 fEndPos   : λ
   			 iCount    : ˶ʱ
        :pfPos     : 飬洢
       ע : ˴Թ켣Ϊ˱⸡㣬߼ٶȣ˴ļ1024
   			 pfposiCount+1Ԫ
*********************************************************************************************/
ZSINT32 CalcRelativePos_Accelerate(ZSINT32 fStartPos, ZSINT32 fEndPos, ZSINT32 *pfpos, ZSINT32 iCount);
/********************************************************************************************
    :CalcRelativePos_Decelerate
   ˵ : ȼ˶ĵĹ켣
        :fStartPos : ʼλ
   			 fEndPos   : λ
   			 iCount    : ˶ʱ
        :pfPos     : 飬洢
       ע : ˴Թ켣Ϊ˱⸡㣬߼ٶȣ˴ļ1024
   			 pfposiCount+1Ԫ
*********************************************************************************************/
ZSINT32 CalcRelativePos_Decelerate(ZSINT32 fStartPos, ZSINT32 fEndPos, ZSINT32 *pfPos, ZSINT32 iCount);

/********************************************************************************************
    :CalcRelativePos_Accel_Decel
   ˵ : ˶ĵĹ켣
        :fStartPos : ʼλ
   			 fEndPos   : λ
   			 iCount    : ˶ʱ
        :pfPos     : 飬洢
       ע : ˴Թ켣Ϊ˱⸡㣬߼ٶȣ˴ļ1024
   			 pfposiCount+1Ԫ
*********************************************************************************************/
ZSINT32 CalcRelativePos_Accel_Decel(ZSINT32 fStartPos, ZSINT32 fEndPos, ZSINT32 *pfpos, ZSINT32 iCount);

/********************************************************************************************
    :CalcRelativePos_Bounce
   ˵ : 㷴ЧĵĹ켣
        :fStartPos : ʼλ
   			 fEndPos   : λ
   			 iCount    : ˶ʱ
        :pfPos     : 飬洢
       ע : ˴Թ켣Ϊ˱⸡㣬߼ٶȣ˴ļ1024
   			 pfposiCount+1Ԫء˴ĲҪЧе
*********************************************************************************************/
ZSINT32 CalcRelativePos_Bounce(ZSINT32 fStartPos, ZSINT32 fEndPos, ZSINT32 *pfPos, ZSINT32 iCount);

/********************************************************************************************
    :CalcRelativePos_OverstepInEnd
   ˵ : ͹켣˶λ(λ)
        :fStartPos : ʼλ
   			 fEndPos   : λ
   			 iCount    : ˶ʱ
        :pfPos     : 飬洢
       ע : ˴Թ켣Ϊ˱⸡㣬߼ٶȣ˴ļ1024
   			 pfposiCount+1Ԫ
*********************************************************************************************/
ZSINT32 CalcRelativePos_OverstepInEnd(ZSINT32 fStartPos, ZSINT32 fEndPos, ZSINT32 *pfPos, ZSINT32 iCount);

/********************************************************************************************
    :CalcRelativePos_OverstepInStart
   ˵ : ͹켣˶λ(ʼλ)
        :fStartPos : ʼλ
   			 fEndPos   : λ
   			 iCount    : ˶ʱ
        :pfPos     : 飬洢
       ע : ˴Թ켣Ϊ˱⸡㣬߼ٶȣ˴ļ1024
   			 pfposiCount+1Ԫ
*********************************************************************************************/
ZSINT32 CalcRelativePos_OverstepInStart(ZSINT32 fStartPos, ZSINT32 fEndPos, ZSINT32 *pfPos, ZSINT32 iCount);
						 
/********************************************************************************************
    :EngineComputeAnimationContrails
   ˵ :ݶͼԹ켣
        :pAnimaion 洢ϢĽṹ
        : ɹ0-1
       ע : ˴Թ켣Ϊ˱⸡㣬߼ٶȣ˴ļ1024
   *********************************************************************************************/
ZSINT32 EngineComputeAnimationContrails(EngineAnimation *pAnimaion);

/********************************************************************************************
    :EngineReleaseAnimationContrails
   ˵ :ͷڵEngineComputeAnimationContrailsʱڴ
        :pAnimaion 洢ϢĽṹ
        : ޡ
       ע : ޡ
   *********************************************************************************************/

ZVOID EngineReleaseAnimationContrails(EngineAnimation *pAnimaion);

/********************************************************************************************
    :EngineGetCurAniPos
   ˵ : ݶͼ㶯ı仯켣
        : pData:ݣʼֹ
        : pPos?ǰ֡λ
       ע : 
*********************************************************************************************/
ZSINT32 EngineGetCurAniPos(EngineData *pData, ZVOID*pPos);

/********************************************************************************************
    :EngineForwardAnimationPos
   ˵ : 켣ĵǰ֡
        : pData: 
        : 
       ע : CurStep1
*********************************************************************************************/
ZVOID EngineForwardAnimationPos(EngineData *pData);


/********************************************************************************************
    :EngineBackwardAnimationPos
   ˵ :ݼǰĵǰ֡
        : pData: 
        : 
       ע : CurStep1
*********************************************************************************************/
ZVOID EngineBackwardAnimationPos(EngineData *pData);

/********************************************************************************************
    :   GetSqrtValue
   ˵ :   ȡĳֵĽƽ
        :   valueֵ
        :  ֵӦƽ
       ע :   ʹÿ㷨,
*********************************************************************************************/
ZSINT32 GetSqrtValue(ZSINT32 value);


/********************************************************************************************
    :   GetAbsValue
   ˵ :   ȡĳֵֵ
        :   valueֵ
        :   ֵӦľֵ
       ע :   
*********************************************************************************************/
ZSINT32 GetAbsValue (ZSINT32 number);


#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif /*_EFFECT_CALC_POS_H*/
