#ifndef _EFFECT_ENGINE_H
#define _EFFECT_ENGINE_H


#ifdef __cplusplus
extern "C"
{
#endif
#include "zcore_type.h"	
#include "EngineType.h"


#define ENGINE_PIXEL565RED(gal_pixel)        ((((gal_pixel) >> 11) & 0x1f)<<3)
#define ENGINE_PIXEL565GREEN(gal_pixel)      ((((gal_pixel) >> 5) & 0x3f)<<2)
#define ENGINE_PIXEL565BLUE(gal_pixel)       (((gal_pixel) & 0x1f)<<3)
#define ENGINE_RGB2P565(r,g,b)               (((r>>3)<<11)|((g>>2)<<5)|(b>>3))	

#define ENGINE_PIXEL888RED(pixel)   (((pixel) >> 16) & 0xFF)
#define ENGINE_PIXEL888GREEN(pixel) (((pixel) >> 8) & 0xFF)
#define ENGINE_PIXEL888BLUE(pixel)  ((pixel) & 0xFF)		
#define ENGINE_RGB2P888(r,g,b)      (((r) << 16) | ((g) << 8) | (b))

#define ENGINE_ALPHA_BLEND_888(Src, Dst, Alpha)\
{\
    ZUINT8 SrcR,SrcG,SrcB;\
    ZUINT8 DstR,DstG,DstB;\
    ZUINT8 OutR,OutG,OutB;\
    SrcR = ENGINE_PIXEL888RED(Src);\
    SrcG = ENGINE_PIXEL888GREEN(Src);\
    SrcB = ENGINE_PIXEL888BLUE(Src);\
    DstR = ENGINE_PIXEL888RED(Dst);\
    DstG = ENGINE_PIXEL888GREEN(Dst);\
    DstB = ENGINE_PIXEL888BLUE(Dst);\
    OutR = ((( SrcR - DstR )*(Alpha))>>8) + DstR;\
    OutG = ((( SrcG - DstG )*(Alpha))>>8) + DstG;\
    OutB = ((( SrcB - DstB )*(Alpha))>>8) + DstB;\
    Dst = (ZSINT32)ENGINE_RGB2P888(OutR, OutG, OutB);\
}

typedef struct _RGB_24Bit
{
    ZUINT8 r;
    ZUINT8 g;
    ZUINT8 b;
}RGB_24Bit;

typedef struct _RGB_32Bit
{
    ZUINT8 b;
    ZUINT8 g;
    ZUINT8 r;
    ZUINT8 a;
}RGB_32Bit;

typedef ZSINT32 EffectColor;
	
	typedef enum
	{ 
		EFFECT_TYPE_WIPE, 
		EFFECT_TYPE_ZOOM,
		EFFECT_TYPE_FADE, 
		EFFECT_TYPE_FLIP,
		EFFECT_TYPE_BOX,
		EFFECT_TYPE_PAGETURN,
		EFFECT_TYPE_BLUR,
			
		EFFECT_TYPE_NUM
	}EffectType;
	
	typedef enum
	{
		EFFECT_ANIM_LINEAR,                            /* Ա仯*/
		EFFECT_ANIM_SINUS,                             /* sin */
		EFFECT_ANIM_ACCELERATE,                        /* */
		EFFECT_ANIM_DECELERATE,                        /*  */
		EFFECT_ANIM_ACCELERATE_DECELERATE,             /* ȼٺ */
		EFFECT_ANIM_BOUNCE,                            /*  */
		EFFECT_ANIM_OVERSTEP_IN_START,                 /* ڹ켣ʼԽ*/
		EFFECT_ANIM_OVERSTEP_IN_END,                   /* ڹ켣βԽ*/
			
		EFFECT_ANIM_NUM
	}EffectAnimaitonType;
	
	
	typedef enum
	{ 
		EFFECT_DIR_LEFT, 
		EFFECT_DIR_RIGHT, 
		EFFECT_DIR_UP, 
		EFFECT_DIR_DOWN,
        EFFECT_DIR_LEFT_UP,
        EFFECT_DIR_RIGHT_DOWN,
        EFFECT_DIR_RIGHT_UP,
        EFFECT_DIR_LEFT_DOWN,
			
		EFFECT_DIR_NUM
	}EffectDirection;
	
	
	typedef enum
	{ 
		EFFECT_STYLE_IN,
		EFFECT_STYLE_OUT,
			
		EFFECT_STYLE_NUM
	}EffectStyle;
	
	typedef enum
	{ 
		EFFECT_IDLE, 
		EFFECT_READY, 
		EFFECT_RUNNING, 
		EFFECT_END,
			
		EFFECT_STATE_NUM
	}EffectState;
	
	typedef enum
	{ 
		EFFECT_MIDDLE, 
		EFFECT_GOOD, 
		EFFECT_FINE, 
		
		EFFECT_ACCURACY_NUM
	}EffectAccuracy;
	
	
	typedef enum
	{ 
		EFFECT_END_QUART,      /*ķ֮һ*/
		EFFECT_END_TRI,           /*֮һ*/
		EFFECT_END_DIM,          /*֮һ*/
		EFFECT_END_NONE,       /*ȫȱʡֵû趨ĻЧеλãֵԷɳСλصЧ*/
			
		EFFECT_ENDSTATE_NUM
	}EffectEndState;
	
	typedef struct tagRectSize
	{
		ZSINT32 nWidth;
		ZSINT32 nHeight;
	}RectSize;
	
	typedef struct 
	{
		ZVOID *pData;                        /* ĵַ */
		RectSize ImageSize;                 /* ͼĿϢ */           
		EngineRect EffectRect;              /* Ч */      
		ZUINT32  bytes;                /* λռֽ */           
		ZUINT32  pitch;                /* ÿеĿ */
		
	}EngineImage;
	
	
	typedef struct 
	{
		EngineImage OutImage;             /*ʵĿ*/
		ZSINT32         Reserved;             /*ֶΣǰ汾ʹ*/						   
	}EngineInstance;
	
	
	typedef struct
	{
		EffectType EffectType;                                     /*ЧͣɳС*/                        
		EffectDirection dir;                                            /*ЧķԺϳʱ켣*/
		EffectStyle        style;                                       /*ľ罥󣬷ɳ*/	
		EffectAccuracy acc;
		EffectColor   BgColor;                                       /*ȫʱǶɫ*/
		ZSINT32            steps;                                              /*֡*/
		ZSINT32            CurStep;                                          /*ǰ֡*/
		EffectAnimaitonType            AnimationType;     /*ֵԼ켣*/
		EffectEndState EndState;                                        /*ʾЧнλãĿǰṩ4ѡ*/
		EngineBool     loop;                                             /*Ƿѭ*/
		ZSINT32          *pContrail;                                      /*켣*/
	}EngineAnimation;
	
	typedef struct
	{
		EngineImage SrcImage;
		EngineImage DstImage;
		EngineAnimation animation;        /*һЩ*/
		
		ZVOID *pEffectData;                     /*ЧӦ*/
	}EngineData;
	
	
#ifdef __cplusplus
}
#endif  /* __cplusplus */


#endif  /* _EFFECT_ENGINE_H */

