#ifndef _ZCORE_GUI_ICON_H_
#define _ZCORE_GUI_ICON_H_

#include "zcore_type.h"
/* Struct definitions */
typedef struct _ICONDIRENTRY {
    ZBYTE bWidth;
    ZBYTE bHeight;
    ZBYTE bColorCount;
    ZBYTE bReserved;
    ZWORD wPlanes;
    ZWORD wBitCount;
    ZDWORD dwBytesInRes;
    ZDWORD dwImageOffset;
}ICONDIRENTRY;

#define SIZEOF_ICONDIRENTRY 16
typedef struct _ICONDIR {
    ZWORD cdReserved;
    ZWORD cdType;    // must be 1.
    ZWORD cdCount;
}ICONDIR;

#ifdef _USE_NEWGAL

typedef struct _ICON {
    ZUINT32  width;
    ZUINT32  height;
    ZUINT32  pitch;
    ZBYTE*   AndBits;
    ZBYTE*   XorBits;
}ICON;

#else

typedef struct _ICON {
    ZSINT32     width;
    ZSINT32     height;
    ZVOID*   AndBits;
    ZVOID*   XorBits;
}ICON;

#endif /* _USE_NEWGAL */

typedef ICON* PICON;

/* Function definitions */
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

/* Initialization and termination. */

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif // _ZCORE_GUI_ICON_H_

