#ifndef OWN_STDIO_H
#define OWN_STDIO_H
#include "zcore_type.h"
#include <stdio.h>
#include <stddef.h>
#include <stdarg.h>

#include "endianrw.h"

#ifdef __cplusplus
extern "C" {
#endif

extern MG_RWops __mg_def_dev;

MG_EXPORT ZSINT32 own_printf( const ZCHAR * format, ... );

MG_EXPORT ZSINT32 own_fprintf( FILE * stream, const ZCHAR * format, ... );

MG_EXPORT ZSINT32 own_sprintf( ZCHAR * str, const ZCHAR * format, ... );

MG_EXPORT ZSINT32 own_fnprintf( FILE * stream, size_t length, const ZCHAR * format, ... );

MG_EXPORT ZSINT32 own_snprintf( ZCHAR * str, size_t length, const ZCHAR * format, ... );

MG_EXPORT ZSINT32 own_vprintf( const ZCHAR * format, va_list args );

MG_EXPORT ZSINT32 own_vfprintf( FILE * stream, const ZCHAR * format, va_list args );

MG_EXPORT ZSINT32 own_vsprintf( ZCHAR * str, const ZCHAR * format, va_list args );

MG_EXPORT ZSINT32 own_vfnprintf( FILE * stream, size_t length, const ZCHAR * format, va_list args );

MG_EXPORT ZSINT32 own_vsnprintf( ZCHAR * str, size_t length, const ZCHAR * format, va_list args );

MG_EXPORT ZSINT32 own_scanf( const ZCHAR * format, ... );

MG_EXPORT ZSINT32 own_fscanf( FILE * stream, const ZCHAR * format, ... );

MG_EXPORT ZSINT32 own_sscanf( const ZCHAR * str, const ZCHAR * format, ... );

MG_EXPORT ZSINT32 own_vscanf( const ZCHAR * format, va_list args );

MG_EXPORT ZSINT32 own_vfscanf( FILE * stream, const ZCHAR * format, va_list args );

MG_EXPORT ZSINT32 own_vsscanf( const ZCHAR * str, const ZCHAR * format, va_list args );

#ifdef __cplusplus
};  /* end of extern "C" */
#endif

#endif /* OWN_STDIO_H */

