#ifndef	_ZCORE_GUI_VCONGUI_H
#define	_ZCORE_GUI_VCONGUI_H

#include "zcore_type.h"
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */    

#ifndef __cplusplus
#ifndef __ECOS__
typedef	enum {
    false, true
}
bool;
#endif
#endif

#define VCONGUI_VERSION "Version 0.5 (Nov. 2001)"

#define MIN_COLS    10
#define MAX_COLS    100
#define MIN_ROWS    10
#define MAX_ROWS    60

#define GetCharWidth GetSysCharWidth
#define GetCCharWidth GetSysCCharWidth
#define GetCharHeight GetSysCharHeight


typedef struct _CHILDINFO
{
    bool startupMessage;
    const ZCHAR* startupStr;
    const ZCHAR* execProg;
    const ZCHAR* execArgs;

    WNDPROC     DefWinProc;
    bool        fMenu;
    ZSINT32         left, top;
    ZSINT32         rows, cols;
}CHILDINFO;
typedef CHILDINFO* PCHILDINFO;

/**
 * 
 * \brief Creates a vcongui main window.
 *
 * This function creates a vcongui main window, and enter a message loop.
 * 
 * \param data The pointer to a CHILDINFO structure.
 */
ZVOID* VCOnMiniGUI (ZVOID* data);


#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif /* _ZCORE_GUI_VCONGUI_H */


