#ifndef Z3D_APP_FRAMEWORK_H
#define Z3D_APP_FRAMEWORK_H

#ifdef __cplusplus
extern "C" {
#endif

/********************************************************************************
    Include File                  ͷļ
********************************************************************************/

/********************************************************************************
    Macro                           궨
********************************************************************************/

#undef  INTERFACE
#define INTERFACE(type)                  \
    typedef struct type type;            \
    void type##Constructor(type* pThis); \
    int type##Destructor(type* pThis);   \
    struct type

#undef  ABSTRACT_CLASS
#define ABSTRACT_CLASS(type)             \
    typedef struct type type;            \
    void type##Constructor(type* pThis); \
    int type##Destructor(type* pThis);   \
    void type##Delete(type* pThis);      \
    struct type

#undef  CLASS
#define CLASS(type)                      \
    typedef struct type type;            \
    type* type##New(void);               \
    void type##Constructor(type* pThis); \
    int type##Destructor(type* pThis);   \
    void type##Delete(type* pThis);      \
    struct type

#undef  CONSTRUCTOR
#define CONSTRUCTOR(type)                                     \
    type* type##New(void)                                     \
    {                                                         \
        struct type *pThis = NULL;                            \
        pThis = (struct type*)z3dMalloc(sizeof(struct type)); \
        if(NULL == pThis)                                     \
        {                                                     \
            return NULL;                                      \
        }                                                     \
        z3dMemset(pThis, 0, sizeof(struct type));             \
        type##Constructor(pThis);                             \
        return pThis;                                         \
    }                                                         \
    void type##Constructor(type* pThis) {

#undef  END_CONSTRUCTOR
#define END_CONSTRUCTOR    }

#undef  DESTRUCTOR
#define DESTRUCTOR(type)              \
    void type##Delete(type* pThis)    \
    {                                 \
         if(NULL == pThis)            \
         {                            \
              return;                 \
         }                            \
         if(type##Destructor(pThis))  \
         {                            \
              z3dFree(pThis);         \
              pThis = NULL;           \
         }                            \
    }                                 \
    int type##Destructor(type* pThis) \
    {

#undef  END_DESTRUCTOR
#define END_DESTRUCTOR    }

#undef  ABSTRACT_CONSTRUCTOR
#define ABSTRACT_CONSTRUCTOR(type) \
    void type##Constructor(type* pThis) {

#undef  END_ABSTRACT_CONSTRUCTOR
#define END_ABSTRACT_CONSTRUCTOR    }

#undef  FUNCTION_SETTING
#define FUNCTION_SETTING(fa, fb)    pThis->fa = fb;

#undef  IMPLEMENTS
#define IMPLEMENTS(type)    struct type type

#undef  EXTENDS
#define EXTENDS(type)       struct type type

#undef  FATHER
#define FATHER(pThis, father) ((father*)(&(pThis->##father)))

#undef  GRANDFATHER
#define GRANDFATHER(pThis, father, grandfather) \
    FATHER(FATHER(pThis, father), grandfather)

#undef  GREATGRANDFATHER
#define GREATGRANDFATHER(pThis, father, grandfather, greatgrandfather) \
    FATHER(GRANDFATHER(pThis, father, grandfather), greatgrandfather)

#undef  SUPER_CONSTRUCTOR
#define SUPER_CONSTRUCTOR(father) \
    father##Constructor(FATHER(pThis, father));

#undef  CHILD
#define CHILD(pSelf, self, child) \
    ((child*)((char*)pSelf - offsetof(child, self)))

#undef  GRANDCHILD
#define GRANDCHILD(pSelf, self, child, grandchild) \
    CHILD(CHILD(pSelf, self, child), child, grandchild)

#undef  GREATGRANDCHILD
#define GREATGRANDCHILD(pSelf, self, child, grandchild, greatgrandchild) \
    CHILD(GRANDCHILD(pSelf, self, child, grandchild), grandchild, greatgrandchild)

#undef  INHERIT_FROM
#define INHERIT_FROM(father, pThis, field)    pThis->father.field

/********************************************************************************
    Struct                       ݽṹ
********************************************************************************/

/********************************************************************************
    Manifest Constant              
********************************************************************************/

/********************************************************************************
    Global Variable                ȫֱ
********************************************************************************/

/********************************************************************************
    Static Variable                ̬
********************************************************************************/

/********************************************************************************
    Global Function Prototype    ȫֺ
********************************************************************************/

#ifdef __cplusplus
}
#endif

#endif
