#ifndef Z3D_COMMON_H
#define Z3D_COMMON_H

#ifdef __cplusplus
extern "C" {
#endif

/********************************************************************************
    Include File                  ͷļ
********************************************************************************/

// C includes
#include <stdio.h>

/********************************************************************************
    Macro                           궨
********************************************************************************/

#undef INLINE
#if defined(__GNUC__)
#  define INLINE __inline__
#elif defined(__MSC__)
#  define INLINE __inline
#elif defined(_MSC_VER)
#  define INLINE __inline
#elif defined(__ICL)
#  define INLINE __inline
#elif defined(__INTEL_COMPILER)
#  define INLINE inline
#elif defined(__WATCOMC__) && (__WATCOMC__ >= 1100)
#  define INLINE __inline
#elif defined(__SUNPRO_C) && defined(__C99FEATURES__)
#  define INLINE inline
#  define __inline inline
#  define __inline__ inline
#elif (__STDC_VERSION__ >= 199901L) // C99
#  define INLINE inline
#else
#  define INLINE __inline
#endif

#undef NULL
#ifdef __cplusplus
#  define NULL     (0)
#else
#  define NULL     ((void *)0)
#endif

#undef  TRUE
#define TRUE     1

#undef  FALSE
#define FALSE    0

// RGB565ʽɫתΪRGB888ʽɫ
#undef  FORMAT_RGB565_TO_RGB888
#define FORMAT_RGB565_TO_RGB888(r, g, b)    do {(*r) = ((*r) << 3) | ((*r) >> 2); *g = ((*g) << 2) | ((*g) >> 4); (*b) = ((*b) << 3) | ((*b) >> 2);} while(0)

// RGB888ʽɫתΪRGB565ʽɫ
#undef  FORMAT_RGB888_TO_RGB565
#define FORMAT_RGB888_TO_RGB565(r, g, b)    do {(*r) = (*r) >> 3; (*g) = (*g) >> 2; (*b) = (*b) >> 3;} while(0)

// RGB565ʽɫתΪRGB16λɫ
#undef  FORMAT_RGB565_TO_RGB16BIT
#define FORMAT_RGB565_TO_RGB16BIT(r, g, b)    (((r) & 0x1F) << 11) | (((g) & 0x3F) << 5) | ((b) & 0x1F)

// RGB16λɫתΪRGB565ʽɫ
#undef  FORMAT_RGB16BIT_TO_RGB565
#define FORMAT_RGB16BIT_TO_RGB565(pixel, r, g, b)    do {(*r) = ((pixel) >> 11) & 0x1F; (*g) = ((pixel) >> 5) & 0x3F; (*b) = (pixel) & 0x1F;} while(0)

// RGB888ʽɫתΪRGB16λɫ
#undef  FORMAT_RGB888_TO_RGB16BIT
#define FORMAT_RGB888_TO_RGB16BIT(r, g, b)    ((((r) >> 3) & 0x1F) << 11) | ((((g) >> 2) & 0x3F) << 5) | (((b) >> 3) & 0x1F)

// RGB16λɫתΪRGB888ʽɫ
#undef  FORMAT_RGB16BIT_TO_RGB888
#define FORMAT_RGB16BIT_TO_RGB888(pixel, r, g, b)    do {(*r) = ((pixel) >> 11) & 0x1F; (*g) = ((pixel) >> 5) & 0x3F; (*b) = (pixel) & 0x1F; \
    (*r) = ((*r) << 3) | ((*r) >> 2); *g = ((*g) << 2) | ((*g) >> 4); (*b) = ((*b) << 3) | ((*b) >> 2);} while(0)

// RGB888ʽɫתΪRGB24λɫ
#undef  FORMAT_RGB888_TO_RGB24BIT
#define FORMAT_RGB888_TO_RGB24BIT(r, g, b)    ((r) << 16) | ((g) << 8) | (b)

// RGB24λɫתΪRGB888ʽɫ
#undef  FORMAT_RGB24BIT_TO_RGB888
#define FORMAT_RGB24BIT_TO_RGB888(pixel, r, g, b)    do {(*r) = ((pixel) >> 16) & 0xFF; (*g) = ((pixel) >> 8) & 0xFF; (*b) = (pixel) & 0xFF;} while(0)

// RGB16λɫתΪRGB24λɫ
#undef  FORMAT_RGB16BIT_TO_RGB24BIT
#define FORMAT_RGB16BIT_TO_RGB24BIT(srcPixel, destPixel)    do {int r = ((srcPixel) >> 11) & 0x1F, g = ((srcPixel) >> 5) & 0x3F, b = (srcPixel) & 0x1F; \
    r = (r << 3) | (r >> 2); g = (g << 2) | (g >> 4); b = (b << 3) | (b >> 2); (destPixel) = (r << 16) | (g << 8) | b;} while(0)

// RGB24λɫתΪRGB16λɫ
#undef  FORMAT_RGB24BIT_TO_RGB16BIT
#define FORMAT_RGB24BIT_TO_RGB16BIT(srcPixel, destPixel)    do {int r  = ((srcPixel) >> 16) & 0xFF, g = ((srcPixel) >> 8) & 0xFF, b = (srcPixel) & 0xFF; \
    (destPixel) = (((r >> 3) & 0x1F) << 11) | (((g >> 2) & 0x3F) << 5) | ((b >> 3) & 0x1F);} while(0)

// RGB16λɫתΪRGB32λɫ
#undef  FORMAT_RGB16BIT_TO_SRGB32BIT
#define FORMAT_RGB16BIT_TO_SRGB32BIT(srcPixel, destPixel)    do {unsigned char r = ((srcPixel) >> 11) & 0x1F, g = ((srcPixel) >> 5) & 0x3F, b = (srcPixel) & 0x1F; \
    (destPixel) = (r << 21) | (g << 10) | b;} while(0)

// RGB32λɫתΪRGB16λɫ
#undef  FORMAT_SRGB32BIT_TO_RGB16BIT
#define FORMAT_SRGB32BIT_TO_RGB16BIT(srcPixel, destPixel)    do {unsigned char r  = ((srcPixel) >> 26) & 0x1F, g = ((srcPixel) >> 15) & 0x3F, b = ((srcPixel) >> 5) & 0x1F; \
    (destPixel) = (r << 11) | (g << 5) | b;} while(0)

// RGBA8888ʽ(alphaռ8λ)ɫתΪRGB32λɫ
#undef  FORMAT_RGBA8888_TO_RGBA32BIT
#define FORMAT_RGBA8888_TO_RGBA32BIT(r, g, b, a)    ((r) << 24) | ((g) << 16) | ((b) << 8) | (a)

// ARGB8888ʽ(alphaռ8λ)ɫתΪRGB32λɫ
#undef  FORMAT_ARGB8888_TO_ARGB32BIT
#define FORMAT_ARGB8888_TO_ARGB32BIT(a, r, g, b)    ((a) << 24) | ((r) << 16) | ((g) << 8) | (b)

/********************************************************************************
    Struct                       ݽṹ
********************************************************************************/

typedef unsigned char     GLboolean;
typedef char              GLbyte;
typedef unsigned char     GLubyte;
typedef short             GLshort;
typedef unsigned short    GLushort;
typedef int               GLint;
typedef unsigned int      GLuint;
typedef float             GLfloat;
typedef double            GLdouble;
typedef void              GLvoid;

// 
typedef struct AREA_TYPE
{
    int left,            // ϽǵX
        top,             // ϽǵY
        right,           // ½ǵX
        bottom;          // ½ǵY

    unsigned int width,  // 
                 height; // ߶

} AREA, *AREA_PTR;

// תǶ
typedef struct ANGLE_TYPE
{
    float x, // XǶ
          y, // YǶ
          z; // ZǶ

} ANGLE, *ANGLE_PTR;

// ֡
typedef struct FRAME_BUFFER_TYPE
{
    unsigned int width,          // 
                 height,         // ߶
                 bitsPerPixel,   // ֡ÿжλ
                 bytesPerPixel,  // ֡ÿжֽ
                 pitch,          // ֡ڴ࣬ÿжֽ
                 size,           // ֡С
                 bitsPerPixelS,  // Դÿжλ
                 bytesPerPixelS, // Դÿжֽ
                 pitchS,         // Դڴ࣬ÿжֽ
                 sizeS;          // ԴС

    void *pBuffer,               // ֡
         *pScreen;               // Դ

} FRAME_BUFFER, *FRAME_BUFFER_PTR;

/********************************************************************************
    Manifest Constant              
********************************************************************************/

/********************************************************************************
    Global Variable                ȫֱ
********************************************************************************/

/********************************************************************************
    Static Variable                ̬
********************************************************************************/

/********************************************************************************
    Global Function Prototype    ȫֺ
********************************************************************************/

void* z3dMalloc(unsigned int size);

void z3dFree(void *ptr);

void z3dMemcpy(void *dest, void *src, unsigned int len);

void z3dMemset(void *ptr, int val, unsigned int len);

/********************************************************************************
      z3dInitArea
        ܣʼ
    startXʼX  startYʼY  width  height߶
    pArea
      ֵ
    ˵
********************************************************************************/
void z3dInitArea(const int startX, const int startY, const unsigned int width, const unsigned int height, AREA_PTR pArea);

/********************************************************************************
      z3dIsInArea
        ܣжǷλڻ
    xX  yY
    pArea
      ֵTRUE  FALSE
    ˵
********************************************************************************/
int z3dIsInArea(const int x, const int y, AREA_PTR pArea);

/********************************************************************************
      z3dNewFrameBuffer
        ܣ½֡
    pFrameBuffer֡
    pFrameBuffer֡
      ֵTRUE  FALSE
    ˵
********************************************************************************/
int z3dNewFrameBuffer(FRAME_BUFFER_PTR pFrameBuffer);

/********************************************************************************
      z3dDeleteFrameBuffer
        ܣɾ֡
    pFrameBuffer֡
    
      ֵ
    ˵
********************************************************************************/
void z3dDeleteFrameBuffer(FRAME_BUFFER_PTR pFrameBuffer);

/********************************************************************************
      z3dReferFrameBuffer
        ܣ½֡棬ⲿڴ
    pBufferⲿڴ  pFrameBuffer֡
    pFrameBuffer֡
      ֵ
    ˵úֱⲿڴ棬µڴ
********************************************************************************/
void z3dReferFrameBuffer(void *pBuffer, FRAME_BUFFER_PTR pFrameBuffer);

/********************************************************************************
      z3dSwapBuffers
        ܣ֡ݸƵԴ
    pArea  pFrameBuffer֡
    pFrameBuffer֡
      ֵ
    ˵
********************************************************************************/
void z3dSwapBuffers(const AREA_PTR pArea, FRAME_BUFFER_PTR pFrameBuffer);

#ifdef __cplusplus
}
#endif

#endif
