#ifndef _ZCORE_DC_H
#define _ZCORE_DC_H
#include "zcore_type.h"
#include "gdi_e.h"
#define TYPE_MGTDEVDC      	  0xF1
#define TYPE_MGTGENDC      	  0xF2
#define TYPE_MGTMEMDC      	  0xF3
#define TYPE_MGTSURFACEDC     0xF4

#define DC_ATTR_BK_COLOR        0
#define DC_ATTR_BK_MODE         1
#define DC_ATTR_PEN_COLOR       2
#define DC_ATTR_BRUSH_COLOR     3
#define DC_ATTR_TEXT_COLOR      4
#define DC_ATTR_TAB_STOP        5

#define DC_ATTR_CHAR_EXTRA      6
#define DC_ATTR_ALINE_EXTRA     7
#define DC_ATTR_BLINE_EXTRA     8

#define DC_ATTR_MAP_MODE        9
#define DC_ATTR_BORDER_COLOR    15


typedef struct _T_DCMgt_DC* PT_DCMgt_DC;

/*
typedef struct _T_SDEV_GC
{
    PT_SDEV_SCREENDEVICE		psd;
} T_SDEV_GC;
*/

typedef enum
{
  /** 
   * The solid pen. 
   * We call the solid pen with zero wide as "zero pen".
   */
  PT_SOLID,
  /** 
   * The on/off dash pen, even segments are drawn; 
   * odd segments are not drawn.
   */
  PT_ON_OFF_DASH,
  /**
   * The double dash pen, even segments are normally. 
   * Odd segments are drawn in the brush color if 
   * the brush type is BT_SOLID, or in the brush color 
   * masked by the stipple if the brush type is BT_STIPPLED.
   */
  PT_DOUBLE_DASH,
} PenType;

typedef enum
{
  PT_CAP_BUTT,
  PT_CAP_ROUND,
  PT_CAP_PROJECTING
} PTCapStyle;

typedef enum
{
  PT_JOIN_MITER,
  PT_JOIN_ROUND,
  PT_JOIN_BEVEL
} PTJoinStyle;

typedef struct _T_DCMgt_DC
{
    ZSINT32 				iType;   			/* T_DCMgt_DCͣT_DCMgt_DCڴT_DCMgt_DC */
        
    ZBOOL				bUse;					/* Ƿռ */
    HWND				hWnd;					/* ھ */
						
    Pixel 				pixPenColor;			/* ɫ */			
    Pixel 				pixBrushColor;			/* ˢɫ */		
    Pixel 				pixBkColor;				/* ڱɫ */
    ZSINT32 				iBkmode;			/* ڱģʽ */
   
    ZSINT32					iMapMode;			/* ӳģʽ */
    ZBOOL				bIsClient;				/* жǷCLIENTDC */
    RECT 				tClipDevRc;				/* 豸 */

    ZSINT32 				iCExtra;     		/* ַ */
    ZSINT32 				iAlExtra;    		/* ϻ߼ */
    ZSINT32 				iBlExtra;    		/* »߼ */
    ZSINT32 				iTabStop;    		/* Tabֵ */
    Pixel 				pixTextColor;			/* ıɫ */
    Pixel 				pixBoderColor;			/* ıɫ */
    ZSINT32             	iPenType;
    ZSINT32             	iPenCapStyle;
    ZSINT32             	iPenJoinStyle;
    ZSINT32             	iPenWidth;

    /* custom dash info */
    ZSINT32                 dash_offset;
    const ZUINT8* dash_list;
    size_t              dash_list_len;

	ZDWORD               dwFlags;
	ZBYTE                bAlpha;
    ZDWORD               dwTransparent;
	RGB*                ptPalate;

    ZSINT32             	iBrushType;
	
    POINT				tDCMgtCurPenPos;		/* ǰ״̬ */
    POINT				tDCMgtCurTextPos;		/* ǰı״̬ */
    PLOGFONT 			pLogFont;				/* ıصĽṹ */

    T_REGION_CLIPRGN 	tDCMgtLocateCrgn;		/* ؼڴÿڵļ */
    T_REGION_CLIPRGN 	tDCMgtAvailableCrgn;	/* ЧڴÿЧڵļ */
    RECT    			tDCMgtDevRc;			/* 豸ߴ磨process¿ܻ壩 */
	
    PT_WM_WGINFO		ptDCMgtWGINFO;			/* ȫϢ */
    ZSINT32					iOldAge;			/* ڴϢڱʾм㴰 */
    PGC			        ptDCMgtGc;				/* 豸ָ */
}T_DCMgt_DC;

/*******************************ԭ*******************************/
extern 	ZBOOL DCMgt_InitDC(ZVOID);
extern	ZBOOL DCMgt_CreateDC(ZVOID);
extern 	HDC  DCMgt_GetDC(HWND hWnd);
extern	HDC  DCMgt_GetClientDC(HWND hWnd);
extern 	ZBOOL DCMgt_ReleaseDC(HDC hdc);
extern 	HDC DCMgt_CreatePrivateClientDC(HWND hwnd);
extern 	ZBOOL DCMgt_DeletePrivateDC(HDC hdc);
extern	HDC DCMgt_CreateCompatibleDC(HDC hdc,ZSINT32 iWidth, ZSINT32 iHeight);
extern	ZBOOL DCMgt_DeleteCompatibleDC(HDC hdc);
extern	HDC DCMgt_CreateMemDC(ZSINT32 iWidth, ZSINT32 iHeight, ZSINT32 iDepth, ZDWORD flags, ZUINT32 Rmask, ZUINT32 Gmask, ZUINT32 Bmask, ZUINT32 Amask);
extern	ZBOOL DCMgt_DeleteMemDC (HDC mem_dc);
extern 	ZBOOL DCMgt_WndClientRect(HWND hWnd, PRECT prc);
extern 	ZBOOL DCMgt_WndRect(HWND hWnd, PRECT prc);
extern	PT_DCMgt_DC  HDCTOPDC(HDC hdc);
extern	ZBOOL DCMgt_IsVisible(PT_DCMgt_DC pdc);
extern 	Pixel DCMgt_SetPenColor(HDC hdc, Pixel pixNewColor);
extern 	Pixel DCMgt_GetPenColor(HDC hdc);
extern 	Pixel DCMgt_SetBrushColor(HDC hdc, Pixel pixNewColor);
extern 	Pixel DCMgt_GetBrushColor(HDC hdc);
extern 	ZBOOL GDI_INIT(ZVOID);
extern	ZBOOL Draw_LineTo(HDC hdc, ZSINT32 x, ZSINT32 y);
extern	ZBOOL Draw_LineToEx(HDC hdc, ZSINT32 x1, ZSINT32 y1, ZSINT32 x2, ZSINT32 y2);
extern 	ZBOOL Draw_Rectangle(HDC hdc, ZSINT32 iLeft, ZSINT32 iTop, ZSINT32 iRight, ZSINT32 iBottom);
extern 	ZBOOL Draw_SetPixel(HDC hdc, ZSINT32 iX, ZSINT32 iY, gal_pixel c);
extern 	gal_pixel  Draw_RGB2Pixel(HDC hdc, ZSINT32 r, ZSINT32 g, ZSINT32 b);
extern 	gal_pixel Draw_GetBkColor (HDC hdc);
extern 	gal_pixel Draw_SetBkColor(HDC hdc, gal_pixel color);
extern 	gal_pixel  Draw_SetTextColor (HDC hdc, gal_pixel color);
extern 	ZSINT32 Draw_SetBkMode(HDC hdc, ZSINT32 iBkmode);
extern	ZBOOL Draw_HVDotLine(HDC hdc, ZSINT32 iX, ZSINT32 iY, ZSINT32 iW_H, ZBOOL bH_V);
extern	ZBOOL  Draw_SaveScreenBox (ZSINT32 iStartX, ZSINT32 iStartY, ZSINT32 iWidth, ZSINT32 iHeight, ZVOID* vBuf);
extern	ZBOOL Draw_MoveTo (HDC hdc, ZSINT32 x, ZSINT32 y);
extern  ZSINT32 Draw_GetDCAttr(HDC hdc, ZSINT32 attr);
extern  ZSINT32 Draw_SetDCAttr(HDC hdc, ZSINT32 attr, ZUINT32 value);
extern  ZSINT32 Draw_SetPenType(HDC hdc, ZSINT32 iPenType);
extern  ZSINT32 Draw_SetPenWidth(HDC hdc, ZSINT32 iPenWidth);
extern  gal_pixel  Draw_RGBA2Pixel (HDC hdc, ZBYTE r, ZBYTE g, ZBYTE b, ZBYTE a);

extern 	HDC GetDC(HWND hwnd);
extern	HDC  GetClientDC(HWND hwnd);
extern 	ZBOOL ReleaseDC(HDC hdc);
extern 	HDC CreatePrivateClientDC(HWND hwnd);
extern 	ZBOOL DeletePrivateDC(HDC hdc);

extern	HDC CreateCompatibleDCEx(HDC hdc, ZSINT32 width, ZSINT32 height);
extern	ZBOOL DeleteCompatibleDC(HDC hdc);
extern	HDC CreateMemDC(ZSINT32 width, ZSINT32 height, ZSINT32 depth, ZDWORD flags,ZUINT32 Rmask, ZUINT32 Gmask, ZUINT32 Bmask, ZUINT32 Amask);
extern	ZBOOL DeleteMemDC (HDC mem_dc);
extern 	Pixel SetPenColor(HDC hdc, Pixel pixNewColor);
extern 	Pixel GetPenColor(HDC hdc);
extern 	Pixel SetBrushColor(HDC hdc, Pixel pixNewColor);
extern 	Pixel GetBrushColor(HDC hdc);
extern	ZBOOL LineTo(HDC hdc, ZSINT32 x, ZSINT32 y);
extern	ZBOOL LineEx(HDC hdc, ZSINT32 x1, ZSINT32 y1, ZSINT32 x2, ZSINT32 y2);
extern 	ZBOOL Rectangle(HDC hdc, ZSINT32 x0, ZSINT32 y0, ZSINT32 x1, ZSINT32 y1);
extern 	ZBOOL SetPixel(HDC hdc, ZSINT32 x, ZSINT32 y, gal_pixel pixel);
extern 	gal_pixel  RGB2Pixel(HDC hdc, ZUINT8 r, ZUINT8 g, ZUINT8 b);
extern 	gal_pixel GetBkColor (HDC hdc);
extern 	gal_pixel SetBkColor(HDC hdc, gal_pixel color);
extern 	gal_pixel  SetTextColor (HDC hdc, gal_pixel color);
extern 	ZSINT32 SetBkMode(HDC hdc, ZSINT32 bkmode);
extern	ZBOOL DrawHVDotLine (HDC hdc, ZSINT32 x, ZSINT32 y, ZSINT32 w_h, ZBOOL H_V);
extern	ZBOOL  SaveScreenBox (ZSINT32 x, ZSINT32 y, ZSINT32 w, ZSINT32 h, ZVOID* vbuf);
extern	ZBOOL MoveTo (HDC hdc, ZSINT32 x, ZSINT32 y);
extern  ZUINT32  GetDCAttr (HDC hdc, ZSINT32 attr);
extern  ZUINT32  SetDCAttr (HDC hdc, ZSINT32 attr, ZUINT32 value);
extern  gal_pixel  RGBA2Pixel (HDC hdc, ZBYTE r, ZBYTE g, ZBYTE b, ZBYTE a);

extern  gal_pixel  GetTextColor (HDC hdc);
extern  PenType SetPenType(HDC hdc, ZSINT32 iPenType);
extern	ZUINT32 SetPenWidth(HDC hdc, ZDWORD width);
extern	ZVOID  SetPenDashes (HDC hdc, ZSINT32 dash_offset, const ZUINT8* dash_list, ZSINT32 n);
//жrcOutputǷhdcЧཻ
extern ZBOOL IsInRcBound(HDC hdc, RECT *rcOutput);   

/*******************************궨*******************************/
#define 	DrawHDotLine(hdc, x, y, w)		Draw_HVDotLine(hdc, x, y, w, TRUE)
#define 	DrawVDotLine(hdc, x, y, h)		Draw_HVDotLine(hdc, x, y, h, FALSE)


#endif//_ZCORE_DC_H
