#ifndef _ZCORE_IAL_H
#define _ZCORE_IAL_H
#include "zcore_type.h"
#include "common.h"

/**
 * RGBA quarter structure.
 * \sa RGB
 */
typedef struct GAL_Color
{
    ZUINT8 r;
    ZUINT8 g;
    ZUINT8 b;
    ZUINT8 a;
} GAL_Color;

/**
 * Palette structure.
 * \sa GAL_Color
 */
typedef struct GAL_Palette
{
    ZSINT32        ncolors;
    GAL_Color* colors;
} GAL_Palette;

typedef struct GAL_Rect {
    ZSINT32      x, y;
    ZSINT32      w, h;
} GAL_Rect;

/**
 * \def MGUI_NR_KEYS
 * \brief Number of MiniGUI keys.
 *
 */
#define MGUI_NR_KEYS                    255

/**
 * \def NR_KEYS
 * \brief The number of keys defined by Linux operating system.
 *
 */
#define NR_KEYS                         128


/**
 * \def SCANCODE_USER
 * \brief The first key scan code different from OS defined ones.
 *
 * You can define your special key scan codes like below
 */
#define SCANCODE_USER              (NR_KEYS + 1)
enum {
    SCANCODE_ESCAPE =                   1,
    SCANCODE_1 =                        2,
    SCANCODE_2 =                        3,
    SCANCODE_3 =                        4,
    SCANCODE_4 =                        5,
    SCANCODE_5 =                        6,
    SCANCODE_6 =                        7,
    SCANCODE_7 =                        8,
    SCANCODE_8 =                        9,
    SCANCODE_9 =                        10,
    SCANCODE_0 =                        11,
    SCANCODE_MINUS =                    12,
    SCANCODE_EQUAL =                    13,
    SCANCODE_BACKSPACE =                14,
    SCANCODE_TAB =                      15,
    SCANCODE_Q =                        16,
    SCANCODE_W =                        17,
    SCANCODE_E =                        18,
    SCANCODE_R =                        19,
    SCANCODE_T =                        20,
    SCANCODE_Y =                        21,
    SCANCODE_U =                        22,
    SCANCODE_I =                        23,
    SCANCODE_O =                        24,
    SCANCODE_P =                        25,
    SCANCODE_BRACKET_LEFT =             26,
    SCANCODE_BRACKET_RIGHT =            27,
    SCANCODE_ENTER =                    28,
    SCANCODE_LEFTCONTROL =              29,
    SCANCODE_A =                        30,
    SCANCODE_S =                        31,
    SCANCODE_D =                        32,
    SCANCODE_F =                        33,
    SCANCODE_G =                        34,
    SCANCODE_H =                        35,
    SCANCODE_J =                        36,
    SCANCODE_K =                        37,
    SCANCODE_L =                        38,
    SCANCODE_SEMICOLON =                39,
    SCANCODE_APOSTROPHE =               40,
    SCANCODE_GRAVE =                    41,
    SCANCODE_LEFTSHIFT =                42,
    SCANCODE_BACKSLASH =                43,
    SCANCODE_Z =                        44,
    SCANCODE_X =                        45,
    SCANCODE_C =                        46,
    SCANCODE_V =                        47,
    SCANCODE_B =                        48,
    SCANCODE_N =                        49,
    SCANCODE_M =                        50,
    SCANCODE_COMMA =                    51,
    SCANCODE_PERIOD =                   52,
    SCANCODE_SLASH =                    53,
    SCANCODE_RIGHTSHIFT =               54,
    SCANCODE_KEYPADMULTIPLY =           55,
    SCANCODE_LEFTALT =                  56,
    SCANCODE_SPACE =                    57,
    SCANCODE_CAPSLOCK =                 58,
    SCANCODE_F1 =                       59,
    SCANCODE_F2 =                       60,
    SCANCODE_F3 =                       61,
    SCANCODE_F4 =                       62,
    SCANCODE_F5 =                       63,
    SCANCODE_F6 =                       64,
    SCANCODE_F7 =                       65,
    SCANCODE_F8 =                       66,
    SCANCODE_F9 =                       67,
    SCANCODE_F10 =                      68,
    SCANCODE_NUMLOCK =                  69,
    SCANCODE_SCROLLLOCK =               70,
    SCANCODE_KEYPAD7 =                  71,
    SCANCODE_CURSORUPLEFT =             71,
    SCANCODE_KEYPAD8 =                  72,
    SCANCODE_CURSORUP =                 72,
    SCANCODE_KEYPAD9 =                  73,
    SCANCODE_CURSORUPRIGHT =            73,
    SCANCODE_KEYPADMINUS =              74,
    SCANCODE_KEYPAD4 =                  75,
    SCANCODE_CURSORLEFT =               75,
    SCANCODE_KEYPAD5 =                  76,
    SCANCODE_KEYPAD6 =                  77,
    SCANCODE_CURSORRIGHT =              77,
    SCANCODE_KEYPADPLUS =               78,
    SCANCODE_KEYPAD1 =                  79,
    SCANCODE_CURSORDOWNLEFT =           79,
    SCANCODE_KEYPAD2 =                  80,
    SCANCODE_CURSORDOWN =               80,
    SCANCODE_KEYPAD3 =                  81,
    SCANCODE_CURSORDOWNRIGHT =          81,
    SCANCODE_KEYPAD0 =                  82,
    SCANCODE_KEYPADPERIOD =             83,
    SCANCODE_LESS =                     86,
    SCANCODE_F11 =                      87,
    SCANCODE_F12 =                      88,
    SCANCODE_F13 =                      89,
    SCANCODE_F14 =                      90,
    SCANCODE_F15 =                      91,
    SCANCODE_F16 =                      92,
    SCANCODE_F17 =                      93,
    SCANCODE_F18 =                      94,
    SCANCODE_KEYPADENTER =              96,
    SCANCODE_RIGHTCONTROL =             95,
    SCANCODE_CONTROL =                  97,
    SCANCODE_KEYPADDIVIDE =             98,
    SCANCODE_PRINTSCREEN =              99,
    SCANCODE_RIGHTALT =                 100,
    SCANCODE_BREAK =                    101,   /* Beware: is 119   */
    SCANCODE_HOME =                     102,
    SCANCODE_CURSORBLOCKUP =            103,   /* Cursor key block */
    SCANCODE_PAGEUP =                   104,
    SCANCODE_CURSORBLOCKLEFT =          105,   /* Cursor key block */
    SCANCODE_CURSORBLOCKRIGHT =         106,   /* Cursor key block */
    SCANCODE_END =                      107,
    SCANCODE_CURSORBLOCKDOWN =          108,   /* Cursor key block */
    SCANCODE_PAGEDOWN =                 109,
    SCANCODE_INSERT =                   110,
    SCANCODE_REMOVE =                   111,
    SCANCODE_BREAK_ALTERNATIVE =        119,   /* on some keyboards! */
    SCANCODE_PAUSE =                    119,
    SCANCODE_POWER =                    120,
    SCANCODE_SLEEP =                    121,
    SCANCODE_WAKEUP =                   122,
    SCANCODE_LEFTWIN =                  125,
    SCANCODE_RIGHTWIN =                 126,
    SCANCODE_MENU =                     127,
    SCANCODE_HEADSETUP =                128,
    SCANCODE_HEADSETDONWN =             129,
    SCANCODE_HEADFREE =                 130,
    SCANCODE_REDIAL =                   131,
    SCANCODE_MESSAGE =                  132,
    SCANCODE_M1 =                       133,
    SCANCODE_M2 =                       134,
    SCANCODE_M3 =                       135,
    SCANCODE_M4 =                       136,
    SCANCODE_M5 =                       137,
    SCANCODE_M6 =                       138,
    SCANCODE_M7 =                       139,
    SCANCODE_M8 =                       140
};

#define SCANCODE_LEFTBUTTON           0x1000
#define SCANCODE_RIGHTBUTTON          0x2000
#define SCANCODE_MIDDLBUTTON          0x4000

#define KEY_SK1            SCANCODE_F8
#define KEY_SK2            SCANCODE_F9
#define KEY_SK3            SCANCODE_F10
#define KEY_SK4            SCANCODE_F11

#endif//_ZCORE_IAL_H
