#ifndef _ZCORE_MSGTYPE_H
#define _ZCORE_MSGTYPE_H
#include "zcore_type.h"

/***********************************************************************
* Messages Define
***********************************************************************/
/*Mouse event messages*/
#define MSG_FIRSTMOUSEMSG     0x0001
#define MSG_LASTMOUSEMSG      0x000F

/*Key event messages*/
#define MSG_FIRSTKEYMSG       0x0010
#define MSG_LASTKEYMSG        0x001F

/*post_event_msgs Post mouse/key event messages*/
#define MSG_FIRSTPOSTMSG      0x0020
#define MSG_LASTPOSTMSG       0x005F

/*creation_msgs Window creation messages*/
#define MSG_FIRSTCREATEMSG    0x0060
#define MSG_LASTCREATEMSG     0x009F

/*Window painting messages*/
#define MSG_FIRSTPAINTMSG     0x00A0
#define MSG_LASTPAINTMSG      0x00CF

/*Internal desktop messages*/
#define MSG_FIRSTSESSIONMSG   0x00D0
#define MSG_LASTSESSIONMSG    0x00EF

/*Internal window management messages*/
#define MSG_FIRSTWINDOWMSG    0x00F0
#define MSG_LASTWINDOWMSG     0x010F

/*Dialog and control messages*/
#define MSG_FIRSTCONTROLMSG   0x0120
#define MSG_LASTCONTROLMSG    0x013F

/*System messages*/
#define MSG_FIRSTSYSTEMMSG    0x0140
#define MSG_LASTSYSTEMMSG     0x016F

/*Internal menu messages*/
#define MSG_FIRSTMENUMSG      0x0170
#define MSG_LASTMENUMSG       0x018F

#define MSG_FIRSTEFFECTMSG    0x0200
#define MSG_LASTEFFECTMSG     0x0300

#define MSG_FIRSTLAYERMSG     0x0400
#define MSG_LASTLAYERMSG      0x0420

#define MSG_2D_FIRST          0x1000
#define MSG_2D_LAST          (MSG_2D_FIRST + 30)

/*User-defined  messages*/
#define MSG_FIRSTUSERMSG    0x0800
#define MSG_LASTUSERMSG     0xEFFF

/***********************************************************************
* Mouse event messages
***********************************************************************/
/*Left mouse button down message.*/
#define MSG_LBUTTONDOWN         MSG_FIRSTMOUSEMSG //0x0001
/*Left mouse button up message.*/
#define MSG_LBUTTONUP           (MSG_FIRSTMOUSEMSG + 1) //0x0002
/*Left mouse button double clicked message.*/
#define MSG_LBUTTONDBLCLK       (MSG_FIRSTMOUSEMSG + 2) //0x0003
/*The mouse moved message.*/
#define MSG_MOUSEMOVE           (MSG_FIRSTMOUSEMSG + 3) //0x0004
/*Right mouse button down message.*/
#define MSG_RBUTTONDOWN         (MSG_FIRSTMOUSEMSG + 4) //0x0005
/*Right mouse button up message.*/
#define MSG_RBUTTONUP           (MSG_FIRSTMOUSEMSG + 5) //0x0006
/*Right mouse button double clicked message. */
#define MSG_RBUTTONDBLCLK       (MSG_FIRSTMOUSEMSG + 6) //0x0007
#define MSG_NCMOUSEOFF          (MSG_FIRSTMOUSEMSG + 6) //0x0007
/*Left mouse button down message in the non-client area.*/
#define MSG_NCLBUTTONDOWN       (MSG_FIRSTMOUSEMSG + 7) //0x0008
/*Left mouse button up message in the non-client area.*/
#define MSG_NCLBUTTONUP         (MSG_FIRSTMOUSEMSG + 8) //0x0009
/*Left mouse button double clicked in the non-client area.*/
#define MSG_NCLBUTTONDBLCLK     (MSG_FIRSTMOUSEMSG + 9) //0x000A
/*Mouse moves in the non-client area.*/
#define MSG_NCMOUSEMOVE         (MSG_FIRSTMOUSEMSG + 10) //0x000B
/*Right mouse button down message in the non-client area.*/
#define MSG_NCRBUTTONDOWN       (MSG_FIRSTMOUSEMSG + 11) //0x000C
/*Right mouse button up message in the non-client area.*/
#define MSG_NCRBUTTONUP         (MSG_FIRSTMOUSEMSG + 12) //0x000D
/*Right mouse button double clicked in the non-client area.*/
#define MSG_NCRBUTTONDBLCLK     (MSG_FIRSTMOUSEMSG + 13) //0x000E
#define MSG_MOUSELONGPRESS      (MSG_FIRSTMOUSEMSG + 14) //0x000F/*ʳΪճ*/

/***********************************************************************
* Key event messages
***********************************************************************/
/*presses a key down.*/
#define MSG_KEYDOWN             MSG_FIRSTKEYMSG //0x0010
/*A character translated from MSG_KEYDOWN message.*/
#define MSG_CHAR                (MSG_FIRSTKEYMSG + 1) //0x0011
/*Releases up a key.*/
#define MSG_KEYUP               (MSG_FIRSTKEYMSG + 2) //0x0012
/*presses down a key when \<Alt\> key is down*/
#define MSG_SYSKEYDOWN          (MSG_FIRSTKEYMSG + 3) //0x0013
/*A system character translated from MSG_SYSKEYDOWN message. when \<Alt\> key is down*/
#define MSG_SYSCHAR             (MSG_FIRSTKEYMSG + 4) //0x0014
/*releases up a key when \<Alt\> key is down. */
#define MSG_SYSKEYUP            (MSG_FIRSTKEYMSG + 5) //0x0015
/*A key symbol translated from MSG_KEYDOWN messages.*/
#define MSG_KEYSYM              (MSG_FIRSTKEYMSG + 6) //0x0016
#define MSG_KEYLONGPRESS        (MSG_FIRSTKEYMSG + 7) //0x0017
#define MSG_KEYALWAYSPRESS      (MSG_FIRSTKEYMSG + 8) //0x0018

/***********************************************************************
* post_event_msgs Post mouse/key event messages
***********************************************************************/
/*Sets cursor shape in the client area.*/
#define MSG_SETCURSOR           MSG_FIRSTPOSTMSG //0x0020
#define HT_UNKNOWN              0x00
#define HT_OUT                  0x01
#define HT_MENUBAR              0x02
#define HT_TRANSPARENT          0x03
#define HT_CLIENT               0x0C
#define HT_NEEDCAPTURE          0x10
#define HT_HSCROLL              0x18
#define HT_VSCROLL              0x19
#define SBPOS_UPARROW           0x85
#define SBPOS_DOWNARROW         0x86
#define SBPOS_UPSPACE           0x87
#define SBPOS_DOWNSPACE         0x88
#define SBPOS_THUMB             0x89
#define SBPOS_UNKNOWN           0x80
#define SBPOS_MASK              0x80

#define MSG_NCHITTEST           (MSG_FIRSTPOSTMSG + 1) //0x0021
#define MSG_HITTEST             (MSG_NCHITTEST)
#define MSG_CHANGESIZE          (MSG_FIRSTPOSTMSG + 2) //0x0022
#define MSG_QUERYNCRECT         (MSG_FIRSTPOSTMSG + 3) //0x0023
#define MSG_QUERYCLIENTAREA     (MSG_FIRSTPOSTMSG + 4) //0x0024
/*Indicates the size of the window is being changed.*/
#define MSG_SIZECHANGING        (MSG_FIRSTPOSTMSG + 5) //0x0025
/*Indicates the size of the window has been changed.*/
#define MSG_SIZECHANGED         (MSG_FIRSTPOSTMSG + 6) //0x0026
/*㴥ʱzcore͸MMIдķŴСϢ*/
#define MSG_MOUSEDPTOUT         (MSG_FIRSTPOSTMSG + 7) //0x0027
#define MSG_MOUSEDPTIN          (MSG_FIRSTPOSTMSG + 8) //0x0028
/*Indicates that the window has gained the input focus.*/
#define MSG_SETFOCUS            (MSG_FIRSTPOSTMSG + 16) //0x0030
/*Indicates that the window has lost the input focus.*/
#define MSG_KILLFOCUS           (MSG_FIRSTPOSTMSG + 17) //0x0031
/*Indicates that the window has gained the input focus because the user clicked the window.*/
#define MSG_MOUSEACTIVE         (MSG_FIRSTPOSTMSG + 18) //0x0032
#define MSG_ACTIVE              (MSG_FIRSTPOSTMSG + 19) //0x0033
#define MSG_CHILDHIDDEN         (MSG_FIRSTPOSTMSG + 20) //0x0034

#define RCTM_CLICK          1
#define RCTM_KEY            2
#define RCTM_MESSAGE        3
#define RCTM_SHOWCTRL       4

/*Indicates that the user activates the menu bar and tracks it.*/
#define MSG_ACTIVEMENU          (MSG_FIRSTPOSTMSG + 32) //0x0040
/*Indicates the end of the tracking of a menu bar or a popup menu.*/
#define MSG_DEACTIVEMENU        (MSG_FIRSTPOSTMSG + 33) //0x0041

/* Scroll bar notifying code */
#define SB_LINEUP               0x01
#define SB_LINEDOWN             0x02
#define SB_LINELEFT             0x03
#define SB_LINERIGHT            0x04
#define SB_PAGEUP               0x05
#define SB_PAGEDOWN             0x06
#define SB_PAGELEFT             0x07
#define SB_PAGERIGHT            0x08
#define SB_THUMBPOSITION        0x09
#define SB_THUMBTRACK           0x0A
#define SB_ENDSCROLL            0x0B
#define SB_TOP                  0x0C
#define SB_BOTTOM               0x0D

/*Indicates that the user has clicked the horizontal scroll bar.*/
#define MSG_HSCROLL             (MSG_FIRSTPOSTMSG + 34) //0x0042
/*Indicates that the user has clicked the vertical scroll bar.*/
#define MSG_VSCROLL             (MSG_FIRSTPOSTMSG + 35) //0x0043
#define MSG_NCSETCURSOR         (MSG_FIRSTPOSTMSG + 36) //0x0044
/*Indicates the mouse is moved in/out the area of the window.*/
#define MSG_MOUSEMOVEIN         (MSG_FIRSTPOSTMSG + 48) //0x0050

/***********************************************************************
* creation_msgs Window creation messages
***********************************************************************/
/*Indicates the window has been created, and gives you a chance to initialize your private objects.*/
#define MSG_CREATE              MSG_FIRSTCREATEMSG //0x0060
/*Indicates the window has been created, but has not registered to the system.*/
#define MSG_NCCREATE            (MSG_FIRSTCREATEMSG + 1) //0x0061
#define MSG_INITPANES           (MSG_FIRSTCREATEMSG + 2) //0x0062
#define MSG_DESTROYPANES        (MSG_FIRSTCREATEMSG + 3) //0x0063
/*Indicates the window will be destroied.*/
#define MSG_DESTROY             (MSG_FIRSTCREATEMSG + 4) //0x0064
#define MSG_NCDESTROY           (MSG_FIRSTCREATEMSG + 5) //0x0065
/*Indicates the user has clicked the closing box on the caption.*/
#define MSG_CLOSE               (MSG_FIRSTCREATEMSG + 6) //0x0066
#define MSG_NCCALCSIZE          (MSG_FIRSTCREATEMSG + 7) //0x0067
/*Indicates the user has clicked the maximizing box on the caption.*/
#define MSG_MAXIMIZE            (MSG_FIRSTCREATEMSG + 8) //0x0068
/*Indicates the user has clicked the minimizing box on the caption.*/
#define MSG_MINIMIZE            (MSG_FIRSTCREATEMSG + 9) //0x0069

/***********************************************************************
* Window painting messages
***********************************************************************/
/*Indicates that the window has been shown or hidden.*/
#define MSG_SHOWWINDOW          MSG_FIRSTPAINTMSG //0x00A0
#define MSG_SHOWCPWIN           (MSG_FIRSTPAINTMSG + 1) //0x00A1  /*ճʾ*/
/*Sent to the window to erase the background.async message*/
#define MSG_ERASEBKGND          0x00B0
/*async message*/
#define MSG_PAINT               0x00B1
#define MSG_NCPAINT             0x00B2
#define MSG_NCACTIVATE          0x00B3
#define MSG_SYNCPAINT           0x00B4

/***********************************************************************
* Internal desktop messages
***********************************************************************/
#define MSG_STARTSESSION        MSG_FIRSTSESSIONMSG //0x00D0
#define MSG_QUERYENDSESSION     (MSG_FIRSTSESSIONMSG + 1) //0x00D1
#define MSG_ENDSESSION          (MSG_FIRSTSESSIONMSG + 2) //0x00D2
#define MSG_REINITSESSION       (MSG_FIRSTSESSIONMSG + 3) //0x00D3

#define MSG_ERASEDESKTOP        (MSG_FIRSTSESSIONMSG + 16) //0x00E0
#define MSG_PAINTDESKTOP        (MSG_FIRSTSESSIONMSG + 17) //0x00E1
#define MSG_DT_MOUSEOFF         (MSG_FIRSTSESSIONMSG + 17) //0x00E1
#define MSG_DT_LBUTTONDOWN      (MSG_FIRSTSESSIONMSG + 18) //0x00E2
#define MSG_DT_LBUTTONUP        (MSG_FIRSTSESSIONMSG + 19) //0x00E3
#define MSG_DT_LBUTTONDBLCLK    (MSG_FIRSTSESSIONMSG + 20) //0x00E4
#define MSG_DT_MOUSEMOVE        (MSG_FIRSTSESSIONMSG + 21) //0x00E5
#define MSG_DT_RBUTTONDOWN      (MSG_FIRSTSESSIONMSG + 22) //0x00E6
#define MSG_DT_RBUTTONUP        (MSG_FIRSTSESSIONMSG + 23) //0x00E7
#define MSG_DT_RBUTTONDBLCLK    (MSG_FIRSTSESSIONMSG + 24) //0x00E8
#define MSG_DT_KEYOFF           (MSG_FIRSTSESSIONMSG + 10) //0x00DA
#define MSG_DT_KEYDOWN          (MSG_FIRSTSESSIONMSG + 26) //0x00EA
#define MSG_DT_CHAR             (MSG_FIRSTSESSIONMSG + 27) //0x00EB
#define MSG_DT_KEYUP            (MSG_FIRSTSESSIONMSG + 28) //0x00EC
#define MSG_DT_SYSKEYDOWN       (MSG_FIRSTSESSIONMSG + 29) //0x00ED
#define MSG_DT_SYSCHAR          (MSG_FIRSTSESSIONMSG + 30) //0x00EE
#define MSG_DT_SYSKEYUP         (MSG_FIRSTSESSIONMSG + 31) //0x00EF

/***********************************************************************
* Internal window management messages
***********************************************************************/
#define MSG_ADDNEWMAINWIN       MSG_FIRSTWINDOWMSG //0x00F0
#define MSG_REMOVEMAINWIN       (MSG_FIRSTWINDOWMSG + 1) //0x00F1
#define MSG_MOVETOTOPMOST       (MSG_FIRSTWINDOWMSG + 2) //0x00F2
#define MSG_SETACTIVEMAIN       (MSG_FIRSTWINDOWMSG + 3) //0x00F3
#define MSG_GETACTIVEMAIN       (MSG_FIRSTWINDOWMSG + 4) //0x00F4
#define MSG_SHOWMAINWIN         (MSG_FIRSTWINDOWMSG + 5) //0x00F5
#define MSG_HIDEMAINWIN         (MSG_FIRSTWINDOWMSG + 6) //0x00F6
#define MSG_MOVEMAINWIN         (MSG_FIRSTWINDOWMSG + 7) //0x00F7
#define MSG_SETCAPTURE          (MSG_FIRSTWINDOWMSG + 8) //0x00F8
#define MSG_GETCAPTURE          (MSG_FIRSTWINDOWMSG + 9) //0x00F9
#define MSG_ENDTRACKMENU        (MSG_FIRSTWINDOWMSG + 10) //0x00FA
#define MSG_TRACKPOPUPMENU      (MSG_FIRSTWINDOWMSG + 11) //0x00FB
#define MSG_CLOSEMENU           (MSG_FIRSTWINDOWMSG + 12) //0x00FC
#define MSG_SCROLLMAINWIN       (MSG_FIRSTWINDOWMSG + 13) //0x00FD
#define MSG_CARET_CREATE        (MSG_FIRSTWINDOWMSG + 14) //0x00FE
#define MSG_CARET_DESTROY       (MSG_FIRSTWINDOWMSG + 15) //0x00FF
#define MSG_ENABLEMAINWIN       (MSG_FIRSTWINDOWMSG + 16) //0x0100
#define MSG_ISENABLED           (MSG_FIRSTWINDOWMSG + 17) //0x0101
#define MSG_SETWINCURSOR        (MSG_FIRSTWINDOWMSG + 18) //0x0102
#define MSG_GETNEXTMAINWIN      (MSG_FIRSTWINDOWMSG + 19) //0x0103

#define MSG_SHOWGLOBALCTRL      (MSG_FIRSTWINDOWMSG + 26) //0x010A
#define MSG_HIDEGLOBALCTRL      (MSG_FIRSTWINDOWMSG + 27) //0x010B
#define MSG_GETHWNDLIST         (MSG_FIRSTWINDOWMSG + 28) //0x010C
/* ĻתϢ */
#define MSG_SCREENROTATION      (MSG_FIRSTWINDOWMSG + 30) //0x010E

/***********************************************************************
* Dialog and control messages
***********************************************************************/
/*indicates a notification message from child window,or the user has selected a menu item.*/
#define MSG_COMMAND             MSG_FIRSTCONTROLMSG //0x0120
#define MSG_SYSCOMMAND          (MSG_FIRSTCONTROLMSG + 1) //0x0121
#define MSG_GETDLGCODE          (MSG_FIRSTCONTROLMSG + 2) //0x0122
#define MSG_INITDIALOG          (MSG_FIRSTCONTROLMSG + 3) //0x0123
#define MSG_NEXTDLGCTRL         (MSG_FIRSTCONTROLMSG + 4) //0x0124
#define MSG_ENTERIDLE           (MSG_FIRSTCONTROLMSG + 5) //0x0125
#define MSG_DLG_GETDEFID        (MSG_FIRSTCONTROLMSG + 6) //0x0126
#define MSG_DLG_SETDEFID        (MSG_FIRSTCONTROLMSG + 7) //0x0127
//#define MSG_DLG_REPOSITION    0x0128
/*query whether the window is a dialog window.*/
#define MSG_ISDIALOG            (MSG_FIRSTCONTROLMSG + 8) //0x0128
/*initialize the controls in a property page.*/
#define MSG_INITPAGE            (MSG_FIRSTCONTROLMSG + 9) //0x0129
/*Indicates the page will be shown or hidden.*/
#define MSG_SHOWPAGE            (MSG_FIRSTCONTROLMSG + 10) //0x012A
/*Indicates that a PSM_SHEETCMD message had been sent to the PropertySheet control.*/
#define MSG_SHEETCMD            (MSG_FIRSTCONTROLMSG + 11) //0x012B
/*This message will be sent to the container window procedure after the container window is created.*/
#define MSG_INITCONTAINER       (MSG_FIRSTCONTROLMSG + 12) //0x012C
/*This message will be sent to the parent of the ScrollView control when the container of the
    ScrollView control reveived a MSG_COMMAND message.*/
#define MSG_SVCONTCMD           (MSG_FIRSTCONTROLMSG + 13) //0x012D
/*freeze or thaw the paint action of the control.*/
#define MSG_FREEZECTRL          (MSG_FIRSTCONTROLMSG + 14) //0x012E
/*Indicates the user is trying to change the font of the window.*/
#define MSG_FONTCHANGING        (MSG_FIRSTCONTROLMSG + 16) //0x0130
/*Indicates the window font has been changed.*/
#define MSG_FONTCHANGED         (MSG_FIRSTCONTROLMSG + 17) //0x0131
/*Sent to the control to get the length of the text.*/
#define MSG_GETTEXTLENGTH       (MSG_FIRSTCONTROLMSG + 18) //0x0132
/*Sent to the control to get the text.*/
#define MSG_GETTEXT             (MSG_FIRSTCONTROLMSG + 19) //0x0133
/*Sent to the control to set the text.*/
#define MSG_SETTEXT             (MSG_FIRSTCONTROLMSG + 20) //0x0134
/*Indicates the window is disabled/enabled.*/
#define MSG_ENABLE              (MSG_FIRSTCONTROLMSG + 21) //0x0135
#define MSG_SVCOMMAND		 (MSG_FIRSTCONTROLMSG + 22) //0x0136
/***********************************************************************
* System messages
***********************************************************************/
#define MSG_QUIT                MSG_FIRSTSYSTEMMSG //0x0140
/*Indicates the system enters idle loop.*/
#define MSG_IDLE                (MSG_FIRSTSYSTEMMSG + 2) //0x0142
#define MSG_TIMEOUT             (MSG_FIRSTSYSTEMMSG + 3) //0x0143
/*Indicates a timer has expired.*/
#define MSG_TIMER               (MSG_FIRSTSYSTEMMSG + 4) //0x0144
#define MSG_CARETBLINK          (MSG_FIRSTSYSTEMMSG + 5) //0x0145
#define MSG_BLINKCARET          (MSG_FIRSTSYSTEMMSG + 6) //0x0146
/*query whether the window needs to open IME window.*/
#define MSG_DOESNEEDIME         (MSG_FIRSTSYSTEMMSG + 16) //0x0150
#define MSG_IME_REGISTER        (MSG_FIRSTSYSTEMMSG + 17) //0x0151
#define MSG_IME_UNREGISTER      (MSG_FIRSTSYSTEMMSG + 18) //0x0152
#define MSG_IME_OPEN            (MSG_FIRSTSYSTEMMSG + 19) //0x0153
#define MSG_IME_CLOSE           (MSG_FIRSTSYSTEMMSG + 20) //0x0154
#define MSG_IME_SETSTATUS       (MSG_FIRSTSYSTEMMSG + 22) //0x0156
#define MSG_IME_GETSTATUS       (MSG_FIRSTSYSTEMMSG + 23) //0x0157

#define IS_ENABLE       1
#define IS_FULLCHAR     2
#define IS_FULLPUNC     3
#define IS_METHOD       4

#define MSG_IME_SETTARGET       (MSG_FIRSTSYSTEMMSG + 24) //0x0158
#define MSG_IME_GETTARGET       (MSG_FIRSTSYSTEMMSG + 25) //0x0159

#define MSG_SHOWMENU            (MSG_FIRSTSYSTEMMSG + 32) //0x0160
#define MSG_HIDEMENU            (MSG_FIRSTSYSTEMMSG + 33) //0x0161
#define MSG_ADDTIMER            (MSG_FIRSTSYSTEMMSG + 34) //0x0162
#define MSG_REMOVETIMER         (MSG_FIRSTSYSTEMMSG + 35) //0x0163
#define MSG_RESETTIMER          (MSG_FIRSTSYSTEMMSG + 36) //0x0164
#define MSG_WINDOWCHANGED       (MSG_FIRSTSYSTEMMSG + 37) //0x0165
#define MSG_BROADCASTMSG        (MSG_FIRSTSYSTEMMSG + 38) //0x0166
#define MSG_REGISTERWNDCLASS    (MSG_FIRSTSYSTEMMSG + 39) //0x0167
#define MSG_UNREGISTERWNDCLASS  (MSG_FIRSTSYSTEMMSG + 40) //0x0168
#define MSG_NEWCTRLINSTANCE     (MSG_FIRSTSYSTEMMSG + 41) //0x0169
#define MSG_REMOVECTRLINSTANCE  (MSG_FIRSTSYSTEMMSG + 42) //0x016A
#define MSG_GETCTRLCLASSINFO    (MSG_FIRSTSYSTEMMSG + 43) //0x016B
#define MSG_CTRLCLASSDATAOP     (MSG_FIRSTSYSTEMMSG + 44) //0x016C

#define CCDOP_GETCCI        0x01
#define CCDOP_SETCCI        0x02

#define MSG_REGISTERKEYHOOK     (MSG_FIRSTSYSTEMMSG + 45) //0x016D
#define MSG_REGISTERMOUSEHOOK   (MSG_FIRSTSYSTEMMSG + 46) //0x016E

/***********************************************************************
* Internal menu messages
***********************************************************************/
#define MSG_INITMENU            MSG_FIRSTMENUMSG //0x0170
#define MSG_INITMENUPOPUP       (MSG_FIRSTMENUMSG + 1) //0x0171
#define MSG_MENUSELECT          (MSG_FIRSTMENUMSG + 2) //0x0172
#define MSG_MENUCHAR            (MSG_FIRSTMENUMSG + 3) //0x0173
#define MSG_ENTERMENULOOP       (MSG_FIRSTMENUMSG + 4) //0x0174
#define MSG_EXITMENULOOP        (MSG_FIRSTMENUMSG + 5) //0x0175
#define MSG_CONTEXTMENU         (MSG_FIRSTMENUMSG + 6) //0x0176
#define MSG_NEXTMENU            (MSG_FIRSTMENUMSG + 7) //0x0177

/***********************************************************************
* 2D
***********************************************************************/
/*ȡ2DЧʹõĻַ*/
#define MSG_2DGETEFFECTBUF      0x0200
/*ʱΪھֲЧ׼*/
#define MSG_2DBEFORECREATE      0x0201
/*ٴʱΪھֲЧ׼*/
#define MSG_2DBEFOREDESTROY     0x0202
/*ִTouchWizЧʱΪھֲЧ׼*/
#define MSG_2DTOUCHWIZPREPARE   0x0203
/*ȡʼĻݱ浽ʼУлGCֹ*/
#define MSG_2DSWITCH2NEWFB      0x0204
/*лGCĬϻ*/
#define MSG_2DSWITCH2DEFAULTFB  0x0205
/*Ŀ껺еˢµĻ*/
#define MSG_2DFLUSHBUFFER       0x0206
/*ֹͣڽеһ֡Ч*/
#define MSG_2DSTOPEFFECT        0x0207
/*жǷִ2DЧ*/
#define MSG_2DGETSTATUS         0x0208
/*뵭*/
#define MSG_2DFADEPREPARE       0x0209
/*ʼ壬Чʼ*/
#define EFFECT_START_BUF        0x0210
/*ֹ壬Ч*/
#define EFFECT_END_BUF          0x0211
/*ĿĻ壬Ч*/
#define EFFECT_DST_BUF          0x0212

#define MSG_REGISTERHWNDHOOK   (0x0300 + 1)
#define MSG_REGISTERCBWINHOOK  (0x0300 + 2)   /*ճ*/

/***********************************************************************
*
***********************************************************************/
#define MSG_LAYER_ENABLE         (MSG_FIRSTLAYERMSG + 1)
#define MSG_LAYER_COLORKEY       (MSG_FIRSTLAYERMSG + 2)
#define MSG_LAYER_ALPHA          (MSG_FIRSTLAYERMSG + 3)
#define MSG_LAYER_ALPHA_TABLE    (MSG_FIRSTLAYERMSG + 4)

#define MSG_2D_GET_VIEW_HEIGHT   (MSG_2D_FIRST + 1) /* ȡݸ߶ͼ߶ȵĲֵ. ͼ߶Ϊһҳݵĸ߶ */
#define MSG_2D_GET_CURRENT_POS   (MSG_2D_FIRST + 2) /* ȡϽǵλ*/
#define MSG_2D_SET_CURRENT_POS   (MSG_2D_FIRST + 3) /* ôݵλ*/
#define MSG_2D_GET_RECT          (MSG_2D_FIRST + 4) /* ȡ*/
#define MSG_2D_UNSET_CURSEL      (MSG_2D_FIRST + 5) /* ȥѡ*/
#define MSG_CLICK                (MSG_2D_FIRST + 6) /* ʱûʹ*/
#define MSG_2D_GET_CONTENT_RATE  (MSG_2D_FIRST + 7)  /* ȡڵݸ߶ͼ߶ȵıֵ */
#define MSG_2D_GET_CONTENT_HIGHT (MSG_2D_FIRST + 8)  /* ȡڵݸ߶*/
#define MSG_2D_STOP_THUMBTOUCH   (MSG_2D_FIRST + 9)  /* Ĵָ*/
#define MSG_2D_BLOCK_UNLOCK      (MSG_2D_FIRST + 10)/* ʱûʹ*/
#define MSG_2D_GET_ENDBUFF       (MSG_2D_FIRST + 11)/* ʱûʹ*/
#define MSG_2D_THUMBTOUCH_FINISH (MSG_2D_FIRST + 12)/* Ϣ*/
#define MSG_2D_POSITION_CHANGED  (MSG_2D_FIRST + 13)/* ֪ͨڵǰλ */
#define MSG_2D_END_PAINT         (MSG_2D_FIRST + 14)/* paint֪ͨϢ */
#define MSG_2D_BOUNDARY          (MSG_2D_FIRST + 15)/* ؼڻ߽ */
#define MSG_2D_READY_EXE_THUMBTOUCH   (MSG_2D_FIRST + 16) /* ڻ֮ǰ־λλ */
#define MSG_2D_PREPARE_THUMBTOUCH     (MSG_2D_FIRST + 17) /* ׼,ҳ */
#define MSG_2D_GET_CURRENT_CTRL       (MSG_2D_FIRST + 18) /* ȡǰʾĿؼ */
#define MSG_2D_GET_LAST_CHILD_CTRL    (MSG_2D_FIRST + 19) /* ȡһӿؼ */
#define MSG_2D_NEW_PAGE_TO_BUFF       (MSG_2D_FIRST + 20) /* ҳ 2010-06-04*/
#define MSG_2D_GET_ITEM_HEIGHT        (MSG_2D_FIRST + 21) /* ȡÿһбĸ߶*/
#define MSG_2D_BEGIN_MOVE             (MSG_2D_FIRST + 22) /* ֪ͨڿʼ*/
#define MSG_2D_THUMBTOUCH_SWITCH_BUFF (MSG_2D_FIRST + 23) /* лԴ浽Ĵָ */
#define MSG_2D_THUMBTOUCH_SET_BKG     (MSG_2D_FIRST + 24) /* wΪõıͼƬָ */
#define MSG_2D_THUMBTOUCH_LBUTTONUP   (MSG_2D_FIRST + 25) /* ڲ·ϵͳupϢʱתϢĴָģ */
#define MSG_2D_THUMBTOUCH_TIMER       (MSG_2D_FIRST + 26)
#define MSG_2D_THUMBTOUCH_REPAINT_CURRBUFF (MSG_2D_FIRST + 27)
/***********************************************************************
* user-defined message
***********************************************************************/
#define MSG_USER  0x0800
#define MSG_GM_SET_NEXT_HIGHTLIGHT  (0x1100 + 2) //һw 1ʾ£-1

ZBOOL GetThumbTouchState();

#endif
