#ifndef _ZCORE_WINMSG_H
#define _ZCORE_WINMSG_H

#include "zcore_type.h"

/*PeekMessage flags*/
#define PM_NOREMOVE     	0x0000
#define PM_REMOVE       	0x0001
#define PM_NOYIELD      	0x0002

/**
 * The message structure.
 */
typedef struct _MSG
{
    /** the handle to the window which receives this message. */
    HWND             hwnd;
    /** the message identifier. */
    ZSINT32              message;
    /** The first parameter of the message (32-bit integer). */
    WPARAM           wParam;
    /** The second parameter of the message (32-bit integer). */
    LPARAM           lParam;
    ZUINT32     time;
    ZVOID*            pAdd;

    /* Ϊlayerչʹ */
    unsigned         addData[4];
} MSG;
typedef MSG* PMSG;

/**
 * 㴥Ϣĸ
 * 洢ṹ
 */
typedef struct _DPTCOORDINATE
{
    ZUINT16   iPosX;        /*x*/
    ZUINT16   iPosY;        /*y*/ 
    ZUINT16   rXVaule;     /* rx*/
    ZUINT16   rYVaule;     /* ry*/
} DPTCOORDINATE;

/*Gets a message from the message queue of a main window.*/
ZSINT32 WMSG_GetMessage (PMSG pMsg, HWND hMainWnd);
/*Posts a message into the message queue of a window and returns immediatly.*/
ZSINT32 WMSG_PostMessage (HWND hWnd, ZSINT32 iMsg, WPARAM wParam, LPARAM lParam);
/*Sends a message to a window.*/
ZSINT32 WMSG_SendMessage (HWND hWnd, ZSINT32 iMsg, WPARAM wParam, LPARAM lParam);
ZSINT32 SendMessageD(HWND hWnd, ZSINT32 iMsg, WPARAM wParam, LPARAM lParam);
ZSINT32 SendAsyncMessage (HWND hWnd, ZSINT32 iMsg, WPARAM wParam, LPARAM lParam);
/*Sends a notification message to a window.*/
ZSINT32 WMSG_SendNotifyMessage (HWND hWnd, ZSINT32 iMsg, WPARAM wParam, LPARAM lParam);
/*Broadcasts a message to all main window on the desktop.*/
ZSINT32 WMSG_BroadcastMessage (ZSINT32 iMsg, WPARAM wParam, LPARAM lParam);
/*Puts a MSG_QUIT message into the message queue of a main window.*/
ZSINT32 WMSG_PostQuitMessage (HWND hWnd);
/*Translates key down and key up messages to MSG_CHAR message and post it into the message queue.*/
ZBOOL WMSG_TranslateMessage (PMSG pMsg);
/*Dispatches a message to the window's callback procedure.*/
ZSINT32 WMSG_DispatchMessage (PMSG pMsg);
/*Removes all messages in the message queue associated with a window.*/
ZSINT32 WMSG_ThrowAwayMessages (HWND pMainWnd);
/*Peeks a post message from the message queue of a main window*/
ZBOOL WMSG_PeekPostMessage(PMSG pMsg,HWND hWnd,ZSINT32 iMsgFilterMin, ZSINT32 iMsgFilterMax, ZUINT uRemoveMsg);

ZVOID NotifyParentEx (HWND hwnd, ZSINT32 id, ZSINT32 code, ZDWORD add_data);

#define NotifyParent(hwnd, id, code) \
                NotifyParentEx(hwnd, id, code, 0)

ZSINT32 GetMessage (PMSG pMsg, HWND hMainWnd);
ZSINT32 PostMessage (HWND hWnd, ZSINT32 iMsg, WPARAM wParam, LPARAM lParam);
ZSINT32 SendMessage (HWND hWnd, ZSINT32 iMsg, WPARAM wParam, LPARAM lParam);
ZSINT32 SendNotifyMessage (HWND hWnd, ZSINT32 iMsg, WPARAM wParam, LPARAM lParam);
ZSINT32 BroadcastMessage (ZSINT32 iMsg, WPARAM wParam, LPARAM lParam);
ZSINT32 PostQuitMessage (HWND hWnd);
ZBOOL   TranslateMessage (PMSG pMsg);
ZSINT32 DispatchMessage (PMSG pMsg);
ZSINT32 ThrowAwayMessages (HWND pMainWnd);
ZBOOL   PeekPostMessage (PMSG pMsg, HWND hWnd, ZSINT32 iMsgFilterMin, ZSINT32 iMsgFilterMax, ZUINT uRemoveMsg);
ZBOOL   PeekMessage (PMSG pMsg, HWND hWnd, ZSINT32 iMsgFilterMin, ZSINT32 iMsgFilterMax, ZUINT uRemoveMsg);
ZSINT32 PostSyncMessage (HWND hWnd, ZSINT32 iMsg, WPARAM wParam, LPARAM lParam);

#endif
