#ifndef FW_COMM_H
#define FW_COMM_H

#include "zcore_type.h"
#include "os_type.h"
#include "osa_api_fw.h"

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#define COMM_CHANNEL_NAME_MAX_LEN		 64

#define COMM_QUEUE_NAME_MAX_LEN			 32

typedef SINT32 (*COMM_MSG_PROC)(UINT32 id, CONST ZVOID *data, UINT32 size, ZVOID *add_data);

/*typedef enum COMM_ERR_CODE*/
/*{*/
#define	COMM_ERR_SUCCESS    		    	0		/* ɹ							*/
#define	COMM_ERR_GENERAL      			 	-1		/* һ					*/
#define	COMM_ERR_NOT_INIT      				-2		/* ͨϵͳûгԻ			*/
#define	COMM_ERR_READY_REG    				-3		/* עѾע		*/
#define	COMM_ERR_READY_CREATE			 	-4		/* ͨѾ				*/
#define	COMM_ERR_MSG_SEND_FAILUR		    -5		/* ϢʧܣҲͨ */
#define	COMM_ERR_MEMORY_NOT_ENOUGH			-6		/* ڴ						*/
#define	COMM_ERR_EXCEED_MAX_LEN			    -7		/* ֳָͨ󳤶	*/
#define	COMM_ERR_THREAD_CREATE_FAILURE		-8		/* ߳ʧ					*/
#define	COMM_ERR_READY_INIT    				-9		/* עѾע		*/
#define	COMM_ERR_INVALID_PARA			    -10    /* ЧĲ					*/
#define	COMM_ERR_CHANNEL_NOT_EXIST		    -11		/* ͨ					*/
#define	COMM_ERR_MSGID_NOT_EXIST		    -12		/* ϢID					*/
/*};*/

typedef struct _ENVELOPE
{
	ZUINT8					channel_name[COMM_CHANNEL_NAME_MAX_LEN + 2];	
	UINT32 					msg_id;			
	ZVOID 					*msg_data;		
	UINT32 					msg_size;		
} ENVELOPE;

/*****************************************************************************
* Function: tp_comm_init
* Purpose:  the initialization interface of communication system.
* Relation: N/A
* Params:
* 																			   
*   Name		Type		In/Out 		Description							   
* -------- 		---- 		------   	----------- 				       
*					 														   
* Return:  if success, return COMM_ERR_SUCCESS.
*		   or COMM_ERR_MEMORY_NOT_ENOUGH, COMM_ERR_THREAD_CREATE_FAILURE, COMM_ERR_READY_INIT for errors.
* Note:    just call once before using commucation system.
*******************************************************************************/
/* SINT32 tp_comm_init(VOID); */
SINT32 tp_comm_init(ZBOOL posix_thread); 

/*****************************************************************************
* Function: tp_comm_destroy
* Purpose:  the destroy interface of communication system
* Relation: N/A
* Params:
* 																			   
*   Name		Type		In/Out 		Description							   
* -------- 		---- 		------   	----------- 				       
*					 														   
* Return:  if success, return COMM_ERR_SUCCESS.
*		   or COMM_ERR_NOT_INIT for some error.
* Note:    just call once after using commucation system.
*******************************************************************************/
SINT32 tp_comm_destroy(ZVOID);

/*****************************************************************************
* Function: tp_comm_channel_create
* Purpose:  create one channel using for commucation.
* Relation: N/A
* Params:
* 																			   
*   Name			Type		In/Out 		Description							   
* -------- 			---- 		------   	----------- 				       
* channel_name  CONST CHAR*		In			the channel_name is used to identify the being created channel.
* msg_proc		COMM_MSG_PROC	In			msg_proc is the message receipt function, when one message is called, 
*												this callback function will be call by comm system.
* add_data		VOID*			In			the additional data of the channel, comm system just pass this data 
*												when call the msg_proc.			
*					 														   
* Return:  if success, return COMM_ERR_SUCCESS.
*		   or COMM_ERR_MEMORY_NOT_ENOUGH, COMM_ERR_INVALID_PARA, COMM_ERR_EXCEED_MAX_LEN for errors.
* Note:    N/A.
*******************************************************************************/
SINT32 tp_comm_channel_create(CONST ZCHAR *channel_name, COMM_MSG_PROC msg_proc , ZVOID *add_data);

/*****************************************************************************
* Function: tp_comm_channel_destroy
* Purpose:  destroy one existing channel.
* Relation: N/A
* Params:
* 																			   
*   Name			Type		In/Out 		Description							   
* -------- 			---- 		------   	----------- 				       
* channel_name  CONST CHAR*		In			to be destroyed channel.
*
* Return:  if success, return COMM_ERR_SUCCESS.
*		   or COMM_CHANNEL_NOT_EXIST, COMM_ERR_INVALID_PARA for errors.
* Note:    N/A.
*******************************************************************************/
SINT32 tp_comm_channel_destroy(CONST ZCHAR *channel_name);

/*****************************************************************************
* Function: tp_comm_channel_query
* Purpose:  query the channel named channel_name.
* Relation: N/A
* Params:
* 																			   
*   Name			Type		In/Out 		Description							   
* -------- 			---- 		------   	----------- 				       
* channel_name  CONST CHAR*		In			the channel to be queryed.
*
* Return:  TRUE : existing.
*		   FALSE : not existing.
* Note:    N/A.
*******************************************************************************/
ZBOOL tp_comm_channel_query(CONST ZCHAR *channel_name);

/*****************************************************************************
* Function: tp_comm_channel_get_add_data
* Purpose:  get channel's additional data.
* Relation: N/A
* Params:
* 																			   
*   Name			Type		In/Out 		Description							   
* -------- 			---- 		------   	----------- 				       
* channel_name  CONST CHAR*		In			to be destroyed channel.
*
* Return:  if success, return channel's additional data.
*		   or NULL if no existing.
*
* Note:    if the additional data is NULL, using this function cant judge the channel is wheather existing,
*				so you shall call tp_comm_channel_query to make sure.
*******************************************************************************/
ZVOID *tp_comm_channel_get_add_data(CONST ZCHAR *channel_name);

/*****************************************************************************
* Function: tp_comm_channel_reg_msg
* Purpose:  register the message to one channel, only the registered messages can
*				be received by this channel.
* Relation: N/A
* Params:
* 																			   
*   Name			Type			In/Out 		Description							   
* -------- 			---- 			------   	----------- 				       
* channel_name		CONST CHAR*		In			the channel.
* msg_id			SINT32			In			the message to be register to channel
*
* Return:  if success, return COMM_ERR_SUCCESS.
*		   or error code for errors, see enum type COMM_ERR_CODE.
*
* Note:    N/A
*******************************************************************************/
SINT32 tp_comm_channel_reg_msg(CONST ZCHAR *channel_name , SINT32 msg_id);

/*****************************************************************************
* Function: tp_comm_channel_unreg_msg
* Purpose:  unregister the message to one channel
* Relation: N/A
* Params:
* 																			   
*   Name			Type			In/Out 		Description							   
* -------- 			---- 			------   	----------- 				       
* channel_name		CONST CHAR*		In			the channel.
* msg_id			SINT32			In			the message to be unregister to channel
*
* Return:  if success, return COMM_ERR_SUCCESS.
*		   or error code for errors, see enum type COMM_ERR_CODE.
*
* Note:    N/A
*******************************************************************************/
SINT32 tp_comm_channel_unreg_msg(CONST ZCHAR *channel_name , SINT32 msg_id);

/*****************************************************************************
* Function: tp_comm_channel_post_msg
* Purpose:  post one message.
* Relation: N/A
* Params:
* 																			   
*   Name			Type			In/Out 		Description							   
* -------- 			---- 			------   	----------- 				       
* channel_name		CONST CHAR*		In			the channel to be posted message.
*												if this parameter is NULL or "", 
*													the comm will search all the channels to judge which channel will receive message.
* msg_id			SINT32			In			the message id to be posted.
* msg_data			CONST VOID *    In			the data of the message, this data will be copy by comm system to be posted out.
* msg_size			UINT32			In			the size of msg_data.
*
* Return:  if success, return COMM_ERR_SUCCESS.
*		   or error code for errors, see enum type COMM_ERR_CODE.
*
* Note:    cuz msg_data will be copy by comm system, so the msg_data struct shall not contain the pointer to point another data.
*******************************************************************************/
SINT32 tp_comm_channel_post_msg(CONST ZCHAR *channel_name, UINT32 msg_id, CONST ZVOID *msg_data, UINT32 msg_size);

/* PF Msg ID base definition	*/
#define	MSG_ID_APP_INNER_BASE       (0x2000)
#define	MSG_ID_SC_NET_BASE          (0x2800)
#define MSG_ID_SC_CALL_BASE         (MSG_ID_SC_NET_BASE+0x100)
#define MSG_ID_SC_SMS_BASE          (MSG_ID_SC_CALL_BASE+0x100)
#define MSG_ID_SC_PB_BASE           (MSG_ID_SC_SMS_BASE+0x100)
#define MSG_ID_MAN_AMT_BASE         (MSG_ID_SC_PB_BASE+0x100)
#define MSG_ID_MAN_MM_BASE          (MSG_ID_MAN_AMT_BASE+0x100)
#define MSG_ID_MAN_BACKLIGHT_BASE   (MSG_ID_MAN_MM_BASE+0x100)
#define MSG_ID_MAN_BATTERY_BASE     (MSG_ID_MAN_BACKLIGHT_BASE+0x100)
#define MSG_ID_MAN_CHARGER_BASE     (MSG_ID_MAN_BATTERY_BASE+0x100)
#define MSG_ID_MAN_COMM_BASE        (MSG_ID_MAN_CHARGER_BASE+0x100)
#define MSG_ID_MAN_DATE_BASE        (MSG_ID_MAN_COMM_BASE+0x100)
#define MSG_ID_MAN_IDLE_BASE        (MSG_ID_MAN_DATE_BASE+0x100)
#define MSG_ID_MAN_KEYPAD_BASE      (MSG_ID_MAN_IDLE_BASE+0x100)
#define MSG_ID_MAN_DISPLAY_BASE     (MSG_ID_MAN_KEYPAD_BASE+0x100)
#define MSG_ID_MAN_VIBRATOR_BASE    (MSG_ID_MAN_DISPLAY_BASE+0x100)

#define MSG_ID_FW					(MSG_ID_MAN_VIBRATOR_BASE+0x100)
#define MSG_ID_AMS_START_ERR		(MSG_ID_FW+0x100)

/*
#define MSG_ID_ITC_BASE		(MSG_ID_FW+0x200)

#define ITC_MSG_START           	(MSG_ID_ITC_BASE+0x2)
#define ITC_MSG_CLOSE           	(MSG_ID_ITC_BASE+0x3)
#define ITC_MSG_SYNC		    	(MSG_ID_ITC_BASE+0x4)
#define MSG_CHANNEL_MSG_ARRIVE  	(MSG_ID_ITC_BASE+0x5)
*/

//#define MSG_ID_APP_BASE  	(MSG_ID_ITC_BASE+0x100)
//#define MSG_ID_GEN_BASE	(MSG_ID_APP_BASE+0x100)

#ifndef MSG_ID_GEN_BASE
#define MSG_ID_GEN_BASE				(MSG_ID_FW+0x300)
#endif
#define MSG_ID_SC_PDP_BASE			(MSG_ID_GEN_BASE+0x100)
#define MSG_ID_MAN_ACC_BASE			(MSG_ID_SC_PDP_BASE+0x100)

#define MSG_ID_SC_USAT_BASE			(MSG_ID_MAN_ACC_BASE+0x100)

#define MSG_ID_SC_PTT_BASE			(MSG_ID_SC_USAT_BASE+0x100)

#define MSG_ID_MM_BASE              (MSG_ID_SC_PTT_BASE+0x100)

#define MSG_ID_MAN_BLUETOOTH_BASE   (MSG_ID_MM_BASE+0x100)

#define MSG_ID_DRM_BASE             (MSG_ID_MAN_BLUETOOTH_BASE +0x100)

#ifndef MSG_ID_MAN_UCC_BASE
#define MSG_ID_MAN_UCC_BASE         (MSG_ID_DRM_BASE + 0x100)
#endif

#define MSG_ID_SC_MBMS_BASE         (MSG_ID_MAN_UCC_BASE+0x100)

#define MSG_ID_SECURITY_BASE        (MSG_ID_SC_MBMS_BASE+0x100)

#ifndef MSG_ID_SC_ELOG_BASE
#define MSG_ID_SC_ELOG_BASE               (MSG_ID_SECURITY_BASE+0x100)
#endif

#define MSG_ID_AEP_BASE       (MSG_ID_SC_ELOG_BASE+0x100)
#define MSG_ID_MAN_FM_BASE    (MSG_ID_AEP_BASE+0x100)
#define MSG_ID_SC_FETION_BASE (MSG_ID_SC_ELOG_BASE+0x200) //Ҫ0x3000x300

#define MSG_ID_MAN_GPS_BASE (MSG_ID_MAN_FM_BASE+100)
#define MSG_ID_DM_BASE      (MSG_ID_MAN_GPS_BASE+100)
#define MSG_ID_MMS_BASE     (MSG_ID_DM_BASE+0x100)
#define MSG_ID_TRACE_NET_BASE               (0xF000)
#define MSG_ID_TRACE_CALL_BASE              (0xF100)
#define MSG_ID_TRACE_SMS_BASE               (0xF200)
#define MSG_ID_TRACE_PDP_BASE               (0xF300)
#define MSG_ID_TRACE_PB_BASE                (0xF400)
#define MSG_ID_TRACE_GEN_BASE               (0xF500)

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif
/*-----------end of fw_comm.h--------------------------------------*/

