#ifndef _FW_PMS_H
#define _FW_PMS_H
#include "zcore_type.h"
#include "fw_plugin.h"
#include "fw_comm.h"

/*
  the error code of PMS
*/
typedef enum 
{
    PMS_SUCCESS = 0              //ɹ
    ,PMS_FAILURE = -1            //ʧ
	,PMS_NOT_INIT = -2           //δʼ
    ,PMS_ALREADY_INIT= -3        //ѳʼ    
	,PMS_WIDGET_WAITING_CFG = -5 //WidgetҪ
	,PMS_PARAMETER_ERR = -6      //
	,PMS_NOT_FOUND_DEPLOY_ID = -7//δҵWidgetʶ	
	,PMS_WIDGET_NOT_STOPPED = -8 //Widgetδֹͣ 
	,PMS_WIDGET_IS_RELEASING = -9//PMSģ˳  
	,PMS_PLUGIN_NOT_FOUND = -10  //ָδҵ
	,PMS_PLUGIN_IS_EXIST = -11
}PMS_ERR_CODE;

/*
  Define the out info of the PlugIn which has been loaded by Plug-in Manage System
  --name
  --author
  --desc
  װ·--pli_path
  --class_id  
*/
typedef struct _plugin_out_info_
{	
	ZCHAR name[PLUGIN_NAME_MAX_LEN+1];
	ZCHAR author[PLUGIN_AUTHOR_MAX_LEN+1];
	ZCHAR desc[PLUGIN_DESC_MAX_LEN+1];	
	ZCHAR pli_path[PLUGIN_PATH_MAX_LEN+1];
	DWORD version;
	PIClassId class_id;	
}PIOutInfo;


/*
  Define the deploy info of Widget-Plugin
  ʼx--x
  ʼy--y
  --w
  --h
  ǷԶ--auto_start
*/
typedef struct _deploy_info_
{
	UINT32 x;
    UINT32 y;
    UINT32 w;
    UINT32 h;
	ZBOOL   auto_start;
}PIDeploy;

/*
  Define how to deploy the widget(one kind of Plug-in)
  --pli_path : װ·
  --deploy:    Ϣ
*/
typedef struct _widget_deploy_info
{	
	ZCHAR pli_path[PLUGIN_PATH_MAX_LEN+1];
	PIDeploy deploy;
}PIWidgetDeploy;


/*
  WidgetĵϢ
*/
typedef struct _widget_out_info_
{
   UINT32 deploy_id;
   PIWidgetDeploy deploy_info;
   PIWidgetState state;
   ZBOOL enable_setting;
}PIWidgetOutInfo;


typedef struct _pms_init_data
{
	HWND widget_parent;
}PMS_INIT_DATA;


// װĿ¼
#define PMS_DEFAULT_ROOT_PATH  "/flash/plugin_root"

// Widgetļ
#define PMS_WIDGET_DEPLOY_CFG_PATH  "/flash/plugin_root/widget_deploy.cfg"

// PMSдWidgetӴڵʼؼID
#define PMS_CTRL_ID_START  2000

//Widgetʾڿؼ
#define PMS_CTRL_WIDGET_WINDOW "CTRL_WIDGET"


//PMSͨϢʼֵ
#define PMS_CHNL_MSG_ID_BASE            (MSG_ID_FW + 0x020)

//ͬб
#define PMS_PLUGIN_SYNCHRONIZED          PMS_CHNL_MSG_ID_BASE+1

//PMSģʼ
#define PMS_MODULE_INITED                PMS_CHNL_MSG_ID_BASE+2


#define PMS_MODULE_RELEASED              PMS_CHNL_MSG_ID_BASE+3

/*
  PMSģʼ
  host: ʾĴھ
*/
SINT32 tp_pms_init(PMS_INIT_DATA* init_data);

/*
  PMSģ˳
*/
SINT32 tp_pms_release();

/*
  װ;
  package_path:װȫ·
*/
SINT32 tp_pms_install_package(const ZCHAR* package_path);

/*
  жز;
*/
SINT32 tp_pms_uninstall(const ZCHAR* pli_path);

/*
  ͬĿ¼µв;
*/
SINT32 tp_pms_synchronize();

/*
  ȡ;
  plugin_class:
*/
SINT32 tp_pms_plugin_count(PIClassId plugin_class);

/*
  ȡϢ();
  plugin_infos:Ϣռ;
  plugin_class:;
  read_count:ȡ
*/
SINT32 tp_pms_plugin_list(PIOutInfo* plugin_infos, PIClassId plugin_class, UINT32 read_count);

/*
   ȡϢ();
   pli_path:װ·;
   plugin_info:Ϣռ;
*/
SINT32 tp_pms_plugin_info(const ZCHAR* pli_path, PIOutInfo* plugin_info);

/*
  Widget;
  deploy_id:Widgetʶ
  deploy_inf:WidgetϢ
*/
SINT32 tp_pms_widget_deploy(UINT32 deploy_id, const PIWidgetDeploy* deploy_info);

/*
  ȡWidget;
  deploy_id:Widgetʶ
*/
SINT32 tp_pms_widget_undeploy(UINT32 deploy_id);


/*
  Widget;
  deploy_id:Widgetʶ
  act:
*/
SINT32 tp_pms_widget_command(UINT32 deploy_id, PIWidgetAct act);

/* 
  Widgetô;
  host:йܴ;
  deploy_id:Widgetʶ
  return: ôڵĴھ
*/
HWND   tp_pms_widget_setting(HWND host, UINT32 deploy_id);


/*
  ȡWidgetĸ
  return: Widgetĸ
*/
SINT32 tp_pms_widget_deployed_count();


/*
  ȡWidgetϢ()
  widget_info:WidgetϢ
  deploy_id:Widgetʶ
*/
SINT32 tp_pms_widget_deployed_info(PIWidgetOutInfo* widget_info, UINT32 deploy_id);

/*
  ȡWidgetϢ()
  widget_info:WidgetϢ
  read_count:ȡ
*/
ZUINT8  tp_pms_widget_deployed_list(PIWidgetOutInfo* widget_info, ZUINT8 read_count);

#endif

