#ifndef GDI_G_H
#define GDI_G_H

/****************************************ͷļ**************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "zcore_type.h"
#include "gui_g.h"
#include "gdi_e.h"

/********************************************************************************/

/*****************************************궨***************************************/

#define PIXEL565RED(gal_pixel)   (((gal_pixel) >> 11) & 0x1f)<<3
#define PIXEL565GREEN(gal_pixel) (((gal_pixel) >> 5) & 0x3f)<<2
#define PIXEL565BLUE(gal_pixel)  ((gal_pixel) & 0x1f)<<3
#define RGB2P565(r,g,b)          ((r>>3)<<11)|((g>>2)<<5)|(b>>3)

#define PIXEL888RED(pixel)   (((pixel) >> 16) & 0xFF)
#define PIXEL888GREEN(pixel) (((pixel) >> 8) & 0xFF)
#define PIXEL888BLUE(pixel)  ((pixel) & 0xFF)		
#define RGB2P888(r,g,b)      (((r) << 16) | ((g) << 8) | (b))
#define RGB2PA888(r,g,b)     (((r) << 16) | ((g) << 8) | (b) | 0xFF000000)
#define ARGB2P8888(a,r,g,b)  (((r) << 16) | ((g) << 8) | (b) | (a << 24))

/* 4Bits surpporting */
#define PIXELRGB4(gal_pixel)  ((gal_pixel)&0xF)
#define PIXELRGB8(gal_pixel)  ((gal_pixel)&0xFF)
#define RGB2GRAY4(r,g,b)  (((30*(r) + 59*(g) + 11*(b))/100)>>4)
#define RGB2GRAY8(r,g,b)  ((30*(r) + 59*(g) + 11*(b))/100)


static __inline ZVOID PIXEL2RGB(ZSINT32 BPP, Pixel pixel, ZBYTE *r, ZBYTE *g, ZBYTE *b )
{
	switch (BPP) 
	{
    case 16:
		{
			*r = PIXEL565RED( pixel);
			*g = PIXEL565GREEN(pixel);
			*b = PIXEL565BLUE(pixel);
			break;
		}
	case 24:
    case 32:
		{
			*r = PIXEL888RED( pixel);
			*g = PIXEL888GREEN(pixel);
			*b = PIXEL888BLUE(pixel);
			break;
		}
	case 4:
        {
            *r = PIXELRGB4(pixel);
            *g = PIXELRGB4(pixel);
            *b = PIXELRGB4(pixel);
            break;
        }
    case 8:
        {
            *r = PIXELRGB8(pixel);
            *g = PIXELRGB8(pixel);
            *b = PIXELRGB8(pixel);
            break;
		}		
    default:
		break;
	}			
}

static __inline ZVOID PPIXEL2RGB(ZSINT32 BPP, Pixel* pixel, ZBYTE *r, ZBYTE *g, ZBYTE *b )
{
	switch (BPP) 
	{
    case 16:
		{
			ZWORD tmp_color = *((ZWORD*)pixel);
			*r = PIXEL565RED(tmp_color);
			*g = PIXEL565GREEN(tmp_color);
			*b = PIXEL565BLUE(tmp_color);
			break;
		}
	case 24:
    case 32:
		{
			*b = *((ZBYTE*)pixel);
			*g = *((ZBYTE*)pixel + 1);
			*r = *((ZBYTE*)pixel + 2);
			break;
		}
	case 4:
        {
            *r = PIXELRGB4(*pixel);
            *g = PIXELRGB4(*pixel);
            *b = PIXELRGB4(*pixel);
            break;
        }
    case 8:
        {
            *r = PIXELRGB8(*pixel);
            *g = PIXELRGB8(*pixel);
            *b = PIXELRGB8(*pixel);
            break;
		}		
    default:
		break;
	}			
}

static __inline ZVOID RGB2PIXEL(ZSINT32 BPP,ZBYTE r,ZBYTE g,ZBYTE b,Pixel *pixel )
{
	switch (BPP) 
	{
	case 16:
		{
			*((ZWORD*)pixel)  = RGB2P565(r,g,b);
			break;
		}
		
	case 24:
		{
			*((ZBYTE*)pixel) = b;
			*((ZBYTE*)pixel + 1) = g;
			*((ZBYTE*)pixel + 2) = r;
			
			break;
		}
		
	case 32:
		{
			*pixel  = RGB2PA888(r,g,b);
			break;
		}

	case 4:
        {
            *(ZBYTE*)pixel = RGB2GRAY4(r,g,b);
            break;
        }
    case 8:
        {
            *(ZBYTE*)pixel = RGB2GRAY8(r,g,b);
            break;
		}		
	default:
		break;
	}		
}

#endif
