#ifndef	os_ppp_H
#define	os_ppp_H
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
 #include "zcore_type.h"
#include "os_type.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
 *                                                                    *
 **************************************************************************/
 
 #define OS_PPP_NAME_SIZE 32
#define OS_PPP_PASSWORD_SIZE 32  

 /**************************************************************************
 *                         궨                                         *
 **************************************************************************/

/**************************************************************************
 *                         ṹͶ                                    *
 **************************************************************************/

struct os_dns_ip_addr
{
          UINT32 local_ip_address; 
          UINT32 dns_address1;
          UINT32 dns_address2;
          UINT32 server_ip_address;
};

typedef enum ppp_authen_type
{
        OS_PAP=0,
        OS_CHAP,
        OS_NO_PPP_AUTHEN
}OS_PPP_AUTHEN_TYPE;


typedef struct _os_ppp_user_info_
{
      ZCHAR user_id[OS_PPP_NAME_SIZE];
      ZCHAR password[OS_PPP_PASSWORD_SIZE];
}OS_PPP_USER_INFO;



typedef struct _OS_PPP_CONFIG_INFO_
{
    OS_PPP_AUTHEN_TYPE authen_type;
    ZVOID *other_config;
} OS_PPP_CONFIG_INFO;

typedef enum _OS_PPP_STATUS
{
     OS_PPP_CLOSED = 0,
     OS_PPP_OPENED
}OS_PPP_STATUS;

typedef ZVOID (* OS_PPP_NOTIFY)(UINT32 ppp_status,ZVOID *notify_param);
/**************************************************************************
 *                        ԭ                                     *
 **************************************************************************/
 

OS_PPP_ID os_ppp_open(OS_PPP_USER_INFO * ppp_user_info,ZCHAR *ppp_name ,UINT32 payload_id ,OS_PPP_CONFIG_INFO *config_info_ptr, 
struct os_dns_ip_addr *dns_ip_ptr);
OS_STATUS os_ppp_close(OS_PPP_ID ppp_id);
OS_STATUS os_ppp_notify_register (OS_PPP_ID ppp_id,OS_PPP_NOTIFY ppp_notify,ZVOID *notify_param);
OS_STATUS os_ppp_status_get(OS_PPP_ID ppp_id,OS_PPP_STATUS *ppp_status);
OS_STATUS os_ppp_config_query(OS_PPP_ID ppp_id,OS_PPP_CONFIG_INFO *config_info_ptr);

 
#ifdef __cplusplus
}
#endif

#endif  /* os_ppp_H */
