#ifndef _FW_ADAPTER_H
#define _FW_ADAPTER_H

/**************************************************************************
*                        ͷļ                                          *
**************************************************************************/
#include "zcore_type.h"
#include "os_type.h"
#include "os_api.h"
//#include "osa_api.h"
#include "zcore_type.h"
#include "osa_api_e.h"
#include "os_file_api.h"


/**************************************************************************
*                        궨                                           *
**************************************************************************/

#define FW_MALLOC(bytes) \
            fw_mem_malloc((UINT32)bytes)
#define FW_FREE(mem) \
            fw_mem_free(mem)
#define FW_MEM_CPY(dest_ptr,src_ptr,copy_len) \
            fw_mem_copy((ZVOID*)(dest_ptr), (ZVOID*)(src_ptr),(UINT32)(copy_len)) 
#define FW_MEM_SET(dest_ptr, src_ptr, len) \
            fw_mem_set((ZVOID*)(dest_ptr), (ZUINT8)(src_ptr),(UINT32)(len))           
#define FW_MEM_REALLOC(mem,bytes) \
            fw_mem_realloc((ZVOID*)(mem),(UINT32)(bytes))
#define FW_MEM_CALLOC(count,bytes) \
            fw_mem_calloc((UINT32)(count),(UINT32)(bytes))

#define pthread_mutex_id  OS_MUTEX_ID
#define pthread_id        OS_THREAD_ID
#define pthread_status   OS_STATUS
#define pthread_sema_id  OS_SEMA_ID
#define pthread_entry    OS_THREAD_ENTRY
#define pthread_queue_status    OS_STATUS
#define pthread_queue_id  OS_QUEUE_ID
#define pthread_timer_id  OS_TIMER_ID
#define pthread_timer_entry OS_FUNC_ENTRY
#define FW_THREAD_FAILURE  0xffffffff


/**************************************************************************
*                        ڴģ麯                                 *
**************************************************************************/
ZVOID *fw_mem_malloc(UINT32 bytes);
ZVOID  fw_mem_free(ZVOID *mem);
ZVOID  fw_mem_copy(ZVOID *dest_ptr, ZVOID *src_ptr,UINT32 copy_len);
ZVOID  fw_mem_set(ZVOID *dest_ptr, ZUINT8 value,UINT32 len);
ZVOID *fw_mem_calloc(UINT32 nelem,UINT32 elsize);
ZVOID *fw_mem_realloc(ZVOID *pMem, UINT32 new_size);

/**************************************************************************
*                        ļģ麯                                  *
**************************************************************************/
FILE*  fw_fopen (const ZCHAR *filename,const ZCHAR *mode);
ZSINT32 fw_fclose(FILE *stream);
ZSINT32 fw_feof(FILE *stream);
ZSINT32 fw_fexist(ZCHAR *filename);
ZSINT32 fw_fflush(FILE *stream);	
ZSINT32 fw_flength(FILE *stream);
size_t fw_fread (ZVOID *data, size_t size, size_t count, FILE *stream);
ZSINT32 fw_fseek(FILE *stream, ZSINT32 offset,ZSINT32 whence);
ZSINT32 fw_ftell(FILE *stream);
size_t fw_fwrite (const ZVOID *data, size_t size, size_t count, FILE *stream);
size_t fw_fprintf (FILE *stream, const ZCHAR *format, ...);

/**************************************************************************
*                        ̣߳ź,еغ          *
**************************************************************************/
pthread_id       fw_thread_create(ZCHAR* szName, pthread_entry proc_ThreadEntry, ZUINT8 pPriorityLevel, UINT32 uiSize, ZVOID* pParam);
pthread_status   fw_thread_delete(pthread_id threadID);
pthread_status   fw_thread_suspend(pthread_id tid);
pthread_status   fw_thread_resume(pthread_id tid);
pthread_id       fw_thread_self(ZVOID);
pthread_status   fw_thread_sleep(UINT32 timeout);
pthread_sema_id  fw_sema_create(ZCHAR *szName,UINT32 init_count);
pthread_status   fw_sema_delete(OS_SEMA_ID semaID);
pthread_status   fw_sema_get(OS_SEMA_ID semaID, UINT32 timeout);
pthread_status   fw_sema_put(OS_SEMA_ID semaID);
pthread_status   fw_sema_count_get(OS_SEMA_ID semaID, UINT32* pCount);
pthread_mutex_id fw_mutex_create(ZCHAR* szMutexName, ZBOOL bFlag);
pthread_status   fw_mutex_get(OS_MUTEX_ID mutexID,UINT32 timeout);
pthread_status   fw_mutex_put(OS_MUTEX_ID mutexID);
pthread_status   fw_mutex_delete(OS_MUTEX_ID mutexID);
pthread_queue_status fw_queue_delete(OS_QUEUE_ID qid);
pthread_queue_id     fw_queue_create(ZCHAR *szName, UINT32 msg_size, UINT32 max_nums);
pthread_queue_status fw_queue_receive(OS_QUEUE_ID qid, ZVOID **msg_ptr, UINT32 timeout);
pthread_queue_status fw_queue_send(OS_QUEUE_ID qid, ZVOID* msg_ptr, UINT32 timeout);

/**************************************************************************
*                        ʱغ                               *
**************************************************************************/
pthread_timer_id fw_timer_create(ZCHAR *name, pthread_timer_entry expir_func, ZVOID*expire_para, UINT32 interval, UINT32 flag);
pthread_status fw_timer_delete(OS_TIMER_ID id);
pthread_status fw_timer_start(OS_TIMER_ID id);
pthread_status fw_timer_stop(OS_TIMER_ID id);
pthread_status fw_timer_restart(OS_TIMER_ID id,UINT32 interval);
//pthread_status fw_timer_info_get(OS_TIMER_ID id,OS_TIMER_INFO *info_ptr);

/**************************************************************************
*                        غ                                 *
**************************************************************************/
ZSINT32 fw_tp_man_alarm_disable(ZVOID);

#endif
