##########################################################################
# makefile:         kernel_adapter.mk
# File:             kernel_adapter.mk
# Version:	    V0.1
# Author:           xuxin194245 -2011.9.14
##########################################################################
ENVDIR = ../../../../../../../ws
include	$(ENVDIR)/makeenv.mk
CONFIG_HOME = ../../../../../../../ws
include $(CONFIG_HOME)/config.mk

OS_SRCDIR = ../src
OS_OBJDIR = ../lib

OS_SRC := $(notdir $(wildcard $(OS_SRCDIR)/*.c)) 
OS_OBJS := $(patsubst %.c,%.o,$(OS_SRC))
OS_COBJECTS := $(addprefix $(OS_OBJDIR)/,$(OS_OBJS))  


OS_OBJS = $(OS_COBJECTS)

OS_LOCAL_INCLUDE  = -I../../../../inc/gui \
                    -I../../../../inc/gal \
                    -I../../../../inc/os \
                    -I../../inc \
                    -I../../../../../../inc/zCore/kernel \
                    -I../../../../../../inc/zCore/os \
                    -I../../../../../../../os/inc \
                    -I../../../../../../inc/zCore/gui \
                    -I../../../../../inc/zCore/gui \
                    -I../../../../../../../inc/zCore/gui \
                    -I../../../../src/gui/adapter/Linux/inc \
                    -I../../../../src/fwkernel/adaptor/inc

all: $(OS_COBJECTS) ar

$(OS_COBJECTS): $(OS_OBJDIR)/%.o: $(OS_SRCDIR)/%.c
	$(OS_CC) -c $(OS_CFLAGS) $(OS_LOCAL_CFLAGS) $(OS_LOCAL_INCLUDE) $< -o $@

ar:
	$(OS_AR) $(OS_OBJDIR)/kernel_adapter.a $(OS_OBJS)
	ranlib $(OS_OBJDIR)/kernel_adapter.a

.PHONY :clean

clean:
	$(OS_RM) $(OS_OBJDIR)/kernel_adapter.a $(OS_OBJS)
 


