#ifndef _FW_AMS_H_
#define _FW_AMS_H_

#include "zcore_type.h" 
#include "gui_g.h"
#include "zcoregui.h"
#include "gdi_inter.h"
#include "window_inter.h"

#include "plat_type_g.h"
#include "fw_pub.h"
#include "fw_common.h"
#include "fw_comm.h"

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

/*
** =============================================================== 
** ===============================================================
*/

/*
** max length of application name
*/
#define MAX_APP_NAME_LEN       32

/*
** max number of running apps in system
*/
#define MAX_RUN_APPS_NUM       20

/*
** define application id 
*/
//typedef UINT32 APP_ID;

/*
** define application name
*/
typedef ZCHAR APP_NAME;

/*
** define application priority class
*/
typedef enum
{
    APP_PRI_LOWEST = 0,
    APP_PRI_BELOW_NORMAL = 1,
    APP_PRI_NORMAL = 2,
    APP_PRI_ABOVE_NORMAL = 3,
    APP_PRI_HIGHEST = 4,
    
} APP_PRIORITY_CLASS;

/*
** define application type
*/
typedef enum
{
    TYPE_LOCAL = 0,
    TYPE_CS = 1,
    TYPE_PS = 2,
    TYPE_EXT = 3,
    
} APP_TYPE;


/*
** define minimal id value of application
*/
#define APP_ID_MIN_VALUE              0x0001

/*
** define applications id base values
*/
#define APP_ID_LOCAL_BASE              APP_ID_MIN_VALUE
#define APP_ID_CS_BASE                 (APP_ID_LOCAL_BASE + 0x0100)
#define APP_ID_PS_BASE                 (APP_ID_CS_BASE + 0x0100)
#define APP_ID_EXT_BASE                (APP_ID_PS_BASE + 0x0100)


/*
** define application running state
*/
typedef enum
{
    RUN_FOREGND = 0,
    RUN_BACKGND = 1,
    RUN_READY   = 2,
    RUN_DEAD    = 3,
    //////whb add////
    RUN_STOPING = 4
  
} APP_RUN_STATE;

/* 
** define applications syn strategy
*/
typedef enum
{
    RULE_WITHOUT_PRI = 0,
    RULE_WITH_PRI = 1,
    
} APP_SYN_STRATEGY;


/*
** define the run param when the application start
*/
typedef struct _APP_START_PARAM_
{
    HWND host;
    ZVOID* add_data;

} APP_START_PARAM, *PAPP_START_PARAM;

/*
** define the start function type of application
*/
typedef SINT32 (*APP_START_FUNC_PTR)(APP_START_PARAM* param);

/*
** define the run param when the application stop
*/
typedef struct _APP_STOP_PARAM_
{
    ZVOID* add_data;

} APP_STOP_PARAM, *PAPP_STOP_PARAM;

/*
** define the stop function type of application
*/
typedef SINT32 (*APP_STOP_FUNC_PTR)(APP_STOP_PARAM* param);

/*
** define the run param when the application pause
*/
typedef struct _APP_PAUSE_PARAM_
{
    ZVOID* add_data;

} APP_PAUSE_PARAM, *PAPP_PAUSE_PARAM;

/*
** define the pause function type of application
*/
typedef SINT32 (*APP_PAUSE_FUNC_PTR)(APP_PAUSE_PARAM* param);

/*
** define the run param when the application resume
*/
typedef struct _APP_RESUME_PARAM_
{
    ZVOID* add_data;

} APP_RESUME_PARAM, *PAPP_RESUME_PARAM;

/*
** define the resume function type of application
*/
typedef SINT32 (*APP_RESUME_FUNC_PTR)(APP_RESUME_PARAM* param);

/*
** define the ctrl information when start one application
*/
typedef struct _START_APP_CTRL_INFO_
{
  APP_ID id;
  ZBOOL  thread_mode;
  ZVOID* add_data;
   
} START_APP_CTRL_INFO, *PSTART_APP_CTRL_INFO;

/*
** define the ctrl information when stop one application
*/
typedef struct _STOP_APP_CTRL_INFO_
{
  APP_ID id;
  ZVOID* add_data;
   
} STOP_APP_CTRL_INFO, *PSTOP_APP_CTRL_INFO;

/*
** define the ctrl information when pause one application
*/
typedef struct _PAUSE_APP_CTRL_INFO_
{
  APP_ID id;
  ZVOID* add_data;
} PAUSE_APP_CTRL_INFO, *PPAUSE_APP_CTRL_INFO;

/*
** define the ctrl information when resume one application
*/
typedef struct _RESUME_APP_CTRL_INFO_
{
  APP_ID id;
  ZVOID* add_data;
   
} RESUME_APP_CTRL_INFO, *PRESUME_APP_CTRL_INFO;

/* 
** define application message proc func type
*/
typedef SINT32 (*APP_MESSAGE_PROC_PTR)(UINT32 msg_id, ZVOID* param, UINT32 msg_size);

/*
** define application static information
*/
typedef struct _APP_STATIC_INFO_
{
    APP_ID id;
    APP_NAME name[MAX_APP_NAME_LEN+1];
    APP_TYPE type;
    APP_PRIORITY_CLASS priority;
    APP_START_FUNC_PTR app_start_func_ptr;
    APP_STOP_FUNC_PTR  app_stop_func_ptr;
    APP_PAUSE_FUNC_PTR app_pause_func_ptr;
    APP_RESUME_FUNC_PTR app_resume_func_ptr;
   // APP_MESSAGE_PROC_PTR app_msg_proc_ptr;
    
} APP_STATIC_INFO, *PAPP_STATIC_INFO;
//    APP_MESSAGE_PROC_PTR app_msg_proc_ptr;
/*
** define application static output information when query 
*/
typedef struct _APP_STATIC_OUT_INFO_
{
    APP_ID id;
    APP_NAME name[MAX_APP_NAME_LEN+1];
    APP_TYPE type;
    APP_PRIORITY_CLASS priority;
    
} APP_STATIC_OUT_INFO, *PAPP_STATIC_OUT_INFO;

/*
** define application runtime information
*/
typedef struct _APP_RUN_INFO_
{
    APP_ID id;
    APP_RUN_STATE state;
    time_t start_time;
    UINT32 order;
    ZBOOL thread_mode;
    time_t bkgnd_time;
    ZBOOL passive_bkgnd;    
    
} APP_RUN_INFO, *PAPP_RUN_INFO;

/* 
** define system statistic information of applications running
*/
typedef struct _SYS_STATISTIC_INFO_
{
    UINT32 total_count;
    UINT32 foregnd_count;
    APP_ID foregnd_apps[MAX_RUN_APPS_NUM];
    UINT32 backgnd_count;
    APP_ID backgnd_apps[MAX_RUN_APPS_NUM];

} SYS_STATISTIC_INFO, *PSYS_STATISTIC_INFO;

/* 
** define ams error code list
*/
enum AMS_ERR_CODE
{
    AMS_ERR_SUCCESS = 0, //generally success error code
    AMS_ERR_FAILURE = -1, //generally failure error code
    AMS_ERR_NOT_INIT = -2, //module not init error
    AMS_ERR_ALREADY_INIT = -3, //module has been inited yet
    AMS_ERR_MEMORY_ERROR = -4, //memory error
    AMS_ERR_ALREADY_START = -5, //the application already started
    AMS_ERR_ALREADY_STOP = -6, //the application already stoped 
    AMS_ERR_ALREADY_PAUSE = -7, //the application already paused
    AMS_ERR_ALREADY_RESUME = -8, //the application already resumed 
    AMS_ERR_FORBID_START = -9, //forbid to start the application to run
    AMS_ERR_FORBID_STOP = -10, //forbid to stop the application to run
    AMS_ERR_FORBID_PAUSE = -11, //forbid to pause the application to run
    AMS_ERR_FORBID_RESUME = -12, //forbid to resume the application to run
    AMS_ERR_NOT_START = -13, //app is not started yet
    AMS_ERR_NOT_STOP = -14, //app is not stopped yet
    AMS_ERR_NOT_PAUSE = -15, //app is not paused yet
    AMS_ERR_NOT_RESUME = -16, //app is not resumed yet
    AMS_ERR_PARAM_ERROR = -17, //the input param error
    AMS_ERR_LIST_NULL = -18, //the list is null
    AMS_ERR_MAX_NUM = -19, //reached max running apps number
    AMS_ERR_CHANNEL_FAILED = -20, //create app default channel failed
    AMS_ERR_ID_ERROR = -21, //app id value is error 
    AMS_ERR_NAME_ERROR = -22, // app name value is error
    AMS_ERR_TYPE_ERROR = -23, // app type value is error
    AMS_ERR_PRIORITY_ERROR = -24, // app priority value is error
    
};

/*
** =============================================================== 
** ===============================================================
*/

/*
** initialize ams module
*/
SINT32 tp_ams_init( ZVOID );

/*
** release ams module
*/
SINT32 tp_ams_release( ZVOID );

/*
** default application start func
*/
SINT32 tp_ams_default_app_start( APP_START_PARAM* param );

/*
** default application stop func
*/
SINT32 tp_ams_default_app_stop( APP_STOP_PARAM* param );

/*
** default application pause func
*/
SINT32 tp_ams_default_app_pause( APP_PAUSE_PARAM* param );

/*
** default application resume func
*/
SINT32 tp_ams_default_app_resume( APP_RESUME_PARAM* param );

/*
** register application message proc according to its default message channel
*/
SINT32 tp_ams_register_message_proc( APP_ID id, APP_MESSAGE_PROC_PTR func_ptr );

/*
** register applications to ams
*/
SINT32 tp_ams_register_apps( CONST APP_STATIC_INFO* infos, UINT32 num );

/*
** unregister applications from ams
*/
SINT32 tp_ams_unregister_apps( CONST APP_ID* ids, UINT32 num );

/*
** query application static info
*/
SINT32 tp_ams_query_app_static_info( APP_ID id, APP_STATIC_OUT_INFO* info );

/*
** query system statistic info
*/
SINT32 tp_ams_query_sys_statistic_info( SYS_STATISTIC_INFO* info );

/*
** query application runtime info
*/
SINT32 tp_ams_query_app_run_info( APP_ID id, APP_RUN_INFO* info );

/*
** set application syn strategy
*/
SINT32 tp_ams_set_syn_strategy( APP_SYN_STRATEGY type );

/*
** start one application
*/
SINT32 tp_ams_start_app( START_APP_CTRL_INFO* ctrl_info );

/*
** stop one application
*/
SINT32 tp_ams_stop_app( STOP_APP_CTRL_INFO* ctrl_info );

/*
** pause one application
*/
SINT32 tp_ams_pause_app( PAUSE_APP_CTRL_INFO* ctrl_info );

/*
** resume one application
*/
SINT32 tp_ams_resume_app( RESUME_APP_CTRL_INFO* ctrl_info );

/////////////////////////////////////////////////////////////////////////////
///////////////////        new interface               //////////////////////
/////////////////////////////////////////////////////////////////////////////

//define channel message id base address for ams
#define AMS_CHNL_MSG_ID_BASE            (MSG_ID_FW + 0x010)

//define start/stop/pause/resume channel message id
#define AMS_START_APP              (AMS_CHNL_MSG_ID_BASE + 0x01)
#define AMS_STOP_APP               (AMS_CHNL_MSG_ID_BASE + 0x02)
#define AMS_PAUSE_APP              (AMS_CHNL_MSG_ID_BASE + 0x03)
#define AMS_RESUME_APP             (AMS_CHNL_MSG_ID_BASE + 0x04)
#define MSG_COMM  (AMS_CHNL_MSG_ID_BASE + 0x05)//whb

#define AMS_START_APP_WITH_PAUSE                0x00000001//ӦʱҪresumeһӦ
#define AMS_START_APP_NO_PAUSE                  0x00000002//ӦʱҪreusmeһӦ
#define AMS_PAUSE_APP_NO_RESUME                 0x00000004//ӦʱҪreusmeһӦ
#define AMS_PAUSE_APP_WITH_RESUME               0x00000008//ӦʱҪresumeһӦ
#define HAPP_INVALID 0  //define invalid app instance handle

typedef UINT32 HAPP;    //app instance handle type

//define callback function that deal with channel message
typedef SINT32 (*APP_CHNL_MSG_PROC)(HAPP happ, UINT32 msg_id, ZVOID* msg_data, UINT32 msg_size);

//distinguish between app3.0 and app2.0
typedef enum APP_VERSION_T
{
    APP_30 = 0,
    APP_20
}APP_VERSION;

//define app template to create app instance
typedef struct APP_TEMPLATE_T
{
    APP_ID id;
    APP_NAME name[MAX_APP_NAME_LEN+1];
    APP_TYPE type;
    APP_PRIORITY_CLASS priority;
    APP_VERSION version;
    HWND host;  //if app run in single thread, it should be HWND_DESKTOP. Otherwise it's host window handle.
    ZBOOL bStartBK;  //start as background running app
    APP_CHNL_MSG_PROC pMsgFunc; //deal with channel msg
}APP_TEMPLATE;

//difine app information for outside
typedef struct APP_OUT_INFO_T
{
    APP_ID id;
    APP_NAME name[MAX_APP_NAME_LEN+1];
    APP_TYPE type;
    APP_PRIORITY_CLASS priority;
    APP_VERSION version;

    APP_RUN_STATE state;
    time_t start_time;
    UINT32 order;
    time_t bkgnd_time;
    ZBOOL passive_bkgnd;

    ZBOOL thread_mode;   //TRUE means app run in single thread; FALSE run in ams thread.
}APP_OUT_INFO;

//if return HAPP_INVALID, that means failure.
HAPP tp_ams_create_app(APP_TEMPLATE *templ);

//if return AMS_ERR_SUCCESS, that means success. Otherwise fail.
SINT32 tp_ams_destroy_app(HAPP happ);

//if return HWND_INVALID, that means failure
HWND tp_ams_get_rootwin(HAPP happ);

//register channel msg
SINT32 tp_ams_reg_msg(HAPP happ, UINT32 msg_id);

//unregister channel msg
SINT32 tp_ams_unreg_msg(HAPP happ, UINT32 msg_id);

//send asynchronous channel message
SINT32 tp_ams_post_msg(HAPP happ, UINT32 msg_id, ZVOID *msg_data, UINT32 msg_size);

//send synchronous channel message
SINT32 tp_ams_send_msg(HAPP happ, UINT32 msg_id, ZVOID *msg_data, UINT32 msg_size);

//AMS do default things
SINT32 tp_ams_do_default(HAPP happ, UINT32 msg_id);

//set capacity of running app instances. 0 means seccess.Otherwise means failure.
SINT32 tp_ams_set_capacity(SINT32 capacity);

//get capacity of running app instances. If less than 0, that means failure.
SINT32 tp_ams_get_capacity();

//get app info
SINT32 tp_ams_get_app_info(HAPP happ, APP_OUT_INFO* info);

//get first app instance handle.HAPP_INVALID means failure or non-existence.
HAPP tp_ams_get_first_app();

//get next app instance handle.HAPP_INVALID means failure or end of apps.
HAPP tp_ams_get_next_app(HAPP happ);

//get count of app intances existing. If less than 0, that means failure.
SINT32 tp_ams_get_app_count();

ZBOOL tp_ams_set_app_run_attribute(APP_ID appId,ZSINT32 att);

ZSINT32 tp_ams_get_app_run_attribute(APP_ID appId);
#ifdef __cplusplus
}
#endif  /* __cplusplus */


#endif// _FW_AMS_H_


