#ifndef _ZCORE_ADAPTOR_THREADS_H_
#define _ZCORE_ADAPTOR_THREADS_H_

#include "zcore_type.h"
#ifdef pthread_t
#undef pthread_t
#endif

#ifdef pthread_mutex_t
#undef pthread_mutex_t
#endif

typedef ZVOID (* ZCORE_OS_THREAD_ENTRY)(ZVOID *param );

#define pthread_mutex_t  OS_MUTEX_ID
#define pthread_t        OS_THREAD_ID
#define pthread_status   OS_STATUS
#define pthread_sema_id  OS_SEMA_ID
#define pthread_mutex_id OS_MUTEX_ID
#define pthread_entry    ZCORE_OS_THREAD_ENTRY

typedef UINT32 OS_STATUS;


#define ZCORE_THREAD_FAILURE  0xffffffff

   pthread_t zcore_thread_create(ZCHAR* szName, pthread_entry proc_ThreadEntry, ZUINT8 pPriorityLevel, UINT32 uiSize, ZVOID* pParam);
   pthread_status zcore_thread_delete(pthread_t threadID);
   pthread_status zcore_thread_delete(pthread_t tid);
   pthread_status zcore_thread_suspend(pthread_t tid);
   pthread_status zcore_thread_resume(pthread_t tid);
   pthread_t zcore_thread_self(ZVOID);
   pthread_status zcore_thread_sleep(UINT32 timeout);
   
   pthread_sema_id zcore_sema_create(ZCHAR *szName,UINT32 init_count);
   pthread_status  zcore_sema_delete(pthread_sema_id semaID);
   pthread_status  zcore_sema_get(pthread_sema_id semaID, UINT32 timeout);
   pthread_status  zcore_sema_put(pthread_sema_id semaID);
   pthread_status  zcore_sema_count_get(pthread_sema_id semaID, UINT32* pCount);
   
   pthread_mutex_id zcore_mutex_create(ZCHAR* szMutexName, ZBOOL bFlag);
   pthread_status   zcore_mutex_get(pthread_mutex_id mutexID,UINT32 timeout);
   pthread_status   zcore_mutex_put(pthread_mutex_id mutexID);
pthread_status   zcore_mutex_delete(pthread_mutex_id mutexID);
#endif
