#ifndef _ICON_FLY_H
#define _ICON_FLY_H
    
#ifdef __cplusplus
extern "C"
{
#endif
    
/*******************************************************************************
*                                      ͷļ
*******************************************************************************/
#include "zcore_type.h"
#include "gui_common.h"
#include "list.h"

/*******************************************************************************
*                                      
*******************************************************************************/
   
/*******************************************************************************
*                                      ݽṹ
*******************************************************************************/
typedef struct _FILLRECTWITHCOLOR
{
    ZCHAR *pImage;
    ZUINT32 imageWidth;
    ZUINT32 imageHeight;
    ZUINT32 startX;
    ZUINT32 startY;
    ZUINT32 fillWidth;
    ZUINT32 fillHeight;

    ZUINT32 bpp;
    ZSINT32 fillColor;
}T_FILLRECTWITHCOLOR;

typedef struct _ICONFLYINFO
{
    ZUINT32 frameNum;
    ZCHAR *pImage;
    ZUINT32 imageWidth;
    ZUINT32 imageHeight;
    RECT boundary;
    
    RECT iconRect;
    RECT start;
    RECT end;

}T_ICONFLYINFO;

typedef struct _RECTMOTION
{
    ZUINT32 frameIndex;
    ZUINT32 frameNum;

    RECT startRect;
    RECT endRect;

    RECT boundaryRect;              //˶Χ  
    RECT currMotionRect;            //ǰ˶
    RECT prevMotionRect;            //˶

    ZBOOL (*SetRectMotionPara)(RECT *pStart, RECT *pEnd, RECT *pBoundary, ZUINT32 frameNum, struct _RECTMOTION *pMotion);
    ZBOOL (*ComputeRectMotion)(struct _RECTMOTION *pMotion);
    ZBOOL (*GetCurrentMotionRect)(struct _RECTMOTION *pMotion, RECT *pCurr);
    ZBOOL (*GetPreviousMotionRect)(struct _RECTMOTION *pMotion, RECT *pPrev);
    ZBOOL (*GetBoundaryRect)(struct  _RECTMOTION *pMotion, RECT *pBoundary);
    ZBOOL (*SetCurrentMotionFrame)(ZUINT32 frameIndex, struct _RECTMOTION *pMotion);
}T_RECTMOTION;

typedef struct _FLYINGICON
{
    list_t list;
        
    ZCHAR *pImage;
    ZUINT32 imageWidth;
    ZUINT32 imageHeight;    
    RECT iconRect;

    RECT recoverRect;
    RECT flyDstRect;
    RECT flyIconRect;
    
    T_RECTMOTION *pMotion;

    ZBOOL (*InitIconFlyingPara)(RECT *pStart, RECT *pEnd, RECT *pBoundary, ZUINT32 frameNum, struct _FLYINGICON *pIcon);    
    ZBOOL (*IconFlyOneStep)(ZUINT32 frameIndex, struct _FLYINGICON *pIcon);
    ZBOOL (*GetRecoverRect)(RECT *pRecover, struct _FLYINGICON *pIcon);
    ZBOOL (*GetFlyDstRect)(RECT *pFlyDst, struct _FLYINGICON *pIcon);
    ZBOOL (*GetFlyIconInfo)(ZCHAR **ppImage, ZUINT32 *pWidth, ZUINT32 *pHeight, RECT *pFlyRect, struct _FLYINGICON *pIcon);
    ZBOOL (*SetFlyIconInfo)(ZCHAR *pImage, ZUINT32 imageWidth, ZUINT32 imageHeight, RECT *pIconRect, struct _FLYINGICON *pIcon);
        
}T_FLYINGICON;

typedef struct _ICONFLYONSCREEN
{ 
    ZCHAR *pScreen;
    ZUINT32 screenWidth;
    ZUINT32 screenHeight;
    ZUINT32 bpp;
    ZSINT32 bgColor;          //ɫ

    T_FLYINGICON *iconHead;

    ZBOOL (*AllIconFlyOneStep)(ZUINT32 frameIndex, struct _ICONFLYONSCREEN *pFly);
    ZBOOL (*IconDisplayInNewPosition)(struct _ICONFLYONSCREEN *pFly);
    ZBOOL (*RecoverBackGround)(struct _ICONFLYONSCREEN *pFly);
    ZBOOL (*SetScreenPara)(ZCHAR *pImage, ZUINT32 screenWidth, ZUINT32 screenHeight, ZUINT32 bpp, struct _ICONFLYONSCREEN *pFly);
    ZBOOL (*SetBgColor)(ZSINT32 color, struct _ICONFLYONSCREEN *pFly);
}T_ICONFLYONSCREEN;

/*******************************************************************************
*                                      ȫֺ
*******************************************************************************/
ZBOOL SetRectMotionPara(RECT *pStart, RECT *pEnd, RECT *pBounday, ZUINT32 frameNum, T_RECTMOTION *pMotion);
T_RECTMOTION *CreateConstantSpeedBeelineRectMotion(ZVOID);
ZVOID DestroyRectMotion(T_RECTMOTION *pMotion);

T_FLYINGICON *CreateFlyingIcon(ZVOID);
ZVOID DestroyFlyingIcon(T_FLYINGICON *pIcon);

T_ICONFLYONSCREEN *CreateIconFlyOnScreenSys(T_ICONFLYINFO * pInfo, ZUINT32 num);
ZVOID DestroyIconFlyOnScreenSys(T_ICONFLYONSCREEN *pFly);

ZBOOL FillColorToSpecificRect(T_FILLRECTWITHCOLOR *pFill);
/*******************************************************************************
*                                      ȫֱ
*******************************************************************************/
    
    
#ifdef __cplusplus
}
#endif
    
#endif

