#ifndef _MGUI_ENDIAN_RW_H
#define _MGUI_ENDIAN_RW_H

#include "zcore_type.h"
#ifdef __cplusplus
extern "C" {
#endif

#define RWAREA_TYPE_UNKNOWN 0
#define RWAREA_TYPE_STDIO   1
#define RWAREA_TYPE_MEM     2

typedef struct MG_RWops {
    ZSINT32 (*seek)(struct MG_RWops *context, ZSINT32 offset, ZSINT32 whence);

    ZSINT32 (*read)(struct MG_RWops *context, ZVOID *ptr, ZSINT32 objsize, ZSINT32 num);

    ZSINT32 (*write)(struct MG_RWops *context, const ZVOID *ptr, ZSINT32 objsize, ZSINT32 num);

#ifdef _USE_OWN_STDIO
    ZSINT32 (*ungetc)(struct MG_RWops *context, ZUINT8 c);
#endif

    ZSINT32 (*close)(struct MG_RWops *context);

    ZSINT32 (*eof)(struct MG_RWops *context);

    ZUINT32 type;

    union {
        struct {
            ZSINT32 autoclose;
            FILE *fp;
        } stdio;
        struct {
            ZUINT8 *base;
            ZUINT8 *here;
            ZUINT8 *stop;
        } mem;
        struct {
            ZVOID *data1;
        } unknown;
    } hidden;
} MG_RWops;


MG_RWops* MGUI_RWFromFile(const ZCHAR *file, const ZCHAR *mode);

MG_RWops* MGUI_RWFromFP(FILE *fp, ZSINT32 autoclose);

MG_RWops* MGUI_RWFromMem(ZVOID *mem, ZSINT32 size);

ZVOID MGUI_InitMemRW (MG_RWops* area, ZVOID *mem, ZSINT32 size);
MG_RWops* MGUI_AllocRW(ZVOID);

ZVOID MGUI_FreeRW(MG_RWops *area);

#define MGUI_RWseek(ctx, offset, whence)    (ctx)->seek(ctx, offset, whence)

#define MGUI_RWtell(ctx)                    (ctx)->seek(ctx, 0, SEEK_CUR)

#define MGUI_RWread(ctx, ptr, size, n)      (ctx)->read(ctx, ptr, size, n)

#define MGUI_RWwrite(ctx, ptr, size, n)     (ctx)->write(ctx, ptr, size, n)

#define MGUI_RWclose(ctx)                   (ctx)->close(ctx)

#define MGUI_RWeof(ctx)                     (ctx)->eof(ctx)
ZSINT32 MGUI_RWgetc (MG_RWops* area);



#ifdef linux
#include <endian.h>
#ifdef __arch__swab16
#define ArchSwap16  __arch__swab16
#endif
#ifdef __arch__swab32
#define ArchSwap32  __arch__swab32
#endif
#endif /* linux */

#define inline
#ifndef ArchSwap16
static inline ZUINT16 ArchSwap16(ZUINT16 E) 
{
        return((E<<8)|(E>>8));
}
#endif
#ifndef ArchSwap32
static inline ZUINT32 ArchSwap32(ZUINT32 E) 
{
        return((E<<24)|((E<<8)&0x00FF0000)|((E>>8)&0x0000FF00)|(E>>24));
}
#endif
#ifdef MGUI_HAS_64BIT_TYPE
#ifndef ArchSwap64
static inline Uint64 ArchSwap64(Uint64 ival) 
{
        ZUINT32 hi, lo;

        /* Separate into high and low 32-bit values and swap them */
        lo = (ZUINT32)(ival&0xFFFFFFFF);
        ival >>= 32;
        hi = (ZUINT32)(ival&0xFFFFFFFF);
        ival = ArchSwap32(lo);
        ival <<= 32;
        ival |= ArchSwap32(hi);
        return(ival);
}
#endif
#else
#ifndef ArchSwap64
#define ArchSwap64(X)        (X)
#endif
#endif /* MGUI_HAS_64BIT_TYPE */

#if MGUI_BYTEORDER == MGUI_LIL_ENDIAN
#define ArchSwapLE16(X)        (X)
#define ArchSwapLE32(X)        (X)
#define ArchSwapLE64(X)        (X)
#define ArchSwapBE16(X)        ArchSwap16(X)
#define ArchSwapBE32(X)        ArchSwap32(X)
#define ArchSwapBE64(X)        ArchSwap64(X)
#else
#define ArchSwapLE16(X)        ArchSwap16(X)
#define ArchSwapLE32(X)        ArchSwap32(X)
#define ArchSwapLE64(X)        ArchSwap64(X)
#define ArchSwapBE16(X)        (X)
#define ArchSwapBE32(X)        (X)
#define ArchSwapBE64(X)        (X)
#endif

extern ZUINT16 MGUI_ReadLE16(MG_RWops *src);

extern ZUINT16 MGUI_ReadBE16(MG_RWops *src);

extern ZUINT32 MGUI_ReadLE32(MG_RWops *src);

extern ZUINT32 MGUI_ReadBE32(MG_RWops *src);

extern Uint64 MGUI_ReadLE64(MG_RWops *src);

extern Uint64 MGUI_ReadBE64(MG_RWops *src);

extern ZSINT32 MGUI_WriteLE16(MG_RWops *dst, ZUINT16 value);

extern ZSINT32 MGUI_WriteBE16(MG_RWops *dst, ZUINT16 value);

extern ZSINT32 MGUI_WriteLE32(MG_RWops *dst, ZUINT32 value);

extern ZSINT32 MGUI_WriteBE32(MG_RWops *dst, ZUINT32 value);

extern ZSINT32 MGUI_WriteLE64(MG_RWops *dst, Uint64 value);

extern ZSINT32 MGUI_WriteBE64(MG_RWops *dst, Uint64 value);

extern ZUINT16 MGUI_ReadLE16FP(FILE *src);

extern ZUINT32 MGUI_ReadLE32FP(FILE *src);

extern ZSINT32 MGUI_WriteLE16FP(FILE *dst, ZUINT16 value);

extern ZSINT32 MGUI_WriteLE32FP(FILE *dst, ZUINT32 value);

static inline ZUINT16 MGUI_ReadLE16Mem (const ZUINT8** pdata)
{
    ZUINT16 ih1, ih2;

    ih1 = *(*pdata); (*pdata)++;
    ih2 = *(*pdata); (*pdata)++;
    return ((ih2<<8)|ih1);
}

static inline ZUINT32 MGUI_ReadLE32Mem (const ZUINT8** pdata)
{
    ZUINT32 q1, q2, q3, q4;

    q1 = *(*pdata); (*pdata)++;
    q2 = *(*pdata); (*pdata)++;
    q3 = *(*pdata); (*pdata)++;
    q4 = *(*pdata); (*pdata)++;
    return ((q4<<24)|(q3<<16)|(q2<<8)|(q1));
}

static inline ZUINT16 MGUI_ReadBE16Mem (const ZUINT8** pdata)
{
    ZUINT16 h1, h2;

    h1 = *(*pdata); (*pdata)++;
    h2 = *(*pdata); (*pdata)++;
    return ((h1<<8)|h2);
}

static inline ZUINT32 MGUI_ReadBE32Mem (const ZUINT8** pdata)
{
    ZUINT32 q1, q2, q3, q4;

    q1 = *(*pdata); (*pdata)++;
    q2 = *(*pdata); (*pdata)++;
    q3 = *(*pdata); (*pdata)++;
    q4 = *(*pdata); (*pdata)++;
    return ((q1<<24)|(q2<<16)|(q3<<8)|(q4));
}

#ifdef __cplusplus
}
#endif

#endif /* _MGUI_ENDIAN_RW_H */

