/* =========================================================================
FILE NAME
    libzte_dmapp.c

GENERAL DESCRIPTION
    This file  include the dmapp lib's  functions

Copyright (c) 2012-2013 by ZTE Incorporated. All Rights Reserved.
============================================================================ */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

#include "libzte_dmapp.h"
#include "fota_common.h"


stateflag_print_t stateflag_print[] = {
	{RECOVERY, "RECOVERY"},
	{RECOVERY_KERNEL, "RECOVERY_KERNEL"},
	{CPUM0, "CPUM0"},
	{CPUZSP, "CPUZSP"},
	{CPUR7, "CPUR7"},
	{CPUAP, "CPUAP"},
	{CPFS, "CPFS"},
	{USERDATA, "USERDATA"},
	{SECUREFS, "SECUREFS"},

	{STATEFLAG_NULL, 0}
};


static int zte_fota_get_fotaflag_partition_path(char *path)
{
	int value = 0;
	char fota_flag_part_name[256] = {'\0'};

	if (path == NULL) {
		printf("fota_get_flag_partition_name fota_flag_part_name is NULL!\n");
		return -1;
	}

	//open ZTE_DUA_PART_UPDATED_FLAG
	//fotaflag------------------------------------------------------------------
	value = zte_fota_browse_fotaflag(ZTE_DUA_FOTAFLAG_BLOCK_PART, fota_flag_part_name, sizeof(fota_flag_part_name));
	if (1 == value) {
		printf("[%s:%s]fota_browse_fotaflag error!\n", __FILE__, __FUNCTION__);
		return -1;
	}
	sprintf(path, "%s/%s", ZTE_DUA_PART_UPDATED_DEV, fota_flag_part_name);
	return 0;
}

static int zte_fota_get_fotaflag(fotaflag_t *fotaflag)
{
#if 0
	char path[128] = {0};
	char fota_flag_temp[ZTE_FOTA_FLAG_LEN] = {0};
	int read_size = 0;
	FILE *fota_flag_file;

	if (fotaflag == NULL) {
		printf("fota_get_fotaflag fotaflag is NULL!\n");
		return -1;
	}

	zte_fota_get_fotaflag_partition_path(path);

	fota_flag_file = fopen(path, "rb");
	//------------------------------------------------------------------------------------------

	//fota_flag_file = fopen("/dev/zftl6", "wb+");
	if (fota_flag_file == NULL) {
		printf("fota_get_fotaflag Fota flag file does not exist!\n");
		return -1;
	}
	read_size = fread(fota_flag_temp, ZTE_FOTA_FLAG_LEN, 1, fota_flag_file);
	if (read_size <= 0) {
		printf("fota_get_fotaflag read fota_flag_file failed!\n");
		return -1;
	}
	//fotaflag = (fotaflag_t *)fota_flag_temp;
	memcpy(fotaflag, fota_flag_temp, sizeof(fotaflag_t));
#endif
	return 1;
}

static int zte_fota_set_fotaflag(char *updateflag, stateflag_t stateflag,
                                 int netdogflag_index, int netdogflag_value)
{
#if 0
	FILE *fota_flag_file;
	int write_size = 0;
	int read_size = 0;

	char path[128] = {0};

	fotaflag_t *fotaflag;
	char fota_flag_temp[ZTE_FOTA_FLAG_LEN] = {0};
	int write_back = 0;
	int ret = -1;

	printf("fota_set_stateflag start!\n");

	zte_fota_get_fotaflag_partition_path(path);

	fota_flag_file = fopen(path, "wb+");
	//------------------------------------------------------------------------------------------

	//fota_flag_file = fopen("/dev/zftl6", "wb+");
	if (fota_flag_file == NULL) {
		printf("fota_set_stateflag Fota flag file does not exist!\n");
		return -1;
	}
	read_size = fread(fota_flag_temp, ZTE_FOTA_FLAG_LEN, 1, fota_flag_file);
	if (read_size <= 0) {
		printf("fota_set_stateflag read fota_flag_file failed!\n");
		return -1;
	}
	fotaflag = (fotaflag_t *)fota_flag_temp;
	if (updateflag != NULL && strcmp(updateflag, "") != 0) {
		memcpy(fotaflag->update_flag, updateflag, sizeof(fotaflag->update_flag));
		write_back = 1;
	}
	if (stateflag > 0) {
		fotaflag->state_flag = stateflag;
		write_back = 1;
	}
	if (netdogflag_index >= 0) {
		fotaflag->netdog_flag[netdogflag_index] = netdogflag_value;
		printf("fota_set_fotaflag is %d!\n", fotaflag->netdog_flag[netdogflag_index]);
		write_back = 1;
	}

	fseek(fota_flag_file, 0, SEEK_SET);

	if (write_back) {
		write_size = fwrite(fotaflag, 1, ZTE_FOTA_FLAG_LEN, fota_flag_file);
		if (write_size <= 0) {
			printf("fota_set_stateflag Write fota_flag_file failed!\n");
			return -1;
		}
		printf("write_size = %d, write fota_flag_file success! End 20160624!\n", write_size);
		fflush(fota_flag_file);
		ret = fsync(fileno(fota_flag_file));
		printf("fota_set_fotaflag fsync ret=%d\n", ret);
	}

	fclose(fota_flag_file);
#endif
	return 1;
}

int zte_fota_set_updateflag(char *updateflag)
{
	return zte_fota_set_fotaflag(updateflag, -1, -1, -1);
}

char* zte_fota_get_updateflag(char *updateflag_buf)
{
	fotaflag_t fotaflag = {0};

	if (updateflag_buf == NULL) {
		return NULL;
	}

	if (zte_fota_get_fotaflag(&fotaflag) >= 0) {
		memcpy(updateflag_buf, fotaflag.update_flag, sizeof(fotaflag.update_flag));
		return updateflag_buf;
	}
	return -1;
}


int zte_fota_set_stateflag(stateflag_t stateflag)
{
	return zte_fota_set_fotaflag(NULL, stateflag, -1, -1);
}

int zte_fota_get_stateflag()
{
#if 0 //klocwork
	fotaflag_t fotaflag = {0};
	if (zte_fota_get_fotaflag(&fotaflag) >= 0) {
		return fotaflag.state_flag;
	}
	return -1;
#endif
	return 0;
}

stateflag_t translate_stateflag_str_to_flag(char *stateflag_str)
{
	if (stateflag_str == NULL)
		return STATEFLAG_NULL;

	int i = 0;

	while (1) {
		if (strcmp(stateflag_print[i].name, "") == 0)
			break;
		if (strcmp(stateflag_print[i].name, stateflag_str) == 0) {
			return stateflag_print[i].stateflag;
		}
		i++;
	}
	return STATEFLAG_NULL;
}

char* translate_stateflag_flag_to_str(stateflag_t stateflag)
{
	int i = 0;

	while (1) {
		if (stateflag_print[i].stateflag == STATEFLAG_NULL)
			break;
		if (stateflag_print[i].stateflag == stateflag)
			return stateflag_print[i].name;
		i++;
	}
	return NULL;
}


int zte_fota_set_netdogflag(int index, int value)
{
	printf("fota_set_netdogflag is %d  %d!\n", index, value);
	return zte_fota_set_fotaflag(NULL, -1, index, value);
}

int zte_fota_get_netdogflag_single(int index)
{
#if 0 //klocwork
	fotaflag_t fotaflag = {0};
	if (zte_fota_get_fotaflag(&fotaflag) >= 0) {
		return fotaflag.netdog_flag[index];
	}
	return -1;
#endif
	return 0;
}

char* zte_fota_get_netdogflag_all(char *netdogflag_buf)
{
	fotaflag_t fotaflag = {0};

	if (netdogflag_buf == NULL) {
		return NULL;
	}
	if (zte_fota_get_fotaflag(&fotaflag) >= 0) {
		memcpy(netdogflag_buf, fotaflag.netdog_flag, sizeof(fotaflag.netdog_flag));
		return netdogflag_buf;
	}
	return NULL;
}


/***********************************************************************
* Description:fotflagӦ豸
* Function:zte_fota_browse_fotaflag()
* Input:
* Output:
* Return:ֵΪ0ΪҵfotaflagֵΪ1ҷʧ
*************************************************************************/
int  zte_fota_browse_fotaflag(char *pathname, char *fota_flag_part_name, unsigned int len)
{
	FILE *fd = NULL;
	DIR *pdir = NULL;//һĿ¼;Ƕļһ
	struct dirent *pentry = NULL;//Ŀ¼ṹ
	struct stat statbuf;
	char buffer[128] = {0};
	char fullpath[256] = {0};

	if (NULL == pathname || NULL == fota_flag_part_name || len <= 0) {
		printf("fota_browse_fotaflag has invalid parameter!\n");
		return 1;
	}
	pdir = opendir(pathname);//һ·һĿ¼
	if (pdir == NULL) {
		printf("fota_browse_fotaflag opendir %s error!\n", pathname);
		return 1;
	}

	while ((pentry = readdir(pdir)) != NULL) {
		if (!strcmp(pentry->d_name, ".") || !strcmp(pentry->d_name, ".."))
			continue;

		snprintf(fullpath, sizeof(fullpath), "%s/%s/%s", pathname, pentry->d_name, ZTE_DUA_FOTAFLAG_PART);
		memset(&statbuf, 0, sizeof(struct stat));
		if (stat(fullpath, &statbuf)) {
			continue;
		}

		fd = fopen(fullpath, "r");
		if (NULL == fd) {
			printf("fota_browse_fotaflag fopen %s failed!\n", fullpath);
			closedir(pdir);
			return 1;
		}
		memset(buffer, 0, sizeof(buffer));
		(void)fgets(buffer, sizeof(buffer), fd);
		if (!strncmp(buffer, ZTE_DUA_FOTAFLAG, strlen(ZTE_DUA_FOTAFLAG))) {
			if (strlen(pentry->d_name) <= (len - 1)) {
				strncpy(fota_flag_part_name, pentry->d_name, strlen(pentry->d_name));
				fclose(fd);
				closedir(pdir);
				return 0;
			} else {
				printf("fota_browse_fotaflag over_array_range error!pentry->d_name=%s, strlen(pentry->d_name)=%d\n",
				       pentry->d_name, strlen(pentry->d_name));
				fclose(fd);
				closedir(pdir);
				return 1;
			}
		}
		fclose(fd);
	}
	closedir(pdir);
	return 1;
}
