
/*****************************************************************************
*  汾 (C)2013ͨѶɷ޹˾
*
*  ģ  ⿨
*  ļ  vsim.h
*  ļʶ
*  ļ
*  ʵֹܣ⿨غͽӿ
*         miaohaixiang
*  汾    
*  ڣ20160406
*  ˵
 *****************************************************************************/
#ifndef UICC_VCARD_H 
#define UICC_VCARD_H

#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <time.h>
#include <syslog.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/sysctl.h>
#include <poll.h>
#include <stddef.h>
#include <linux/if_packet.h>
#include "softap_api.h"
#include <sys/un.h>
#include <ctype.h>
#include <semaphore.h>
#include <pthread.h>

typedef unsigned char	 u8;
typedef unsigned char	 Byte;
typedef unsigned char	 BYTE;
typedef unsigned char	 BITS;
typedef unsigned short     WORD;
typedef UINT32              DWORD;
typedef unsigned long long UINT64;

//in bits
#define VSIM_DIGIT_BITS 32
#define VSIM_HALF_DIGIT_BITS 16
//in bytes
#define VSIM_DIGIT_LEN (VSIM_DIGIT_BITS / 8)
//Max len in digits
#define MAX_VSIM_DIGITS  ((VSIM_MAX_RSA_MODULUS_LEN + VSIM_DIGIT_LEN - 1) / VSIM_DIGIT_LEN + 1)
//Max digits
#define MAX_VSIM_DIGIT 0xffffffff
#define MAX_VSIM_HALF_DIGIT 0xffff


#define VSIM_LOW_HALF(x) ((x) & MAX_VSIM_HALF_DIGIT)
#define VSIM_HIGH_HALF(x) (((x) >> VSIM_HALF_DIGIT_BITS) & MAX_VSIM_HALF_DIGIT)
#define VSIM_TO_HIGH_HALF(x) (((VSIM_DIGIT)(x)) << VSIM_HALF_DIGIT_BITS)
#define VSIM_DIGIT_2MSB(x) (unsigned int)(((x) >> (VSIM_DIGIT_BITS - 2)) & 3)

/**/
#define Z_VCARD_NV_BIN_LENGTH (UINT32)4
#define Z_VCARD_NV_MAGIC_NUM_LENGTH (UINT32)4

#define Z_VCARD_NV_LENGTH_ADDR        (UINT32)0
#define Z_VCARD_NV_PUBLIC_KEY_ADDR (UINT32)(Z_VCARD_NV_LENGTH_ADDR + Z_VCARD_NV_BIN_LENGTH + Z_VCARD_NV_MAGIC_NUM_LENGTH)
#define Z_VCARD_NV_AUTH_PARM_ADDR (UINT32)(Z_VCARD_NV_PUBLIC_KEY_ADDR + (sizeof(t_Vcard_EncPubKey)))
#define Z_VCARD_NV_SEC_INFO_ADDR     (UINT32)(Z_VCARD_NV_AUTH_PARM_ADDR + (sizeof(t_Vcard_AuthInfo)))
#define Z_VCARD_NV_EF_CONTENT_ADDR   (UINT32)(Z_VCARD_NV_SEC_INFO_ADDR + (sizeof(t_Vcard_SecurityInfo)))
#define Z_VCARD_MAX_FLASH_BLOCK_SIZE (UINT32)262144

#define UICC_VCARD_MAX_DF_FCP_LEN  (BYTE)52
#define UICC_VCARD_MAX_GSM_EF_FCP_LEN  (BYTE)20
#define UICC_VCARD_MAX_GSM_DF_FCP_LEN  (BYTE)36
#define UICC_VCARD_MAX_EF_NUM  (BYTE)100
#define UICC_VCARD_MAX_DF_NUM  (BYTE)20

#define UICC_VCARD_MAX_PIN_LEN (BYTE)8
#define UICC_VCARD_MAX_PUK_LEN (BYTE)8
#define UICC_VCARD_MAX_AID_LEN (BYTE)16
#define UICC_VCARD_DIR_REC_LEN (BYTE)56
#define UICC_VCARD_MIN_VALID_AID_LEN (BYTE)7

#define UICC_VCARD_MAX_PIN1_RETRY_NUM (BYTE)3
#define UICC_VCARD_MAX_PUK1_RETRY_NUM (BYTE)10
#define UICC_VCARD_MAX_PIN2_RETRY_NUM (BYTE)3
#define UICC_VCARD_MAX_PUK2_RETRY_NUM (BYTE)10

#define  DFKEY_MF                     (BYTE)0
#define  DFKEY_ADF               	  (BYTE)1
#define  DFKEY_GSM                (BYTE)2
#define  DFKEY_USIM_GSMACSS           (BYTE)3
#define  DFKEY_USIM_MEXE              (BYTE)4
#define  DFKEY_USIM_SOLSA             (BYTE)5
#define  DFKEY_USIM_HNB               (BYTE)6
#define  DFKEY_MF_TELE_PB             (BYTE)7
#define  DFKEY_USIM_WLAN              (BYTE)8
#define  DFKEY_MF_TELE_MMEDIA         (BYTE)9
#define  DFKEY_MF_TELE_MMSS           (BYTE)10
#define  DFKEY_MF_TELE                (BYTE)11
#define  DFKEY_MF_TELE_GRAPH          (BYTE)12
#define  DFKEY_USIM_PB                    (BYTE)13
#define  DFKEY_GSM_IRIDIUM            (BYTE)14
#define  DFKEY_GSM_GLOBST             (BYTE)15
#define  DFKEY_GSM_ICO                (BYTE)16
#define  DFKEY_GSM_ACES               (BYTE)17
#define  DFKEY_GSM_EIATIA             (BYTE)18
#define  DFKEY_GSM_CTS                (BYTE)19
#define  DFKEY_GSM_SOLSA              (BYTE)20
#define  DFKEY_GSM_MEXE               (BYTE)21
#define  DFKEY_MF_IS41                (BYTE)22
#define  DFKEY_MF_FPCTS               (BYTE)23
#define  DFKEY_ISIM_MF                (BYTE)24
#define  DFKEY_ISIM_ADF               (BYTE)25
#define  DFKEY_ISIM_TELE              (BYTE)26
#define  DFKEY_END                    (BYTE)DFKEY_ISIM_TELE
#define  Z_UICCMNG_MAX_DF_NUM         (DFKEY_END+1)
#define  DFKEY_INVALID                (BYTE)0xFF
#define  EFKEY_INVALID                (WORD)0xFFFF

/*DF FID*/
#define UICC_VCARD_MF_FID                                 (WORD)0x3F00
#define UICC_VCARD_TELE_FID                              (WORD)0x7F10
#define UICC_VCARD_GSM_FID                              (WORD)0x7F20
#define UICC_VCARD_GRAPHICS_FID                      (WORD)0x5F50
#define UICC_VCARD_USIM_FID                              (WORD)0x7FFF
#define UICC_VCARD_USIM_PB_FID                        (WORD)0x5F3A
#define UICC_VCARD_USIM_GSM_ACCESS_FID      (WORD)0x5F3B
#define UICC_VCARD_USIM_MEXE_FID                    (WORD)0x5F3C
#define UICC_VCARD_USIM_SOLASA_FID                (WORD)0x5F70
#define UICC_VCARD_GSM_SOLASA_FID                 (WORD)0x5F70
#define UICC_VCARD_ISIM_TELE_FID                     (WORD)0x7F10
#define UICC_VCARD_ISIM_ADF_FID                      (WORD)0x7FFF

/*SIM EF TYPE*/
#define Z_VCARD_EF_REC_CONT                    (BYTE)0
#define Z_VCARD_EF_BIN_CONT                     (BYTE)1
#define Z_VCARD_DF_FCP                               (BYTE)2
#define Z_VCARD_EF_FCP                               (BYTE)3
#define Z_VCARD_SEC_INFO                           (BYTE)4
#define Z_VCARD_AUTH_PARM                        (BYTE)5

#define Z_VCARD_AUTH_PARM_SQN_MS            (BYTE)0
#define Z_VCARD_AUTH_PARM_K                       (BYTE)1
#define Z_VCARD_AUTH_PARM_OP                     (BYTE)2

#define Z_VCARD_SUCCESS                            (BYTE)0
#define Z_VCARD_TYPE_NOT_SUPPORT         (BYTE)1
#define Z_VCARD_INVALID_LENGTH              (BYTE)2
#define Z_VCARD_INVALID_DATA                  (BYTE)3
#define Z_VCARD_FILE_NOT_SUPPORT          (BYTE)4
#define Z_VCARD_CARD_NOT_INIT                (BYTE)5
#define Z_VCARD_INVALID_RECORD_NUM     (BYTE)6
#define Z_VCARD_MEMORY_ERROR                 (BYTE)7
#define Z_VCARD_CARD_TYPE_ERROR            (BYTE)8
#define Z_VCARD_CARD_FILE_EXIST             (BYTE)9

/*File Type*/
#define Z_VCARD_FILE_TYPE_INVALID                 (BYTE)0
#define Z_VCARD_FILE_TYPE_DF                          (BYTE)1
#define Z_VCARD_FILE_TYPE_EF                          (BYTE)2

/*EF File Type*/
typedef BYTE t_Vcard_EfFileType;
#define Z_VCARD_EF_TYPE_BIN                          (BYTE)0
#define Z_VCARD_EF_TYPE_REC                          (BYTE)1
#define Z_VCARD_EF_TYPE_CYC                          (BYTE)2

typedef BYTE t_Vcard_EFAppType;
#define Z_VCARD_EF_SHARE                                 (BYTE)0 /*ICCID SIM USIM Ӧùļ*/
#define Z_VCARD_EF_USIM_ONLY                         (BYTE)1  
#define Z_VCARD_EF_GSM_ONLY                           (BYTE)2  
#define Z_VCARD_EF_GSM_USIM                           (BYTE)3 /*USIM SIM Ӧùļ*/

typedef BYTE t_Vcard_ChvPukType;
#define Z_VCARD_TYPE_CHV1                                  (BYTE)0  
#define Z_VCARD_TYPE_PUK1                                  (BYTE)1  
#define Z_VCARD_TYPE_CHV2                                  (BYTE)2  
#define Z_VCARD_TYPE_PUK2                                  (BYTE)3 

/*ļȨ*/
typedef BYTE t_Vcard_AccRule;
#define Z_VCARD_ACC_ALW                     (BYTE)0  
#define Z_VCARD_ACC_PIN1                    (BYTE)1  
#define Z_VCARD_ACC_PIN2                    (BYTE)2  
#define Z_VCARD_ACC_RFU                      (BYTE)3  
#define Z_VCARD_ACC_ADM                     (BYTE)4 
#define Z_VCARD_ACC_UNSUP                 (BYTE)15

typedef BYTE t_Vcard_AccType;
#define Z_VCARD_OPRT_READ        (BYTE)0  
#define Z_VCARD_OPRT_UPDATE    (BYTE)1
#define Z_VCARD_OPRT_ACTIVE     (BYTE)2
#define Z_VCARD_OPRT_DEACTIVE (BYTE)3
#define Z_VCARD_OPRT_INCREASE (BYTE)4

#define Z_VCARD_DATA_CONTENT_OFFSET (DWORD)4

#define Z_VCARD_APP_STAT_INITEING (BYTE)1
#define Z_VCARD_APP_STAT_INITED (BYTE)2
#define Z_VCARD_APP_STAT_TERM (BYTE)0

#define UICC_VCARD_AUTH_RAND_LEN (BYTE)16
#define UICC_VCARD_AUTH_AUTN_LEN (BYTE)16
#define UICC_VCARD_AUTH_KC_LEN (BYTE)8
#define UICC_VCARD_AUTH_CK_LEN (BYTE)16
#define UICC_VCARD_AUTH_IK_LEN (BYTE)16
#define UICC_VCARD_AUTH_RES_LEN (BYTE)16
#define UICC_VCARD_AUTH_AUTS_LEN (BYTE)14
#define UICC_VCARD_AUTH_AMF_LEN (BYTE)2
#define UICC_VCARD_AUTH_MAC_LEN (BYTE)8
#define UICC_VCARD_AUTH_SQN_LEN (BYTE)6
#define UICC_VCARD_AUTH_MAC_A_LEN (BYTE)8
#define UICC_VCARD_AUTH_XRES_LEN (BYTE)16
#define UICC_VCARD_AUTH_AK_LEN (BYTE)6
#define UICC_VCARD_AUTH_MAC_S_LEN (BYTE)8
#define UICC_VCARD_AUTH_SRES_LEN    (BYTE)4
#define UICC_VCARD_AUTH_K_LEN       (BYTE)16
#define UICC_VCARD_AUTH_OP_LEN     (BYTE)16
#define UICC_VCARD_SQN_MS_NUM      (BYTE)32
#define UICC_VCARD_AUTH_ENCRYPT_K_LEN    (BYTE)128
#define UICC_VCARD_AUTH_ENCRYPT_OP_LEN  (BYTE)128
#define UICC_VCARD_ENC_PUBLIC_MOD_LEN    (BYTE)128
#define UICC_VCARD_ENC_PUBLIC_EXP_LEN     (BYTE)128
#define UICC_VCARD_PUBLIC_MOD_LEN    (BYTE)128
#define UICC_VCARD_PUBLIC_EXP_LEN     (BYTE)128

#define UICC_VCARD_AUTH_CAUSE_SYS_FAIL (BYTE)21
#define UICC_VCARD_AUTH_CAUSE_MAC_FAIL (BYTE)20

#define UICC_VCARD_MAX_BIN_SIZE   (DWORD)(256*1024)

#define Z_APUICC_USAT_MAX_AID_LEN           (BYTE)16              

#define   ZPS_ApUicc_APPMODE_NULL               (BYTE)0  
#define   Z_APUICC_APPMODE_NULL             ZPS_ApUicc_APPMODE_NULL               
#define   ZPS_ApUicc_APPMODE_USIM               (BYTE)1  
#define   Z_APUICC_APPMODE_USIM             ZPS_ApUicc_APPMODE_USIM               
#define   ZPS_ApUicc_APPMODE_SIM                (BYTE)2  
#define   Z_APUICC_APPMODE_SIM              ZPS_ApUicc_APPMODE_SIM    
#define   ZPS_ApUicc_APPMODE_ISIM                (BYTE)3  
#define   Z_APUICC_APPMODE_ISIM              ZPS_ApUicc_APPMODE_ISIM 
#define   ZPS_ApUicc_MAX_INITAPPMODEVAL         (BYTE)ZPS_ApUicc_APPMODE_ISIM
#define   Z_APUICC_MAX_INITAPPMODEVAL       ZPS_ApUicc_MAX_INITAPPMODEVAL     

#define ZOSS_SUCCESS            0x0
#define ZOSS_ERROR              0xffffffff
#define ZOSS_NULL               NULL        

#define  USIM_DFKEY_MF                     (BYTE)0
#define  USIM_DFKEY_USIM_ADF               (BYTE)1
#define  USIM_DFKEY_USIM_PB                (BYTE)2
#define  USIM_DFKEY_USIM_GSMACSS           (BYTE)3
#define  USIM_DFKEY_USIM_MEXE              (BYTE)4
#define  USIM_DFKEY_USIM_SOLSA             (BYTE)5
#define  USIM_DFKEY_USIM_HNB               (BYTE)6
#define  USIM_DFKEY_MF_TELE_PB             (BYTE)7
#define  USIM_DFKEY_USIM_WLAN              (BYTE)8
#define  USIM_DFKEY_MF_TELE_MMEDIA         (BYTE)9
#define  USIM_DFKEY_MF_TELE_MMSS           (BYTE)10
#define  USIM_DFKEY_MF_TELE                (BYTE)11
#define  USIM_DFKEY_MF_TELE_GRAPH          (BYTE)12
#define  USIM_DFKEY_MF_GSM                (BYTE)13
#define  USIM_DFKEY_END                    (BYTE)USIM_DFKEY_MF_GSM
#define  USIM_DFKEY_NUM                    (BYTE)(USIM_DFKEY_END + 1)
#define  USIM_DFKEY_INVALID                (BYTE)0xFF

#define  SIM_DFKEY_MF                     (BYTE)0
#define  SIM_DFKEY_MF_TELE                (BYTE)1
#define  SIM_DFKEY_MF_TELE_GRAPH          (BYTE)2
#define  SIM_DFKEY_GSM                    (BYTE)3
#define  SIM_DFKEY_GSM_IRIDIUM            (BYTE)4   //NONE,ûļ
#define  SIM_DFKEY_GSM_GLOBST             (BYTE)5   //NONE
#define  SIM_DFKEY_GSM_ICO                (BYTE)6   //NONE
#define  SIM_DFKEY_GSM_ACES               (BYTE)7   //NONE
#define  SIM_DFKEY_GSM_EIATIA             (BYTE)8   //NONE
#define  SIM_DFKEY_GSM_CTS                (BYTE)9   //NONE
#define  SIM_DFKEY_GSM_SOLSA              (BYTE)10
#define  SIM_DFKEY_GSM_MEXE               (BYTE)11
#define  SIM_DFKEY_MF_IS41                (BYTE)12   //NONE
#define  SIM_DFKEY_MF_FPCTS               (BYTE)13   //NONE
#define  SIM_DFKEY_END                    (BYTE)SIM_DFKEY_MF_FPCTS
#define  SIM_DFKEY_NUM                    (BYTE)(SIM_DFKEY_END + 1)
#define  SIM_DFKEY_INVALID               (BYTE)0xFF

#define Z_SUCC                                            (BYTE)0
#define Z_FAIL                                            (BYTE)1

/*==========STATUS WORD: SW1SW2===========*/
#define  Z_UICCMNG_SUCCESS                   (WORD)0x9000
#define  Z_UICCMNG_SUCCESS_CMD_PENDING       (WORD)0x9100
#define  Z_UICCMNG_BUSY                      (WORD)0x9300
#define  Z_UICCMNG_WARNING                   (WORD)0x6200
#define  Z_UICCMNG_WARN_EOF                  (WORD)0x6282
#define  Z_UICCMNG_WARN_RETRIES              (WORD)0x63C0
#define  Z_UICCMNG_ERROR                     (WORD)0x6400
#define  Z_UICCMNG_MEMORY_ERROR              (WORD)0x6581
#define  Z_UICCMNG_ERR_WRONG_LENGTH          (WORD)0x6700
#define  Z_UICCMNG_ERR_FILE_NOF_FOUND        (WORD)0x6A82
#define  Z_UICCMNG_ERR_REC_NOT_FOUND         (WORD)0x6A83
#define  Z_UICCMNG_FILE_SECURED              (WORD)0x6982
#define  Z_UICCMNG_BLOCKED                   (WORD)0x6983
#define  Z_UICCMNG_EOF_REACHED               (WORD)0x6282
#define  Z_UICCMNG_NOT_AVAIL                 (WORD)0x6985
#define  Z_UICCMNG_REF_NOT_FOUND             (WORD)0x6A88
#define  Z_UICCMNG_GSM_ERR_WRONG_P3          (WORD)0x6700
#define  Z_UICCMNG_GSM_ERR_WRONG_P1_P2       (WORD)0x6B00
#define  Z_UICCMNG_GSM_ERR_TECHNICAL         (WORD)0x6F00
#define  Z_UICCMNG_GSM_ERR_OUT_OF_RANGE      (WORD)0x9402
#define  Z_UICCMNG_GSM_ERR_FILE_NOT_FOUND    (WORD)0x9404
#define  Z_UICCMNG_GSM_ERR_FILE_INCONSISTENT (WORD)0x9408
#define  Z_UICCMNG_GSM_NO_CHV_INIT           (WORD)0x9802
#define  Z_UICCMNG_GSM_UNSUCCESSFUL_SECURITY (WORD)0x9804/*access condition not fulfilled
                                                           unsuccessful CHV verification, at least one attempt left
                                                           unsuccessful UNBLOCK CHV verification, at least one attempt left
                                                           authentication failed (see note)*/
#define  Z_UICCMNG_GSM_CONTRA_CHV_STATUS     (WORD)0x9808
#define  Z_UICCMNG_GSM_CONTRA_INVAL_STATUS   (WORD)0x9810
#define  Z_UICCMNG_GSM_CHV_FAIL_NO_ATTEMPS   (WORD)0x9840  /*unsuccessful CHV verification, no attempt left
                                                            unsuccessful UNBLOCK CHV verification, no attempt left
                                                            CHV blocked
                                                            UNBLOCK CHV blocked*/
#define  Z_UICCMNG_GSM_NO_INCREASE           (WORD)0x9850
#define  Z_UICCMNG_GSM_SUCCESS_W_RESP_LEN        (WORD)0x9F00
#define  Z_UICCMNG_GSM_SUCCESS_W_RESP_LEN_MASK   (WORD)0xFF00
#define  Z_UICCMNG_WRAN_RETRIES              (WORD)0x9200
#define  Z_UICCMNG_RETRIES_HB                (WORD)0x6300
#define  Z_UICCMNG_WRAN_CORRUPT              (WORD)0x6281
#define  Z_UICCMNG_INVALIDATED               (WORD)0x6283
#define  Z_UICCMNG_ERROR_CHANGED             (WORD)0x6500
#define  Z_UICCMNG_ERROR_INS                 (WORD)0x6D00
#define  Z_UICCMNG_WRONG_CLASS               (WORD)0x6E00
#define  Z_UICCMNG_NO_CLA_SUPPORT            (WORD)0x6800
#define  Z_UICCMNG_NO_LOG_CHAN               (WORD)0x6881
#define  Z_UICCMNG_NO_SM                     (WORD)0x6882
#define  Z_UICCMNG_NOT_ALLOW                 (WORD)0x6900
#define  Z_UICCMNG_STRUCT_ERR                (WORD)0x6981
#define  Z_UICCMNG_INVALID_DATA              (WORD)0x6984
#define  Z_UICCMNG_NOT_EF                    (WORD)0x6986
#define  Z_UICCMNG_WRONG_PARA                (WORD)0x6A80
#define  Z_UICCMNG_NO_FUNCTION               (WORD)0x6A81
#define  Z_UICCMNG_ERR_P1_P2                 (WORD)0x6A86
#define  Z_UICCMNG_ERR_LC                    (WORD)0x6A87
#define  Z_UICCMNG_ERR_AUTH                  (WORD)0x9862
#define  Z_UICCMNG_ERR_AUTH_GSM_NOT_SUPPORT  (WORD)0x9864
#define  Z_UICCMNG_DL_RESP_LEN               (WORD)0x9E00
#define  Z_UICCMNG_GSM_NO_EF                 (WORD)0x9400

/*===========Z_UICC&SIM INS===========*/
#define  Z_UICCMNG_SIM_INS_SELECT            (BYTE)0xA4
#define  Z_UICCMNG_SIM_INS_STATUS            (BYTE)0xF2
#define  Z_UICCMNG_SIM_INS_READ_BINARY       (BYTE)0xB0
#define  Z_UICCMNG_SIM_INS_UPDATE_BINARY     (BYTE)0xD6
#define  Z_UICCMNG_SIM_INS_READ_RECORD       (BYTE)0xB2
#define  Z_UICCMNG_SIM_INS_UPDATE_RECORD     (BYTE)0xDC
#define  Z_UICCMNG_SIM_INS_SEARCH_RECORD     (BYTE)0xA2
#define  Z_UICCMNG_SIM_INS_INCREASE          (BYTE)0x32
#define  Z_UICCMNG_SIM_INS_VERIFY_PIN        (BYTE)0x20
#define  Z_UICCMNG_SIM_INS_CHANGE_PIN        (BYTE)0x24
#define  Z_UICCMNG_SIM_INS_DISABLE_PIN       (BYTE)0x26
#define  Z_UICCMNG_SIM_INS_ENABLE_PIN        (BYTE)0x28
#define  Z_UICCMNG_SIM_INS_UNBLOCK_PIN       (BYTE)0x2C
#define  Z_UICCMNG_SIM_INS_DEACTIVATE_FILE   (BYTE)0x04
#define  Z_UICCMNG_SIM_INS_ACTIVATE_FILE     (BYTE)0x44
#define  Z_UICCMNG_SIM_INS_AUTHENTICATE      (BYTE)0x88
#define  Z_UICCMNG_SIM_INS_GET_CHALLENGE     (BYTE)0x84
#define  Z_UICCMNG_SIM_INS_TERMINAL_PROFILE  (BYTE)0x10
#define  Z_UICCMNG_SIM_INS_ENVELOPE          (BYTE)0xC2
#define  Z_UICCMNG_SIM_INS_FETCH             (BYTE)0x12
#define  Z_UICCMNG_SIM_INS_TERMINAL_RESPONSE (BYTE)0x14
#define  Z_UICCMNG_SIM_INS_MANAGE_CHANNEL    (BYTE)0x70
#define  Z_UICCMNG_SIM_INS_GET_RESPONSE      (BYTE)0xC0


/* Ŀ¼ */
#define Z_UICCMNG_PATH_DEPTH                      (BYTE)5

/* FIDֽ */
#define  Z_UICCMNG_FID_LEN                  (BYTE)2

/*Authenticate length*/
#define     ZPS_ApUicc_MAX_LEN_RAND            (BYTE)16  
#define     Z_APUICC_MAX_LEN_RAND           ZPS_ApUicc_MAX_LEN_RAND            
#define     ZPS_ApUicc_MAX_LEN_AUTN            (BYTE)16  
#define     Z_APUICC_MAX_LEN_AUTN           ZPS_ApUicc_MAX_LEN_AUTN            
#define     ZPS_ApUicc_MAX_LEN_KC              (BYTE)8  
#define     Z_APUICC_MAX_LEN_KC             ZPS_ApUicc_MAX_LEN_KC              
#define     ZPS_ApUicc_MAX_LEN_RES             (BYTE)16  
#define     Z_APUICC_MAX_LEN_RES            ZPS_ApUicc_MAX_LEN_RES             
#define     ZPS_ApUicc_MAX_LEN_AUTS            (BYTE)14  
#define     Z_APUICC_MAX_LEN_AUTS           ZPS_ApUicc_MAX_LEN_AUTS            
/*the flag of Authenticate context*/
#define     ZPS_ApUicc_AUTH_GSM                (BYTE)0        /*GSM auth*/  
#define     Z_APUICC_AUTH_GSM               ZPS_ApUicc_AUTH_GSM                
#define     ZPS_ApUicc_AUTH_UMTS               (BYTE)1        /*UMTS auth*/  
#define     Z_APUICC_AUTH_UMTS              ZPS_ApUicc_AUTH_UMTS               

/*Authenticate err*/
#define     ZPS_ApUicc_AUTH_MACFAIL            (BYTE)20    /*MAC failure*/  
#define     Z_APUICC_AUTH_MACFAIL           ZPS_ApUicc_AUTH_MACFAIL            
#define     ZPS_ApUicc_AUTH_SYNCFAIL           (BYTE)21    /*Sync failure*/  
#define     Z_APUICC_AUTH_SYNCFAIL          ZPS_ApUicc_AUTH_SYNCFAIL           
#define     ZPS_ApUicc_AUTH_GSMAUTHUNACCPT     (BYTE)23    /*Gsm auth unaccept*/  
#define     Z_APUICC_AUTH_GSMAUTHUNACCPT    ZPS_ApUicc_AUTH_GSMAUTHUNACCPT     
#define     ZPS_ApUicc_AUTH_OTHERFAIL         (BYTE) 0xFF
#define     Z_APUICC_AUTH_OTHERFAIL           ZPS_ApUicc_AUTH_OTHERFAIL

typedef struct 
{
    BYTE  abFid[Z_UICCMNG_FID_LEN];
}T_zUiccmng_FileID;

typedef struct
{
    BYTE bPathLen;
    T_zUiccmng_FileID   tFid[Z_UICCMNG_PATH_DEPTH];
}T_zUiccmng_Path;

typedef struct{
    WORD                       wCurNo;     /*ŵָֽ룬ǵڼֽ*/
    BYTE                       bCurBitPtr;  /*ֽеĿʼַָ룬ǵڼֽڵĵڼλ*/
    WORD                       wLen;        /*ٵĳȣֹ*/
    BYTE                      *pbCode;   /* ԭʼ*/
    BYTE                       bBitEd;    /*ڴнԭʼַָ*/
    BITS                       bType1:1;  /*ļǷΪ1Ϊ11Ϊ10*/
    BITS                       :7;
}T_zUiccmng_CdecInfo_T;


typedef BYTE t_Vcard_auth_sqn_ms[8];

typedef struct
{
    BYTE  bAuthType;
    BYTE  abRand[UICC_VCARD_AUTH_RAND_LEN];
    BYTE  abAutn[UICC_VCARD_AUTH_AUTN_LEN];
}t_vcard_AuthParm;

typedef struct
{
    BYTE  abKc[UICC_VCARD_AUTH_KC_LEN];
    BYTE  abCK[UICC_VCARD_AUTH_CK_LEN];
    BYTE  abIK[UICC_VCARD_AUTH_IK_LEN];
    BYTE  abRes[UICC_VCARD_AUTH_RES_LEN];
}t_vcard_Succ;

typedef struct
{
    BYTE  bFailCause;
    BYTE  abAuts[UICC_VCARD_AUTH_AUTS_LEN];
}t_vcard_Fail;

typedef union
{
    t_vcard_Succ  tAuthSucc; 
    t_vcard_Fail    tAuthFail; 
}t_u_Vcard_AuthRsp;

typedef struct{
    BYTE  bAuthRlt;
    t_u_Vcard_AuthRsp uAuthRsp;
} t_vcard_AuthRst;

typedef struct 
{
    BYTE bExistFlag;
    BYTE bRecNum;
    BYTE bRecLen;
    DWORD dwAddrOffset;    
}t_vCard_EfFileInfo;

typedef struct 
{
    WORD wFid;
    t_vCard_EfFileInfo tUsimInfo;
    t_vCard_EfFileInfo tSimInfo;
}t_Vcard_EfFcp;

typedef struct 
{
    BYTE bExistFlag;
    BYTE abPadding[3];
}t_Vcard_DfFcp;

typedef struct 
{
    t_Vcard_DfFcp atDfFcp[Z_UICCMNG_MAX_DF_NUM];
    t_Vcard_EfFcp atEfFcp[UICC_VCARD_MAX_EF_NUM];
}t_Vcard_Fcp;

typedef struct 
{
    BITS bIsPin1Enabled:1;
    BITS bIsPin1Verified:1;
    BITS bIsPin1Blocked:1;
    BITS bIsCardBroken:1;    
    BITS :3;
}t_Vcard_SecurityStat;

typedef struct 
{
    BYTE bCurrentApp;
    BYTE bAPPStat;
    BYTE abPadding[2];
    BYTE abCurrentAid[Z_APUICC_USAT_MAX_AID_LEN];
}t_Vcard_AppInfo;

typedef struct 
{
    BITS bIsPowerOn :1;
    BITS bIsPin1Enabled :1;
    BITS bIsPin1Verified :1;
    BITS bIsPin1Blocked :1;
    BITS bIsPuk1Blocked :1;
    BITS bIsPin2Enabled :1;
    BITS bIsPin2Verified :1;
    BITS bIsPin2Blocked :1;
    
    BITS bIsPuk2Blocked :1;
    BITS :7;
    BYTE bCurrentRecNum;
    BYTE bCurSelFileType;    
    BYTE bCurrentDf;
    BYTE bPadding;
    WORD wCurrentEf;
    t_Vcard_AppInfo tAppInfo;
}t_Vcard_CardStatus;

typedef struct 
{
    BYTE bIsPin1Enabled;
    BYTE bIsPin1Blocked;
    BYTE bIsPuk1Blocked;
    BYTE bIsPin2Enabled;
    BYTE bIsPin2Blocked;
    BYTE bIsPuk2Blocked;   
    BYTE bPin1RemainNum;
    BYTE bPin2RemainNum;
    BYTE bPuk1RemainNum;
    BYTE bPuk2RemainNum;
    BYTE abPadding[2];
    BYTE abPin1[UICC_VCARD_MAX_PIN_LEN];
    BYTE abPuk1[UICC_VCARD_MAX_PUK_LEN];
    BYTE abPin2[UICC_VCARD_MAX_PIN_LEN];
    BYTE abPuk2[UICC_VCARD_MAX_PUK_LEN];    
}t_Vcard_SecurityInfo;

typedef struct {
    BYTE                                   bEfType; /*ļԣ¼ͻ*/
    BYTE                                   bRecNum;
    WORD                                 wDataOffset; /*ƫ*/
    BYTE                                   bLen;
    BYTE                                   bMaxEfLen;
    BYTE                                   abPadding[2];
}t_Vcard_EfFileInfo;

typedef struct {
    BYTE                                   abEncExp[UICC_VCARD_ENC_PUBLIC_EXP_LEN];
    BYTE                                   abEncMod[UICC_VCARD_ENC_PUBLIC_MOD_LEN];
}t_Vcard_EncPubKey;

typedef struct {
    BYTE                                   abEncK[UICC_VCARD_AUTH_ENCRYPT_K_LEN];
    BYTE                                   abEncOP[UICC_VCARD_AUTH_ENCRYPT_OP_LEN];
    t_Vcard_auth_sqn_ms           atSqnMs[UICC_VCARD_SQN_MS_NUM];
}t_Vcard_AuthInfo;

typedef struct 
{
    t_Vcard_EncPubKey   tEncPubKey;
    t_Vcard_AuthInfo      tAuthParm;
    t_Vcard_SecurityInfo tSecInfo; 
    t_Vcard_Fcp             tFcp;
    DWORD dwEfInfoSize;
    BYTE *pbEfInfo;
}t_Vcard_CardInfo;

typedef enum
{
  DRV_UICC_TRANSFER_SUCCEEDED,
  DRV_UICC_TRANSFER_FAILED
} T_ZDrvUicc_ApduReselt;

/**
 * \enum T_ZDrvUicc_ResetResult
 * Response cause for function \ref UICC_reset.
 */
typedef enum
{
  DRV_UICC_ACTIVATION_SUCCEEDED,
  DRV_UICC_ACTIVATION_FAILED,
  DRV_UICC_REJECT_CARD
} T_ZDrvUicc_ResetResult;

/**
 * \enum T_ZDrvUicc_CloseResult
 * Response cause for function \ref UICC_close.
 */
typedef enum
{
  DRV_UICC_DEACTIVATION_SUCCEEDED,
  DRV_UICC_DEACTIVATION_FAILED,
  DRV_UICC_ALREADY_DEACTIVATED
} T_ZDrvUicc_CloseResult;

/**
 * \enum T_ZDrvUicc_SetInOutCallBack
 * Response cause for callback function \ref UICC_set_inout_callback.
 */
typedef enum
{
  DRV_CALLBACK_FUNCTION_SET, /*!< Callback function registered. */
  DRV_CALLBACK_NOT_AVAILABLE /*!< Callback function NOT registered (or not supported). */
} T_ZDrvUicc_SetInOutCallBack;

/**
 * \enum T_ZDrvUicc_CardSelector
 * Card selector.
 */
typedef enum
{
  DRV_UICC_PRIMARY_CARD,
  DRV_UICC_SECONDARY_CARD_1,
  DRV_UICC_SECONDARY_CARD_2
} T_ZDrvUicc_CardSelector;

/**
 * \enum T_ZDrvUicc_CommandCase
 * Command case indicator.
 */
typedef enum
{
  DRV_UICC_CMD_CASE_1,    /*!< No Tx nor Tx command. */
  DRV_UICC_CMD_CASE_2,    /*!< Rx command.           */ 
  DRV_UICC_CMD_CASE_3,    /*!< Tx command.           */
  DRV_UICC_CMD_CASE_4     /*!< Tx and Rx command.    */
} T_ZDrvUicc_CommandCase;

/**
 * \enum T_ZDrvUicc_ResetMode
 * Reset indicator.
 */
typedef enum
{
  DRV_UICC_COLD_RESET,   /*!< Cold Reset. */
  DRV_UICC_WARM_RESET    /*!< Warm Reset (reset with RST line only). */
} T_ZDrvUicc_ResetMode;

 /**
 * \struct T_ZDrvUicc_ApduHeader
 * Structure holding the APDU command header. 
 */
typedef struct
{
  UINT8  cla;  /*!< Command CLAss.       */
  UINT8  ins;  /*!< Command INStruction. */
  UINT8  p1;   /*!< Command Parameter.   */
  UINT8  p2;   /*!< Command Parameter.   */
  UINT16 lc;   /*!< Tx-size. */
  UINT16 le;   /*!< Rx-Size. */
} T_ZDrvUicc_ApduHeader;


/**
 * \struct T_ZDrvUicc_ApduFooter
 * Structure holding the APDU command response 'header'. 
 */
typedef struct
{
  UINT16 luicc; /*!< Actual Rx-size recived. */
  UINT8  sw1;   /*!< Received Status Word SW1. */
  UINT8  sw2;   /*!< Received Status Word SW2. */
} T_ZDrvUicc_ApduFooter;



typedef T_ZDrvUicc_ApduReselt  (*t_Vcard_ApduHandler)(T_ZDrvUicc_CardSelector card_selector,\
                                                                      T_ZDrvUicc_CommandCase command_case,\
                                                                      BOOL                              extended_length,\
                                                                      T_ZDrvUicc_ApduHeader    c_apdu,\
                                                                      T_ZDrvUicc_ApduFooter     *r_apdu_ptr,\
                                                                      UINT8                             *apdu_data_ptr);

typedef struct
{
    BYTE   bApduIns;
    t_Vcard_ApduHandler     ptUsimApduHandler;
    t_Vcard_ApduHandler     ptSimApduHandler;
}t_Vcard_ApduCmdMap;

typedef struct
{
    WORD wFid;
    t_Vcard_EfFileType  bEfType;
    BYTE bRecLen;
    BYTE bRecNum;
    t_Vcard_AccRule tReadRule;
    t_Vcard_AccRule tUpdateRule;
    t_Vcard_AccRule tIncreaseRule;    
}T_zVcard_FileInfo;

typedef struct
{
    WORD wFid;
    t_Vcard_EfFileType   bEfType;
    t_Vcard_AccRule tReadRule;
    t_Vcard_AccRule tUpdateRule;
    t_Vcard_AccRule tIncreaseRule;    
    t_Vcard_EFAppType tAppType;
    BYTE bUsimParentDf;
    BYTE bSimParentDf;
    BYTE abPadding[3];
}T_zVcard_EfAttribute;

UINT32 zVcard_ReadNv(UINT32 NvItemID, VOID *NvItemData, UINT32 NvItemLen);

UINT32 zVcard_WriteNv(UINT32 NvItemID, VOID *NvItemData, UINT32 NvItemLen);

BOOL zVcard_WriteEfNV(UINT16 efid, UINT16 indx, VOID *data, UINT16 dataLen);

T_ZDrvUicc_ResetResult zVcard_ResetCard(T_ZDrvUicc_CardSelector tCardNum);

T_ZDrvUicc_CloseResult zVcard_CloseCard(T_ZDrvUicc_CardSelector tCardNum);

UINT8 zVcard_GetAtr(T_ZDrvUicc_CardSelector bSlotNum, UINT8 *atr);

T_ZDrvUicc_ApduReselt zVcard_TransportApdu(T_ZDrvUicc_CardSelector card_selector,
                                                                                  T_ZDrvUicc_CommandCase command_case,
                                                                                  BOOL                              extended_length,
                                                                                  T_ZDrvUicc_ApduHeader    c_apdu,
                                                                                  T_ZDrvUicc_ApduFooter     *r_apdu_ptr,
                                                                                  UINT8                             *apdu_data_ptr);

BYTE zVcard_Init(VOID);

void v_sim_f1    ( u8 k[16], u8 rand[16], u8 sqn[6], u8 amf[2],
             u8 mac_a[8] );
void v_sim_f2345 ( u8 k[16], u8 rand[16],
             u8 res[8], u8 ck[16], u8 ik[16], u8 ak[6] );
void v_sim_f1star( u8 k[16], u8 rand[16], u8 sqn[6], u8 amf[2], 
             u8 mac_s[8] );
void v_sim_f5star( u8 k[16], u8 rand[16],
             u8 ak[6] );
void v_sim_ComputeOPc( u8 op_c[16] );
void v_sim_RijndaelKeySchedule( u8 key[16] );
void v_sim_RijndaelEncrypt( u8 input[16], u8 output[16] );
void A3A8(/* in */ Byte rand[16], /* in */ Byte key[16],/* out */ Byte simoutput[12]);


#ifndef PROTOTYPES
#define PROTOTYPES 1
#endif

typedef unsigned char *POINTER;
typedef unsigned short int UINT2;
typedef unsigned long int UINT4;
typedef signed long int signeddigit;


typedef UINT4 VSIM_DIGIT;
typedef UINT2 VSIM_HALF_DIGIT;

#ifndef NULL_PTR
#define NULL_PTR ((POINTER)0)
#endif

#ifndef UNUSED_ARG
#define UNUSED_ARG(x) x = *(&x);
#endif


#if PROTOTYPES
#define PROTO_LIST(list) list
#else
#define PROTO_LIST(list) ()
#endif

#define ID_OK    0
#define ID_ERROR 1

#define RE_DATA 0x0401
#define RE_LEN 0x0406

#define MAX_RSA_MODULUS_BITS 1024
#define VSIM_MAX_RSA_MODULUS_LEN ((MAX_RSA_MODULUS_BITS + 7) / 8)
#define MAX_RSA_PRIME_BITS ((MAX_RSA_MODULUS_BITS + 1) / 2)
#define MAX_RSA_PRIME_LEN ((MAX_RSA_PRIME_BITS + 7) / 8)


typedef struct {
  unsigned short int bits;                     /* length in bits of modulus */
  unsigned char modulus[VSIM_MAX_RSA_MODULUS_LEN];  /* modulus */
  //unsigned char publicExponent[VSIM_MAX_RSA_MODULUS_LEN];     /* public exponent */
  //unsigned char exponent[VSIM_MAX_RSA_MODULUS_LEN]; /* private exponent */
  unsigned char prime[2][MAX_RSA_PRIME_LEN];   /* prime factors */
  unsigned char primeExponent[2][MAX_RSA_PRIME_LEN];     /* exponents for CRT */
  unsigned char coefficient[MAX_RSA_PRIME_LEN];          /* CRT coefficient */
} R_RSA_PRIVATE_KEY;

typedef struct {
  unsigned short int bits;                     /* length in bits of modulus */
  BYTE modulus[VSIM_MAX_RSA_MODULUS_LEN];  /* modulus */
  BYTE exponent[VSIM_MAX_RSA_MODULUS_LEN]; /* public exponent */
} R_RSA_PUBLIC_KEY;


void VSIM_Decode(VSIM_DIGIT *, unsigned int, unsigned char *, unsigned int);
void VSIM_Encode(unsigned char *, unsigned int, VSIM_DIGIT *, unsigned int);

void VSIM_Assign (VSIM_DIGIT *, VSIM_DIGIT *, unsigned int);
void VSIM_AssignZero (VSIM_DIGIT *, unsigned int);
void VSIM_Assign2Exp (VSIM_DIGIT *, unsigned int, unsigned int);

VSIM_DIGIT VSIM_Add (VSIM_DIGIT *, VSIM_DIGIT *, VSIM_DIGIT *, unsigned int);
VSIM_DIGIT VSIM_Sub(VSIM_DIGIT *, VSIM_DIGIT *, VSIM_DIGIT *, unsigned int);
void VSIM_Mult (VSIM_DIGIT *, VSIM_DIGIT *, VSIM_DIGIT *, unsigned int);
void VSIM_Div(VSIM_DIGIT *, VSIM_DIGIT *, VSIM_DIGIT *, unsigned int, VSIM_DIGIT *,unsigned int);
VSIM_DIGIT VSIM_LShift(VSIM_DIGIT *, VSIM_DIGIT *, unsigned int, unsigned int);
VSIM_DIGIT VSIM_RShift (VSIM_DIGIT *, VSIM_DIGIT *, unsigned int, unsigned int);

void VSIM_Mod(VSIM_DIGIT *, VSIM_DIGIT *, unsigned int, VSIM_DIGIT *, unsigned int);
void VSIM_ModMult(VSIM_DIGIT *, VSIM_DIGIT *, VSIM_DIGIT *, VSIM_DIGIT *, unsigned int);
void VSIM_ModExp (VSIM_DIGIT *, VSIM_DIGIT *, VSIM_DIGIT *, unsigned int, VSIM_DIGIT *,unsigned int);

int VSIM_Cmp (VSIM_DIGIT *, VSIM_DIGIT *, unsigned int);
unsigned int VSIM_Digits (VSIM_DIGIT *, unsigned int);

#define VSIM_ASSIGN_DIGIT(a, b, digits) {VSIM_AssignZero (a, digits); a[0] = b;}


int RSAPublicDecrypt(unsigned char *output,        /* output block */
                                          unsigned int *outputLen,        /* length of output block */
                                          unsigned char *input,          /* input block */
                                          unsigned int inputLen,         /* length of input block */
                                          R_RSA_PUBLIC_KEY *publicKey    /* RSA public key */);

extern SINT32 zAmt_GetPublicKey(BYTE *pE, UINT32 *pELen, BYTE *pN, UINT32 *pModulusLen);

/**************************************************************************
* : zVcard_CmpOpK
* : ֤KOPǷһ
* ˵: (IN)	pbK			16	byte	УxmlеabKֵ
					pbOp		16	byte	УxmlеabOpcֵ
					pbEncExp	128	byte	vsim.binе0x8-0x87ֽݣƫ0ʼ
					pbEncMod	128	byte	vsim.binе0x88-0x107ֽ
					pbEncK		128	byte	vsim.binе0x108-0x187ֽ
					pbEncOP		128	byte	vsim.binе0x188-0x207ֽ
*   ֵ: 0	Уͨ
			1	Уʧ
* ˵: Уʱʹ
**************************************************************************/
BYTE zVcard_CmpOpK(BYTE *pbK, BYTE *pbOp, BYTE *pbEncExp, BYTE *pbEncMod, BYTE *pbEncK, BYTE *pbEncOP);

#endif

