#include <mach/dma.h>
#include "linux/dmaengine.h"

#include <linux/kthread.h>
//#include <linux/Timer.h>
#include <linux/semaphore.h>
#include <linux/dma-mapping.h>
#include <net/SI/ext_mem.h>
#include <linux/skbuff.h>
#include <linux/completion.h>
#include <linux/wait.h>
#include "multi_packet.h"
#include "rndis.h"
#include "mbim.h"

//#include <linux/android_notify.h>
#include <mach/highspeed_debug.h>
#include <mach/dma_cfg.h>
#include <linux/delay.h>


#include <linux/slab.h>
#include <linux/kernel.h>
#include <linux/device.h>
#include <linux/etherdevice.h>
#include <linux/list.h>
#include <linux/atomic.h>
#include <linux/miscdevice.h>
#include <linux/vmalloc.h>
#include <linux/crc32.h>
#include <linux/if_vlan.h>
#include <asm-generic/ioctl.h>


extern unsigned int get_panic_flag(void);
extern unsigned int usb_get_rndis_list_max_flag(void);
extern int mbim_get_work_mode(void);


#define MULTIPACKET_MAXNUM		10

#define DMA_LINK_LIST_MAX_NUM		MULTIPACKET_MAXNUM
#define DMA_ADDR_INVALID	(~(dma_addr_t)0)

#define RNDIS_MSGHEAD_SIZE				sizeof(struct rndis_packet_msg_type)
#define RNDIS_PACKET_ALIGNMENT_FACTOR	1
#define RNDIS_PACKET_ALIGNMENT			(2<<RNDIS_PACKET_ALIGNMENT_FACTOR)
#define RNDIS_ALIGN(X)		((X+RNDIS_MSGHEAD_SIZE+RNDIS_PACKET_ALIGNMENT-1)&~(int)(RNDIS_PACKET_ALIGNMENT-1))    

#define USB_BIND_DMA_BUF_NUM	 8	//8*16*1024	//ա240K
#define USB_UNBIND_DMA_BUF_NUM	 6	//6*16*1024	//ա240K

#if MULTIPACKET_BUF_ALLOC
#else
#define USB_DMA_TX_BUF_ADDR  DMA_RAM_FOR_USB_ADDR_BASE 
#define USB_DMA_RX_BUF_ADDR  DMA_RAM_FOR_USB_ADDR_BASE + USB_DMA_BUF_SIZE
#endif
	
#define USB_MAX_BUF_NUM		16     //336		
#define USB_RNDIS_PKT_MAXSIZE   1568
#define USB_VIRTUAL_PACKET_MAXSIZE   USB_RNDIS_PKT_MAXSIZE
#define PACKET_BUF_EXTRA_NUM    6


#define USB_BIND_TIMER_EXPIRES			10/5
#define MIN(x,y)		  		((x) < (y) ? (x) : (y))



#define USE_DMA_TRANSFER 1

#define USE_ONLY_LIST	0

#define  RNDIS_NAME_STR  "rndis"
#define  MBIM_NAME_STR   "mbim"

struct usb_multi_packet {

	int	numInTrans;	
	struct usb_ep		*ep;

	unsigned	int 		dmaChannelAlloc;
	struct dma_chan * pdmaChannel;
	//dma_channel_def	dmaChannelCfg[DMA_LINK_LIST_MAX_NUM];
	//struct completion	dmaCmplt;	
	struct semaphore	dmaSem;
	
	/* vnic packet list */
	struct list_head	vincPkt_list;
	atomic_t			vnicPkt_num;	
	spinlock_t		vnicPkt_spinLock;	

	atomic_t			count;	
	/* usb buf list*/
	struct list_head	usbBuf_list;
	atomic_t		usbBuft_num;	
	spinlock_t		usbBuf_spinLock;	/* guard usb pool buf list */
#if 1//USE_ONLY_LIST
	//struct usb_request * reqNode[USB_MAX_BUF_NUM];
	volatile int	reqRdPos;	
	volatile int	reqWrPos;	
	volatile int	reqNum;	
	spinlock_t	reqSpinLock;	/* guard usb pool buf list */
	wait_queue_head_t reqWait;	
#endif
	wait_queue_head_t wait;
	struct task_struct	*thread;

	struct timer_list	timer; 	
#if MULTIPACKET_BUF_ALLOC
	int buf_alloc_state;
	int dma_running;
#endif
#ifdef PKT_UNBIND
	int pkt_num;
#endif
    uint8_t net_type ;   //0:δ֪  1rndis2mbim 
    int (*wrap) (struct usb_multi_packet * , struct usb_request *) ;
    int (*unwrap)(struct usb_multi_packet * , struct usb_request *) ;
    int maxPacketNum ;
    struct usb_request ** reqNode;
    dma_channel_def	*dmaChannelCfg;
    unsigned trans_buffer_size ;
    
    
};

struct multi_packet{

	volatile int maxPacketNum; 
	volatile int bindedMaxPacketNum;
	unsigned int active;
	
	struct usb_gadget *gadget;	
	struct gether *geth;
	struct usb_multi_packet bind;
	struct usb_multi_packet unbind;
    void *alloc_mem ;
};


static struct multi_packet multiPacket = {0};
//static struct usb_multi_packet *bind = NULL;
//static struct usb_multi_packet *unbind = NULL;

//unsigned int g_VNIC_MultiPacket_MaxNum = 10;
int multi_packet_get_maxnum(void);

extern void dev_kfree_skb_any(struct sk_buff *skb);
extern int get_vnic_multi_packet_num(void);

void dma_callback(void *data)
{
	struct usb_multi_packet *dev = (struct usb_multi_packet *)data;
#if MULTIPACKET_BUF_ALLOC
	dev->dma_running = 0;
#endif
	up(&dev->dmaSem);
	//complete(&dev->dmaCmplt);
	//USBSTACK_DBG("dma callback");
}


int dma_Scatter_Trans(struct usb_multi_packet * dev, unsigned int Cnt )
{
#if USE_DMA_TRANSFER
	signed int ret = 0;	
	struct dma_async_tx_descriptor *desc =NULL;
	dev->dmaChannelCfg[Cnt-1].link_addr = 0;
	ret=dmaengine_slave_config(dev->pdmaChannel, 
						(struct dma_slave_config*)dev->dmaChannelCfg);

	if (ret!= 0)
	{
		USBSTACK_DBG("dma config err: %d ", ret);
		USB_ASSERT(0," DMA ");
		return ret;
	}

	/* start transfer */

	desc = dev->pdmaChannel->device->device_prep_interleaved_dma(dev->pdmaChannel,NULL,0);
	desc->callback = (dma_async_tx_callback)dma_callback;
	desc->callback_param = (void *) dev;

	/*zx29_chan->zx29_dma_cookie = */dmaengine_submit(desc);
	dma_async_issue_pending(dev->pdmaChannel);
#if MULTIPACKET_BUF_ALLOC
	dev->dma_running = 1;
#endif

	//wait_for_completion_interruptible(&dev->dmaCmplt);
	down(&dev->dmaSem);
	return ret;		

#else
	int i = 0;
	for( i=0;i<Cnt;i++)
	{
		memcpy(dev->dmaChannelCfg[i].dest_addr, 
				dev->dmaChannelCfg[i].src_addr, 
				dev->dmaChannelCfg[i].count);
	}
	return 0;
#endif
}

static bool dma_filterFn(struct dma_chan *chan, void *param)
{
	return true;
}


void clean_vnic_packet_list(struct usb_multi_packet *multiPkt)
{
    unsigned long flags;
	struct usb_request	*req = NULL;

	spin_lock_irqsave(&multiPkt->vnicPkt_spinLock, flags);
	while (!list_empty(&multiPkt->vincPkt_list))
	{
		req = container_of(multiPkt->vincPkt_list.next, struct usb_request, list);
		list_del(&req->list);
        spin_unlock_irqrestore(&multiPkt->vnicPkt_spinLock, flags);
#if 0//USE_DMA_TRANSFER
		if(psbuff_virt_to_phys(req->buf, &req->dma) == 0)
		{
			usb_gadget_unmap_request(multiPacket.gadget, req, 1);
		}
#endif
		dev_kfree_skb_any(req->context);
		usb_ep_free_request(multiPkt->ep, req);
		spin_lock_irqsave(&multiPkt->vnicPkt_spinLock, flags);
	}
	spin_unlock_irqrestore(&multiPkt->vnicPkt_spinLock, flags);
}

void mbim_change_rx_complete(usb_complete_t __complete)
{

    unsigned long flags;
	struct usb_request	*req = NULL;
	struct usb_multi_packet *punbind = &multiPacket.unbind;
	int cnt = 0;
	struct list_head *pkt_head = &punbind->vincPkt_list;
	struct list_head *pkt_next = pkt_head->next;
	spin_lock_irqsave(&punbind->vnicPkt_spinLock, flags);
	if(list_empty(&punbind->vincPkt_list)){
		spin_unlock_irqrestore(&punbind->vnicPkt_spinLock, flags);
		printk("mbim_change_rx_complete, vincPkt_list\r\n");
		
		return;
	}
	while (pkt_next != pkt_head)
	{
		req = container_of(pkt_next, struct usb_request, list);
		req->complete = __complete;
		cnt++;
		pkt_next = pkt_next->next;
	}

	spin_unlock_irqrestore(&punbind->vnicPkt_spinLock, flags);
	printk("mbim_change_rx_complete, cnt:%d, complete:%p\r\n", cnt, __complete);
}

void u_ether_rx_vnic_packet_list(void)
{
    unsigned long flags;
	struct usb_request	*req = NULL;
	struct usb_multi_packet *punbind = &multiPacket.unbind;

    if(multi_packet_get_maxnum() <=1 )
        return;

	spin_lock_irqsave(&punbind->vnicPkt_spinLock, flags);
	while (!list_empty(&punbind->vincPkt_list))
	{
		req = container_of(punbind->vincPkt_list.next, struct usb_request, list);
		list_del(&req->list);
		spin_unlock_irqrestore(&punbind->vnicPkt_spinLock, flags);
        atomic_dec(&punbind->vnicPkt_num);
		req->status = -ESHUTDOWN;
		req->complete(punbind->ep, req);
		spin_lock_irqsave(&punbind->vnicPkt_spinLock, flags);
	}
    /* е*/
    punbind->reqRdPos = 0;
    punbind->reqWrPos = 0;
	spin_unlock_irqrestore(&punbind->vnicPkt_spinLock, flags);
}
void u_ether_tx_vnic_packet_list(void)
{
    unsigned long		flags;
	struct usb_request	*req = NULL;
    struct usb_multi_packet *bind = &multiPacket.bind;

    if(multi_packet_get_maxnum() <=1 )
        return;

	spin_lock_irqsave(&bind->vnicPkt_spinLock, flags);
	while (!list_empty(&bind->vincPkt_list))
	{
		req = container_of(bind->vincPkt_list.next, struct usb_request, list);
		list_del(&req->list);
		spin_unlock_irqrestore(&bind->vnicPkt_spinLock, flags);
        atomic_dec(&bind->vnicPkt_num);
		req->status = -ESHUTDOWN;
		req->complete(bind->ep, req);
		spin_lock_irqsave(&bind->vnicPkt_spinLock, flags);
	}
    bind->reqRdPos = 0;
	bind->reqWrPos = 0;
	spin_unlock_irqrestore(&bind->vnicPkt_spinLock, flags);
}

/***************************************************************************  
 *						RNDISЭ/  
 ****************************************************************************/
/* RNDIS  */
int rndis_unwrap(struct usb_multi_packet * unbind, struct usb_request *req)
{
    unsigned long flags;
	int tempLength = req->actual;
	unsigned char * tempBufAddr = req->buf;
	unsigned char * tempDmaAddr = req->dma;
	
	struct rndis_packet_msg_type *head = NULL;
	struct usb_request *temp_req= NULL;

	int index = 0;
	struct list_head *temp_list =  &unbind->vincPkt_list;

#if MULTIPACKET_BUF_ALLOC
	if((req->buf == NULL) || (req->dma == NULL))
	{
		USBSTACK_DBG("req buf or dma is null\n");
		return 0;
	}
#endif
	if(req->status !=0)
	{
		//req״̬Ƿ
		//USB_ASSERT(0, "REQ: 0x%x", req);
		USBSTACK_DBG("req->status: %d", req->status);
		return req->status;
	}
	
	spin_lock_irqsave(&unbind->vnicPkt_spinLock, flags);
	if(list_empty(&unbind->vincPkt_list)){
		USBSTACK_DBG("%s unbind vincPkt list NULL", __func__);
		temp_list = NULL;
	}
	spin_unlock_irqrestore(&unbind->vnicPkt_spinLock, flags);
		
	if(temp_list == NULL){
		USBSTACK_DBG("rndis_unwrap vnic Pktlist is NULL");
		return 0;	
	}
	
	do
	{
#if MULTIPACKET_BUF_ALLOC
		//ʱreq bufΪգ򷵻
		if(tempBufAddr == NULL){
			USBSTACK_DBG("req is freel\n");
			break;
		}
#endif
		head = (struct rndis_packet_msg_type *)tempBufAddr;
		if(head->MessageType != cpu_to_le32(REMOTE_NDIS_PACKET_MSG))
		{
			//ͷУ
			USBSTACK_DBG("USB RNDIS HEAD ERR :%0x\n",head->MessageType);
 			break;
		}

		if(tempLength < (unsigned short)head->MessageLength)
		{
			//ʣ೤Ȳ㣬
			USBSTACK_DBG("USB RNDIS DATA LENGTH ERR templen:%d,msg len:%d\n",tempLength,(unsigned short)head->MessageLength);
			break;
		}

		spin_lock_irqsave(&unbind->vnicPkt_spinLock, flags);
		if(list_empty(&unbind->vincPkt_list)){
			USBSTACK_DBG("%s unbind vincPkt list NULL", __func__);
			temp_list = NULL;
		}
		else
			temp_list = temp_list->next;		
		spin_unlock_irqrestore(&unbind->vnicPkt_spinLock, flags);
		
		if(temp_list == &unbind->vincPkt_list){
			USBSTACK_DBG("unbind get the head of list\n");
			return index;
		}
		
		if(temp_list == NULL){
			if(kthread_should_stop()){
				USBSTACK_DBG("unbind is kill and unwrap exit");
               return index;
			}else{
#if 0
                msleep(2);
                continue;
#else

               return index;
#endif
			}
		}

		unbind->dmaChannelCfg[index].count = (unsigned short)head->DataLength;

#if USE_DMA_TRANSFER
		unbind->dmaChannelCfg[index].link_addr = 1;
		unbind->dmaChannelCfg[index].src_addr = (unsigned int)(tempDmaAddr + 8  \
												+ head->DataOffset);
#else
		unbind->dmaChannelCfg[index].src_addr = (unsigned int)(tempBufAddr + 8  \
												+ head->DataOffset);
#endif

		++index;

	
		temp_req = container_of(temp_list, struct usb_request, list);
		
#if USE_DMA_TRANSFER
		unbind->dmaChannelCfg[index-1].dest_addr = (unsigned int)temp_req->dma;
#else
		unbind->dmaChannelCfg[index-1].dest_addr = (unsigned int)temp_req->buf;
#endif

		temp_req->actual = (unsigned short)head->DataLength;

		tempLength -= (unsigned short)head->MessageLength;
		if(tempLength <= RNDIS_MSGHEAD_SIZE)
		{
			break;   //
		}

		tempBufAddr += (unsigned short)head->MessageLength;
		tempDmaAddr += (unsigned short)head->MessageLength;
	    	
	}while(unbind->maxPacketNum -index);
		
	return index;
}

/* RNDIS RNDISͷ */
int rndis_add_head(unsigned int msgAddr, unsigned msgLen)
{
	struct rndis_packet_msg_type *head = NULL;

	head = (struct rndis_packet_msg_type *)msgAddr;

	memset((void*)head, 0, RNDIS_MSGHEAD_SIZE);
	head->MessageType = cpu_to_le32(REMOTE_NDIS_PACKET_MSG);
	head->MessageLength = cpu_to_le32(RNDIS_ALIGN(msgLen));
	head->DataOffset = cpu_to_le32(36);
	head->DataLength = cpu_to_le32(msgLen);

	return head->MessageLength;	
}
/* RNDIS  */
int rndis_wrap(struct usb_multi_packet * bind, struct usb_request *req)
{
	int index = 0;  	
	int bindPacketNum = 0;
	dma_addr_t	tempDmaAddr = req->dma;
	unsigned int	tempBufAddr = (unsigned int)req->buf;
	unsigned int	tempLen = 0;
	unsigned long			flags;
	struct usb_request *temp_req = NULL;
	struct list_head *temp_list =  NULL;

	req->length = 0;

	spin_lock_irqsave(&bind->vnicPkt_spinLock, flags);
	temp_list =  &bind->vincPkt_list;
	
	spin_unlock_irqrestore(&bind->vnicPkt_spinLock, flags);

	bindPacketNum = atomic_read(&bind->vnicPkt_num);
	bindPacketNum = MIN(bindPacketNum, bind->maxPacketNum);	
	
	if(bindPacketNum < 1)
		return bindPacketNum;
	
	do
	{	
		spin_lock_irqsave(&bind->vnicPkt_spinLock, flags);
		temp_list = temp_list->next;
		
		if(temp_list == 	&bind->vincPkt_list){
			USBSTACK_DBG("bind get the head of list\n");
			spin_unlock_irqrestore(&bind->vnicPkt_spinLock, flags);
			return index;
		}
		
		temp_req = container_of(temp_list, struct usb_request, list);
		spin_unlock_irqrestore(&bind->vnicPkt_spinLock, flags);

#if USE_DMA_TRANSFER

		//USBSTACK_DBG("index: %d, list: 0x%x", index, &temp_req->list);
		//USBSTACK_DBG("index: %d, src: 0x%x", index, temp_req->dma);
		bind->dmaChannelCfg[index].link_addr = 1;
		bind->dmaChannelCfg[index].src_addr = (unsigned int)temp_req->dma;
		bind->dmaChannelCfg[index].dest_addr =(unsigned int)(tempDmaAddr + RNDIS_MSGHEAD_SIZE);
#else
		bind->dmaChannelCfg[index].src_addr = (unsigned int)temp_req->buf;
		bind->dmaChannelCfg[index].dest_addr =(unsigned int)(tempBufAddr + RNDIS_MSGHEAD_SIZE);
#endif
		bind->dmaChannelCfg[index].count = (unsigned short)temp_req->length;
		
		tempLen = rndis_add_head(tempBufAddr, temp_req->length);
		
		tempDmaAddr += tempLen;
		tempBufAddr += tempLen;
		
		req->length += tempLen;
		
		index++;			
	}while(bindPacketNum -index);

    return bindPacketNum;
}



/***************************************************************************  
 *						MBIMЭ/  
 ****************************************************************************/
/* MBIM  */
int mbim_unwrap(struct usb_multi_packet * unbind, struct usb_request *req)
{
    unsigned long flags;
	unsigned char * tempBufAddr = req->buf;
	unsigned char * tempDmaAddr = req->dma;
	
	struct usb_request *temp_req= NULL;

	int index = 0;
	struct list_head *temp_list =  &unbind->vincPkt_list;
    int cur_first_datagram ;
    int first_ndp_index ;
    int next_ndp_index ;
    int nfram ;
    uint16_t datagram_len ;
    uint16_t datagram_index ;
    int j = 0 ;
    int head_size = 0;

#if MULTIPACKET_BUF_ALLOC
	if((req->buf == NULL) || (req->dma == NULL))
	{
		USBSTACK_DBG("req buf or dma is null\n");
		return 0;
	}
#endif
	if(req->status !=0)
	{
		//req״̬Ƿ
		//USB_ASSERT(0, "REQ: 0x%x", req);
		USBSTACK_DBG("req->status: %d", req->status);
		return req->status;
	}
	
	spin_lock_irqsave(&unbind->vnicPkt_spinLock, flags);
	if(list_empty(&unbind->vincPkt_list)){
		USBSTACK_DBG("%s unbind vincPkt list NULL", __func__);
		temp_list = NULL;
	}
	spin_unlock_irqrestore(&unbind->vnicPkt_spinLock, flags);
		
	if(temp_list == NULL){
		USBSTACK_DBG("rndis_unwrap vnic Pktlist is NULL");
		return 0;	
	}
	//ͷ
    first_ndp_index = mbim_get_first_ndp16_offset(req) ;
    if(first_ndp_index <=0)
    {
        USBSTACK_DBG("[%s]:mbim ntb is not completed, first_ndp_index = %d\n",__func__,first_ndp_index ) ;
        return first_ndp_index ;
    }
    //printk("[func]:%s, [line]:%d , first_ndp_index = %d \n",__func__,__LINE__,first_ndp_index ) ;
	do
	{
#if MULTIPACKET_BUF_ALLOC
		//ʱreq bufΪգ򷵻
		if(tempBufAddr == NULL){
			USBSTACK_DBG("req is freel\n");
			break;
		}
#endif
		//жǷreq->read

		//printk("[func]:%s, [line]:%d , first_ndp_index = %d \n",__func__,__LINE__,first_ndp_index ) ;

        //ȡһ
        nfram = mbim_get_next_datagram_fragment(req, first_ndp_index, &cur_first_datagram ,&next_ndp_index) ;
        if( nfram < 0 )
        {
            USBSTACK_DBG("[func]:%s ,[line]: %d , mbim ntb is not complete ,nfram = %d \n",__func__,__LINE__ ,nfram) ;
            return index ;
        }
		//printk("[func]:%s ,[line]: %d , nfram = %d ,cur_first_datagram = %d ,next_ndp_index= %d \n",__func__,__LINE__ ,
		// nfram ,cur_first_datagram ,next_ndp_index) ;
        head_size = mbim_get_reverse_head_size() ;
        for(j = 0 ;j< nfram;j++ )
        {
            //DMA
            if(index == unbind->maxPacketNum)
            {
                   //printk("[func]:%s ,[line]: %d , mbim ntb is too big  \n",__func__,__LINE__ ) ;
                   return index;
            }
            int i = 0 ;
            
            datagram_index = get_unaligned_le16( req->buf+cur_first_datagram +j*4);
            datagram_len = get_unaligned_le16( req->buf+cur_first_datagram + j*4+2);
			//printk("[func]:%s ,[line]: %d , datagram_index= %d,datagram_len = %d \n",__func__,__LINE__,datagram_index,datagram_len) ;
 
            if(datagram_index == 0 || datagram_len == 0)
            {
                USBSTACK_DBG("[func]:%s ,[line]: %d , datagram_index= %d,datagram_len = %d \n",__func__,__LINE__,datagram_index,datagram_len) ;
                break ;

            }
			
            if( req->buf + req->actual < req->buf + datagram_index +datagram_len )
            {
                USBSTACK_DBG("[func]:%s ,[line]: %d , datagram_index= %d,datagram_len = %d , req->actual = %d \n",
                    __func__,__LINE__,datagram_index,datagram_len, req->actual) ;
                return -EFAULT ;
            }
    		spin_lock_irqsave(&unbind->vnicPkt_spinLock, flags);
    		if(list_empty(&unbind->vincPkt_list))
            {
    			USBSTACK_DBG("%s unbind vincPkt list NULL", __func__);
    			temp_list = NULL;
    		}
    		else
    		{
    			temp_list = temp_list->next;
            }
	
    		spin_unlock_irqrestore(&unbind->vnicPkt_spinLock, flags);
    		
    		if(temp_list == &unbind->vincPkt_list)
            {
                USBSTACK_DBG("unbind get the head of list\n");
                return index;
    		}

    		if(temp_list == NULL)
            {
                USBSTACK_DBG("unbind is kill and unwrap exit");
				return index;
    		}
            
            unbind->dmaChannelCfg[index].count = (unsigned short)datagram_len ;
    
#if USE_DMA_TRANSFER
            unbind->dmaChannelCfg[index].link_addr = 1;
            unbind->dmaChannelCfg[index].src_addr = (unsigned int)(tempDmaAddr +datagram_index);
#else
            unbind->dmaChannelCfg[index].src_addr = (unsigned int)(tempBufAddr + datagram_index) ;
#endif
    
        
            temp_req = container_of(temp_list, struct usb_request, list);
            
#if USE_DMA_TRANSFER
            unbind->dmaChannelCfg[index].dest_addr = (unsigned int)temp_req->dma + head_size;
#else
            unbind->dmaChannelCfg[index].dest_addr = (unsigned int)temp_req->buf + head_size;
#endif
    
            temp_req->actual = (unsigned short)datagram_len;

            //printk("[func]:%s ,[line]: %d , src_addr = 0x%x,dst_addr = 0x%x \n",__func__,__LINE__,
			//	unbind->dmaChannelCfg[index].src_addr,unbind->dmaChannelCfg[index].dest_addr) ;
 
            //
            index++ ;
            
        }
     
        if(next_ndp_index == 0)
        {
           break ;
        }
        first_ndp_index = next_ndp_index ; 

	}while(unbind->maxPacketNum - index);
		
	return index;
}


/* MBIM  */
int mbim_wrap(struct usb_multi_packet * bind, struct usb_request *req)
{
	int index = 0;  	
	int bindPacketNum = 0;
	dma_addr_t	tempDmaAddr = req->dma;
	unsigned int	tempBufAddr = (unsigned int)req->buf;
	unsigned int	tempLen = 0;
	unsigned long			flags;
	struct usb_request *temp_req = NULL;
	struct list_head *temp_list =  NULL;
    int ncm_head_size = 0 ; 
    uint16_t cur_index = 0 ;
    struct mbim_ncm_info ncm_info ;
	req->length = 0;
	spin_lock_irqsave(&bind->vnicPkt_spinLock, flags);
	temp_list =  &bind->vincPkt_list;
	
	spin_unlock_irqrestore(&bind->vnicPkt_spinLock, flags);

	bindPacketNum = atomic_read(&bind->vnicPkt_num);
	bindPacketNum = MIN(bindPacketNum, bind->maxPacketNum);	
	if(bindPacketNum < 1)
		return bindPacketNum;
	//ʼͷϢ
    ncm_head_size = mbim_get_nth16_and_ndp16_size();
    mbim_ncm16_and_ndp16_init((char *)tempBufAddr, ncm_head_size+1) ;
    tempBufAddr += ncm_head_size ;
    req->length += ncm_head_size ;
    tempDmaAddr += ncm_head_size ;
    cur_index += ncm_head_size ;
    
	do
	{	
		spin_lock_irqsave(&bind->vnicPkt_spinLock, flags);
		temp_list = temp_list->next;
		
		if(temp_list == 	&bind->vincPkt_list){
			USBSTACK_DBG("bind get the head of list\n");
			spin_unlock_irqrestore(&bind->vnicPkt_spinLock, flags);
			return index;
		}
		
		temp_req = container_of(temp_list, struct usb_request, list);
		spin_unlock_irqrestore(&bind->vnicPkt_spinLock, flags);


#if USE_DMA_TRANSFER

		//USBSTACK_DBG("index: %d, list: 0x%x", index, &temp_req->list);
		//USBSTACK_DBG("index: %d, src: 0x%x", index, temp_req->dma);
		bind->dmaChannelCfg[index].link_addr = 1;
		bind->dmaChannelCfg[index].src_addr = (unsigned int)temp_req->dma;
		bind->dmaChannelCfg[index].dest_addr =(unsigned int)tempDmaAddr;
#else
		bind->dmaChannelCfg[index].src_addr = (unsigned int)temp_req->buf;
		bind->dmaChannelCfg[index].dest_addr =(unsigned int)tempBufAddr;
#endif
		bind->dmaChannelCfg[index].count = (unsigned short)temp_req->length;
		//printk("index = %d \n",index ,(unsigned long)tempDmaAddr , (unsigned long)(temp_req->dma + temp_req->real));
		
		//޸ͷϢ
        ncm_info.ndp_datagram_off = cur_index ;
        ncm_info.ndp_datagram_len =(unsigned short)temp_req->length ;
        cur_index += (unsigned short)temp_req->length;
        cur_index = ((cur_index+3)>>2)<<2 ; //4ֽڶ
        ncm_info.nth_block_len = cur_index;
        
		if(mbim_fill_ncm16_vary_head_info(req->buf, &ncm_info)<0) 
		{
            USBSTACK_DBG("[%s]: fill ntb head info err\n",__func__) ;
            return -EFAULT ;
        }
		tempDmaAddr = (unsigned int)req->dma + cur_index;
		tempBufAddr += (unsigned int)req->buf +cur_index;
		req->length = cur_index;
    	//USBSTACK_DBG("[%s]: [line]:%d ,index=%d ....\n",__func__,__LINE__,index) ;			
		index++;			
	}while(bindPacketNum -index);

    return bindPacketNum;
}


int virtual_network_wrap(struct usb_multi_packet * bind, struct usb_request *req)
{
    int ret = 0 ;
    if(bind->wrap)
    {
        ret = bind->wrap(bind,  req) ;
        if(ret > 0 && (req->length % bind->ep->maxpacket == 0) )
        {
            req->zero = 1 ;
        }else
        {
            req->zero = 0 ;
        }
        return  ret ;
    }

    USBSTACK_DBG("[%s]:net type is unknown \n",__func__) ;
    return -EINVAL ;



}


int virtual_network_unwrap(struct usb_multi_packet * unbind, struct usb_request *req)
{

    if(unbind->unwrap)
    {
        return unbind->unwrap(unbind,  req) ;
    }
    USBSTACK_DBG("[%s]:net type is unknown \n",__func__) ;
    return  -EINVAL ;


}


void usbUnbind_ep_queue(struct usb_multi_packet *punbind)
{
	int		retval = -ENOMEM;
	struct usb_request	*req= NULL;

	req = punbind->reqNode[punbind->reqWrPos];

#if MULTIPACKET_BUF_ALLOC
	if(req == NULL){
		usb_printk("usbUnbind_ep_queue, req is null\n");
		return;
	}
#endif

	punbind->reqWrPos = (punbind->reqWrPos+1)%punbind->reqNum;
    atomic_inc(&punbind->usbBuft_num);
    
	//spin_unlock_irqrestore(&punbind->reqSpinLock, flags);
	req->length = punbind->trans_buffer_size ;
	//memset(req->buf, 0, req->length);
	//USBSTACK_DBG("multi-rx len: %d", req->length);
	retval = usb_ep_queue(punbind->ep, req, GFP_ATOMIC);
	if(retval)
	{
		USBSTACK_DBG("rx err value: %d, req:0x%p", retval,req );
	}
}

void usbUnbind_rx_complete(struct usb_ep *ep, struct usb_request *req)
{
	struct usb_multi_packet *punbind = &multiPacket.unbind;

#if MULTIPACKET_BUF_ALLOC
	if(punbind->buf_alloc_state == 0)
	{
		USBSTACK_DBG("usbUnbind_rx_complete,buf is free\n");
		usb_printk("usbUnbind_rx_complete,buf is free\n");
		return;
	}
#endif
	if((multiPacket.active==0)&&(req->status < 0))
	{
		USBSTACK_DBG("Rx cmplt, req->status:%d", req->status);
		return;
	}
	
	//USBSTACK_DBG("Rx-cmpl len: %d", req->actual);
	//if node ring is not full
	if((punbind->reqWrPos+1)%punbind->reqNum != punbind->reqRdPos)
	{
		usbUnbind_ep_queue(punbind)	;
	}
	atomic_inc(&punbind->count);

#ifndef PKT_UNBIND
	wake_up(&punbind->wait);
#else
	if(req->actual <= USB_VIRTUAL_PACKET_MAXSIZE){
		punbind->pkt_num++;
	}

	if((punbind->pkt_num >= 5) || (req->actual > USB_VIRTUAL_PACKET_MAXSIZE)){
		wake_up(&punbind->wait);
	}else if(punbind->pkt_num == 1){
		mod_timer(&punbind->timer, (jiffies + USB_BIND_TIMER_EXPIRES));
	}
#endif
}

/*ؽջ廻ڻѹδĽڵ*/
int usbUnbind_num_backlog(struct usb_multi_packet *punbind)
{
#if 0
	int 	RdPos;
	int	WrPos;
	unsigned long		flags;
	spin_lock_irqsave(&punbind->reqSpinLock, flags);
	RdPos = punbind->reqRdPos;
	WrPos = punbind->reqWrPos;
	spin_unlock_irqrestore(&punbind->reqSpinLock, flags);

	USBSTACK_DBG("RdPos:%d, WrPos:%d", RdPos,WrPos);

	if(RdPos<= WrPos)
	{
		return WrPos- RdPos;
	}
	else
	{
		return punbind->reqNum+ WrPos- RdPos;
	}
#else
	int n = atomic_read(&punbind->count);
	//USBSTACK_DBG("rxCount :%d", n);
	return n;
#endif

}

unsigned int eth_offline_num = 0;
unsigned int packet_num = 0;
int usbUnbind_thread(void *ptr)
{
	unsigned long			flags;
	int		retval = -ENOMEM;
	int wait_event_ret = 0;
	struct usb_multi_packet *punbind = (struct usb_multi_packet *)ptr;
	struct usb_request	*req = NULL;
	struct usb_ep *ep = punbind->ep;
       struct gether *port = container_of(ep, struct gether, out_ep);
	struct eth_dev	*dev = container_of(port, struct eth_dev, port_usb);
	//struct sched_param param = { .sched_priority = 1 };
	//sched_setscheduler(current, SCHED_FIFO, &param);
	USBSTACK_DBG("unbind thread entry!");

	atomic_set(&punbind->count, 0);

	struct sched_param sch_param = { .sched_priority = 1 };
	sch_param.sched_priority = 37;
	sched_setscheduler(current, SCHED_FIFO, &sch_param);
	
	while(!kthread_should_stop())
	{
		wait_event_ret = wait_event_interruptible(punbind->wait,  
			usbUnbind_num_backlog(punbind)||kthread_should_stop());
		
		if(kthread_should_stop())
		{
			USBSTACK_DBG("unbind thread stop");
			break;
		}
		
		if(wait_event_ret < 0)
			continue;
		
		atomic_dec(&punbind->count);
		if(dev->eth_state== 0){
			eth_offline_num++;
			if(eth_offline_num == 1 || eth_offline_num%3000 == 0){
				usb_printk("%s, %u portname:%s\n", __func__, __LINE__, port->func.name);
				USBSTACK_DBG("%s, %u portname:%s\n", __func__, __LINE__, port->func.name);
			}

			return -ESHUTDOWN;
		}
		
#if USE_ONLY_LIST
		spin_lock_irqsave(&punbind->usbBuf_spinLock, flags);
		req = container_of(punbind->usbBuf_list.next, struct usb_request, list);
		list_del_init(&req->list);
		spin_unlock_irqrestore(&punbind->usbBuf_spinLock, flags);
        atomic_dec(&punbind->usbBuft_num);
#else
		spin_lock_irqsave(&punbind->reqSpinLock, flags);
		req = punbind->reqNode[punbind->reqRdPos];
		spin_unlock_irqrestore(&punbind->reqSpinLock, flags);		
#endif
#if MULTIPACKET_BUF_ALLOC
		if(req == NULL){
			usb_printk("%s, %u req is null\n", __func__, __LINE__);
			continue;
		}
#endif
		//printk("-----------unbind,read len:%d\r\n", req->actual);
		punbind->numInTrans = virtual_network_unwrap(punbind, req);
		if(punbind->numInTrans == 1){
			packet_num++;
		}else if(packet_num > 0){
			packet_num = 0;
			if(sch_param.sched_priority == 36){
				sch_param.sched_priority = 37;
				sched_setscheduler(current, SCHED_FIFO, &sch_param);
			}
		}
			
		if((packet_num > 5) && (sch_param.sched_priority == 37)){
			sch_param.sched_priority = 36;
			sched_setscheduler(current, SCHED_FIFO, &sch_param);
		}
		if((punbind->numInTrans <= 0)||(punbind->numInTrans>10))
		{
			USBSTACK_DBG(" punbind->numInTrans err : %d", punbind->numInTrans);
		}
		else
		{
			//USBSTACK_DBG("multi-rx num: %d", unbindPacketNum);
			dma_Scatter_Trans(punbind, punbind->numInTrans);
			
			spin_lock_irqsave(&punbind->vnicPkt_spinLock, flags);
			do
			{
			    if (list_empty(&punbind->vincPkt_list)){
					USBSTACK_DBG("%s unbind vincPkt_list is NULL", __func__);
					break;
			    }
				req = container_of(punbind->vincPkt_list.next, struct usb_request, list);
				list_del_init(&req->list);
				spin_unlock_irqrestore(&punbind->vnicPkt_spinLock, flags);

				atomic_dec(&punbind->vnicPkt_num);

#if USE_DMA_TRANSFER
				usb_gadget_unmap_request(multiPacket.gadget, req, 0);
#endif
				//USBSTACK_DBG("Rx len: %d", req->actual);
				if(multiPacket.active)
				{
					if(punbind->numInTrans == 1){
						struct sk_buff	*skb = req->context;
						skb_set_last_pkg(skb);
					}
					req->complete(punbind->ep, req);
				}
				else
				{
					dev_kfree_skb_any(req->context);	
					usb_ep_free_request(punbind->ep, req);
				}
				spin_lock_irqsave(&punbind->vnicPkt_spinLock, flags);
				
			}while(--punbind->numInTrans);
			spin_unlock_irqrestore(&punbind->vnicPkt_spinLock, flags);
		}
		
		spin_lock_irqsave(&punbind->reqSpinLock, flags);
		punbind->reqRdPos = (punbind->reqRdPos+1)%punbind->reqNum;
		spin_unlock_irqrestore(&punbind->reqSpinLock, flags);
        atomic_dec(&punbind->usbBuft_num);
		
		if(punbind->reqRdPos == punbind->reqWrPos)
		{
			//spin_unlock_irqrestore(&punbind->reqSpinLock, flags);		
			usbUnbind_ep_queue(punbind);
		}
	}

	clean_vnic_packet_list(punbind);

	eth_offline_num = 0;

	USBSTACK_DBG("unbind thread exit!");
	return 0;
}


void usbBind_timerCallBack(unsigned long data)
{
	struct usb_multi_packet *pbind = (struct usb_multi_packet *)data;
	wake_up(&pbind->wait);
	//USBSTACK_DBG("wake_up");
	return;
}

#ifdef PKT_UNBIND
void usbunBind_timerCallBack(unsigned long data)
{
	struct usb_multi_packet *punbind = (struct usb_multi_packet *)data;
	wake_up(&punbind->wait);
	//USBSTACK_DBG("wake_up");
	return;
}
#endif

void usbBind_tx_complete(struct usb_ep *ep, struct usb_request *req)
{
	unsigned long			flags;
	struct usb_multi_packet *pbind = &multiPacket.bind;

#if MULTIPACKET_BUF_ALLOC
	if(pbind->buf_alloc_state == 0){
		USBSTACK_DBG("usbBind_tx_completebuf alloc state:%d\n",pbind->buf_alloc_state);
		usb_printk("usbBind_tx_completebuf alloc state:%d\n",pbind->buf_alloc_state);
		return;
	}
#endif
	spin_lock_irqsave(&pbind->usbBuf_spinLock, flags);
	req->zero = 0;
	if(list_empty(&pbind->usbBuf_list))
	{
		list_add_tail(&req->list, &pbind->usbBuf_list);
		pbind->reqRdPos = (pbind->reqRdPos+1)%pbind->reqNum;
		spin_unlock_irqrestore(&pbind->usbBuf_spinLock, flags);
		atomic_inc(&pbind->usbBuft_num);
		atomic_set(&pbind->count, 1);
		wake_up(&pbind->reqWait);
	}
	else
	{
		list_add_tail(&req->list, &pbind->usbBuf_list);
		pbind->reqRdPos = (pbind->reqRdPos+1)%pbind->reqNum;
		spin_unlock_irqrestore(&pbind->usbBuf_spinLock, flags);
		atomic_inc(&pbind->usbBuft_num);
	}

	//USBSTACK_DBG("Tx-cmpl len: %d", req->actual);
}


void usbBind_ep_queue(struct usb_multi_packet *pbind, struct usb_request *req)
{
	int	retval=0;
	unsigned long			flags;
	struct usb_ep *ep = pbind->ep;
	struct gether *port = container_of(ep, struct gether, in_ep);
	struct eth_dev	*dev = container_of(port, struct eth_dev, port_usb);

	req->zero = ((req->length)%(pbind->ep->maxpacket)==0) ? 1 : 0;
	//dsb();
	retval = usb_ep_queue(pbind->ep, req, GFP_ATOMIC);
	//USBSTACK_DBG("multi-tx len: %d", req->length);

	if (retval==0) 
	{
		do
		{
			spin_lock_irqsave(&pbind->vnicPkt_spinLock, flags);
			if (list_empty(&pbind->vincPkt_list))
			{
			    pbind->numInTrans = 0;
				BUG_ON(atomic_read(&pbind->vnicPkt_num));
				USBSTACK_DBG("%s bind vnicPkt list is NULL!", __func__);
				spin_unlock_irqrestore(&pbind->vnicPkt_spinLock, flags);//11
				break;
			}
			req = container_of(pbind->vincPkt_list.next, struct usb_request, list);
			list_del_init(&req->list);
			spin_unlock_irqrestore(&pbind->vnicPkt_spinLock, flags);

			atomic_dec(&pbind->vnicPkt_num);
			//USBSTACK_DBG("%d, release list:0x%x, dma: 0x%x", gbindPacketNum,&req->list,req->dma);
			
#if 0//USE_DMA_TRANSFER
			if(psbuff_virt_to_phys(req->buf, &req->dma) == 0)
			{
				usb_gadget_unmap_request(multiPacket.gadget, req, 1);
			}
#endif
			req->status = (multiPacket.active == 0) ? -ESHUTDOWN : 0;
			req->complete(pbind->ep, req);
			if(multiPacket.active == 0)
			{
				USBSTACK_DBG("bind deactive !\n");
			}
		}while(--pbind->numInTrans);
	}
	else
	{
		if(multiPacket.active && dev->eth_state == 1)
		{
			USB_ASSERT(0, "tx fail value(%d)", retval);
		}
		else
		{
			/* ·ϿUSBʧ ǷҪСкͷСSKBԤС*/
//			atomic_set(&pbind->vnicPkt_num, 0);	
			USBSTACK_DBG("bind deactive and net is disconnect!");
		}
		/*黹*/
		usbBind_tx_complete(pbind->ep, req);
	}	
}

int usbBind_thread(void *ptr)
{
	unsigned long			flags;
	struct usb_multi_packet *pbind = (struct usb_multi_packet *)ptr;
	struct usb_request	*req = NULL;
	struct usb_ep *ep = pbind->ep;
	struct gether *port = container_of(ep, struct gether, in_ep);
	struct eth_dev	*dev = container_of(port, struct eth_dev, port_usb);
	int wait_event_ret = 0;
	
	atomic_set(&pbind->count, 1);

	USBSTACK_DBG("bind thread entry!");
	struct sched_param sch_param = { .sched_priority = 1 };
	sch_param.sched_priority = 37;
	sched_setscheduler(current, SCHED_FIFO, &sch_param);

	

	while(!kthread_should_stop())
	{
		wait_event_ret = wait_event_interruptible(pbind->wait, 
			(atomic_read(&pbind->vnicPkt_num) && multiPacket.active == 1)||kthread_should_stop());

		if(kthread_should_stop())
		{
			USBSTACK_DBG("bind thread stop-1");
			break;
		}
		
		if(wait_event_ret < 0)	//only deal stop signal, others will continue wait condition	
			continue;
		
		if(dev->eth_state== 0){
			eth_offline_num++;
			if(eth_offline_num == 1 || eth_offline_num%3000 == 0){
				usb_printk("%s, %u portname:%s\n", __func__, __LINE__, port->func.name);
				USBSTACK_DBG("%s, %u portname:%s\n", __func__, __LINE__, port->func.name);
			}

			return -ESHUTDOWN;
		}

		/* USB-BUFлȡռ */
		spin_lock_irqsave(&pbind->usbBuf_spinLock, flags);

		if (list_empty(&pbind->usbBuf_list)) {
			atomic_set(&pbind->count, 0);
			spin_unlock_irqrestore(&pbind->usbBuf_spinLock, flags);
			USBSTACK_DBG("bind-buf is empty");
wait_reqwait_signal:			
			wait_event_ret = wait_event_interruptible(pbind->reqWait, 
				atomic_read(&pbind->count)||kthread_should_stop());

			if(kthread_should_stop())
			{
				USBSTACK_DBG("bind thread stop-2");
				break;
			}
			
			if(wait_event_ret < 0)	//only deal stop signal, others will continue wait reqWait condition	
				goto wait_reqwait_signal;

			spin_lock_irqsave(&pbind->usbBuf_spinLock, flags);
		}
	
		
		req = container_of(pbind->usbBuf_list.next, struct usb_request, list);
#if MULTIPACKET_BUF_ALLOC
		if(req == NULL || multiPacket.active == 0){
			usb_printk("%s, %u maybe req is null or mp active:%d\n", __func__, __LINE__, multiPacket.active);
			spin_unlock_irqrestore(&pbind->usbBuf_spinLock, flags);
			continue;
		}
#endif
		list_del_init(&req->list);
		pbind->reqWrPos = (pbind->reqWrPos+1)%pbind->reqNum;
		spin_unlock_irqrestore(&pbind->usbBuf_spinLock, flags);
        atomic_dec(&pbind->usbBuft_num);
		
		/* Э飬װݰ */		
		pbind->numInTrans = virtual_network_wrap(pbind, req);
		//USBSTACK_DBG("multi-tx num: %d", bindPacketNum);
		
		if(pbind->numInTrans > 0){
			/* DMAݵָλã */
			dma_Scatter_Trans(pbind, pbind->numInTrans);
			//printk("--------bind tx,data len:%d!\n", req->length);

			/* USBݰ */
			usbBind_ep_queue(pbind, req);
		}
	}

	/* ߳ǰVNICԼBUF*/
	clean_vnic_packet_list(pbind);

	eth_offline_num = 0;

	USBSTACK_DBG("bind thread exit!");
	return 0;
}


void usb_multi_pkt_dma_init(struct usb_multi_packet *multiPkt, int is_bind)
{
	int index = 0;
	signed int ret = 0;
	dma_channel_def *pDmaDef = NULL;
	dma_cap_mask_t mask;
	
	//init_completion(&multiPkt->dmaCmplt);
	sema_init(&multiPkt->dmaSem, 0);
	
	dma_cap_zero(mask);
	dma_cap_set(DMA_SLAVE, mask);

	if(multiPkt->dmaChannelAlloc == 0)
	{
		multiPkt->pdmaChannel = dma_request_channel(mask, zx29_dma_filter_fn,
											(void*)DMA_CH_MEMORY);	
		if(!multiPkt->pdmaChannel)
		{
			USBSTACK_DBG("request dma channel fail!!!!");
			return;
		}
		multiPkt->dmaChannelAlloc =1;
	}

	pDmaDef = multiPkt->dmaChannelCfg;
    printk("[func]:%s ,[line]:%d ,channel num= %d\n",__func__,__LINE__,multiPacket.maxPacketNum) ;

	for(index=0;index < multiPacket.maxPacketNum;index++)
	{	
		pDmaDef[index].dma_control.tran_mode = TRAN_MEM_TO_MEM;
		pDmaDef[index].dma_control.irq_mode =  DMA_ALL_IRQ_ENABLE;
		pDmaDef[index].dma_control.src_burst_size = DMA_BURST_SIZE_8BIT;
		pDmaDef[index].dma_control.src_burst_len = DMA_BURST_LEN_16;
		pDmaDef[index].dma_control.dest_burst_size = DMA_BURST_SIZE_8BIT;
		pDmaDef[index].dma_control.dest_burst_len = DMA_BURST_LEN_16;
	}
}

#if MULTIPACKET_BUF_ALLOC
int usb_multi_pkt_list_init(struct usb_multi_packet *multiPkt, int is_bind)
{
	/* init vnic packet list */
	INIT_LIST_HEAD(&multiPkt->vincPkt_list);
	spin_lock_init(&multiPkt->vnicPkt_spinLock);

	atomic_set(&multiPkt->vnicPkt_num, 0);
	
	/* init usb buf list */
	INIT_LIST_HEAD(&multiPkt->usbBuf_list);
    atomic_set(&multiPkt->usbBuft_num, 0);
	spin_lock_init(&multiPkt->usbBuf_spinLock);	

	multiPkt->reqRdPos = 0;
	multiPkt->reqWrPos = 0;
	spin_lock_init(&multiPkt->reqSpinLock);	

	return 0;
}
#else
int usb_multi_pkt_buf_init(struct usb_multi_packet *multiPkt, int is_bind)
{
	int i = 0;
	unsigned int usbBuf_num = 0;
	struct usb_request	*req = NULL;

    //mark....... 
	int addr_offset = USB_VIRTUAL_PACKET_MAXSIZE*multi_packet_get_maxnum();

	i = USB_DMA_BUF_SIZE/addr_offset;
	USBSTACK_DBG("USB BUF SIZE %d!", i);
	
	/* init vnic packet list */
	INIT_LIST_HEAD(&multiPkt->vincPkt_list);
	spin_lock_init(&multiPkt->vnicPkt_spinLock);

	atomic_set(&multiPkt->vnicPkt_num, 0);
	
	/* init usb buf list */
	INIT_LIST_HEAD(&multiPkt->usbBuf_list);
    atomic_set(&multiPkt->usbBuft_num, 0);
	spin_lock_init(&multiPkt->usbBuf_spinLock);	

	multiPkt->reqNum = i;
	multiPkt->reqRdPos = 0;
	multiPkt->reqWrPos = 0;
	spin_lock_init(&multiPkt->reqSpinLock);	
	while (i--) 
	{
		req = usb_ep_alloc_request(multiPkt->ep, GFP_ATOMIC);
		if (!req){
            USBSTACK_DBG("%s, bind:%d, Warning Alloc Request Fail!", __func__, is_bind);
			return list_empty(&multiPkt->usbBuf_list) ? -ENOMEM : 0;
		}

		if(is_bind)
		{
			req->dma = USB_DMA_TX_BUF_ADDR + addr_offset*i;
			req->complete = usbBind_tx_complete;
		}
		else
		{
			req->dma = USB_DMA_RX_BUF_ADDR + addr_offset*i;
			req->complete = usbUnbind_rx_complete ;
		}

		req->buf = ioremap(req->dma, addr_offset);
        BUG_ON(req->buf == NULL);
		
		list_add_tail(&req->list, &multiPkt->usbBuf_list);
		usbBuf_num = atomic_inc_return(&multiPkt->usbBuft_num);
		multiPkt->reqNode[multiPkt->reqNum - i-1] = req;
	}
    USBSTACK_DBG("%s, bind:%d, i:%d, usbBuf_num:%d", __func__, is_bind, i, usbBuf_num);
	return 0;
}

#endif
static int usb_multi_pkt_init(struct usb_multi_packet *multiPkt, int is_bind)
{
	init_waitqueue_head(&multiPkt->wait);
	init_waitqueue_head(&multiPkt->reqWait);
	
	usb_multi_pkt_dma_init(multiPkt, is_bind);
#if MULTIPACKET_BUF_ALLOC
	usb_multi_pkt_list_init(multiPkt, is_bind);
#else
	usb_multi_pkt_buf_init(multiPkt, is_bind);
#endif
	return 0;
}

void usb_mutli_pkt_exit(struct usb_multi_packet *multiPkt, int is_bind)
{
	int index = multiPkt->reqNum;
	struct usb_request	*req = NULL;
#if MULTIPACKET_BUF_ALLOC
	int addr_offset = multiPkt->trans_buffer_size ; //*multi_packet_get_maxnum();
#endif
	req = multiPkt->reqNode[0];
	if(req){
		if(req->buf){
			if(is_bind)
				dma_free_coherent(NULL, addr_offset*USB_BIND_DMA_BUF_NUM, req->buf, req->dma);
			else
				dma_free_coherent(NULL, addr_offset*USB_UNBIND_DMA_BUF_NUM, req->buf, req->dma);
		}
	}

	while (index) 
	{
		req = multiPkt->reqNode[multiPkt->reqNum - index];
		
#if MULTIPACKET_BUF_ALLOC
		if(req){
				req->buf = NULL;
				req->dma = NULL;			
				list_del(&req->list);
				multiPkt->reqNode[multiPkt->reqNum - index] = NULL;
		}
#else
		iounmap(req->buf);
		list_del(&req->list);
#endif
		
        //iounmap(req->buf);
		usb_ep_free_request(multiPkt->ep, req);

		index--;
	}
}


int multi_packet_get_maxnum(void)
{
	return multiPacket.maxPacketNum;
}

void multi_packet_set_actual_maxnum(int max_packet_num)
{
	multiPacket.maxPacketNum = max_packet_num;
	multiPacket.bind.maxPacketNum = max_packet_num;
	multiPacket.unbind.maxPacketNum = max_packet_num;
}

void multi_packet_activate(void)
{	
	if(multiPacket.active == 0)
	{
		multiPacket.active = 1;

		USBSTACK_DBG("USB link is active!");

		if(multi_packet_get_maxnum() > 1)
		{
			usbUnbind_ep_queue(&multiPacket.unbind);
		}
	}
}


void multi_packet_deactivate(void)
{
    if (multiPacket.active == 1)
    {
        multiPacket.active = 0;
        USBSTACK_DBG("USB link is inactive!");
    }
}

#undef RNDIS_DL_MULTI_DESC

/* io  for vnic to write packet */
int multi_packet_tx_queue(struct usb_ep *ep, struct usb_request *req, gfp_t gfp_flags)
{
	int	retval = 0;
    unsigned long flags;
	struct multi_packet *multiPkt = &multiPacket;
	struct sk_buff *skb = (struct sk_buff *)req->context;
	ep->is_netep = 1;
	int bind_th_state = 0;
	int tx_debug = 0;
	if(multi_packet_get_maxnum() <=1 )
	{
		//req->dma = virt_to_phys(req->buf);
		//retval = usb_gadget_map_request(multiPacket.gadget, req, 1);
		//dma_sync_single_for_device();
		if(multiPkt->geth == NULL)
			ep->protocol_type = 2;
		else if(strcmp(multiPkt->geth->func.name,RNDIS_NAME_STR) == 0)
            ep->protocol_type = 1;
		else
			ep->protocol_type = 2;
		retval = usb_ep_queue(ep, req, gfp_flags);
	}
	else
	{
#ifdef RNDIS_DL_MULTI_DESC
		ep->protocol_type = 1;
		retval = usb_ep_queue(ep, req, gfp_flags);
#else
		int num = 0;
		int list_max = usb_get_rndis_list_max_flag();
		struct usb_multi_packet *pbind = &multiPacket.bind;

		ep->protocol_type = 1;

		spin_lock_irqsave(&pbind->vnicPkt_spinLock, flags);
#if 0
		bind_th_state = atomic_read(&pbind->count);
		if(bind_th_state == 0){			
			spin_unlock_irqrestore(&pbind->vnicPkt_spinLock, flags);
			//all usbBuf_list sent waiting for completed, so drop this skb
			printk("bind usb_req exhausted, drops this skb\n");
			tx_debug = get_panic_flag();
			if(tx_debug & 0x4)
				panic("bind usb_req exhausted\n");
			return -ENOSPC;
		}
#endif		
		if(list_max != 0){
			num = atomic_read(&pbind->vnicPkt_num);
			if(num > list_max){
				spin_unlock_irqrestore(&pbind->vnicPkt_spinLock, flags);
				wake_up(&pbind->wait);			
				printk("bind vnicPkt backlog skb:%d, drop this packet\n", num);
				return -ENOSPC;			
			}
		}		
		list_add_tail(&req->list, &pbind->vincPkt_list);
		spin_unlock_irqrestore(&pbind->vnicPkt_spinLock, flags);

		num = atomic_inc_return(&pbind->vnicPkt_num);
		if(num > multi_packet_get_maxnum()){
			wake_up(&pbind->wait);	
			return retval;				
		}
		num = num %multi_packet_get_maxnum();

		//USBSTACK_DBG("add vnic pkt Tx len: %d, dma:0x%x", req->length, req->dma);
		//USBSTACK_DBG("Tx num: %d", num);
		if(skb_get_last_pkg(skb) == 1){
			wake_up(&pbind->wait);
			return retval;
		}
		
		if((num == 0)||(req->length<1400)) 
		{
			/* ﵽСʱ*/
			wake_up(&pbind->wait);
		}
		else if(num == 1)
		{
			/* ѹһʱʱݰѹʱ */
			mod_timer(&pbind->timer, (jiffies + USB_BIND_TIMER_EXPIRES));
			//USBSTACK_DBG( "mod_timer: %u", jiffies + USB_BIND_TIMER_EXPIRES);
		}
#endif
	}
	return retval;
}


/* io  for vnic to read packet */
int multi_packet_rx_queue(struct usb_ep *ep, struct usb_request *req,  gfp_t gfp_flags)
{
	int	retval = 0;
    unsigned long flags;
	struct multi_packet *multiPkt = &multiPacket;
	ep->is_netep = 1;
	if(multi_packet_get_maxnum() <=1 )
	{
		///retval = usb_gadget_map_request(multiPacket.gadget, req, 0);
		//ep->protocol_type = 2;
		if(multiPkt->geth == NULL)
			ep->protocol_type = 2;
		else if(strcmp(multiPkt->geth->func.name,RNDIS_NAME_STR) == 0)
            ep->protocol_type = 1;
		else
			ep->protocol_type = 2;
		retval = usb_ep_queue(ep, req, gfp_flags);
	}
	else
	{
		struct usb_multi_packet *punbind = &multiPacket.unbind;

		ep->protocol_type = 1;
		
#if USE_DMA_TRANSFER
		retval = usb_gadget_map_request(multiPacket.gadget, req, 0);
		if(retval)
		{
			USBSTACK_DBG( "failed to map buffer");
			return retval;
		}
#endif
        spin_lock_irqsave(&punbind->vnicPkt_spinLock, flags);
        list_add_tail(&req->list, &punbind->vincPkt_list);
        spin_unlock_irqrestore(&punbind->vnicPkt_spinLock, flags);

		atomic_inc(&punbind->vnicPkt_num);
	}
	return retval;
}

#if MULTIPACKET_BUF_ALLOC
int usb_mutli_pkt_buf_alloc(struct usb_multi_packet *multiPkt, int is_bind)
{
	void *dma_buf_vir;
	dma_addr_t	dma_buf_phy;
	unsigned long flags;
	int i = 0;
	unsigned int usbBuf_num = 0;
	struct usb_request	*req = NULL;
    int addr_offset = 0 ;
    //ж
    if(multiPkt ==NULL)
    {
        printk("%s .line:%d ,para invalid \n",__func__,__LINE__) ;
        return -1 ;
    }
    switch(multiPkt->net_type)
    {
        case 1:
        {
            //multiPkt->trans_buffer_size = USB_RNDIS_PKT_MAXSIZE;
            addr_offset = USB_RNDIS_PKT_MAXSIZE*multi_packet_get_maxnum();
            multiPkt->trans_buffer_size = addr_offset;
            break;
        }
        case 2:
        {
            int siz = mbim_get_trans_buffer_size();
            if(siz <= 0)
            {
                 printk("%s .line:%d ,siz invalid \n",__func__,__LINE__) ;
                return -1 ;
            }
            printk("%s .line:%d ,siz =%d \n",__func__,__LINE__ ,siz) ;
            siz = ((siz+3)>>2) << 2 ; //4ֽڶ
            multiPkt->trans_buffer_size = siz; 
            addr_offset = siz;
            break;
        }
        default: 
        {
            printk("%s .line:%d ,para invalid , multiPkt->net_type = %d \n",__func__,__LINE__,multiPkt->net_type) ;
            return -1 ;
        }
    }

	//int addr_offset = USB_VIRTUAL_PACKET_MAXSIZE*multi_packet_get_maxnum(); //4ֽڶ

	if(is_bind)
		i = USB_BIND_DMA_BUF_NUM;
	else
		i = USB_UNBIND_DMA_BUF_NUM;

	dma_buf_vir = dma_alloc_coherent(NULL, addr_offset*i,  &dma_buf_phy, GFP_KERNEL);
	if (!dma_buf_vir){
		printk(KERN_INFO "usb_mutli_pkt_buf_alloc bind:%d error[%s][%d]\n",is_bind,__func__,__LINE__);
		return -ENOMEM;
	}
	while (i--) 
	{
		req = usb_ep_alloc_request(multiPkt->ep, GFP_ATOMIC);
		if (!req){
            		usb_printk("%s, bind:%d, Warning Alloc Request Fail!", __func__, is_bind);
			spin_lock_irqsave(&multiPkt->usbBuf_spinLock, flags);
			while (!list_empty(&multiPkt->usbBuf_list))
			{
				req = container_of(multiPkt->usbBuf_list.next, struct usb_request, list);
				list_del(&req->list);
				spin_unlock_irqrestore(&multiPkt->usbBuf_spinLock, flags);
				usb_ep_free_request(multiPkt->ep, req);
				req = NULL;
				spin_lock_irqsave(&multiPkt->usbBuf_spinLock, flags);
			}
			spin_unlock_irqrestore(&multiPkt->usbBuf_spinLock, flags);
			atomic_set(&multiPkt->usbBuft_num, 0);
			multiPkt->reqNum = 0;
			if(is_bind)
				dma_free_coherent(NULL, addr_offset*USB_BIND_DMA_BUF_NUM, dma_buf_vir, dma_buf_phy);
			else
				dma_free_coherent(NULL, addr_offset*USB_UNBIND_DMA_BUF_NUM, dma_buf_vir, dma_buf_phy);
			return -ENOMEM;
		}
	
		req->buf = dma_buf_vir + addr_offset*usbBuf_num;
		req->dma = dma_buf_phy + addr_offset*usbBuf_num;

		if(is_bind)
			req->complete = usbBind_tx_complete;
		else
			req->complete = usbUnbind_rx_complete ;

		spin_lock_irqsave(&multiPkt->usbBuf_spinLock, flags);	
		list_add_tail(&req->list, &multiPkt->usbBuf_list);
		multiPkt->reqNode[usbBuf_num] = req;
		spin_unlock_irqrestore(&multiPkt->usbBuf_spinLock, flags);
		usbBuf_num = atomic_inc_return(&multiPkt->usbBuft_num);
	}
    USBSTACK_DBG("%s, bind:%d, i:%d, usbBuf_num:%d", __func__, is_bind, i, usbBuf_num);
	
alloc_end:
	if(usbBuf_num > 0){		
		multiPkt->reqNum = usbBuf_num;
		multiPkt->buf_alloc_state = 1;
	}
	return 0;
}

void usb_mutli_pkt_buf_free(struct usb_multi_packet *multiPkt, int is_bind)
{
	unsigned long flags;
	int index = multiPkt->reqNum;
	struct usb_request	*req = NULL;
	int addr_offset = multiPkt->trans_buffer_size ;//*multi_packet_get_maxnum();

	while(multiPkt->dma_running){
		usb_printk("bind:%d dma is running, waiting for complete\n",is_bind);
		msleep(10);
	}

//printk("usb_mutli_pkt_buf_free :%d\n",multiPkt->reqNum);
	multiPkt->buf_alloc_state = 0;
	if(!is_bind)
		usb_ep_free_queue(multiPkt->ep);

	atomic_set(&multiPkt->usbBuft_num, 0);
	INIT_LIST_HEAD(&multiPkt->usbBuf_list);//???

	req = multiPkt->reqNode[0];
	if(req){
		if(req->buf){
			if(is_bind)
				dma_free_coherent(NULL, addr_offset*USB_BIND_DMA_BUF_NUM, req->buf, req->dma);
			else
				dma_free_coherent(NULL, addr_offset*USB_UNBIND_DMA_BUF_NUM, req->buf, req->dma);
		}
	}

	while (index) 
	{
		req = multiPkt->reqNode[multiPkt->reqNum - index];
		if(req){
			req->buf = NULL;
			req->dma = NULL;
			spin_lock_irqsave(&multiPkt->usbBuf_spinLock, flags);	
			multiPkt->reqNode[multiPkt->reqNum - index] = NULL;	
			list_del(&req->list);
			spin_unlock_irqrestore(&multiPkt->usbBuf_spinLock, flags);			
			usb_ep_free_request(multiPkt->ep, req);
			req = NULL;
		}
		index--;
	}

	multiPkt->reqNum = 0;	
	multiPkt->reqRdPos = 0;
	multiPkt->reqWrPos = 0;
    multiPkt->trans_buffer_size = 0 ;
}

void set_rndis_wrap_unwrap_header()
{
	struct multi_packet *multiPkt = &multiPacket;
	if(multiPkt->maxPacketNum > 1)
   	{
		multiPkt->geth->ioport->wrap = NULL;
		multiPkt->geth->ioport->unwrap = NULL;
   	}
}

int multi_packet_buf_alloc()
{
	struct multi_packet *multiPkt = &multiPacket;
	struct usb_multi_packet *pbind = &multiPacket.bind;
	struct usb_multi_packet *punbind = &multiPacket.unbind;
	int rtv;
	
	USBSTACK_DBG("multi_packet_buf_alloc!");
	usb_printk("multi_packet_buf_alloc!\n");

	if(multiPkt->maxPacketNum > 1){
#ifndef RNDIS_DL_MULTI_DESC
		rtv = usb_mutli_pkt_buf_alloc(pbind,1);
		if(rtv < 0){
			usb_printk("multi_packet_buf_alloc, pbind faild\n");
			return -ENOMEM;
		}
#endif
		rtv = usb_mutli_pkt_buf_alloc(punbind,0);
		if(rtv < 0){
			usb_mutli_pkt_buf_free(pbind,1);
			usb_printk("multi_packet_buf_alloc, pbind faild\n");
			return -ENOMEM;
		}
	}
	return 0;
}

int multi_packet_buf_free()
{
	struct multi_packet *multiPkt = &multiPacket;
	struct usb_multi_packet *pbind = &multiPacket.bind;
	struct usb_multi_packet *punbind = &multiPacket.unbind;
	
	USBSTACK_DBG("multi_packet_buf_free!");
	usb_printk("multi_packet_buf_free!\n");

	if(multiPkt->maxPacketNum > 1){
#ifndef RNDIS_DL_MULTI_DESC
		usb_mutli_pkt_buf_free(pbind,1);
#endif
		usb_mutli_pkt_buf_free(punbind,0);
	}
	return 0;
}
#endif

int multi_packet_handle_init(struct gether *geth, struct usb_gadget *gadget)
{
	struct multi_packet *multiPkt = &multiPacket;
	struct usb_multi_packet *pbind = &multiPacket.bind;
	struct usb_multi_packet *punbind = &multiPacket.unbind;
    multiPkt->maxPacketNum = get_vnic_multi_packet_num();
	multiPkt->bindedMaxPacketNum = multiPkt->maxPacketNum;
#if 1

    size_t alloc_req_size =   (multiPkt->maxPacketNum + PACKET_BUF_EXTRA_NUM) * sizeof(struct usb_request *) ;
    size_t alloc_dma_channel_size   = (multiPkt->maxPacketNum+1) *sizeof(dma_channel_def)  ;
    size_t total_mem_size = (alloc_req_size+alloc_dma_channel_size) *2 ;
    

    multiPacket.alloc_mem =  kzalloc(total_mem_size,  GFP_KERNEL) ;

    if(multiPacket.alloc_mem == NULL)
    {
        printk("[func]:%s ,[line]:%d ,alloc_mem is null \n",__func__,__LINE__) ;
        return -1 ;
    }
    pbind->reqNode = (struct usb_request **) multiPacket.alloc_mem  ;
    punbind->reqNode = (struct usb_request **) (multiPacket.alloc_mem + alloc_req_size) ;
    pbind->dmaChannelCfg = (dma_channel_def	*) (multiPacket.alloc_mem + alloc_req_size*2);
    punbind->dmaChannelCfg = (dma_channel_def	*) (multiPacket.alloc_mem +  alloc_req_size*2 + alloc_dma_channel_size);
    
#endif
	USBSTACK_DBG("multi-pkt init begin!");
	
	multiPkt->active = 0;
	
	multiPkt->gadget = gadget;
	multiPkt->geth = geth;

	if(multiPkt->maxPacketNum>1)
	{
		//unbind = &multiPkt->unbind;	
		punbind->ep = geth->out_ep;	
#ifdef PKT_UNBIND
		setup_timer(&punbind->timer, usbunBind_timerCallBack, (unsigned long)punbind);
#endif
		usb_multi_pkt_init(punbind, 0);
		punbind->thread = kthread_run(usbUnbind_thread, (unsigned long)punbind+1, "usbunbind_thread");
		BUG_ON(IS_ERR(punbind->thread));
		//bind = &multiPkt->bind;	
#ifndef RNDIS_DL_MULTI_DESC
		pbind->ep =  geth->in_ep;
		setup_timer(&pbind->timer, usbBind_timerCallBack, (unsigned long)pbind);
		usb_multi_pkt_init(pbind, 1);
		pbind->thread = kthread_run(usbBind_thread, pbind, "usbbind_thread");
		BUG_ON(IS_ERR(pbind->thread));
#if 0
        if(strcmp(geth->func.name,RNDIS_NAME_STR)==0)
        {
            geth->wrap = NULL;

        }
#endif
#endif
        pbind->maxPacketNum  = multiPkt->maxPacketNum ;
        punbind->maxPacketNum  = multiPkt->maxPacketNum ;
#if 0
        if(strcmp(geth->func.name,RNDIS_NAME_STR) == 0)
        {
            geth->unwrap = NULL;
        }
#endif

        //ж
        printk("$$$$$$$geth->func.name = %s \n",geth->func.name) ;
        if(strcmp(geth->func.name,RNDIS_NAME_STR) == 0)
        {
            pbind->wrap = rndis_wrap;
            pbind->unwrap = rndis_unwrap;
            punbind->wrap = rndis_wrap;
            punbind->unwrap = rndis_unwrap;
            pbind->net_type  = 1 ;
            punbind->net_type  = 1 ;

        }else if(strcmp(geth->func.name,MBIM_NAME_STR) == 0)
        {
            pbind->wrap = mbim_wrap;
            pbind->unwrap = mbim_unwrap;
            punbind->wrap = mbim_wrap;
            punbind->unwrap = mbim_unwrap;
            pbind->net_type  = 2 ;
            punbind->net_type = 2 ;

        } else
        {
            pbind->wrap = NULL;
            pbind->unwrap = NULL;
            punbind->wrap = NULL;
            punbind->unwrap = NULL;
            pbind->net_type  = 0 ;
            punbind->net_type = 0 ;
            printk("$$$$$$ net type unknown \n");
        }
        
	}
	return 0;
}


void multi_packet_handle_exit(void)
{
	struct usb_multi_packet *pbind = &multiPacket.bind;
	struct usb_multi_packet *punbind = &multiPacket.unbind;


	USBSTACK_DBG("multi-pkt exit begin!");

	if(multiPacket.maxPacketNum>1 || multiPacket.bindedMaxPacketNum > 1)
	{
#ifndef RNDIS_DL_MULTI_DESC
		USBSTACK_DBG("kill bind thread");
		kthread_stop(pbind->thread);
		if (multiPacket.maxPacketNum > 1)
			usb_mutli_pkt_exit(pbind, 1);
#endif

		USBSTACK_DBG("kill unbind thread");
		kthread_stop(punbind->thread);
		if (multiPacket.maxPacketNum > 1)
			usb_mutli_pkt_exit(punbind, 0);
	}
	multiPacket.maxPacketNum = 0;
	multiPacket.bindedMaxPacketNum = 0;
    if(multiPacket.alloc_mem != NULL)
    {
        kfree(multiPacket.alloc_mem);
        multiPacket.alloc_mem = NULL ;
    }

    pbind->maxPacketNum = 0 ;
    punbind->maxPacketNum = 0 ;
    
    pbind->wrap = NULL;
    pbind->unwrap = NULL;
    punbind->wrap = NULL;
    punbind->unwrap = NULL;

}

