/*******************************************************************************
 * Copyright (C) 2007, sanchips Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        wangchao
 * Date:          2016-3-18
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

/****************************************************************************
*                                             Include files
****************************************************************************/

#include <mach/highspeed_debug.h>
#include <mach/zx29_usb.h>
#include <mach/iomap.h>
#include <linux/irqflags.h>
#include <linux/slab.h>
#include <linux/kthread.h>

/****************************************************************************
*                                             Local Macros
****************************************************************************/


/****************************************************************************
*                                             Local Types
****************************************************************************/

/****************************************************************************
*                                             Local Constants
****************************************************************************/

/****************************************************************************
*                                             Local Function Prototypes
****************************************************************************/
void usbPoll_Delay_ms(int ms);
extern void USB_POLL_Isr(void);
extern int USB_POLL_Read(char *pchBuf, int dwLen);
extern int USB_POLL_Write(char *pchBuf, int dwLen);
extern int USB_POLL_Enum(void);

/****************************************************************************
*                                            Global Constants
****************************************************************************/
#define USB_GLOBAL_REG_ADDR       ZX_USB_BASE  
#define USB_DEVICE_REG_ADDR       (ZX_USB_BASE + 0x800)
#define USB_PWR_CLK_REG_ADDR  (ZX_USB_BASE + 0xE00)
#define POWER_ENABLE_REG          0x21
/****************************************************************************
*                                            Global Variables
****************************************************************************/
unsigned char usb_global_reg[USB_GLOBAL_SIZE];
unsigned char usb_device_reg[USB_DEVICE_SIZE];
unsigned char usb_pwr_clk_reg[USB_PWR_CLK_SIZE];
/****************************************************************************
*                                            Global Function Prototypes
****************************************************************************/
extern void dwc_otg_hal_init(void);
extern int zx234290_i2c_read_simple_PSM(u8 reg, void *dest);
extern int dwc_otg_is_clk_enable(void);
extern void dwc_otg_clk_enable(int isOn);
/***************************************************************************n
*                                            Function Definitions
****************************************************************************/
int zDrvUsbPoll_Save_Regs()
{
		volatile char val = 1;
		int ret;

		//check usb dwc_otg controller power status
		ret = zx234290_i2c_read_simple_PSM(POWER_ENABLE_REG, &val);
		if(ret){
			usb_printk("Read Power Enable Controller Value Fault! ret:%d\n",ret);
            return -1;
        }
    	usb_printk("USB DWC_OTG POWER STATUS[%d]--->OPEN!\n", val);
    	if((val & 0x01) == 0)
    	{
    		return -1;
    	}
		//check usb dwc_otg clock enable 
		ret = dwc_otg_is_clk_enable();
		if(!ret)
		{
			usb_printk("USB DWC_OTG CLOCK STATUS[%d]--->Disable!\n", ret);
			dwc_otg_clk_enable(1);
		}
		usb_printk("USB DWC_OTG POWER STATUS[%d]--->Enable!\n", ret);

		memcpy(usb_global_reg, (uint32_t *)USB_GLOBAL_REG_ADDR, USB_GLOBAL_SIZE);
		memcpy(usb_device_reg, (uint32_t *)USB_DEVICE_REG_ADDR, USB_DEVICE_SIZE);
		memcpy(usb_pwr_clk_reg, (uint32_t *)USB_PWR_CLK_REG_ADDR, USB_PWR_CLK_SIZE);
		
		return 0;
}

/*******************************************************************************
 * Function: zDrvUsbPoll_Init
 * Description:
  1ϿPCĵǰ
 2ʼUSBڲݽṹ
 3ӣӺҪzDrvUsbPoll_Isròѯ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zDrvUsbPoll_Init(void)
{
 	//dwc_otg_hal_init();
	int ret = 0;

	usb_printk("Save USB Regs Begining...\n");
	ret = zDrvUsbPoll_Save_Regs();

	usb_printk("Save USB Regs %s!\n",ret == 0 ? "Success" : "Failed");
	zx29_usbdev_init();
	return ret;
}

/*******************************************************************************
 * Function: zDrvUsbPoll_isConnect
 * Description:
  1жöǷ
  2˺ҪϵĲѯȷöٵ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
bool zDrvUsbPoll_isConnect(VOID)
{
	return  USB_POLL_Enum();
}


/*******************************************************************************
 * Function: zDrvUsbPoll_Isr
 * Description:
  1USBжϴҪϲѯ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zDrvUsbPoll_Isr(VOID)
{
	USB_POLL_Isr();
	return 0;
}

/*******************************************************************************
 * Function: zDrvUsbPoll_Read
 * Description:
  USB첽ʽûжݣ̷0
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zDrvUsbPoll_Read(u8* pBuf, int length)
{
	return (USB_POLL_Read(pBuf,length));
}

/*******************************************************************************
 * Function: zDrvUsbPoll_Write
 * Description:
  USBд첽ʽûжݣ̷0
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zDrvUsbPoll_Write(u8* pBuf, int length)
{
	return (USB_POLL_Write(pBuf,length));
}

/*******************************************************************************
 * Function: usbPoll_Delay_ms
 * Description:
  soft delay
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
void usbPoll_Delay_ms(int ms)
{
	int i,j;
	for (i=0;i<ms;i++)
		for (j=0;j<10000;j++);

}

/*******************************************************************************
 * Function: usbPoll_Delay_us
 * Description:
  soft delay
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
void usbPoll_Delay_us(int us)
{
	int i,j;
	for (i=0;i<us;i++)
		for (j=0;j<10;j++);
}




/*******************************************************************************

					ΪUSB POLL ܲԺ

 ********************************************************************************/
char * pReadBuf = NULL;
//char buf_poll[8*1024];
void usbPoll_testThread(int arg)
{
	int ret = 0;
	int readLen=0;
	int index=0;
	bool isConnect;

	usb_printk("USB POLL test begin!\n");
	
	usb_printk("disable irq!\n");
	local_irq_disable();

	usb_printk("kzalloc start!\n");
	pReadBuf =kzalloc(8*1024, GFP_KERNEL);
	if(pReadBuf == NULL){
		printk("pReadBuf allocl fail\n");
		return;
	}
	//pReadBuf = buf_poll;
	usb_printk("kzalloc end with pReadBuf=%p!\n", pReadBuf);

	
	for (index = 0;index < 8190;index++)
		*(pReadBuf+index) = index%10+0x30;

	ret = zDrvUsbPoll_Init();
	if (ret < 0)
		return;

	usb_printk("USB POLL init over!\n");	

	//local_irq_disable();
	
	while (! zDrvUsbPoll_isConnect())
	{
		isConnect = zDrvUsbPoll_isConnect();
		if (isConnect == true)
			break;
	}

	usb_printk("USB POLL enum over!\n");	


	index = 0;

	while (index < 1000000)
	{
		zDrvUsbPoll_Isr();
		index++;
	}

	while (1)
	{
		zDrvUsbPoll_Isr();

		readLen = zDrvUsbPoll_Read(pReadBuf,8190);
		if (readLen > 0)
		{
			zDrvUsbPoll_Write(pReadBuf, readLen);
		}
		/*
		isConnect = zDrvUsbPoll_isConnect();
		if (isConnect == true)
			break;
		*/
	}
	local_irq_enable();
    //return ret;
}

void usbPoll_reInit(void)
{
	int ret = 0;
	int readLen=0;
	int index=0;
	bool isConnect;
	
	ret = zDrvUsbPoll_Init();
	if (ret < 0)
		return;

	usb_printk("USB POLL init AGAIN over!\n");	
	
	while (! zDrvUsbPoll_isConnect())
	{
		isConnect = zDrvUsbPoll_isConnect();
		if (isConnect == true)
			break;
	}

	index = 0;

	while (index < 1000000)
	{
		zDrvUsbPoll_Isr();
		index++;
	}
	usb_printk("USB POLL enum AGAIN over!\n");	
}

void usbPoll_test(void)
{
	kthread_run(usbPoll_testThread, NULL, "usbPoll_test");
}



