/* ------------------------------------------------------------------
 * Copyright (C) 1998-2010 PacketVideo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 * -------------------------------------------------------------------
 */
/****************************************************************************************
Portions of this file are derived from the following 3GPP standard:

    3GPP TS 26.173
    ANSI-C code for the Adaptive Multi-Rate - Wideband (AMR-WB) speech codec
    Available from http://www.3gpp.org

(C) 2007, 3GPP Organizational Partners (ARIB, ATIS, CCSA, ETSI, TTA, TTC)
Permission to distribute, modify and use this file under the standard license
terms listed above has been obtained from the copyright holder.
****************************************************************************************/
/*
------------------------------------------------------------------------------



 Pathname: ./src/pvamrwbdecoder_basic_op_gcc_armv5.h

------------------------------------------------------------------------------
 INCLUDE DESCRIPTION

------------------------------------------------------------------------------
*/

#ifndef PVAMRWBDECODER_BASIC_OP_RVCT_ARMV5_H
#define PVAMRWBDECODER_BASIC_OP_RVCT_ARMV5_H


#ifdef __cplusplus
extern "C"
{
#endif


static_vo int16 sub_int16(int16 var1, int16 var2)
{
    register int32 L_var_out;
    register int32 L_var_aux;
    register int32 ra = (int32)var1;
    register int32 rb = (int32)var2;

    __asm{
        mov  L_var_out, ra, lsl #16;
        mov  L_var_aux, rb, lsl #16;
        qsub L_var_out, L_var_out, L_var_aux;
        mov  L_var_out, L_var_out, asr #16;
    }

    return (int16)L_var_out;

}

static_vo int16 add_int16(int16 var1, int16 var2)
{
    register int32 L_var_out;
    register int32 L_var_aux;
    register int32 ra = (int32)var1;
    register int32 rb = (int32)var2;

    __asm{
        mov  L_var_out, ra, lsl #16;
        mov  L_var_aux, rb, lsl #16;
        qadd L_var_out, L_var_out, L_var_aux;
        mov  L_var_out, L_var_out, asr #16;
    }

    return (int16)L_var_out;

}

static_vo  int32 mul_32by16(int16 hi, int16 lo, int16 n)
{
    register int32 H_32;
    register int32 L_32;
    register int32 ra = (int32)hi;
    register int32 rb = (int32)lo;
    register int32 rc = (int32)n;


    __asm{
        smulbb H_32, ra, rc;
        smulbb L_32, rb, rc;
        add    H_32, H_32, L_32, asr #15;
        qadd   H_32, H_32, H_32;
    }
    return H_32;
}


static_vo int32 sub_int32(int32 L_var1, int32 L_var2)
{
    register int32 L_var_out;
    register int32 ra = L_var1;
    register int32 rb = L_var2;

    __asm{qsub L_var_out, ra, rb};

    return L_var_out;
}

static_vo int32 add_int32(int32 L_var1, int32 L_var2)
{
    register int32 L_var_out;
    register int32 ra = L_var1;
    register int32 rb = L_var2;

    __asm {qadd L_var_out, ra, rb};

    return L_var_out;
}

static_vo int32 msu_16by16_from_int32(int32 L_var3, int16 var1, int16 var2)
{
    register int32 L_var_out;
    register int32 ra = (int32)var1;
    register int32 rb = (int32)var2;
    register int32 rc = L_var3;

    __asm {
         smulbb L_var_out, ra, rb;
         qdsub  L_var_out, rc, L_var_out;
    }

    return L_var_out;
}


static_vo int32 mac_16by16_to_int32(int32 L_var3, int16 var1, int16 var2)
{
    register int32 L_var_out;
    register int32 ra = (int32)var1;
    register int32 rb = (int32)var2;
    register int32 rc = L_var3;

    __asm {
        smulbb L_var_out, ra, rb;
        qdadd  L_var_out, rc, L_var_out;
    }

    return L_var_out;
}


static_vo  int32 mul_16by16_to_int32(int16 var1, int16 var2)
{
    register int32 L_var_out;
    register int32 ra = (int32)var1;
    register int32 rb = (int32)var2;

    __asm {
        smulbb L_var_out, ra, rb;
        qadd L_var_out, L_var_out, L_var_out;
    }

    return L_var_out;
}


static_vo int16 mult_int16(int16 var1, int16 var2)
{
    register int32 L_var_out;
    register int32 ra = (int32)var1;
    register int32 rb = (int32)var2;

    __asm {
        smulbb L_var_out, ra, rb;
        mov L_var_out, L_var_out, asr #15;
    }

    return (int16)L_var_out;
}

static_vo int16 amr_wb_round(int32 L_var1)
{
    register int32 L_var_out;
    register int32 ra = (int32)L_var1;
    register int32 rb = (int32)0x00008000L;

    __asm {
        qadd L_var_out, ra, rb;
        mov  L_var_out, L_var_out, asr #16;
    }
    return (int16)L_var_out;
}

static_vo int16 amr_wb_shl1_round(int32 L_var1)
{
    register int32 L_var_out;
    register int32 ra = (int32)L_var1;
    register int32 rb = (int32)0x00008000L;

    __asm {
        qadd L_var_out, ra, ra;
        qadd L_var_out, L_var_out, rb;
        mov L_var_out, L_var_out, asr #16;
    }
    return (int16)L_var_out;
}


static_vo int32 fxp_mac_16by16(const int16 L_var1, const int16 L_var2, int32 L_add)
{
    register int32 tmp;
    register int32 ra = (int32)L_var1;
    register int32 rb = (int32)L_var2;
    register int32 rc = (int32)L_add;

    __asm {smlabb tmp, ra, rb, rc};
    return (tmp);
}

static_vo int32 fxp_mul_16by16bb(int16 L_var1, const int16 L_var2)
{
    register int32 tmp;
    register int32 ra = (int32)L_var1;
    register int32 rb = (int32)L_var2;

    __asm {smulbb tmp, ra, rb};
    return (tmp);
}


#define fxp_mul_16by16(a, b)  fxp_mul_16by16bb(  a, b)


static_vo int32 fxp_mul32_by_16(int32 L_var1, const int32 L_var2)
{
    register int32 tmp;
    register int32 ra = (int32)L_var1;
    register int32 rb = (int32)L_var2;

    __asm {smulwb tmp, ra, rb};
    return (tmp);
}

#define fxp_mul32_by_16b( a, b)   fxp_mul32_by_16( a, b)



#ifdef __cplusplus
}
#endif




#endif   /*  PVAMRWBDECODER_BASIC_OP_GCC_ARMV5_H  */

