#ifndef AMR_ALG_H
#define AMR_ALG_H

#ifndef NULL
#define NULL 0
#endif
#ifdef __cplusplus
extern "C" {
#endif
#ifdef WIN32
#define dllexport   __declspec( dllexport )
#endif
#ifdef AMR_ARM11WM6
#define dllexport   __declspec( dllexport )
#endif
#define AMR_ENC_STATIC_SIZE	      0x0b50             /* ȫݶδС */                 
#define AMR_DEC_STATIC_SIZE		  0x0700		    /* ȫݶδС */

/*ģʽ*/
#define	MR475    			   	  0
#define	MR515	 				  1
#define	MR59					  2
#define	MR67					  3
#define	MR74					  4
#define	MR795					  5
#define	MR102					  6
#define	MR122					  7


/*֡*/
#define	TX_SPEECH_GOOD 		      0 
#define	TX_SID_FIRST		      1 
#define	TX_SID_UPDATE		      2 
#define	TX_NO_DATA			      3 

/*֡ͼ*/
#define             AMR_4_75                       0    /*4.75k֡*/
#define             AMR_5_15                       1    /*5.15k֡*/
#define             AMR_5_90                       2    /*5.90k֡*/
#define             AMR_6_70                       3    /*6.70k֡*/
#define             AMR_7_40                       4    /*7.40k֡*/
#define             AMR_7_95                       5    /*7.95k֡*/
#define             AMR_10_2                       6    /*10.2k֡*/
#define             AMR_12_2                       7    /*12.2k֡*/
#define             AMR_COM_FOR_NOISE              8    /*MR֡*/
#define             AMR_GSM_COM_FOR_NOISE          9    /*GSM-EFR֡*/ 
#define             AMR_IS641_COM_FOR_NOISE       10    /*IS-641֡*/ 
#define             AMR_PDC_COM_FOR_NOISE         11    /*PDC-EFR֡*/
#define             AMR_NO_DATA                   15    /*֡*/


typedef struct 
{
    void* pEncChannelStAddr;    /*ͨʷݵĵַ*/
    short wChnSize;				/*ʾʷݵĳȣʼʱУãͨ-2*/
    short wParamSize;			/*űṹĳȣʼʱУãͨ-2*/
	char  cEncMode;             /*ģʽ8Ϊ07*/
    char  cUseVx;               /*(VAD)أڱ룬1ΪVAD, 0Ϊر*/
    char  cTxType;              /*֡,4Ϊ03*/
    char  cPackFormat;          /*AMR֡ṹʽ0Ϊʽ11Ϊʽ2*/
	char  cGlobalCheck;
}T_AMREncParam;


typedef struct 
{
    void* pDecChannelStAddr;     /*ͨʷݵĵַ*/
    short wChnSize;			 	 /*ʾʷݵĳȣʼʱУãͨ-2*/
    short wParamSize;			 /*űṹĳȣʼʱУãͨ-2*/
	char  cFQI;                  /*ָ֡ʾ1Ϊ֡0Ϊ֡ʽ1½룩*/
    char  cFrmTypeIndex;         /*֡13֡ʽ1½룩*/
    char  cBadFrameFlag;         /*־1Ϊ0Ϊʽ2½룩*/
    char  cPackFormat;           /*ݽʽ0Ϊʽ11Ϊʽ2ӦͱĴʽӦ*/
    char  cDecMode;
	char  cGlobalCheck;
}T_AMRDecParam;



#ifdef WIN32
extern dllexport short AMR_Encoder_Init (T_AMREncParam  *pParam); /*ʼһͨMR봦*/
extern dllexport short AMR_Decoder_Init (T_AMRDecParam  *pParam); /*ʼһͨMR봦*/

extern dllexport short  AMR_Encoder_Proc (  short  *pwInputPnt, 
						                    short  wInSize,
                                            unsigned char  *pucOutputPnt, 
                                            short *pwOutSize,
                                            T_AMREncParam  *pParam);
                           

extern dllexport short  AMR_Decoder_Proc (  unsigned char  *pucInputPnt, 
						                    short  wInSize,
                                            short  *pwOutputPnt, 
                                            short  *pwOutSize,
                                            T_AMRDecParam  *pParam);
                           
extern dllexport short  AMR_GetVer();                          

#else
#ifdef AMR_ARM11WM6
extern dllexport short AMR_Encoder_Init (T_AMREncParam  *pParam); /*ʼһͨMR봦*/
extern dllexport short AMR_Decoder_Init (T_AMRDecParam  *pParam); /*ʼһͨMR봦*/

extern dllexport short  AMR_Encoder_Proc (  short  *pwInputPnt, 
						                    short  wInSize,
                                            unsigned char  *pucOutputPnt, 
                                            short *pwOutSize,
                                            T_AMREncParam  *pParam);
                           

extern dllexport short  AMR_Decoder_Proc (  unsigned char  *pucInputPnt, 
						                    short  wInSize,
                                            short  *pwOutputPnt, 
                                            short  *pwOutSize,
                                            T_AMRDecParam  *pParam);
                           
extern dllexport short  AMR_GetVer();                          
#else
 short AMR_Encoder_Init (T_AMREncParam  *pParam); /*ʼһͨMR봦*/
 short AMR_Decoder_Init (T_AMRDecParam  *pParam); /*ʼһͨMR봦*/

 short AMR_Encoder_Proc (  short  *pwInputPnt, 
	                       short  wInSize,
                           unsigned char  *pucOutputPnt, 
                           short *pwOutSize,
                           T_AMREncParam  *pParam);
                           

 short AMR_Decoder_Proc (  unsigned char  *pucInputPnt, 
	                       short  wInSize,
                           short  *pwOutputPnt, 
                           short  *pwOutSize,
                           T_AMRDecParam  *pParam);
                           
 short AMR_GetVer(void);  
#endif
#endif
#endif
