/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : oss_queue.c
*    : oss_queue.c
* ļ : 
* ʵֹ : Ϣеʵļ
*      : xuxingkui
*      : V1.0
*  : 2007/06/01
* ˵ :          
**************************************************************************/
/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : xiaxinguo
* ޸ : 2007/10/16
* ޸ : 
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : junkuiZhao
* ޸ : 2012/09/15
* ޸ : PC-LINTڱ淶޸ EC: 617001781881  
**************************************************************************/
/**************************************************************************
* ޸ı : 0003
*    : junkuiZhao
* ޸ : 2012/10/10
* ޸ : ߲ EC: 617001781957
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "osa.h"
#include "oss_api.h"

#ifdef __cplusplus
extern "C"
{
#endif
/**************************************************************************
* 궨
**************************************************************************/
#define ALIGN_NEXT(size,align)	((((UINT32)(size)) + align - 1) & (~(align - 1))) 

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct
{
    T_ZOss_Node node;       /*          */
    UINT16      msg_size;   /* ʵϢֽ   */
    CHAR        msg[1];     /* Ϣʵ         */
}T_Queue_Msg;

/**************************************************************************
* : zOss_QueueCreate
* : Ϣ
* ˵(IN)
                queue_name:Ϣ, 󳤶ȲܳMAX_QUEUENAME_LEN(63)
                maxMsgs:еϢ
                maxMsgLen:һϢֽ
            (OUT)
*   ֵ: ɹϢID; ʧ:ZOSS_NULL
* ˵:  
**************************************************************************/ 
ZOSS_QUEUE_ID zOss_QueueCreate(const CHAR *queue_name, UINT32 maxMsgs, UINT32 maxMsgLen)
{
    T_ZOss_Queue    *queue_id   = NULL;
    UINT32          i           = 0;
    UINT32          block_size  = 0;
    CHAR            *ptr        = NULL;

    block_size  = sizeof(T_Queue_Msg) + maxMsgLen;
    block_size  = ALIGN_NEXT(block_size, 4); /* 4ֽڶ */
    queue_id    = (T_ZOss_Queue *)zOss_Malloc(sizeof(T_ZOss_Queue) + block_size * maxMsgs);

    if (queue_id == NULL)
    {
        return ZOSS_NULL;
    }

    zOss_Memset(queue_id, 0, sizeof(T_ZOss_Queue));

    zOss_ListInit(&(queue_id->queue_list));
    zOss_ListInit(&(queue_id->free_list));
    
    queue_id->mutex_id = zOss_CreateMutex(queue_name, ZOSS_INHERIT);

    if (NULL == queue_id->mutex_id)
    {
        zOss_Free(queue_id);
        return ZOSS_NULL;
    }

    queue_id->sem_id = zOss_CreateSemaphore(queue_name, 0);

    if (NULL == queue_id->sem_id)
    {
        zOss_DeleteMutex( queue_id->mutex_id);
        zOss_Free(queue_id);
        return ZOSS_NULL;
    }

    queue_id->max_msgs      = maxMsgs;
    queue_id->max_msgLen    = maxMsgLen;
    ptr                     = (CHAR *)queue_id + sizeof(T_ZOss_Queue); /* ָһڵ */

    for(i = 0; i < maxMsgs; i++)
    {
        zOss_ListAdd(&queue_id->free_list, (T_ZOss_Node *)ptr);
        
        ptr += block_size; /* ָһڵ */
    }

    return (ZOSS_QUEUE_ID)queue_id;
}

/**************************************************************************
* : zOss_QueueSend
* : ϢзϢ
* ˵(IN)
                queue_id:ϢID
                msg_ptr:Ϣָ
                size:ϢС
                timeout:Ϣʱ,ȴʱ.
                priority:
                    ZOSS_QUEUE_MSG_PRI_NORMAL:ŵϢβ
                    ZOSS_QUEUE_MSG_PRI_URGENT :ŵϢ		
            (OUT)
*   ֵ: ɹ:ZOSS_SUCCESS; ʧ:ZOSS_ERROR
* ˵: ϢԺ
**************************************************************************/ 
UINT32 zOss_QueueSend(ZOSS_QUEUE_ID queue_id, VOID *msg_ptr, UINT32 size, UINT32 timeout, UINT32 priority)
{
    T_ZOss_Node     *pCurNode   = NULL;
    T_Queue_Msg     *pCurMsg    = NULL;
    T_ZOss_Queue    *pCurQueue  = NULL;

    zOss_AssertEx(queue_id != NULL && msg_ptr != NULL && size > 0, ZOSS_ERROR);	
    
    pCurQueue = (T_ZOss_Queue *)queue_id;

    if(pCurQueue->max_msgLen < size)/* Ϣֽ */
    {
        return ZOSS_ERROR;
    }

    if(zOss_GetMutex(pCurQueue->mutex_id, timeout) != ZOSS_SUCCESS) 
    {
        return ZOSS_ERROR;
    }
    
    /* ӿлȡһڴ */
    pCurNode = zOss_ListFirst(&pCurQueue->free_list);

    if (pCurNode == NULL)
    {
        zOss_PutMutex(pCurQueue->mutex_id);
        
        return ZOSS_ERROR;
    }
    zOss_ListDelete(&pCurQueue->free_list, pCurNode);

    /* ڴ */
    pCurMsg             = (T_Queue_Msg *)pCurNode;
    pCurMsg->msg_size   = (UINT16)size;

    zOss_Memcpy(pCurMsg->msg, msg_ptr, size);

    /* ҵʹ */
    if(priority == ZOSS_QUEUE_MSG_PRI_URGENT)
    {
        zOss_ListInsert(&pCurQueue->queue_list, NULL, pCurNode);/*  */
    }
    else
    {
        zOss_ListAdd(&pCurQueue->queue_list, pCurNode); /* β */
    }

    zOss_PutMutex(pCurQueue->mutex_id);

    /* Է */
    zOss_PutSemaphore(pCurQueue->sem_id);
    return ZOSS_SUCCESS;
}

/**************************************************************************
* : zOss_QueueRecv
* : ϢϢ
* ˵(IN)
                queue_id:ϢID
                timeout:Ϣпʱ,ȴʱ.
                buffer:Ϣ
                maxsize:յֽ
            (OUT)
*   ֵ: ɹ:ʵյֽ;ʧ:ZOSS_ERROR
* ˵: ϢԺ
**************************************************************************/ 
UINT32 zOss_QueueRecv(ZOSS_QUEUE_ID queue_id, VOID *buffer, UINT32 maxsize, UINT32 timeout)
{
    T_ZOss_Node     *pCurNode   = NULL;
    T_ZOss_Queue    *pCurQueue  = NULL;
    T_Queue_Msg     *pCurMsg    = NULL;
    UINT32          result      = ZOSS_ERROR;

    if (queue_id == NULL)
    {
        return ZOSS_ERROR;
    }

    pCurQueue = (T_ZOss_Queue *)queue_id;

    /* ȴݵ */
    if( zOss_GetSemaphore(pCurQueue->sem_id, timeout) != ZOSS_SUCCESS )
    { 
        return ZOSS_ERROR;
    }
    
    /* ʹȡݣȡźӦÿԻȡ */
    if(zOss_GetMutex(pCurQueue->mutex_id, timeout) != ZOSS_SUCCESS)
    {
        /* ܹȡźضݣȡ壬Ϊֹٻȡݣʹźԭֵ */
        zOss_PutSemaphore(pCurQueue->sem_id);
        return ZOSS_ERROR;
    }

    pCurNode = zOss_ListFirst(&pCurQueue->queue_list);

    if (pCurNode == NULL)
    {
        result = 0;
    }
    else
    {
        zOss_ListDelete(&pCurQueue->queue_list, pCurNode);
       
        /* ݸ֪û */
        pCurMsg = (T_Queue_Msg *)pCurNode;
        result  = pCurMsg->msg_size < maxsize ? pCurMsg->msg_size : maxsize;
        
        zOss_Memcpy(buffer, pCurMsg->msg, result);
        zOss_Memset(pCurMsg->msg, 0, pCurQueue->max_msgLen); /* ڵϢ0   */
        zOss_ListAdd(&pCurQueue->free_list, pCurNode);  /* ݿŵ   */
    }

    zOss_PutMutex(pCurQueue->mutex_id);
    
    return result;
}

/**************************************************************************
* : zOss_QueueFreeCount
* : ȡпп
* ˵ 
            (IN)
                queue_id:ϢID
            (OUT)
*   ֵ: еĿнڵĿ
* ˵:  
**************************************************************************/ 
UINT32 zOss_QueueFreeCount(ZOSS_QUEUE_ID queue_id)
{
    T_ZOss_Queue  *pCurQueue = NULL;

    zOss_AssertEx(queue_id != NULL, 0);	

    pCurQueue = (T_ZOss_Queue *)queue_id;
    return zOss_ListCount(&pCurQueue->free_list);
}

/**************************************************************************
* : zOss_QueueDelete
* : ɾϢ
* ˵ 
            (IN)
                queue_id:ϢID
            (OUT)
*   ֵ: ɹZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵:  
**************************************************************************/ 
UINT32 zOss_QueueDelete(ZOSS_QUEUE_ID queue_id)
{
    T_ZOss_Queue    *pCurQueue  = NULL;

    zOss_AssertEx(queue_id != NULL, ZOSS_ERROR);
    
    pCurQueue = (T_ZOss_Queue *)queue_id;

    zOss_DeleteSemaphore(pCurQueue->sem_id);
    zOss_DeleteMutex(pCurQueue->mutex_id);
    zOss_Free(pCurQueue);
    return ZOSS_SUCCESS;
}

#ifdef __cplusplus
    }
#endif

