/************************************************************************
* Ȩ (C)2007,ͨѶɷ޹˾
*
* ļƣ win_fs.c
* ļʶ
* ժҪ ļϵͳļϵͳӿڣ
*
* ޸     汾     ޸ı     ޸	     ޸
* ---------------------------------------------------------------------
* 2007/06/28   V1.0			           鲨          
* 2007/10/22   V1.0       ޸         鲨          ޸ӿ
************************************************************************/

/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "oss_api.h"
#include "tools_api.h"
#include "win_fs.h"
#include <stdio.h>
#include <io.h>
#include <sys\stat.h>
/*2008.8.6 pc-lint
#include <shlwapi.h>
*/
#include <direct.h>
#include <winbase.h>

#ifdef __GNUC__
#include <dirent.h>
#endif

#ifdef __cplusplus
extern "C"
{
#endif

#define FILELEN (ZOSS_MAX_FILENAME_LEN +1)/*ļ,·*/

/**************************************************************************
 *                           ȫֱ                                      *
 **************************************************************************/
static BOOL g_fs_init_flag = FALSE;                              /*ļϵͳǷѾʼ*/
static T_ZDrvFS_DiskInfo g_fs_reflexmap;                         /*̷ʵĿ¼ӳ*/

/**************************************************************************
 *                           ֲ                                      *
 **************************************************************************/
UINT32 VDD_FNameMap (const CHAR *filename,CHAR* changedname);
UINT32 VDD_FBackNameMap (const CHAR *filename,CHAR* changedname);

/**************************************************************************
*                         ȫֺʵ                                    *
**************************************************************************/

/**********************************************************************
* ƣVDD_FsInit
* ļϵͳעӿ
* ˵
*   ֵ
* ZOSS_SUCCESS:豸ʼɹ
* ZOSS_ERROR  :豸ʼʧ
* ˵
***********************************************************************/
UINT32 VDD_FsInit( VOID )
{
    UINT32 ureturn;
    SINT32 ret;
    UINT32 i;
    BOOL bRet;
    CHAR * currentDir = NULL;
    UINT32 result;
    if (TRUE == g_fs_init_flag )
    {
        return ZOSS_SUCCESS;
    }
    if (ZOSS_ERROR == VDD_SND( SIM_MSG_VDD_FS_DISK_GETINFO, (PBYTE)(&g_fs_reflexmap), sizeof(T_ZDrvFS_DiskInfo)))
    {
        return ZOSS_ERROR;
    }
    g_fs_init_flag = TRUE;
    for (i = 0;i<g_fs_reflexmap.disknum;i++)
    {
        ret = (SINT32)strlen(g_fs_reflexmap.diskinfo[i].realpath);
        if (g_fs_reflexmap.diskinfo[i].realpath[ret-1] == '\\')
            g_fs_reflexmap.diskinfo[i].realpath[ret-1] = 0;
        ret = (SINT32)strlen(g_fs_reflexmap.diskinfo[i].virtualpath);
        if (g_fs_reflexmap.diskinfo[i].virtualpath[ret-1] == '\\')
            g_fs_reflexmap.diskinfo[i].virtualpath[ret-1] = 0;
        ret = _access( g_fs_reflexmap.diskinfo[i].realpath, 0 );
        if ( -1 == ret)
        {
            ureturn = 0;
            ureturn = (UINT32)_mkdir(g_fs_reflexmap.diskinfo[i].realpath);
            if (ureturn == ZOSS_ERROR)
            {
                return ZOSS_ERROR;
            }

        }
    }
    currentDir = zOss_Malloc(FILELEN);
    if ( NULL == currentDir )
    {
        return ZOSS_ERROR;
    }

    result = VDD_FNameMap("C:",currentDir);
    if ( ZOSS_SUCCESS != result )
    {
        return ZOSS_ERROR;
    }
    else
    {
        /* pc-lint 2008.8.6 */
        bRet = SetCurrentDirectory(currentDir);
        if (!bRet)
        {
            return ZOSS_ERROR;
        }
    }
    return ZOSS_SUCCESS;
}

/**********************************************************************
* ƣVDD_FsExit
* ļϵͳעӿ
* ˵
*   ֵ
* ZOSS_SUCCESS:豸עɹ
* ZOSS_ERROR  :豸עʧ
* ˵
***********************************************************************/
UINT32 VDD_FsExit( VOID )
{
    zOss_Memset(&g_fs_reflexmap,0,sizeof(T_ZDrvFS_DiskInfo));
    g_fs_init_flag = FALSE;
    return ZOSS_SUCCESS;
}

/**********************************************************************
* ƣVDD_FsUpdate
* ļϵͳ½ӿ
* ˵
*   ֵ
* ZOSS_SUCCESS:豸ʼɹ
* ZOSS_ERROR  :豸ʼʧ
* ˵
***********************************************************************/
UINT32 VDD_FsUpdate( VOID )
{
    if (FALSE == g_fs_init_flag )
    {
        return ZOSS_ERROR;
    }
    if (ZOSS_ERROR == VDD_SND( SIM_MSG_VDD_FS_DISK_GETINFO, (PBYTE)(&g_fs_reflexmap), sizeof(T_ZDrvFS_DiskInfo)))
    {
        return ZOSS_ERROR;
    }
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ VDD_FNameMap
*  ӳļʵʵļ
* ˵ (IN)  filename:ӳļ
*   ֵ ɹ:ʵļָ;ʧ:NULL.
* ˵
**************************************************************************/
UINT32 VDD_FNameMap (const CHAR *filename,CHAR* changedname)
{
    SINT32 i,state,realName,vDiskLen,Disk_num;
    CHAR temp[FILELEN]={0};
    CHAR dirName[FILELEN]={0};
    char * colon = NULL;
    state = 0; 

    colon = strchr((char *)filename, ':');
    if (colon == NULL)/*ûҵ,·*/
    {
        strcpy((char *)changedname, (const char *)filename);
        return ZOSS_SUCCESS;
    }
    else if (colon == (char *)filename +1)/*̷ľ·,̷һĸ*/
    {
        Disk_num = (SINT32)g_fs_reflexmap.disknum;
        for (i = 0;i<Disk_num;i++)
        {
            vDiskLen = (SINT32)strlen(g_fs_reflexmap.diskinfo[i].virtualpath);
            memcpy(temp,filename,(UINT32)vDiskLen);
            if (temp[0] == 'c')
            {
                temp[0] = 'C';
            }
            temp[vDiskLen] = 0;
            state = memcmp(temp,g_fs_reflexmap.diskinfo[i].virtualpath,(UINT32)vDiskLen);
            if (state == 0)
            {
                memcpy(dirName,filename + vDiskLen,strlen(filename)-(UINT32)vDiskLen);
                dirName[strlen(filename)-(UINT32)vDiskLen] = 0;
                state = 1;
                break;
            }
        }
        if (i >= Disk_num)
        {
            return ZOSS_ERROR;
        }
        realName = (SINT32)strlen(g_fs_reflexmap.diskinfo[i].realpath);
        Disk_num = realName + strlen(dirName);
        if (Disk_num >254)
            return ZOSS_ERROR;
        memcpy(changedname,g_fs_reflexmap.diskinfo[i].realpath,(UINT32)realName);
        memcpy(changedname+realName,dirName,strlen(dirName));
        changedname[(UINT32)realName+strlen(dirName)]= 0;

        return ZOSS_SUCCESS;
    }
    else
    {
        *changedname = 0;/*ַ*/
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* ƣ VDD_FBackNameMap
*  ӳļʵʵļ
* ˵ (IN)  filename:ӳļ
*   ֵ ɹ:ʵļָ;ʧ:NULL.
* ˵
**************************************************************************/
UINT32 VDD_FBackNameMap (const CHAR *filename,CHAR* changedname)
{
    SINT32 i,state,nameLen,vDiskLen,Disk_num;
    /*char *temp = (char*)malloc(FILELEN);
    //char *dirName = (char*)malloc(FILELEN);*/
    CHAR temp[FILELEN]={0};
    CHAR dirName[FILELEN]={0};
    state = 0;
    Disk_num = (SINT32)g_fs_reflexmap.disknum;
    for (i = 0;i<Disk_num;i++)
    {
        vDiskLen = (SINT32)strlen(g_fs_reflexmap.diskinfo[i].realpath);
        memcpy(temp,filename,(UINT32)vDiskLen);
        temp[vDiskLen] = 0;
        state = memcmp(temp,g_fs_reflexmap.diskinfo[i].realpath,(UINT32)vDiskLen);
        if (state == 0)
        {
            memcpy(dirName,filename + vDiskLen,strlen(filename)-(UINT32)vDiskLen);
            dirName[strlen(filename)-(UINT32)vDiskLen] = 0;
            state = 1;
            break;
        }
    }
    if (i >= Disk_num)
    {
        return ZOSS_ERROR;
    }
    nameLen = (SINT32)strlen(g_fs_reflexmap.diskinfo[i].virtualpath);
    memcpy(changedname,g_fs_reflexmap.diskinfo[i].virtualpath,(UINT32)nameLen);
    memcpy(changedname+nameLen,dirName,strlen(dirName));
    changedname[(UINT32)nameLen+strlen(dirName)]= '\0';
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ zOss_Mkdir
* Ŀ¼
* ˵ (IN)   dirname:Ŀ¼
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR,ļڣ
                            Ҳʧܵġ
* ˵
**************************************************************************/
UINT32 zOss_Mkdir(const CHAR * dirname)
{
    UINT32 result;
    SINT32 createResult;

    CHAR * changedName = NULL;

    changedName = zOss_Malloc( FILELEN );
    if ( NULL == changedName )
    {
        return ZOSS_ERROR;
    }
    zOss_Memset( changedName, 0, FILELEN );

    result = VDD_FNameMap( dirname , changedName );
    if ( result != ZOSS_SUCCESS )
    {
        zOss_Free( changedName );
        return ZOSS_ERROR;
    }

    createResult = CreateDirectory( changedName, NULL );
    if ( createResult != 0 )
    {
        zOss_Free( changedName );
        return ZOSS_SUCCESS;
    }
    else
    {
        zOss_Free( changedName );
        return ZOSS_ERROR;
    }

}

/**************************************************************************
* ƣ zOss_Rmdir
* ɾĿ¼
* ˵ (IN)
             dirname:Ŀ¼
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_Rmdir(const CHAR * dirname)
{
    UINT32 result;
    SINT32 rmResult;

    CHAR * changedName = NULL;
    changedName = zOss_Malloc( FILELEN );
    if ( NULL == changedName )
    {
        return ZOSS_ERROR;
    }
    zOss_Memset( changedName, 0, FILELEN );

    result = VDD_FNameMap( dirname , changedName );
    if ( result != ZOSS_SUCCESS )
    {
        zOss_Free( changedName );
        return ZOSS_ERROR;
    }

    rmResult = _rmdir( changedName );
    if ( rmResult != 0 )
    {
        zOss_Free( changedName );
        return ZOSS_ERROR;
    }
    else
    {
        zOss_Free( changedName );
        return ZOSS_SUCCESS;
    }
}

/**************************************************************************
* ƣ zOss_Rndir
* Ŀ¼
* ˵ (IN)   old_dirname:ԭĿ¼;new_dirname:Ŀ¼
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_Rndir(const CHAR * old_dirname, const CHAR *new_dirname)
{
    UINT32 result;
    CHAR * changedNameold = NULL;
    CHAR * changedNamenew = NULL;

    changedNameold = zOss_Malloc ( FILELEN );
    if ( NULL == changedNameold )
    {
        return ZOSS_ERROR;
    }

    changedNamenew = zOss_Malloc ( FILELEN );
    if ( NULL == changedNamenew )
    {
        zOss_Free( changedNameold );
        return ZOSS_ERROR;
    }

    zOss_Memset( changedNameold, 0, FILELEN );
    zOss_Memset( changedNamenew, 0, FILELEN );

    result = VDD_FNameMap( old_dirname , changedNameold );
    if ( ZOSS_SUCCESS != result )
    {
        zOss_Free( changedNameold );
        zOss_Free( changedNamenew );
        return ZOSS_ERROR;
    }

    result = VDD_FNameMap( new_dirname , changedNamenew );
    if ( ZOSS_SUCCESS != result )
    {
        zOss_Free( changedNameold );
        zOss_Free( changedNamenew );
        return ZOSS_ERROR;
    }

    if (0 != rename(changedNameold, changedNamenew))
    {
        zOss_Free( changedNameold );
        zOss_Free( changedNamenew );
        return ZOSS_ERROR;
    }

    zOss_Free( changedNameold );
    zOss_Free( changedNamenew );

    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ zOss_GetPwd
* ȡǰĿ¼
* ˵ (IN)   dirname:Ŀ¼;dirnamelen:Ŀ¼
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_GetPwd(CHAR * dirname, UINT32 dirnamelen)
{
    UINT32 mapRet;
    CHAR * oldName = NULL;
    CHAR * retGet;
    UINT32 len;

    if (NULL == dirname)
    {
        assert(NULL != dirname);
        return ZOSS_ERROR;
    }

    oldName = zOss_Malloc( FILELEN );
    if ( oldName == NULL )
    {
        return ZOSS_ERROR;
    }
    zOss_Memset( oldName, 0, FILELEN );

    retGet = _getcwd(oldName, FILELEN);

    if ( retGet != NULL )
    {
        len = strlen(oldName);
        if ( len >= FILELEN )
        {
            return ZOSS_ERROR;
        }

        mapRet = VDD_FBackNameMap( oldName , dirname );
        if ( mapRet != ZOSS_SUCCESS )
        {
            zOss_Free( oldName );
            return ZOSS_ERROR;
        }

        len = strlen(dirname);
        if (len == 2)
        {
            dirname[len] = '\\';
            dirname[len + 1] = '\0';
        }

        zOss_Free( oldName );
        return ZOSS_SUCCESS;
    }
    else
    {
        zOss_Free( oldName );
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* ƣ zOss_ChDir
* õǰ·
* ˵ (IN)   dirname:Ŀ¼
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_ChDir(CHAR * dirname)
{
    int result;
    UINT32 status;
    CHAR changedname[FILELEN];

    assert(NULL != dirname);

    if (NULL == dirname )
    {
        return ZOSS_ERROR;
    }

    status = VDD_FNameMap(dirname, changedname);

    if (status == ZOSS_ERROR)
    {
        return status;
    }

    result = _chdir(changedname);

    if (0 == result)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* ƣ zOss_IsDir
* бǷΪĿ¼
* ˵ (IN)   dirname:Ŀ¼
*   ֵ Ŀ¼:TRUE;ļ:FALSE
* ˵OSEб
**************************************************************************/
BOOL  zOss_IsDir(const CHAR * dirname)
{
    UINT32 mapResult;
    CHAR * changedName = NULL;
    struct _stat statinfo;
    SINT32 statRet;

    zOss_ASSERT( NULL != dirname );

    changedName = zOss_Malloc( FILELEN );
    if ( changedName == NULL )
    {
        return FALSE;
    }

    zOss_Memset( changedName, 0, FILELEN );

    mapResult = VDD_FNameMap( dirname , changedName );
    if ( ZOSS_ERROR == mapResult )
    {
        zOss_Free( changedName );
        return FALSE;
    }

    statRet = _stat(changedName, &statinfo);
    if (statRet!=0)
    {
        zOss_Free( changedName );
        return FALSE;
    }

    zOss_Free( changedName );

    if ( statinfo.st_mode & _S_IFDIR )
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

/**************************************************************************
* ƣ zOss_OpenDir
* ָĿ¼ȡĿ¼
* ˵ (IN)
                dirname:Ŀ¼;
             (OUT)
                dir_entry_ptr:Ŀ¼;
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32  zOss_OpenDir(const CHAR * dirname, VOID **dir_entry_ptr)
{
    DIR *temp;
    UINT32 mapResult;
#ifndef __GNUC__
    HANDLE  handle;
    BOOL setResult;
#endif
    CHAR * changedName = NULL;

    assert(NULL != dirname);
    assert(NULL != dir_entry_ptr);

    changedName = zOss_Malloc( FILELEN );
    if ( changedName == NULL )
    {
        return ZOSS_ERROR;
    }
    zOss_Memset( changedName, 0, FILELEN );

    mapResult = VDD_FNameMap( dirname , changedName );
    if ( ZOSS_SUCCESS != mapResult )
    {
        zOss_Free( changedName );
        return ZOSS_ERROR;
    }

#ifndef __GNUC__
    /* µDIRռ */
    temp = ( DIR * )zOss_Malloc( sizeof( DIR ) );
    if ( NULL == temp )
    {
        zOss_Free( changedName );
        return ZOSS_ERROR;
    }

    /* õǰ· */
    setResult = SetCurrentDirectory( changedName );
    if ( 0 == setResult )
    {
        zOss_Free( changedName );
        zOss_Free( temp );
        return ZOSS_ERROR;
    }

    /* ȡļľ */
    handle =  FindFirstFile( "*", &temp->dirEntry);
    if ( INVALID_HANDLE_VALUE == handle )
    {
        zOss_Free( changedName );
        zOss_Free( temp );
        return ZOSS_ERROR;
    }
    else
    {
        temp->isFirstFile = TRUE;
        temp->dirHandle = handle;
        * dir_entry_ptr =  temp;
        zOss_Free( changedName );
        return ZOSS_SUCCESS;
    }
#else
    temp = opendir(changedName);
    *dir_entry_ptr = temp;
    if (NULL == temp)
    {
        zOss_Free( changedName );
        return ZOSS_ERROR;
    }
    else
    {
        zOss_Free( changedName );
        return ZOSS_SUCCESS;
    }
#endif
}

/**************************************************************************
* ƣ OSS_CloseDir
* رĿ¼
* ˵ (IN)   dir_entry_ptr:Ŀ¼;
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_CloseDir(VOID **dir_entry_ptr)
{
#ifndef __GNUC__
    DIR *temp;
    CHAR * currentDir;
#endif
    BOOL result;
    UINT32 ret;

    assert(NULL != dir_entry_ptr);
#ifndef __GNUC__
    temp = ( DIR * )( * dir_entry_ptr );
    result = FindClose( temp->dirHandle );
    if ( result != 0 )
    {
        currentDir = zOss_Malloc(FILELEN);
        if ( NULL == currentDir )
        {
            return ZOSS_ERROR;
        }

        ret = VDD_FNameMap("C:\\",currentDir);
        if ( ZOSS_SUCCESS != ret )
        {
            return ZOSS_ERROR;
        }
        else
        {
            result = SetCurrentDirectory(currentDir);
            if (!result)
            {
                return ZOSS_ERROR;
            }
        }

        zOss_Free( currentDir );
        zOss_Free( * dir_entry_ptr );
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
#else
    result = closedir(*dir_entry_ptr);
    if (result == 0)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
#endif
}

/**************************************************************************
* ƣ zOss_ReadDir
* ȡָĿ¼µļĿ¼
* ˵ (IN)   dir_entry_ptr:Ŀ¼;
        dir_item_ptr:Ŀ¼ϢĽṹָ룬û
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_ReadDir(VOID **dir_entry_ptr,ZOSS_S_DIRENT* dir_item_ptr)
{
#ifndef __GNUC__
    DIR *temp;
#endif

    BOOL result;

#ifdef __GNUC__
    struct dirent *entry;
#endif
    assert( NULL != dir_entry_ptr );
    assert( NULL != dir_item_ptr );
    if (NULL == dir_entry_ptr || NULL == dir_item_ptr)
    {
        return ZOSS_ERROR;
    }

#ifndef __GNUC__
    temp = (DIR *) (*dir_entry_ptr);
    if (temp->isFirstFile == TRUE)
    {
        temp->isFirstFile = FALSE;
        zOss_Memcpy( dir_item_ptr->d_name, temp->dirEntry.cFileName, 255);
        return ZOSS_SUCCESS;
    }

    result =  FindNextFile( temp->dirHandle, &temp->dirEntry );
    if ( 0 != result )
    {
        zOss_Memcpy( dir_item_ptr->d_name, temp->dirEntry.cFileName, 255);
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
#else
    entry = readdir((DIR *)( *dir_entry_ptr) );
    if (NULL == entry)
    {
        zOss_Memset(dir_item_ptr, 0 , sizeof(ZOSS_S_DIRENT));
        result = ZOSS_ERROR;
    }
    else
    {
        zOss_Memcpy(dir_item_ptr->d_name, entry->d_name,255);
        result = ZOSS_SUCCESS;
    }
    return result;
#endif

}


/**************************************************************************
* : zOss_Rewinddir
* : λĿ¼ͷʼĿ¼
* ˵: 
            (IN)  
                dir_entry_ptr:Ŀ¼;
           
*   ֵ: 
* ˵:
**************************************************************************/ 
VOID zOss_Rewinddir(VOID *dir_entry_ptr)
{
    if (NULL == dir_entry_ptr)
    {
        assert(NULL != dir_entry_ptr);
        return;
    }
#ifndef __GNUC__

#else
    rewinddir(dir_entry_ptr);
#endif
    return;        
}

/**************************************************************************
* ƣ zOss_ChMod
* ļĿ¼
* ˵ (IN)   pathname:ļĿ¼;attrs:ļĿ¼µ
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_ChMod(const CHAR *pathname, mode_t attrs)
{
    SINT32 result;
    UINT32 mapResult;
    CHAR changedName[FILELEN];

    mapResult = VDD_FNameMap( pathname , changedName );

    if ( mapResult != ZOSS_SUCCESS )
    {
        return mapResult;
    }

    result = chmod((const char *)changedName, (int)attrs);

    if ( 0 == result )
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* ƣ zOss_Stat
* ȡļĿ¼ϸϢ
* ˵ (IN)   pathname:ļĿ¼;buf:ڴ洢Ϣstatṹ
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_Stat(const CHAR *pathname, ZOSS_S_STAT *buf)
{
    UINT32 ureturn;
    struct stat statinfo;
    
    CHAR Dname[FILELEN] = {0};
    assert(NULL != pathname);
    assert(NULL != buf);

    if ( NULL == pathname)
    {
        return ZOSS_ERROR;
    }
    if ( NULL == buf)
    {
        return ZOSS_ERROR;
    }
    ureturn = VDD_FNameMap (pathname,Dname);
    if (ureturn == ZOSS_ERROR)
    {
        return ZOSS_ERROR;
    }

    if (0 != stat(Dname, &statinfo))
    {
        return ZOSS_ERROR;
    }

    /* ԼĳԱֵԱе */
    buf->st_atime = statinfo.st_atime;
    buf->st_ctime = statinfo.st_ctime;
    buf->st_dev = statinfo.st_dev;
    buf->st_gid = ( UINT32 )( statinfo.st_gid );
    buf->st_ino = statinfo.st_ino;
    buf->st_mode = statinfo.st_mode;
    buf->st_mtime = statinfo.st_mtime;
    buf->st_nlink = (UINT16)(statinfo.st_nlink);
    buf->st_rdev = statinfo.st_rdev;
    buf->st_size = (UINT32)statinfo.st_size;
    buf->st_uid = (UINT32)(statinfo.st_uid);

    return ZOSS_SUCCESS;
}


/**************************************************************************
* ƣ zOss_FExist
*  бļǷ
* ˵ (IN)   filename:ļ
*   ֵ :TRUE;:FALSE
* ˵ бļĿ¼Ƿ
**************************************************************************/
BOOL zOss_FExist(const CHAR *filename)
{
    UINT32 mapResult;
    CHAR * changedName = NULL;
    struct _stat statinfo;
    SINT32 statRet;

    zOss_ASSERT( NULL != filename );

    changedName = zOss_Malloc( FILELEN );
    if ( changedName == NULL )
    {
        return FALSE;
    }

    zOss_Memset( changedName, 0, FILELEN );

    mapResult = VDD_FNameMap( filename , changedName );
    if ( ZOSS_ERROR == mapResult )
    {
        zOss_Free( changedName );
        return FALSE;
    }

    statRet = _stat(changedName, &statinfo);
    if (statRet!=0)
    {
        zOss_Free( changedName );
        return FALSE;
    }

    zOss_Free( changedName );

    if ( statinfo.st_mode & _S_IFDIR )
    {
        return FALSE;
    }
    else
    {
        return TRUE;
    }
}

/**************************************************************************
* ƣ zOss_FCreate
*  ļ
* ˵ (IN)  filename:ļ
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR.
* ˵
**************************************************************************/
UINT32 zOss_FCreate (const CHAR *filename)
{
    FILE *fp;
    UINT32 ureturn;
    CHAR create_file[FILELEN] ={0};

    assert(NULL != filename);
    if (NULL == filename)
    {
        return ZOSS_ERROR;
    }

    ureturn = VDD_FNameMap(filename,create_file);
    if (ZOSS_ERROR == ureturn)
    {
        return ZOSS_ERROR;
    }
    fp = fopen(create_file,"wb");
    if (NULL == fp)
    {
        return ZOSS_ERROR;
    }
    fclose(fp);
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ zOss_FOpen
*  һļ
* ˵ (IN)  filename:ļ
           mode:򿪷ʽ.
             "r": Open text file for reading.
                     "w": Truncate to zero length or create text file for writing.
                     "a": Append; open or create text file for writing at end of file.
                     "rb": Open binary file for reading.
                     "wb": Truncate to zero length or create binary file for writing.
                     "ab": Append; open or create binary file for writing at end of file
                     "r+": Open text file for update (reading and writing).
                     "w+": Truncate to zero length or create text file for update.
                     "a+": Append open or create text file for update, writing at end of file.
                     "r+b" or "rb+": Open binary file for update (reading and writing).
                     "w+b" or "wb+": Truncate to zero length or create binary file for update.
                     "a+b" or "ab+": Append; open or create binary file for update, writing at end of file.
*   ֵ ɹ:ļ;ʧ:ZOSS_NULL.
* ˵
**************************************************************************/
FILE *zOss_FOpen (const CHAR * filename, const CHAR * mode)
{
    FILE *fp = NULL;
    UINT32 ureturn;
    CHAR open_file[FILELEN]= {0};

    assert(NULL != filename);
    assert(NULL != mode);
    ureturn = VDD_FNameMap(filename,open_file);
    if (ZOSS_ERROR == ureturn)
    {
        return ZOSS_NULL;
    }
    fp = fopen(open_file,mode);
    if (NULL == fp)
    {
        return ZOSS_NULL;
    }
    return fp;
}

/**************************************************************************
* ƣ VDD_FSeek
*  λļеĶдλ
* ˵ (IN)   fd: ļ,VDD_FOpen()ķֵ
            offset:ԭʼλÿʼҪƶƫ
            whence:
            ZOSS_SEEK_SET :ļʼ
            ZOSS_SEEK_CUR :ǰλ
            ZOSS_SEEK_END :ļβ
*   ֵ ɹ:ȷZOSS_SUCCESS;ʧ:ش.
* ˵
**************************************************************************/
UINT32 zOss_FSeek (FILE *stream, SINT32 offset, SINT32 whence)
{
    SINT32 uReturn;
    assert(NULL != stream);
    if ( NULL == stream )
    {
        return ZOSS_ERROR;
    }

    uReturn = fseek(stream, offset, whence);
    if (0 == uReturn)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* ƣ zOss_FRead
*  ļ
* ˵ (IN)   data:Ŷȡݵڴָ
            size:ݵԪĴС
            count:ȡĸ
            stream:ļָ
*   ֵ ʵʶֽ
* ˵
**************************************************************************/
SSIZE_T zOss_FRead(void *data, SSIZE_T size, SSIZE_T count, FILE *stream)
{
    SINT32 uReturn;
    assert(NULL != stream);
    assert(NULL != data);
    if (NULL == data)
    {
        return 0;
    }
    if (size <0)
    {
        return 0;
    }
    if (NULL == stream)
    {
        return 0;
    }

    uReturn = (SINT32)fread(data,(UINT32)size,(UINT32)count,stream);
    return uReturn;
}

/**************************************************************************
* ƣ zOss_FWrite
*  дļ
* ˵ (IN)    data:дݵڴָ
             size:ݵԪĴС
             count:дĸ
             stream:ļָ
*   ֵ ʵдֽ
* ˵
**************************************************************************/
SSIZE_T zOss_FWrite(const void *data, SSIZE_T size, SSIZE_T count, FILE *stream)
{
    SSIZE_T uReturn;
    assert(NULL != stream);
    assert(NULL != data);
    if (NULL == data)
    {
        return 0;
    }
    if (size <0)
    {
        return 0;
    }
    if (NULL == stream)
    {
        return 0;
    }


    uReturn = (SINT32)fwrite(data,(UINT32)size,(UINT32)count,stream);
    return uReturn;
}

/**************************************************************************
* ƣ zOss_FEof
*  Ƿļβ
* ˵ (IN)    stream:ļָ
*   ֵ ʾǰļָѵļβ,ʾû
* ˵
**************************************************************************/
UINT32 zOss_FEof(FILE *stream)
{
    assert(NULL != stream);
    if (NULL == stream)
    {
        return 0;
    }

    return feof(stream);
}

/**************************************************************************
* ƣ zOss_FTell
*  شļʼĵǰļָλ
* ˵ (IN)    stream:ļָ
*   ֵ ɹ:ļʼĵǰļָλ;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_FTell(FILE *stream)
{
    SINT32 uReturn;

    assert(NULL != stream);
    if (NULL == stream)
    {
        return 0;
    }

    uReturn = ftell(stream);
    if (-1 == uReturn)
    {
        return ZOSS_ERROR;
    }
    return(UINT32)uReturn;
}

/**************************************************************************
* ƣ zOss_FClose
*  رļ
* ˵ (IN)   stream:ļָ
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_FClose(FILE *stream)
{
    SINT32 uReturn;
    assert(NULL != stream);
    if (NULL == stream)
    {
        return ZOSS_ERROR;
    }
    uReturn = fclose(stream);
    if (0 == uReturn)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* ƣ VDD_FRename
*  ļ
* ˵ (IN)   old_filename:ԭļ
                        new_filename:ļ
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_FRename(const CHAR *old_filename, const CHAR *new_filename)
{
    UINT32 uReturn;
    CHAR source_file[FILELEN] ={0};
    CHAR dest_file [FILELEN]={0};

    assert(NULL != old_filename);
    assert(NULL != new_filename);
    if ((NULL ==old_filename)||(NULL == new_filename))
    {
        return ZOSS_ERROR;
    }
    uReturn = VDD_FNameMap(old_filename,source_file);
    if (ZOSS_ERROR == uReturn)
    {
        return ZOSS_ERROR;
    }
    uReturn = VDD_FNameMap(new_filename,dest_file);
    if (ZOSS_ERROR == uReturn)
    {
        return ZOSS_ERROR;
    }
    uReturn = (UINT32)rename(source_file,dest_file);
    if (0 == uReturn)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* ƣ VDD_FDelete
*  ɾļ
* ˵ (IN)   filename:ļ
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_FDelete(const CHAR * filename)
{
    UINT32 uReturn;
    CHAR delete_file[FILELEN]= {0};

    assert(NULL != filename);
    if (NULL == filename)
    {
        return ZOSS_ERROR;
    }
    uReturn = VDD_FNameMap(filename,delete_file);
    if (ZOSS_ERROR == uReturn)
    {
        return ZOSS_ERROR;
    }
    uReturn = (UINT32)remove(delete_file);
    if (0 == uReturn)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* ƣ VDD_FLength
*  ȡļ
* ˵ (IN)   stream:ļָ
*   ֵ ļ,󷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_FLength(FILE *stream)
{
    UINT32 ret;
    struct stat statbuf;

    assert(NULL != stream);
    if (NULL == stream)
    {
        return ZOSS_ERROR;
    }

    /* get information about the file */
    ret = (UINT32)fstat(fileno(stream), &statbuf);
    if (ret != 0)
    {
        return ZOSS_ERROR;
    }
    else
    {
        return(UINT32)statbuf.st_size;
    }
}

/**************************************************************************
* ƣ zOss_FError
* ָĿ¼ȡĿ¼
* ˵ (IN)    stream:ļָ
*   ֵ ⵽󷵻ط0 ֵ򣬷0
* ˵ڵײʵԭ򣬺صķ0ֵĺ壬
׼cferrorĺ岻һ¡
**************************************************************************/
UINT32 zOss_FError(FILE *stream)
{
    assert(NULL != stream);

    if (NULL == stream)
    {
        return ZOSS_ERROR;
    }

    return(UINT32)ferror(stream);
}

/**************************************************************************
* ƣ zOss_FTruncate
* 
* ˵ (IN)    stream:ļָ
*   ֵ
**************************************************************************/
UINT32 zOss_FTruncate(FILE *stream, UINT32 size)
{
    int result;
    UINT32 status;

    assert(NULL != stream);

    if (NULL == stream)
    {
        return ZOSS_ERROR;
    }
    result = chsize(stream->_file,(long)size);

    if (result == 0)
    {
        status = ZOSS_SUCCESS;
    }
    else
    {
        status = ZOSS_ERROR;
    }

    return status;
}

/**************************************************************************
* ƣ zOss_FFlush
*  ͬļļڵдļ
* ˵ (IN)    stream:ļָ
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_FFlush(FILE *stream)
{
    int result;

    assert(NULL != stream);

    if (NULL == stream)
    {
        return ZOSS_ERROR;
    }

    result = fflush(stream);

    if (result == -1)
    {
        return ZOSS_ERROR;
    }
    else
    {
        return ZOSS_SUCCESS;
    }
}

/**************************************************************************
* ƣ zOss_MountDisk
* ش
* ˵ (IN)   diskname:̷
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_MountDisk(CHAR diskname)
{
    return ZOSS_ERROR;
}

/**************************************************************************
* ƣ zOss_UnMountDisk
* жش
* ˵ (IN)   diskname:̷
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_UnMountDisk(CHAR diskname)
{
    return ZOSS_ERROR;
}

/**************************************************************************
* ƣ zOss_GetDiskFreeSpace
* ȡ̵ָʣռ
* ˵ (IN)   diskname:̷,CD.
                              (OUT) space:ʣռĴС,λbyte.
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_GetDiskFreeSpace(CHAR diskname, UINT64 *space)
{
    return ZOSS_ERROR;
}

/**************************************************************************
* ƣ zOss_GetDiskCapacity
* жش
* ˵ (IN)   diskname:̷,CD.
                              (OUT) space:ʣռĴС,λbyte.
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_GetDiskCapacity(CHAR diskname, UINT64 *space)
{
    return ZOSS_ERROR;
}

/**************************************************************************
* ƣ zOss_GetCurrentZonetime
*  ȡǰʱ
* ˵ 
*   ֵ ɹ:ʱ;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_GetCurrentZonetime()
{
    TIME_ZONE_INFORMATION timeZone;
    UINT32 result;
    result = GetTimeZoneInformation(&timeZone);
    if (result == TIME_ZONE_ID_STANDARD)
    {
        return(UINT32)timeZone.Bias;
    }
    else
    {
        return ZOSS_ERROR;
    }
}

/**************************************************************************
* ƣ zOss_SyncFS
*  ļϵͳͬ
* ˵ (IN)
             (OUT)
*   ֵ ɹZOSS_SUCCESS,ʧܷZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_SyncFS(VOID)
{
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣ FS_Init
*  ļϵͳʼ
* ˵ (IN)
             (OUT)
*   ֵ ɹZOSS_SUCCESS,ʧܷZOSS_ERROR
* ˵
**************************************************************************/
VOID  FS_Init(VOID)
{    
    UINT32 retCode = VDD_FsInit();
    zOss_ASSERT(retCode == ZOSS_SUCCESS);
}

#ifdef __cplusplus
}
#endif
