/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : tos_ramdump_arm_client.c
* ļ : 
* ʵֹ : 
*      : 
*      : 1.0
*  : 2013/07/18
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "sup_ramdump.h"
#include "drvs_icp.h"
#include "ram_config.h"

#ifdef _OS_TOS
#include <cyg/hal/tos_arm_mmu.h>
#endif

#ifdef __cplusplus
extern "C"
{
#endif

/*************************************************************************
* ⲿ
**************************************************************************/

/**************************************************************************
* ȫֳ/
**************************************************************************/
T_zOss_RamdumpOpt           g_zRamdump_Optfunc      = {NULL,NULL};
T_zOss_RamdumpClientInfo    *g_zRamdump_ClientInfo  = NULL;
T_zOss_RamdumpClientMsgInfo g_zRamdump_IcpMsgInfo   = {0};

#define ZRAMDUMP_CLIENT_FILE "sup_ramdump_client.con"
#define ZRAMDUMP_CLIENT_ICP_TABLE(srcModId,desModId,chID)
#define ZRAMDUMP_CLIENT_MEM_TABLE(identifier,pRamdumpStartAddr,ramdumpSize) 
#define ZRAMDUMP_SERVER_MEM_TABLE(identifier,pRamdumpStartAddr,ramdumpSize,serverFlagBase)
#undef  ZRAMDUMP_CLIENT_ICP_TABLE
#define ZRAMDUMP_CLIENT_ICP_TABLE(identifier,actorID,chID)                      \
                             (UINT32)(identifier),(T_HalIcp_MsgActor)(actorID), \
                             (T_ZDrvRpMsg_ChID)(chID)
static T_zOss_RamdumpIcpInfo s_zRamdump_IcpClientInfo = 
{
    #include ZRAMDUMP_CLIENT_FILE
};

#undef  ZRAMDUMP_CLIENT_ICP_TABLE
#define ZRAMDUMP_CLIENT_ICP_TABLE(identifier,actorID,chID)
#undef  ZRAMDUMP_CLIENT_MEM_TABLE
#define ZRAMDUMP_CLIENT_MEM_TABLE(identifier,pRamdumpStartAddr,ramdumpSize)     \
                              (UINT32)(identifier),(CHAR *)(pRamdumpStartAddr), \
                              (UINT32)(ramdumpSize)                           
static T_zOss_RamdumpClientConInfo s_zRamdump_ClientCfgInfo = 
{
    #include ZRAMDUMP_CLIENT_FILE
};
#undef  ZRAMDUMP_CLIENT_MEM_TABLE
#define ZRAMDUMP_CLIENT_MEM_TABLE(identifier,pRamdumpStartAddr,ramdumpSize)
static BOOL s_zRamdump_InitFlag = FALSE;

/**************************************************************************
* 궨
**************************************************************************/
#define ZOSS_RAMDUMP_CLIENT_ICP_SIZE        0x40

/**************************************************************************
* ݽṹ
**************************************************************************/

/**************************************************************************
* ֲԭ
**************************************************************************/
static VOID ramdump_ClientSendMsg(T_zOss_RamdumpIcpInfo *IcpInfo, T_zOss_RamdumpClientMsgInfo *pMsgInfo);
static VOID ramdump_ClientProcessMsg(VOID *pMsg, UINT32 len);
static VOID ramdump_Main(VOID);

/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
 * ƣramdump_ClientSendMsg
 * ˼ͨѶϢͽӿ
 * ˵(IN):
 *              pIcpInfo: ramdump ICPϢ
 *              pMsgInfo: ICPϢ
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ClientSendMsg(T_zOss_RamdumpIcpInfo *pIcpInfo, T_zOss_RamdumpClientMsgInfo *pMsgInfo)
{
    T_ZDrvRpMsg_Msg icpMsg  = { 0 };

    icpMsg.actorID = pIcpInfo->actorID;
    icpMsg.chID    = pIcpInfo->chID;
    icpMsg.flag    = 1;
    icpMsg.buf     = pMsgInfo;
    icpMsg.len     = sizeof(T_zOss_RamdumpClientMsgInfo);
    zDrvRpMsg_WriteLockIrq(&icpMsg);
}

/**************************************************************************
 * ƣramdump_GetConfigRegion
 * ȡramdҪ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
#ifdef CYGOPT_HAL_ARM_MMU
static VOID ramdump_GetConfigRegion(VOID)
{    
    T_zOss_RamdumpRegion regionInfo = {0};
    UINT32               cnt        = 0;
    T_zTos_MmuConfigItem *pItem     = NULL;
    
    for (cnt = 0; cnt < g_zTos_MmuConfigTable.count; cnt++)
    {   
        pItem = &g_zTos_MmuConfigTable.item[cnt];
        if (pItem->attr & ZTOS_MMU_REGION_DUMP)
        {
            regionInfo.baseForServer = pItem->server_base;
            regionInfo.baseForSelf   = pItem->physical_base;
            regionInfo.size          = pItem->size;
            regionInfo.baseForCopy   = (pItem->attr & ZTOS_MMU_REGION_COPY) ? pItem->server_base : 0;
            zOss_RamdumpConfigureMem(&regionInfo);
        }
    }
}
#endif

/**************************************************************************
 * ƣramdump_SetPartition
 * ramdumpռ仮֣
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_SetPartition(VOID)
{    
    UINT32 size;
    UINT32 sizeUnit = s_zRamdump_ClientCfgInfo.ramdumpSize/ZOSS_RAMDUMP_CLIENT_TOTAL_RATE;;
   
    /* ramdumpַ */
    memset(s_zRamdump_ClientCfgInfo.pRamdumpStartAddr, 0, s_zRamdump_ClientCfgInfo.ramdumpSize);
    g_zRamdump_ClientInfo  = (T_zOss_RamdumpClientInfo *)(((UINT32)s_zRamdump_ClientCfgInfo.pRamdumpStartAddr + sizeof(UINT32) - 1) & ~(sizeof(UINT32) - 1));
    g_zRamdump_ClientInfo->clientFlagBase = (UINT32)g_zRamdump_ClientInfo+((sizeof(T_zOss_RamdumpClientInfo) + sizeof(UINT32) - 1)& ~(sizeof(UINT32) - 1));
    g_zRamdump_ClientInfo->pCmmInfo = (T_zOss_RamdumpCmmFileInfo *)((char *)g_zRamdump_ClientInfo->clientFlagBase+4);
    g_zRamdump_ClientInfo->pCmmInfo->cmmFileSize = 0;
    size = (sizeUnit * ZOSS_RAMDUMP_CMM_INFO_RATE - sizeof(UINT32) + 1) & ~(sizeof(UINT32) - 1);
    g_zRamdump_ClientInfo->pCmmInfo->cmmFileMaxSize = (size - sizeof(T_zOss_RamdumpCmmFileInfo));
     
    g_zRamdump_ClientInfo->pConfigureInfo= (T_zOss_RamdumpRegionInfo *)((CHAR*)g_zRamdump_ClientInfo->pCmmInfo + size);
    g_zRamdump_ClientInfo->pConfigureInfo->regionNum = 0;
    size = (sizeUnit * ZOSS_RAMDUMP_CONFIGURED_REGION_RATE - sizeof(UINT32) + 1) & ~(sizeof(UINT32) - 1);
    g_zRamdump_ClientInfo->pConfigureInfo->regionMaxNum = (size - sizeof(T_zOss_RamdumpRegionInfo)) / sizeof(T_zOss_RamdumpRegion);
    
    g_zRamdump_ClientInfo->pParsedInfo = (T_zOss_RamdumpRegionInfo *)((CHAR*)g_zRamdump_ClientInfo->pConfigureInfo + size);
    g_zRamdump_ClientInfo->pParsedInfo->regionNum = 0;
    size = (sizeUnit * ZOSS_RAMDUMP_PARSED_REGION_RATE - sizeof(UINT32) + 1) & ~(sizeof(UINT32) - 1);
    g_zRamdump_ClientInfo->pParsedInfo->regionMaxNum = (size - sizeof(T_zOss_RamdumpRegionInfo)) / sizeof(T_zOss_RamdumpRegion);
    
    g_zRamdump_ClientInfo->pErrInfo = (T_zOss_RamdumpBuffInfo *)((CHAR *)g_zRamdump_ClientInfo->pParsedInfo + size);
    size = (sizeUnit * ZOSS_RAMDUMP_ERR_INFO_RATE - sizeof(UINT32) + 1) & ~(sizeof(UINT32) - 1);  
    g_zRamdump_ClientInfo->pErrInfo->pBuff = (CHAR *)g_zRamdump_ClientInfo->pErrInfo + sizeof(T_zOss_RamdumpBuffInfo);
    g_zRamdump_ClientInfo->pErrInfo->buffLen = size - sizeof(T_zOss_RamdumpBuffInfo);  
    g_zRamdump_ClientInfo->clientId    = s_zRamdump_ClientCfgInfo.clientId;
    sprintf((char *)g_zRamdump_ClientInfo->pErrInfo->pBuff, "%d_c_core: exact error!\n",(int)s_zRamdump_ClientCfgInfo.clientId); 

    zOss_AssertExN(((CHAR *)g_zRamdump_ClientInfo->pErrInfo->pBuff+ size) <= 
                   (s_zRamdump_ClientCfgInfo.pRamdumpStartAddr + s_zRamdump_ClientCfgInfo.ramdumpSize));
}

/**************************************************************************
 * ƣramdump_ClientProcessMsg
 * ˼ͨѶserverϢӿ
 * ˵(IN):
 *              pBuff:Ϣbuff
 *              len  :Ϣĳ
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ClientProcessMsg(VOID *pBuff, UINT32 len)
{
    T_zOss_RamdumpServerMsgInfo *ramdumpMsg = (T_zOss_RamdumpServerMsgInfo *)pBuff;

    switch(ramdumpMsg->msgType)
    { 
    case ZOSS_RAMDUMP_EXCPT_TYPE:
        {
            sprintf((char *)g_zRamdump_ClientInfo->pErrInfo->pBuff, "%d_c_core: force error!\n",(int)g_zRamdump_ClientInfo->clientId); 
            zOss_RamdumpHandle(1, 1, 1);
            break;
        }
    case ZOSS_RAMDUMP_TEST_EXCPT_TYPE:
        {
            sprintf((char *)g_zRamdump_ClientInfo->pErrInfo->pBuff, "%d_c_core: exact error!\n",(int)g_zRamdump_ClientInfo->clientId); 
            zOss_RamdumpHandle(1, 1, 1);
            break;
        }
    default:
        {
            break;
        }
    }
}

/**************************************************************************
 * ƣramdump_ClientIcpInit
 * client ICP ʼ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ClientIcpInit(VOID)
{
    zDrvRpMsg_CreateChannel(s_zRamdump_IcpClientInfo.actorID, s_zRamdump_IcpClientInfo.chID, ZOSS_RAMDUMP_CLIENT_ICP_SIZE);
    zDrvRpMsg_RegCallBack(s_zRamdump_IcpClientInfo.actorID, s_zRamdump_IcpClientInfo.chID, ramdump_ClientProcessMsg);
}

/**************************************************************************
 * ƣramdump_NotifyServerExceptionOccur
 * ֪ͨserver쳣
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_NotifyServerExceptionOccur(VOID)
{
    T_zOss_RamdumpClientMsgInfo msgInfo = {0};

    msgInfo.Identifier        = s_zRamdump_ClientCfgInfo.clientId;
    msgInfo.msgType           = ZOSS_RAMDUMP_EXCPT_TYPE;
    msgInfo.pRamdumpStartAddr = s_zRamdump_ClientCfgInfo.pRamdumpStartAddr;
    msgInfo.radmumpSize       = s_zRamdump_ClientCfgInfo.ramdumpSize;
    ramdump_ClientSendMsg(&s_zRamdump_IcpClientInfo, &msgInfo);
}

/**************************************************************************
 * ƣramdump_ProcessException
 * 쳣Ϣ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_ProcessException(VOID)
{
    *(UINT32 *)g_zRamdump_ClientInfo->clientFlagBase = ZOSS_RAMDUMP_FLAG_SECOND_VALUE;
    zOss_CleanCache();
    while (*(UINT32 *)g_zRamdump_ClientInfo->clientFlagBase != ZOSS_RAMDUMP_FLAG_THIRD_VALUE);
    zOss_RamdumpCreateCmmFile(g_zRamdump_ClientInfo->pCmmInfo);
    *(UINT32 *)g_zRamdump_ClientInfo->clientFlagBase = ZOSS_RAMDUMP_FLAG_FOUR_VALUE;
    zOss_CleanCache();
}

/*****************************************************************************
 * ƣ ramdump_Main
 *  ִramdump
 * ˵ (IN):
 *            (OUT):
 *   ֵ
 * ˵
 ****************************************************************************/
static VOID ramdump_Main(VOID)
{
    ramdump_NotifyServerExceptionOccur();
    ramdump_ProcessException();
}

/**************************************************************************
* ȫֺʵ
**************************************************************************/

/**************************************************************************
 * ƣ zOss_RamdumpHandle
 *  Ramdump
 * ˵
 *   ֵ
 * ˵ TOSϵͳûʵ壻
 **************************************************************************/
VOID zOss_RamdumpHandle(UINT16 user_called, UINT16 ecode, UINT16 extra)
{
    static UINT32   excepNum = 0;
    ZOSS_INTR       old_intr;
    
    ZOSS_SAVE_IRQ(old_intr);
    if (++excepNum > 1 || !s_zRamdump_InitFlag)   /* ֻһγֳ */
    {
        for( ; ; ) ;
    }
    zOss_RamdumpEncodeError(g_zRamdump_ClientInfo->pErrInfo->pBuff, user_called, ecode, extra);
    ramdump_Main();
    for( ; ; ) ;
    ZOSS_RESTORE_IRQ(old_intr);
}

/**************************************************************************
 * ƣramdump_RegionsCmmFile
 * T32cmműڴд
 * ˵(IN):
 *              address: cmműĵַ             
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
CHAR *zOss_RamdumpCreateRegionsCmmFile(CHAR *address)
{
    CHAR    fileName[ZOSS_RAMDUMP_FILENAME_LEN] = {0};
    UINT32  i                                   = 0;
  
    sprintf(fileName, "%d_c_mem.bin", (int)g_zRamdump_ClientInfo->clientId);
    for (i = 0; i < g_zRamdump_ClientInfo->pParsedInfo->regionNum; i++)
    {   
        T_zOss_RamdumpRegion *pRegion = &(g_zRamdump_ClientInfo->pParsedInfo->regions[i]);
        if (pRegion->baseForSelf != pRegion->baseForServer)
        {
            UINT32 parsedEnd  = pRegion->baseForSelf + pRegion->size - 1;
            address += sprintf(address, "data.load.binary &%s\\%d_%s %#lx--%#lx /noclear\r\n", ZOSS_RAMDUMP_DIR_NAME, 
                               (int)i, fileName, pRegion->baseForSelf, parsedEnd);
            if (pRegion->baseForCopy != 0)
            {
                memcpy((void*)pRegion->baseForCopy, (void*)pRegion->baseForSelf,(parsedEnd - pRegion->baseForSelf + 1));
            }
        }
        else
        {      
            address += (UINT32)sprintf(address, "data.load.binary &%s\\%d_%s %#lx--%#lx /noclear\r\n", ZOSS_RAMDUMP_DIR_NAME,
                                       (int)i, fileName, pRegion->baseForSelf, pRegion->baseForSelf + pRegion->size - 1);
        }
    }
    
    return address;
}

/**************************************************************************
 * ƣ zOss_RamdumpConfigureMem
 *  ڴϢ
 * ˵ (IN):
 *              regionInfo: ָ룻
 *            (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpConfigureMem(T_zOss_RamdumpRegion *regionInfo)
{
    T_zOss_RamdumpRegionInfo *pCfgInfo = g_zRamdump_ClientInfo->pConfigureInfo;
    
    if (regionInfo->size == 0)
        return;
    zOss_AssertExN(pCfgInfo->regionNum < pCfgInfo->regionMaxNum);
    zOss_AssertExN((regionInfo->size - 1) <= (0xFFFFFFFF - regionInfo->baseForServer));
    pCfgInfo->regions[pCfgInfo->regionNum].baseForServer = regionInfo->baseForServer;
    pCfgInfo->regions[pCfgInfo->regionNum].baseForSelf   = regionInfo->baseForSelf;
    pCfgInfo->regions[pCfgInfo->regionNum].baseForCopy   = regionInfo->baseForCopy;
    pCfgInfo->regions[pCfgInfo->regionNum].size          = regionInfo->size;
    (pCfgInfo->regionNum)++;
}

/**************************************************************************
 * ƣ zOss_RamdumpSetOperation
 *  ramdumpûעӿڣ
 * ˵ (IN): 
 *              funcObjPtr: ص
 *            (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpSetOperation(T_zOss_RamdumpOpt *funcObjPtr)
{
    zOss_AssertExN(funcObjPtr != NULL);
    
    if (funcObjPtr->ramdump_Process_PreHook != NULL)
    {
        g_zRamdump_Optfunc.ramdump_Process_PreHook = funcObjPtr->ramdump_Process_PreHook;
    }
    
    if (funcObjPtr->ramdump_Process_AftHook != NULL)
    {
        g_zRamdump_Optfunc.ramdump_Process_AftHook = funcObjPtr->ramdump_Process_AftHook;
    }
}

/**************************************************************************
 * : zOss_RamdumpInit
 * Ramdumpʼ 
 * ˵
 *   ֵ
 * ˵
 ***************************************************************************/     
VOID zOss_RamdumpInit(VOID)
{    
    ramdump_SetPartition();
#ifdef CYGOPT_HAL_ARM_MMU
    ramdump_GetConfigRegion();   
#endif
    ramdump_ClientIcpInit();
    *(UINT32 *)g_zRamdump_ClientInfo->clientFlagBase = ZOSS_RAMDUMP_FLAG_FIRST_VALUE;
    g_zRamdump_IcpMsgInfo.Identifier        = s_zRamdump_ClientCfgInfo.clientId;
    g_zRamdump_IcpMsgInfo.msgType           = ZOSS_RAMDUMP_INIT_TYPE;
    g_zRamdump_IcpMsgInfo.pRamdumpStartAddr = s_zRamdump_ClientCfgInfo.pRamdumpStartAddr;
    g_zRamdump_IcpMsgInfo.radmumpSize       = s_zRamdump_ClientCfgInfo.ramdumpSize;

    ramdump_ClientSendMsg(&s_zRamdump_IcpClientInfo, &g_zRamdump_IcpMsgInfo);
    zOss_CleanCache();
    s_zRamdump_InitFlag = TRUE;
}

/**************************************************************************
 * ƣOsa_SysErrHndInit
 * ַȫֱʼ,ȡramdumpڴĬ
                                  arm0arm1ͬ
 * ˵
 *   ֵ
 * ˵׮Ϊ˼osecskyramdumpܣ
 ***************************************************************************/
VOID Osa_SysErrHndInit(VOID)
{

}

#ifdef __cplusplus
}
#endif

