/************************************************************************
 * Ȩ (C)2010,ͨѶɷ޹˾
 * ģ  
 * ļƣ os_file.c
 * ļʶ Zcoreļزӿ
 * ժҪ
 *
 * ޸    汾       ޸ı        ޸        ޸
 * ----------------------------------------------------------------------
 * 2010-04-28    1.0                        Darren.Ma       ½
 ************************************************************************/

 /**************************************************************************
  *                        ͷļ                                                                         *
  **************************************************************************/
 
#include "os_type.h"
#include "os_pub.h"
#include "zcore_type.h"

#ifdef _STDLIB
#include <stdio.h>
#include <dirent.h>
#include <sys/stat.h>
#include<fcntl.h>




/**************************************************************************
* ƣ tp_fopen
*  ָļ
* ˵ filenameļ
                                modeļ򿪵ģʽ
*   ֵ    ɹ򷵻ļָ룬򷵻NULL
* ˵ ѡ
**************************************************************************/
FILE* tp_fopen (const ZCHAR *filename,const ZCHAR *mode)
{
    if (filename == NULL || mode == NULL)
    {
        printf("\nchenxin 11.24 filename is NULL!\n");
        return NULL;
    }
    return (FILE *)fopen(filename,mode);
}
/**************************************************************************
* ƣ tp_fclose
*  ָļ
* ˵ filenameļ
                                modeļ򿪵ģʽ
*   ֵ    ɹ򷵻ļָ룬򷵻NULL
* ˵ ѡ
**************************************************************************/
ZSINT32   tp_fclose(FILE *stream)
{
    if (stream == NULL)
    {
        return 0;
    }
    return fclose(stream);
}
/**************************************************************************
* ƣ tp_feof
*  ǷѴﵽָļĽβ
* ˵ streamļָ
*   ֵ    ⵽ѵļβ򷵻طֵ򷵻0
* ˵ ѡ
**************************************************************************/
ZSINT32   tp_feof(FILE *stream)
{
    if (stream == NULL)
    {
        return 0;
    }
    return feof(stream);
}
/**************************************************************************
* ƣ tp_fexist
*  ָļǷ
* ˵ filenameļ
*   ֵ    򷵻0򷵻-1
* ˵ ѡ
**************************************************************************/
ZSINT32   tp_fexist(ZCHAR *filename)
{
    FILE * file = NULL;
    ZSINT32 ret = 0;
    if (filename == NULL)
    {
        return 0;
    }
    file = (FILE *)fopen((const char*)filename,"r");
    if (file)
    {
        ret = 1;
        fclose(file);
    }
    else
        ret = 0;
    return ret;
}
/**************************************************************************
* ƣ tp_fflush
*  ͬļļڵдļ
* ˵ streamļָ
*   ֵ    ɹ򷵻0򷵻-1
* ˵ ѡ
**************************************************************************/
ZSINT32   tp_fflush(FILE *stream)
{
    if (stream == NULL)
    {
        return 0;
    }

    return fflush(stream);
}
/**************************************************************************
* ƣ tp_fflush
* ȡָļĳ
* ˵ streamļָ
*   ֵ    ɹ򷵻ָļĳȣ򷵻-1
* ˵ ѡ
**************************************************************************/
ZSINT32   tp_flength(FILE *stream)
{
    ZSINT32     length = 0;
    FILE            *fp = stream;

    if (stream == NULL)
    {
        return 0;
    }
    fseek(fp,SEEK_SET,SEEK_END);
    length = ftell(fp);
    return length;
}
/**************************************************************************
* ƣ tp_fread
* ļstreamжȡcountݵԪ
                                ÿһݵԪĳΪsizeֽڣdataָĿ
* ˵ dataݵĴŵַָ
                          sizeݵԪĴС
                                countݵԪĸ
                                streamļָ
*   ֵ    ɹ򷵻ָļĳȣ򷵻-1
* ˵ ѡ
**************************************************************************/
size_t tp_fread (ZVOID *data, size_t size, size_t count, FILE *stream)
{
    if (data == NULL ||stream == NULL )
    {
        return 0;
    }
    return fread(data,size,count,stream);
}
/**************************************************************************
* ƣ tp_fseek
* ļָָλ
* ˵ streamļָ
                                offsetʼַʼƫλΪֽ
                                whenceļָʼλ
*   ֵ    ɹ򷵻0򷵻ط0ֵ
* ˵ ѡ
**************************************************************************/
ZSINT32   tp_fseek(FILE *stream,UINT32 offset,ZSINT32 whence)
{
    if (stream == NULL)
    {
        return 0;
    }
    return fseek(stream,offset,whence);
}
/**************************************************************************
* ƣ tp_ftell
* ļָƫλֵ
* ˵ streamļָ
*   ֵ    ɹ򷵻ļĵǰλã򷵻-1
* ˵ ѡ
**************************************************************************/
ZSINT32   tp_ftell(FILE *stream)
{
    if (stream == NULL)
    {
        return 0;
    }
    return ftell(stream);
}
/**************************************************************************
* ƣ tp_fwrite
* ַָʼָݵԪӵָļ
* ˵ dataݵĴŵַָ
                                sizeݵԪĴС
                                coutݵԪĸ
                                streamļָ
*   ֵ    ɹ򷵻ȷе򷵻-1
* ˵ ѡ
**************************************************************************/
size_t tp_fwrite (const ZVOID *data, size_t size, size_t count, FILE *stream)
{
    if (data == NULL ||stream == NULL )
    {
        return 0;
    }
    return fwrite(data, size, count, stream);
}

/**************************************************************************
* ƣ tp_fprintf
* ָʽдļ
* ˵ streamļָ
                                formatͱ׼cprintf
*   ֵ    ɹ򷵻дֽ򷵻0
* ˵ ѡ
**************************************************************************/
size_t tp_fprintf (FILE *stream, const ZCHAR *format, ...)
{
    if (stream == NULL )
    {
        return 0;
    }
    return OS_FAILURE;
}

/**************************************************************************
* ƣ tp_fdelete
* ɾָļ
* ˵ filenameɾļ
*   ֵ    ɹ򷵻0򷵻-1
* ˵ ѡ
**************************************************************************/
ZSINT32 tp_fdelete(ZCHAR * pfileName)
{
    return  remove(pfileName);
}

/**************************************************************************
* ƣ tp_ftruncate
* ļضָ
* ˵ filenameɾļ
                                sizeָ
*   ֵ    ɹ򷵻0򷵻-1
* ˵ ѡ
**************************************************************************/
ZSINT32 tp_ftruncate(FILE *stream, size_t size)
{
    return ftruncate(stream, size);
}

int tp_opendir(char *dir_name, VOID **dir_entry_ptr)
{
	if (*((DIR**)dir_entry_ptr) = opendir(dir_name) == NULL)
	{
		return -1;
	}
	
	return 0; 
}

int tp_closedir(VOID *dir_entry_ptr)
{
	return closedir(dir_entry_ptr);
}

int tp_mkdir(char *dir_name)
{
	return mkdir(dir_name, S_IRWXU);
}

int tp_isdir(char *dir_name)
{
	struct stat buf;

	if(stat(dir_name,&buf)<0)
       {
		return 0;
       }
	if (S_ISDIR(buf.st_mode))
                return 1;
	return 0;
}

int tp_chdir(char *new_dir_name)
{
	return chdir(new_dir_name);
}

int  tp_frename(char *old_filename, char *new_filename)
{
	return rename(old_filename, new_filename);
}

int tp_rmdir(char *dir_name)
{
	return rmdir(dir_name);
}

int tp_fcreate(char *filename)
{
	int fd = 0;
	if (fd = open(filename, O_RDWR|O_CREAT) == -1)
		return -1;
	close(fd );
	return 0;
}

int tp_rndir(char *old_dir_name, char *new_dir_name)
{
	return rename(old_dir_name, new_dir_name);
}


#endif


