/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : sup_ramdump_comm.c
* ļ : 
* ʵֹ : ramdumpIOӿʵַװ
*      :
*      : 1.0
*  : 2014/03/25
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* #include
**************************************************************************/
#ifdef _USE_CP_USB
#include "oss_api.h"
#include "drvs_usbPoll.h"
#else
#include "oss_api.h"
#include "drvs_icp.h"
#include "drv_api.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* ⲿͱ
**************************************************************************/
#ifndef _USE_CP_USB
extern SINT32 zDrvRpMsg_CreateLockSaveChannel (T_ZDrvRpMsg_MsgActor actorID, T_ZDrvRpMsg_ChID chID, UINT32 size);
extern SINT32 zDrvRpMsg_ReadLockIrq(const T_ZDrvRpMsg_Msg *pMsg);
#endif
/**************************************************************************
* ȫֳ/
**************************************************************************/

/**************************************************************************
* 궨
**************************************************************************/
#define ZOSS_RAMDUMP_USB_POLL_CNT        100
#define ZOSS_RAMDUMP_ICP_CHANNEL_SIZE   0x2800
#define ZOSS_RAMDUMP_ICP_DATA_SIZE(len) (min((len),(ZOSS_RAMDUMP_ICP_CHANNEL_SIZE/2)))

/**************************************************************************
* ݽṹ
**************************************************************************/

/**************************************************************************
* ֲԭ
**************************************************************************/

/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
* ȫֺʵ
**************************************************************************/
#ifdef _USE_CP_USB
/**************************************************************************
 * ƣzOss_RamdumpUsbInit
 * ramdump USB ʼ.
 * ˵
 *           (IN)
 *              
 *           (OUT)
 *              
 *  ֵ
 * ˵
 **************************************************************************/
VOID zOss_RamdumpUsbInit(VOID)
{
    zDrvUsbPoll_Init();                 /* ʼUSB        */
    while (!zDrvUsbPoll_isConnect()) ;  /* ѯUSBǷ  */
}

/**************************************************************************
 * ƣzOss_RamdumpUsbReadData
 * ָͨ.
 * ˵
 *           (IN)
 *              buffer: ݵbufferָ룻
 *              size  : ݵĴС
 *           (OUT)
 *              
 *  ֵ
 * ˵
 **************************************************************************/
VOID zOss_RamdumpUsbReadData(UINT8 *buffer, UINT32 size)
{
    UINT32 count = 0;

    do
    {
        zDrvUsbPoll_Isr();
        count = (UINT32)zDrvUsbPoll_Read(buffer, size);
        if( size <= count)
        {
            break;
        }        
        buffer += count;
        size -=count;
    }
    while (size > 0);
}

/***************************************************************************
 * ƣzOss_RamdumpIoWriteData
 * дݵָͨ.
 * ˵(IN):
 *              buffer: ݵbufferָ룻
 *              size  : ݵĴС
 *           (OUT):
 *              ޣ
 *   ֵ
 * ˵
 ****************************************************************************/
VOID zOss_RamdumpUsbWriteData(UINT8 *buffer, UINT32 size)
{
    UINT32 count = 0;

    while (size > 0)
    {
        zDrvUsbPoll_Isr();
        count = (UINT32)zDrvUsbPoll_Write(buffer, size);
        if( size <= count)
        {
            break;
        }
        
        buffer += count;
        size -=count;
    }
}

/***************************************************************************
 * ƣzOss_RamdumpIoFinish
 * Ramdumpļ
 * ˵(IN):
 *           (OUT):
 *   ֵ
 * ˵
 ****************************************************************************/
VOID zOss_RamdumpUsbFinish(VOID)
{
    UINT32  i;
    
    for (i = 0; i < ZOSS_RAMDUMP_USB_POLL_CNT; i++)  /* ȴݷ */
    {
        zDrvUsbPoll_Isr();
    }
}

/***************************************************************************
 * ƣzOss_RamdumpSetUsbOpt
 * Usbͨ;
 * ˵(IN):
 *           (OUT):
 *   ֵ
 * ˵
 ****************************************************************************/
VOID zOss_RamdumpSetUsbOpt(VOID)
{
    T_zOss_RamdumpIoOpt hook = {zOss_RamdumpUsbInit, zOss_RamdumpUsbReadData, zOss_RamdumpUsbWriteData, zOss_RamdumpUsbFinish};

    zOss_RamdumpSetIoOpt(hook);
    return;
}
#else
/**************************************************************************
 * ƣzOss_RamdumpIcpReadData
 * ָͨ.
 * ˵
 *           (IN)
 *              buffer: ݵbufferָ룻
 *              size  : ݵĴС
 *           (OUT)
 *              
 *  ֵ
 * ˵
 **************************************************************************/
static VOID zOss_RamdumpIcpReadData(UINT8 *buffer, UINT32 size)
{
    T_ZDrvRpMsg_Msg icpMsg = {0};
    UINT8  *pBuf           = buffer;
    SINT32 retCode         = RPMSG_CHANNEL_NOMSG;
    
    icpMsg.actorID = ICP_MSG_ACTOR_A9;
    icpMsg.chID    = RAMDUMP;
    icpMsg.buf     = buffer;
    icpMsg.len     = size;
    icpMsg.flag    |= RPMSG_READ_POLL;
    
    do
    {
        retCode = zDrvRpMsg_ReadLockIrq(&icpMsg);
        if(retCode != RPMSG_CHANNEL_NOMSG)
        {
            if( size <= icpMsg.len)
            {
                break;
            }
            pBuf       =  icpMsg.buf;
            pBuf       += icpMsg.len;
            icpMsg.buf =  pBuf;
            size       -= icpMsg.len;
            icpMsg.len =  size;
        }        
    }while (size > 0);
}

/***************************************************************************
 * ƣzOss_RamdumpIcpWriteData
 * дݵָͨ.
 * ˵(IN):
 *              buffer: ݵbufferָ룻
 *              size  : ݵĴС
 *           (OUT):
 *              ޣ
 *   ֵ
 * ˵
 ****************************************************************************/
static VOID zOss_RamdumpIcpWriteData(UINT8 *buffer, UINT32 size)
{
    T_ZDrvRpMsg_Msg icpMsg = {0};
    SINT32 retCode         = RPMSG_SPACE_NOT_ENOUGH;
        
    icpMsg.actorID  = ICP_MSG_ACTOR_A9;
    icpMsg.chID     = RAMDUMP;
    icpMsg.buf      = buffer;
    icpMsg.len      = ZOSS_RAMDUMP_ICP_DATA_SIZE(size);
    icpMsg.flag     |= RPMSG_WRITE_INT;

    do
    {
        retCode = zDrvRpMsg_WriteLockIrq(&icpMsg);
        if(retCode>0)
        {
            buffer      += retCode;
            size        -= retCode;
            icpMsg.buf  = buffer;
            icpMsg.len  = ZOSS_RAMDUMP_ICP_DATA_SIZE(size);
        }
    }while ((retCode == RPMSG_SPACE_NOT_ENOUGH)||(size > 0));
}

/**************************************************************************
 * ƣzOss_RamdumpIcpInit
 * ramdump Icp ʼ.
 * ˵
 *           (IN)
 *              
 *           (OUT)
 *              
 *  ֵ
 * ˵
 **************************************************************************/
static VOID zOss_RamdumpIcpInit(VOID)
{
    SINT32 retCode  = DRV_SUCCESS;
    UINT8  pBuff[]  = "ramdump";
    
    retCode = zDrvRpMsg_CreateLockSaveChannel(ICP_MSG_ACTOR_A9, RAMDUMP, ZOSS_RAMDUMP_ICP_CHANNEL_SIZE);
    zOss_ASSERT(retCode == DRV_SUCCESS);

    /*ͨдһݱʾͨ*/
    zOss_RamdumpIcpWriteData(pBuff, strlen((const char *)pBuff));    
}

/***************************************************************************
 * ƣzOss_RamdumpIcpFinish
 * Ramdumpļ
 * ˵(IN):
 *           (OUT):
 *   ֵ
 * ˵
 ****************************************************************************/
static VOID zOss_RamdumpIcpFinish(VOID)
{

}

/***************************************************************************
 * ƣzOss_RamdumpSetIcpOpt
 * ICPͨ;
 * ˵(IN):
 *           (OUT):
 *   ֵ
 * ˵
 ****************************************************************************/
VOID zOss_RamdumpSetIcpOpt(VOID)
{
    T_zOss_RamdumpIoOpt hook = {zOss_RamdumpIcpInit, zOss_RamdumpIcpReadData, zOss_RamdumpIcpWriteData, zOss_RamdumpIcpFinish};
	
    zOss_RamdumpSetIoOpt(hook);
    return;
}
#endif

#ifdef __cplusplus
}
#endif

