/*******************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
********************************************************************************
* ģ   : P98_VSIM
*    : vsim_icp.c
* ļ : 
* ʵֹ : vsimݹӿ
*      : 
*      : V1.0
*  : 2016-08-06
* ˵ : 
*******************************************************************************/

/*******************************************************************************
* #include
*******************************************************************************/
#include "oss_api.h"
#include "drv_api.h"
#include "drvs_rpmsg.h"
#include "drvs_icp.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
* 궨
*******************************************************************************/
#define VSIM_ICP_CHANNEL_SIZE    (1 * 1024)
#define VSIM_ICP_CHANNEL         (VSIM)
#define VSIM_ICP_MAX_SIZE        (5 * 1024)
#define VSIM_ICP_MSG_HEADER_SIZE (16)
#define VSIM_ICP_BUF_SIZE        (VSIM_ICP_MAX_SIZE-VSIM_ICP_MSG_HEADER_SIZE)

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/

typedef struct
{
    UINT32 addr;
    UINT32 len;
    CHAR   buf[VSIM_ICP_BUF_SIZE];
} icp_msg_data_t;

typedef struct
{
    unsigned long  cmd;
    unsigned long  total;
    icp_msg_data_t data;
} icp_msg_t;

enum
{
    VSIM_CMD_RECOVERY = 1,
	VSIM_CMD_WRITE_FACTORY,
	VSIM_CMD_WRITE_SPECIAL,
};

/*******************************************************************************
* ⲿ
*******************************************************************************/


/*******************************************************************************
* ֲԭ
*******************************************************************************/
static UINT32 vsim_icp_buf[VSIM_ICP_MAX_SIZE / sizeof(UINT32)];

/*******************************************************************************
* ȫֳ/
*******************************************************************************/


/*******************************************************************************
* ֲʵ
*******************************************************************************/

/*******************************************************************************
* ƣ vSIM_Resume_Data
*  ָ
* ˵ (IN)
*                index: :
*                index = VSIM_WORK_AREA:   ָ
*                index = VSIM_BACKUP_AREA: ָ  
*                index = VSIM_BOTH_AREA:   ָͱ  
*            (OUT)
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
*******************************************************************************/
static VOID vsim_icp_read_blocked(SINT32 args)
{
    UINT32          ret   = ZOSS_ERROR;
    CHAR            *pBuf = NULL;
    CHAR            *pTmp = NULL;
    UINT32           len  = 0;
    icp_msg_t       *pMsg = NULL;    
    T_ZDrvRpMsg_Msg msgRead;
    T_ZDrvRpMsg_Msg msgWrite;

    msgRead.actorID = ICP_MSG_ACTOR_A9;
    msgRead.chID    = VSIM_ICP_CHANNEL;
    msgRead.buf     = vsim_icp_buf;

    msgWrite.actorID = ICP_MSG_ACTOR_A9;
    msgWrite.chID    = VSIM_ICP_CHANNEL;

    while(1)
    {
        ret = ZOSS_ERROR;
        msgRead.flag = ~RPMSG_READ_POLL;
        msgRead.len  = sizeof(vsim_icp_buf);

        do
        {
            ret = zDrvRpMsg_Read(&msgRead);
            if (ret == RPMSG_CHANNEL_INEXISTANCE)
                break;
            zOss_ASSERT(ret > 0);

            pMsg = (icp_msg_t *)vsim_icp_buf;
            if(pMsg->total)
            {
                if(!pBuf)
                {
                    pBuf = zOss_Malloc(pMsg->total);
                    if (pBuf == NULL)
                        zOss_ASSERT(pBuf != NULL);

                    pTmp = pBuf;
                    len = pMsg->total;
                }
                zOss_Memcpy(pTmp, pMsg->data.buf, pMsg->data.len);
                pTmp += pMsg->data.len;
                len -= pMsg->data.len;

                msgWrite.buf = &ret;
                ret = 0;
                msgWrite.flag = RPMSG_WRITE_INT;
                msgWrite.len = sizeof(ret);
                ret = zDrvRpMsg_Write(&msgWrite);
                zOss_ASSERT(ret > 0);
            }
        }while(len > 0);

        if (ret == RPMSG_CHANNEL_INEXISTANCE)
            continue;

        switch (pMsg->cmd)
        {
            case VSIM_CMD_RECOVERY:
                ret = zOss_vSIMRecovery();
                break;

            case VSIM_CMD_WRITE_FACTORY:                    
                ret = zOss_vSIMFacWrite((VOID *)pBuf, pMsg->total);
                ret = 0;
                break;

            case VSIM_CMD_WRITE_SPECIAL:
                ret = zOss_vSIMDataWrite(pMsg->data.addr, (VOID *)pBuf, pMsg->total);
                ret = 0;
                break;

            default:
                break;
        }

        if (pBuf != NULL)
        {
            zOss_Free(pBuf);
            pBuf = NULL;
        }

        msgWrite.buf = &ret;
        msgWrite.flag = RPMSG_WRITE_INT;
        msgWrite.len = sizeof(ret);
        ret = zDrvRpMsg_Write(&msgWrite);
        zOss_ASSERT(ret > 0);

        zOss_Memset(vsim_icp_buf, 0, VSIM_ICP_MAX_SIZE);
    }
}


/*******************************************************************************
* ȫֺʵ
*******************************************************************************/
/*******************************************************************************
* ƣ zOss_vSIMAgtInit
*  VSIMʼ
* ˵ 
*   ֵ ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
* ˵
*******************************************************************************/
VOID zOss_vSIMAgtInit(VOID)
{
    SINT32         ret;
    ZOSS_THREAD_ID threadID;
    
    ret = zDrvRpMsg_CreateChannel(ICP_MSG_ACTOR_A9, VSIM_ICP_CHANNEL, VSIM_ICP_CHANNEL_SIZE);
    zOss_ASSERT(ret == DRV_SUCCESS);


    threadID = zOss_CreateThread("vsim_icp_read_thread", vsim_icp_read_blocked, 0, 4 * 1024, 25, 1, 1);
    zOss_ASSERT(threadID != NULL);
}

#ifdef __cplusplus
}
#endif

