/**
 * 
 * @file      amtnv.h
 * @brief     
 *            This file is part of FTM.
 *            AMTģNVӿ
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2018/04/28  1.0      liu.xin        Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#ifndef __AMTNV_H
#define __AMTNV_H
#include "os_type_def.h"
#include "RONvParam_AMT.h"
#include "RWNvConfig.h"


/**
 * @brief дnvro
 * @param dwStart nvʼַƫ,0 ~ 2M-1 bytes
 * @param dwLen nv,1 ~ 2M bytes
 * @param from д
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
unsigned int amt_nvro_write(unsigned int dwStart, unsigned int dwLen, unsigned char *from);

/**
 * @brief nvro
 * @param dwStart nvʼַƫ,0 ~ 2M-1 bytes
 * @param dwLen nv,1 ~ 2M bytes
 * @param to 
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
unsigned int amt_nvro_read(unsigned int dwStart, unsigned int dwLen, unsigned char *to);

/**
 * @brief дһNVRO
 * @param nvParam NV
 * @param NvItemData дݵĵַ
 * @param NvItemLen ݳ
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
int  amt_write_nv_item(NvParam_AMT nvParam, UINT8 *NvItemData, UINT32 NvItemLen);

/**
 * @brief һNVRO
 * @param nvParam  NV
 * @param NvItemData 
 * @param NvItemLen  ݳ
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
int  amt_read_nv_item(NvParam_AMT nvParam,UINT8 *NvItemData, UINT32 NvItemLen);

/**
 * @brief дԱ־λ
 * @param nvParam  Ա־λöֵ
 * @param NvItemData д
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
int  amt_write_test_flag_item(NvParam_AMTFlags nvParam,UINT8 *NvItemData);

/**
 * @brief Ա־λ
 * @param nvParam  Ա־λöֵ
 * @param NvItemData 
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
int  amt_read_test_flag_item(NvParam_AMTFlags nvParam,UINT8 *NvItemData);

/**
 * @brief NVROûԶ
 * @param dwStart nvʼַƫ,0 ~ 1023
 * @param dwLen nv,1 ~ 1024 bytes
 * @param from д
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
int  amt_nvro_user_write(UINT32 dwStart, UINT32 dwLen, UINT8* from);

/**
 * @brief NVROûԶд
 * @param dwStart nvʼַƫ,0 ~ 1023
 * @param dwLen nv,1 ~ 1024 bytes
 * @param from 
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
int  amt_nvro_user_read(UINT32 dwStart, UINT32 dwLen, UINT8* to);

/**
 * @brief NVROοԶд
 * @param dwStart nvʼַƫ,0 ~ 1023
 * @param dwLen nv,1 ~ 1024 bytes
 * @param from д
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
int amt_nvro_ref_write(UINT32 dwStart, UINT32 dwLen, UINT8* from);

/**
 * @brief NVROοԶ
 * @param dwStart nvʼַƫ,0 ~ 1023
 * @param dwLen nv,1 ~ 1024 bytes
 * @param to 
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
int amt_nvro_ref_read(UINT32 dwStart, UINT32 dwLen, UINT8* to);

/**
* @brief ӦòжϵǰǷamtģʽ
* @param 
* @return 1 amtģʽ
* @return 0 normalģʽ
* @note   
* @warning 
*/
int is_amt_mode(void);

/**
 * @brief bootģʽ
 * @param bootmode 2ֽڵıʶ: 
 *              {0x54,0x00} : user,
 *              {0x54,0x01} : debug,
 *              {0x54,0x02} : factory,
 *              {0x54,0x4D} : amt,
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
unsigned int amt_set_bootmode(unsigned char  bootmode[]);

/**
 * @brief õؼ־λ
 * @param batdet_value ؼ־
 *             0 : ,
 *             1 : 
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
unsigned int amt_set_batdet_flag(int batdet_value);

/**
 * @brief ؼ־λ
 * @param pbatdet_value ĵؼ־
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
unsigned int amt_get_batdet_flag(int *pbatdet_value);

/**
 * @brief amtģʽ½AT־
 * @param bootmode 2ֽڵıʶ: 
 *              {0x41,0x54} : amtģʽ½AT
 * @return 0 ɹ  
 * @return -1 ʧ
 * @note   
 * @warning 
 */
unsigned int amt_set_amt_atmode(unsigned char  bootmode[],unsigned char  atmode[]);
unsigned int is_amt_atmode();





#endif // __AMTNV_H
