#ifndef __LPA_INNER_H__
#define __LPA_INNER_H__

#include <openssl/ssl.h>
#include <openssl/bio.h>

#include "lpa_api.h"

#include "cjson.h"
#include "md5.h"
#include "errno.h"

#define MAX_IMEI_LEN 17
#define MAX_TRANSID_LEN 41

#define CSIM_REQ_LEN 600 
#define CSIM_RESP_LEN 600 
#define APDU_REQ_LEN 520 //tag10+255*2+00
#define APDU_RESP_LEN 520 //0xFF*2+sw1+sw2=514
#define APDU_BYTE_LEN 261 //csimЭջ󳤶255 APDU_RESP_LEN/2+1
#define MIN_APDU_LEN 16 //80E2910004TG01XX

#define SMDP_HTTP_MAX_LEN 0x20000 //128K
#define TRIG_HTTP_MAX_LEN 0x2000 //8K
#define HTTP_CHUNKED_FLAG 0x7FFFFFFF




#define ICCID_LEN 20

//#define CSIM_APDU_LEN 511  //csimЭջ󳤶255

#ifndef BOOL
#define BOOL 	  	unsigned char
#endif
#ifndef TRUE
#define	TRUE	1
#endif
#ifndef FALSE
#define	FALSE	0
#endif


typedef struct
{
    int sock_fd;
    SSL_CTX *ssl_ct;
    SSL *ssl;
 
    //url Ϣ
    char *host;
    char *path;
    int port;
} https_context_t;

//https
int https_init(https_context_t *context);
int https_uninit(https_context_t *context);
int https_read(https_context_t *context,void* buff,int len);
int https_write(https_context_t *context,const void* buff,int len);
int https_get_status_code(https_context_t *context, int *content_len);
int https_read_content(https_context_t *context,char *resp_contet,int max_len);

//es10b
char *GetEUICCChallenge(void);
char *GetEUICCInfo(BOOL flag);
char *AuthenticateServer(char *signd1Hex, char *signature1Hex, char *ciPKIdHex, char *certificateHex, char *matchingId, char *imeiHex);
char *PrepareDownload(char *transId ,char *signed2Hex,char *signature2Hex,char *certiHex,char *confirmCode);
char *LoadBoundProfilePackage(char * bppHex);


//es10c
char *EnableProfile(char *iccidHex);
char *EUICCMemoryReset(void);
char *GetProfilesInfo(char *iccidHex);
char *DisableProfile(char *iccidHex);
char *DeleteProfile  (char *iccidHex);
char *GetEID(void);

//es9+
char *InitiateAuthentication(char *euiccChallenge, char *euiccInfo1, char *smdpAddress);
char *AuthenticateClient(char *transactionId,char *authSerRespHex);
char *GetBoundProfilePackage (char *transactionId, char *predlRespHex);
char *HandleNotification(char *pnfHex);

//channel
char *OpenLogicalChannel(void);
int CloseLogicalChannel(int chan_id);


//edcode
char *lpa_tlv_get_val_by_tag(unsigned char *apdu_byte, int apdu_len, unsigned int tag);
char *lpa_tag_apdu_from_atresp(char *atres_apdu, unsigned int tag);
char *lpa_get_apdu_from_atresp(char *atres_apdu);
int lpa_csim_resp_code(char *atres_apdu, int *second_len);
int lpa_csim_resp_normal(char *atres_apdu);

int string2bytes(const char* pSrc, unsigned char* pDst, int nSrcLength);
int bytes2string(const unsigned char* pSrc, char* pDst, int nSrcLength);

char *lpa_base64_encode(const char*data, int data_len);
unsigned char *lpa_base64_decode(const unsigned char *src, int len, int *out_len);

void lpa_trans_iccid(char *iccid, int len);

#endif
