#ifndef OS_ADAPTER_H
#define OS_ADAPTER_H

#include <stdio.h>
#include "os_type.h"
#include "backlight.h"
#include "display.h"

#define NULL        ((ZVOID *)0)

typedef unsigned int size_t ;
//typedef int FILE;
typedef long time_t;



int    tp_fclose(FILE *stream);

int    tp_feof(FILE *stream);

int    tp_fexist(char *filename);

int    tp_fflush(FILE *stream);

int    tp_flength(FILE *stream);

FILE*  tp_fopen (const char *filename,const char *mode);

size_t tp_fread (void *data, size_t size, size_t count, FILE *stream);

int    tp_fseek(FILE *stream,long offset,int whence);

int    tp_ftell(FILE *stream);

size_t tp_fwrite (const void *data, size_t size, size_t count, FILE *stream);

MAN_LCD_MODE  tp_man_lcd_get_mode(ZVOID);
ZSINT32 tp_man_alarm_power_off(ZBOOL enable);

#endif

