#ifndef _ZCORE_CTRL_SCROLLVIEW_H_
#define _ZCORE_CTRL_SCROLLVIEW_H_

#include "zcore_type.h" 
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */


#define CTRL_SCROLLVIEW           ("scrollview")

#define CTRL_SCROLLWND            ("scrollwnd")


typedef GHANDLE HSVITEM;

#define SVS_NOTIFY              0x0001L
#define SVS_UPNOTIFY            0x0002L
#define SVS_AUTOSORT            0x0004L
#define SVS_LOOP                0x0008L

#define SVS_HINT       0x0040L

typedef enum
{
    NORMAL_ITEM = 0,
    HINT_ITEM,
    DUMP_ITEM,    
}ItemAttr;

ZSINT32 GUIAPI DefaultContainerProc (HWND hWnd, ZSINT32 message, WPARAM wParam, LPARAM lParam);
ZDWORD mglist_get_item_adddata (GHANDLE hi);
ZDWORD scrollview_get_item_adddata (HSVITEM hsvi);
ZSINT32 scrollview_get_item_index (HWND hWnd, HSVITEM hsvi);
ZBOOL scrollview_is_item_hilight (HWND hWnd, HSVITEM hsvi);
ZBOOL scrollview_is_item_selected (HSVITEM hsvi);
ZSINT32 scrollview_set_item_height (HWND hWnd, HSVITEM hsvi, ZSINT32 height);

typedef ZSINT32  (*SVITEM_INITFUNC)    (HWND hWnd, HSVITEM hsvi);
typedef ZVOID (*SVITEM_DESTROYFUNC) (HWND hWnd, HSVITEM hsvi);
typedef ZVOID (*SVITEM_DRAWFUNC) (HWND hWnd, HSVITEM hsvi, HDC hdc, RECT *rcDraw);

typedef ZVOID (*SVITEM_ADDHINTITEMFUNC) (HWND hWnd, HSVITEM hsvi, ZSINT32 itemIndex, ZSINT32 itemHeight, ItemAttr ItemAttr);
/**
 * \var typedef int (*SVITEM_CMP) (HSVITEM hsvi1, HSVITEM hsvi2)
 * \brief Type of the scrollview item compare function
 */
typedef ZSINT32 (*SVITEM_CMP) (HSVITEM hsvi1, HSVITEM hsvi2);


/**
 * Structure which defines a container.
 */
typedef struct _CONTAINERINFO
{
    WNDPROC     user_proc;              /** user-defined window procedure of the container */

    ZSINT32         controlnr;              /** number of controls */
    PCTRLDATA   controls;               /** pointer to control array */

    ZDWORD       dwAddData;              /** additional data */
} CONTAINERINFO;
typedef CONTAINERINFO* PCONTAINERINFO;


/** structure of item operations */
typedef struct _svitem_operations
{
    SVITEM_INITFUNC     initItem;     /** called when an scrollview item is created */
    SVITEM_DESTROYFUNC  destroyItem;  /** called when an item is destroied */
    SVITEM_DRAWFUNC     drawItem;     /** call this to draw an item */
    SVITEM_DRAWFUNC     drawHintItem;     /** call this to draw an hint item */
} SVITEMOPS;
typedef SVITEMOPS* PSVITEMOPS;

/** structure of the scrollview item info */
typedef struct _SCROLLVIEWITEMINFO
{
    ZSINT32        nItem;           /** index of item */
    ZSINT32        nItemHeight;     /** height of an item */
    ItemAttr      itemAttr;           /**attribute of an item*/
    ZDWORD      addData;         /** item additional data */
} SVITEMINFO;
typedef SVITEMINFO* PSVITEMINFO;


 /**
 * Ϣ:SVM_ADDITEM
 * Ϣ:ScrollViewһĿ
 * 
 * :
 *         wParam:phsvi
 *         lParam:(LPARAM)&svii
 * ֵ:
 *                   ʧܷ-1
 */
#define SVM_ADDITEM             0xF300

 /**
  * Ϣ:   SVM_DELITEM
  * Ϣ: ScrollViewSVM_DELITEMϢ 
  * ˵:
  *            (IN)wParam: (WPARAM)nItem;
  *            (IN)lParam: (LPARAM)hsvi;
  *   ֵ: ɹ0ʧܷ-1
  * ˵: hsviΪЧʱҲ0
  **/
#define SVM_DELITEM             0xF301

 /**
  * Ϣ:   SVM_SETITEMDRAW
  * Ϣ: ScrollView Ļƻص
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: (LPARAM)pfn;
  *   ֵ: ؾɵĻƺָ
  * ˵: 
  **/
#define SVM_SETITEMDRAW         0xF302


 /**
  * Ϣ:   SVM_SETHINTITEMDRAW
  * Ϣ: ScrollView hintĿƻص
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: (LPARAM)pfn;
  *   ֵ: ؾɵĻƺָ
  * ˵: 
  **/
#define SVM_SETHINTITEMDRAW         0xF339


 /**
  * Ϣ:   SVM_SETHINTITEMADD
  * Ϣ: ScrollView hintĿӻص
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: (LPARAM)pfn;
  *   ֵ: ؾɵhintĿӺָ
  * ˵: 
  **/
#define SVM_SETHINTITEMADD         0xF440


 /**
  * Ϣ:   SVM_SETHINTITEMADD
  * Ϣ: ScrollView hintĿӻص
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: (LPARAM)pfn;
  *   ֵ: ؾɵhintĿӺָ
  * ˵: 
  **/
#define SVM_SETHINTITEM_DSTEIGHT        0xF441

/**
 * Ϣ:   SVM_SETDEFAULT_HINT_ITEM
 * Ϣ: ScrollView ȱʡhintĿ
 * ˵:
 *            (IN)wParam: 0;
 *            (IN)lParam: (LPARAM)ҪhintĿĿ;
 *   ֵ: ӵhintĿֵ
 * ˵: 
 **/
#define SVM_SETDEFAULT_HINT_ITEM        0xF442

 /**
  * Ϣ:   SVM_ADDCTRLS
  * Ϣ: ScrollView ӿؼ
  * ˵:
  *            (IN)wParam: (WPARAM)itemNr;
  *            (IN)lParam: (LPARAM)pctrls;
  *   ֵ: ɹ0-1
  * ˵: 
  **/
#define SVM_ADDCTRLS            0xF303

 /**
  * Ϣ:   SVM_SETCONTWIDTH
  * Ϣ: ScrollView ݿ
  * ˵:
  *            (IN)wParam: cont_w;
  *            (IN)lParam: 0;
  *   ֵ: úݿȣ
  *                      0ʾʧܣ
  *                      ĿԭпͬҲ
  *                      0
  * ˵: 
  **/
#define SVM_SETCONTWIDTH        0xF306

 /**
  * Ϣ:   SVM_SETCONTHEIGHT
  * Ϣ: ScrollView ݸ߶
  * ˵:
  *            (IN)wParam: cont_h;
  *            (IN)lParam: 0;
  *   ֵ: úݸ߶ȣ
  *                      0ʾʧܣ
  *                      ĸ߶ԭи߶ͬҲ
  *                      0
  * ˵: 
  **/
#define SVM_SETCONTHEIGHT       0xF307

 /**
  * Ϣ:   SVM_GETCTRL
  * Ϣ: ͨؼIDÿؼ
  * ˵:
  *            (IN)wParam: id;
  *            (IN)lParam: 0;
  *   ֵ: ɹؿؼ,򷵻0
  * ˵: 
  **/
#define SVM_GETCTRL             0xF308

 /**
  * Ϣ:   SVM_RESETCONTENT
  * Ϣ: ػScrollview
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: ɹ,ʧܷ-1
  * ˵: 
  **/
#define SVM_RESETCONTENT        0xF309

 /**
  * Ϣ:   SVM_SETITEMOPS
  * Ϣ: ĿĻص
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: (LPARAM)iop;
  *   ֵ: ɹ0,ʧܷ-1
  * ˵: 
  **/
#define SVM_SETITEMOPS          0xF30a

 /**
  * Ϣ:   SVM_GETMARGINS
  * Ϣ: ȡScrollViewıֵ߽
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: (LPARAM)&rcMargin ;
  *   ֵ: 0
  * ˵: 
  **/
#define SVM_GETMARGINS            0xF30b

 /**
  * Ϣ:   SVM_SETMARGINS
  * Ϣ: ScrollViewıֵ߽
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: (LPARAM)rcMargin ߽;
  *   ֵ: ɹ0
  * ˵: 
  **/
#define SVM_SETMARGINS            0xF311

 /**
  * Ϣ:   SVM_GETLEFTMARGIN
  * Ϣ: ȡScrollViewֵ߽
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: ɹֵ߽,ʧܷ-1
  * ˵: 
  **/
#define SVM_GETLEFTMARGIN         0xF312

 /**
  * Ϣ:   SVM_GETTOPMARGIN
  * Ϣ: ȡScrollViewĶֵ߽
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: ɹضֵ߽,򷵻-1
  * ˵: 
  **/
#define SVM_GETTOPMARGIN          0xF313

 /**
  * Ϣ:   SVM_GETRIGHTMARGIN
  * Ϣ: ȡScrollViewұֵ߽
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: ɹұֵ߽,򷵻-1
  * ˵: 
  **/
#define SVM_GETRIGHTMARGIN        0xF314

 /**
  * Ϣ:   SVM_GETBOTTOMMARGIN
  * Ϣ: ȡScrollViewĵױֵ߽
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: ɹصױֵ߽,򷵻-1
  * ˵: 
  **/
#define SVM_GETBOTTOMMARGIN       0xF315

 /**
  * Ϣ:   SVM_GETVISIBLEWIDTH
  * Ϣ: ȡScrollViewĿӿ
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: ɹؿӿ,򷵻-1
  * ˵: 
  **/
#define SVM_GETVISIBLEWIDTH       0xF316

 /**
  * Ϣ:   SVM_GETVISIBLEHEIGHT
  * Ϣ: ȡScrollViewĿӸ߶
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: ɹؿӸ߶,򷵻-1
  * ˵: 
  **/
#define SVM_GETVISIBLEHEIGHT      0xF317

 /**
  * Ϣ:   SVM_GETCONTWIDTH
  * Ϣ: ȡScrollViewĿ
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: ɹĿ,򷵻-1
  * ˵: 
  **/
#define SVM_GETCONTWIDTH          0xF318

 /**
  * Ϣ:   SVM_GETCONTHEIGHT
  * Ϣ: ȡScrollViewĸ߶
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: ɹĸ߶,򷵻-1
  * ˵: 
  **/
#define SVM_GETCONTHEIGHT         0xF319

 /**
  * Ϣ:   SVM_SETCONTRANGE
  * Ϣ: ScrollViewĿȺ͸߶
  * ˵:
  *            (IN)wParam: cont_w;
  *            (IN)lParam: cont_h;
  *   ֵ: ǰֵı䷵0򷵻-1
  * ˵: 
  **/
#define SVM_SETCONTRANGE          0xF31a

 /**
  * Ϣ:   SVM_GETCONTENTX
  * Ϣ: ȡXƫ
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: ɹؿXƫ,򷵻-1
  * ˵: 
  **/
#define SVM_GETCONTENTX           0xF31b

 /**
  * Ϣ:   SVM_GETCONTENTY
  * Ϣ: ȡYƫ
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: ɹؿYƫ,򷵻-1
  * ˵: 
  **/
#define SVM_GETCONTENTY           0xF31c

 /**
  * Ϣ:   SVM_SETCONTPOS
  * Ϣ: ÿƫ
  * ˵:
  *            (IN)wParam: cont_x;
  *            (IN)lParam: cont_y;
  *   ֵ: ɹ0,򷵻-1
  * ˵: 
  **/
#define SVM_SETCONTPOS            0xF31d

 /**
  * Ϣ:   SVM_GETCURSEL
  * Ϣ: ȡĿֵ
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: ɹصǰֵ
  * ˵: 
  **/
#define SVM_GETCURSEL             0xF31e

 /**
  * Ϣ:   SVM_SELECTITEM
  * Ϣ: ѡлѡָScrollViewеĿ
  * ˵:
  *            (IN)wParam: nItem;
  *            (IN)lParam: bSel;
  *   ֵ: ɹ0,ʧܷ-1
  * ˵: bSelΪTRUEΪѡУFALSEΪѡ
  **/
#define SVM_SELECTITEM            0xF31f

 /**
  * Ϣ:   SVM_SHOWITEM
  * Ϣ: ʹScrollViewĳĿɼ
  * ˵:
  *            (IN)wParam: nItem;
  *            (IN)lParam: hsvi;
  *   ֵ: ɹ0,ʧܷ-1
  * ˵: hsviΪҲ0
  **/
#define SVM_SHOWITEM              0xF320

 /**
  * Ϣ:   SVM_CHOOSEITEM
  * Ϣ: ʹScrollViewĳĿѡ
  * ˵:
  *            (IN)wParam: nItem;
  *            (IN)lParam: hsvi;
  *   ֵ: ɹ0,ʧܷ-1
  * ˵: hsviΪҲ0
  **/
#define SVM_CHOOSEITEM            0xF321

 /**
  * Ϣ:   SVM_SETCURSEL
  * Ϣ: ScrollViewĳĿ
  * ˵:
  *            (IN)wParam: nItem;
  *            (IN)lParam: bVisible,TRUEʹָɼFALSEı
  *                        ָɼ״̬;
  *   ֵ: ɹ0,ʧܷ-1
  * ˵: 
  **/
#define SVM_SETCURSEL             0xF322

 /**
  * Ϣ:   SVM_SETITEMINIT
  * Ϣ: ScrollViewĿĳʼص
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: (LPARAM)pfn;
  *   ֵ: ɹؾɵĳʼ,򷵻NULL
  * ˵: 
  **/
#define SVM_SETITEMINIT            0xF323

 /**
  * Ϣ:   SVM_SETITEMDESTROY
  * Ϣ: ScrollViewĿٺص
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: (LPARAM)pfn;
  *   ֵ: ɹؾɵٺ,򷵻NULL
  * ˵: 
  **/
#define SVM_SETITEMDESTROY        0xF324

 /**
  * Ϣ:   SVM_SETITEMCMP
  * Ϣ: ScrollViewĿıȽϺص
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: (LPARAM)pfn;
  *   ֵ: ɹؾɵıȽϺ,򷵻NULL
  * ˵: 
  **/
#define SVM_SETITEMCMP            0xF327

 /**
  * Ϣ:   SVM_MAKEPOSVISIBLE
  * Ϣ: ʹĳλÿɼ
  * ˵:
  *            (IN)wParam: pos_x;
  *            (IN)lParam: pos_y;
  *   ֵ: 0
  * ˵: 
  **/
#define SVM_MAKEPOSVISIBLE        0xF328

 /**
  * Ϣ:   SVM_SETCONTAINERPROC
  * Ϣ: ScrollwndĴڻص
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: ScrollwndĴڻصָ;
  *   ֵ: ɹؾɵĹ̺,򷵻NULL
  * ˵: 
  **/
#define SVM_SETCONTAINERPROC       0xF329

 /**
  * Ϣ:   SVM_GETFOCUSCHILD
  * Ϣ: ĳĿΪ۽Ŀ
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: ɹ۽Ŀľ
  * ˵: 
  **/
#define SVM_GETFOCUSCHILD          0xF32a

 /**
  * Ϣ:   SVM_GETHSCROLLVAL
  * Ϣ: ȡˮƽֵ
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: ˮƽֵ
  * ˵: 
  **/
#define SVM_GETHSCROLLVAL           0xF32b

 /**
  * Ϣ:   SVM_GETVSCROLLVAL
  * Ϣ: ȡֱֵ
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: شֱֵ
  * ˵: 
  **/
#define SVM_GETVSCROLLVAL           0xF32c

 /**
  * Ϣ:   SVM_GETHSCROLLPAGEVAL
  * Ϣ: ȡˮƽҳ
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: ˮƽҳ
  * ˵: 
  **/
#define SVM_GETHSCROLLPAGEVAL       0xF32d

 /**
  * Ϣ:   SVM_GETVSCROLLPAGEVAL
  * Ϣ: ȡֱҳ
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: شֱҳ
  * ˵: 
  **/
#define SVM_GETVSCROLLPAGEVAL       0xF32e

 /**
  * Ϣ:   SVM_SETSCROLLVAL
  * Ϣ: ˮƽʹֱֵ
  * ˵:
  *            (IN)wParam: hval;
  *            (IN)lParam: vval;
  *   ֵ: 0
  * ˵: 
  **/
#define SVM_SETSCROLLVAL           0xF32f

 /**
  * Ϣ:   SVM_SETSCROLLPAGEVAL
  * Ϣ: ˮƽʹֱҳ
  * ˵:
  *            (IN)wParam: hval;
  *            (IN)lParam: vval;
  *   ֵ: 0
  * ˵: 
  **/
#define SVM_SETSCROLLPAGEVAL       0xF330

 /**
  * Ϣ:   SVM_SORTITEMS
  * Ϣ: ָĶԱȺĿ
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: ȽϺsort_func;
  *   ֵ: sort_funcΪշ-1򷵻0
  * ˵: 
  **/
#define SVM_SORTITEMS              0xF331

 /**
  * Ϣ:   SVM_GETITEMCOUNT
  * Ϣ: ȡScrollViewеĿ
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: Ŀ
  * ˵: 
  **/
#define SVM_GETITEMCOUNT           0xF332

 /**
  * Ϣ:   SVM_GETITEMADDDATA
  * Ϣ: ȡScrollViewеָĿ
  * ˵:
  *            (IN)wParam: nItem;
  *            (IN)lParam: hsvi;
  *   ֵ: Ŀָ
  * ˵:hsviΪʹhsviȡݣ
  *                hsviΪʱʹnItemȡ
  **/
#define SVM_GETITEMADDDATA         0xF333

 /**
  * Ϣ:   SVM_SETITEMADDDATA
  * Ϣ: ScrollViewеָĿ
  * ˵:
  *            (IN)wParam: nItem;
  *            (IN)lParam: addData;
  *   ֵ: Ŀɵָ,
  *           nItemΪЧ򷵻0
  * ˵: 
  **/
#define SVM_SETITEMADDDATA         0xF334

 /**
  * Ϣ:   SVM_REFRESHITEM
  * Ϣ: ˢScrollViewеָĿ
  * ˵:
  *            (IN)wParam: nItem;
  *            (IN)lParam: hsvi;
  *   ֵ: 0
  * ˵: hsviΪҲ0
  **/
#define SVM_REFRESHITEM            0xF335

 /**
  * Ϣ:   SVM_SETITEMHEIGHT
  * Ϣ: ָĿĸ߶
  * ˵:
  *            (IN)wParam: nItem;
  *            (IN)lParam: height;
  *   ֵ: ظĿɵĸ߶
  * ˵: 
  **/
#define SVM_SETITEMHEIGHT         0xF336

 /**
  * Ϣ:   SVM_GETFIRSTVISIBLEITEM
  * Ϣ: ȡһĿ
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: صһĿ
  * ˵: 
  **/
#define SVM_GETFIRSTVISIBLEITEM   0xF337

 /**
  * Ϣ:   SVM_CANCELCURSEL
  * Ϣ: ȡǰĿѡ״̬
  * ˵:
  *            (IN)wParam: 0;
  *            (IN)lParam: 0;
  *   ֵ: 0
  * ˵: 
  **/

#define SVM_CANCELCURSEL          0xF338

/** indicates clicking on the item */
#define SVN_CLICKED             1

/** indicates the hilighted item changed */
#define SVN_SELCHANGED          2

/** indicates the hilighted item changing */
#define SVN_SELCHANGING			4

/** ֪ͨڵɿ
Ϊ*/
#define SVN_CLICKEDUP 			6
/** ֪ͨڵбλ 
Ϊλ*/
#define SVN_DOWNPOS			7

/** ֪ͨɿбλ 
Ϊλ*/
#define SVN_UPPOS			8

/*֪ͨscrollviewǰĿ*/
#define SVN_ITEM_CLICKED    999
/*֪ͨscrollviewǰѾͷŵĿ*/
#define SVN_ITEM_CLICKUP    110

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif /* _ZCORE_CTRL_SCROLLVIEW_H_ */

