#ifndef _ZCORE_CTRL_SCROLLVIEW_IMPL_H_
#define _ZCORE_CTRL_SCROLLVIEW_IMPL_H_
/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include <assert.h>
#include "zcore_type.h"
#include "listmodel.h"
/**************************************************************************
 *                         궨                                         *
 **************************************************************************/
#define SV_LEFTMARGIN           5
#define SV_TOPMARGIN            5
#define SV_RIGHTMARGIN          5
#define SV_BOTTOMMARGIN         5
#define SV_DEF_ITEMHEIGHT       16

#define TEST_SCROLL_THUMBTOUCH  0x0001
#define TEST_SCROLL_TEXT_SELECTED 0x0002
/**************************************************************************
 *                                                                *
 **************************************************************************/

/** 
 * ṹ: SVITEMDATA
 *   : ScrollViewĿ 
 **/
typedef struct _sv_itemdata
{
    MgItem mgitem;
    ZSINT32  nItemHeight;   /* height of an item */

    ItemAttr itemAttr;  /*attribute of an item*/

} SVITEMDATA;

typedef SVITEMDATA* PSVITEMDATA;

/** 
 * ṹ: SVLIST
 *   : ScrollViewб 
 **/
typedef struct _svlist_data
{
    MgList mglist;  
    ZSINT32 nDefItemHeight;   /* default line height */

} SVLIST;

typedef SVLIST* PSVLIST;


typedef enum
{
    STATE_FOLD,
    STATE_FOLDING,
    STATE_UNFOLDING,
    STATE_UNFOLD,

    NUM_FOLD_STATE
    
}FOLD_STATE;

/**
*ṹ: SVCONTROL
*: ScrollViewչʱĹݣڼ¼ǰչ״̬
**/
typedef struct _svctrl_data
{
    ZBOOL bStyleFold;                   /*ʶscrollviewؼʱǷչķ*/
    FOLD_STATE foldState;           /*ʶǰScrollViewhint*/
    
    ZSINT32    nHinted;                         /*ǰչֵ*/
    ZSINT32    nCurHintIndex;              /* ǰչֵ*/
    ZSINT32    nCurIndex;                    /*ǰеѡֵ*/

    ZSINT32    nCurHeight;                  /*hintĵǰ߶*/
    ZSINT32    nDstHeight;                  /*hintĿĸ߶*/

} SVCONTROL;

typedef SVCONTROL* PSVCONTROL;




/** 
 * ṹ: SVDATA
 *   : ScrollView 
 * ӿ  : svdata_init : 캯
 *         svdata_destroy: 
 **/
typedef struct _scrvwdata
{
    SCRDATA scrdata;
    SVLIST  svlist;

	POINT pFirstPos;
	ZDWORD     flags; 

    ZSINT32 (*svdata_init)    (HWND hWnd,struct _scrvwdata * psvdata);
    ZSINT32 (*svdata_destroy) (struct _scrvwdata * psvdata);
} SVDATA;

typedef SVDATA *PSVDATA;

#define psvscr ((PSCRDATA)pscrollviewdata)
#define hsvwnd (psvscr->hSV)

/** 
 * ScrollView
 **/
#define SV_ASSERT(condition) assert(condition); 

/* ------------------------- external api -------------------------- */
/**
 * ScrollViewϢĬϴ
 **/
 ZSINT32     ScrollViewCtrlProc       (HWND hWnd, ZSINT32 message, WPARAM wParam, LPARAM lParam);
/**
 * ScrollViewʼ
 **/
 ZSINT32     scrollview_init          (HWND hWnd, PSVDATA psv);
/**
 * ScrollViewٴ
 **/
 ZVOID    scrollview_destroy       (PSVDATA psvdata);
/**
 * ScrollViewĿ 
 **/
 HSVITEM scrollview_add_item      (HWND hWnd, PSVDATA psvdata, HSVITEM hsvi, PSVITEMINFO pii, ZSINT32 *idx);
/**
 * ScrollViewָĿǰĿ
 **/
 HSVITEM scrollview_add_item_ex   (HWND hWnd, PSVDATA psvdata, HSVITEM hsvi, 
                                   HSVITEM nexthsvi, PSVITEMINFO pii, ZSINT32 *idx);
/**
 * ScrollViewɾһĿ
 **/
 ZSINT32     scrollview_del_item      (HWND hWnd, PSVDATA psvdata, ZSINT32 nItem, HSVITEM hsvi);
/**
 * ScrollView
 **/
 ZVOID    scrollview_reset_content (HWND hWnd, PSVDATA psvdata);
/**
 * ScrollViewȡһĿY
 **/
 ZSINT32     scrollview_get_item_ypos (PSVDATA psvdata, HSVITEM hsvi);
/**
 * жĳλǷScrollViewĿ
 **/
 ZSINT32     scrollview_is_in_item    (PSVDATA psvdata, ZSINT32 mousey, HSVITEM *phsvi, ZSINT32 *itemy);
/**
 * ScrollViewvisChangedжػ
 **/
 ZVOID    scrollview_set_svlist    (HWND hWnd, PSCRDATA pscrdata, ZBOOL visChanged);
/**
 * ScrollView
 **/
 ZVOID    scrollview_draw          (HWND hWnd, HDC hdc, PSVDATA psvdata);

/* -------------------------------------------------------------------------- */

/**
 * ScrollViewˢ
 **/
 ZVOID    scrollview_refresh_content (PSVDATA psvdata);
/**
 * ScrollViewԶ
 **/
 ZVOID    scrollview_set_autosort    (PSVDATA psvdata);
/**
 * ScrollViewȡȫĿĸ߶
 **/
 ZSINT32     scrollview_get_total_item_height (PSVDATA psvdata);
/**
 * ScrollViewѡĿ
 **/
 ZVOID    scrollview_select_item     (PSVDATA psvdata, HSVITEM hsvi, ZBOOL bSel);
/**
 * ScrollViewѡһĿ
 **/
 ZVOID    scrollview_select_one_item (PSVDATA psvdata, HSVITEM hsvi);
/**
 * ScrollViewȡȫѡ
 **/
 ZVOID    scrollview_unselect_all    (PSVDATA psvdata);
/**
 * ScrollViewȫѡĿ
 **/
 ZVOID    scrollview_select_all      (PSVDATA psvdata);
/**
 * ScrollViewȡĿ
 **/
 ZSINT32     scrollview_get_item_count  (PSVDATA psvdata);
/**
 * ScrollViewȡھ
 **/
 HWND    scrollview_get_window      (PSVDATA psvdata);
/**
 * ScrollViewȡĿ
 **/
 HSVITEM scrollview_get_hilighted_item (PSVDATA psvdata);
/**
 * ScrollViewĿص
 **/
 ZVOID    scrollview_set_itemops     (PSVDATA psvdata, PSVITEMOPS iop);
/**
 * ScrollViewʾĿ
 **/
 ZVOID    scrollview_hilight_item    (PSVDATA psvdata, HSVITEM hsvi);
/**
 * ʹScrollViewĿɼ
 **/
 ZBOOL    scrollview_make_item_visible (PSVDATA psvdata, HSVITEM hsvi);
/**
 * ScrollViewˢĳָĿ
 **/
 ZVOID    scrollview_refresh_item_ex (PSVDATA psvdata, HSVITEM hsvi, const RECT *rcInv);
/**
 * ScrollViewĿ
 **/
 ZVOID    scrollview_refresh_item    (PSVDATA psvdata, HSVITEM hsvi);
/**
 * סScrollView
 **/
 ZVOID    scrollview_freeze          (HWND hWnd, PSVDATA psvdata, ZBOOL lock);
/**
 * ScrollViewͨȡĿ
 **/
 HSVITEM scrollview_get_item_by_index (PSVDATA psvdata, ZSINT32 nItem);
/**
 * ScrollViewȡһĿľ
 **/
 HSVITEM scrollview_get_next_item   (PSVDATA psvdata, HSVITEM hsvi);
/**
 * ScrollViewȡǰһĿľ
 **/
 HSVITEM scrollview_get_prev_item   (PSVDATA psvdata, HSVITEM hsvi);
/**
 * ScrollViewĿ
 **/
 ZSINT32     scrollview_sort_items      (PSVDATA psvdata, ZVOID* pfn, ZSINT32 fn_type);   
/**
 * ScrollViewȡĿĸ߶
 **/
 ZSINT32     scrollview_get_item_height (HSVITEM hsvi);
/**
 * ScrollViewػĳĿ
 **/
 ZVOID    scrollview_redraw_item     (PSVDATA psvdata, HSVITEM hsvi);

/* -------------------------------------------------------------------------- */

#endif  /* _ZCORE_CTRL_SCROLLVIEW_IMPL_H_ */

