#ifndef _ZCORE_CTRL_SCROLLWND_H_
#define _ZCORE_CTRL_SCROLLWND_H_
#include "zcore_type.h"
#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
 *	                            ͷļ                            *
 **************************************************************************/
#include "ctrl/scrolled.h"
#ifndef  ZTE_PLATFORMIZATION_HFILE
#include "../list.h"
#endif

/**************************************************************************
 *	                            ݶ                           *
 **************************************************************************/

#define CTRL_CONTAINER   "container"

typedef struct _containerdata
{
    /* ھ */
    HWND hSV;
    /* ڱʶ */
    ZDWORD flags;

} CONTDATA;
typedef CONTDATA* PCONTDATA;

typedef struct _swdata
{
    SCRDATA scrdata;

    /* ھ */
    HWND hContainer;
    /* ˽ */
    PCONTDATA pContdata;

    /* ڱʶ*/
    ZDWORD flags;

	HWND hSelectedChild;
} SWDATA;
typedef SWDATA *PSWDATA;

#ifndef _TYPE_WNDPROC
#define _TYPE_WNDPROC
typedef ZSINT32 (* WNDPROC)(HWND, ZSINT32, WPARAM, LPARAM);
#endif

/**************************************************************************
 *                           ⺯                                 *
 **************************************************************************/
ZSINT32  ScrollWndCtrlProc (HWND hWnd, ZSINT32 message, WPARAM wParam, LPARAM lParam);
ZSINT32  scrollwnd_init (HWND hWnd, PSWDATA psv);
ZVOID    scrollwnd_destroy (PSWDATA pswdata);
ZVOID    scrollwnd_hscroll (HWND hWnd, PSWDATA pswdata, WPARAM wParam, LPARAM lParam);
ZVOID    scrollwnd_vscroll (HWND hWnd, PSWDATA pswdata, WPARAM wParam, LPARAM lParam);
ZVOID    scrollwnd_reset_content (HWND hWnd, PSWDATA pswdata);
ZSINT32  scrollwnd_SetContWidth (HWND hWnd, PSWDATA pswdata, ZSINT32 cont_w);
ZVOID    scrollwnd_set_cont_pos (HWND hWnd, PSWDATA pswdata, ZSINT32 cont_x, ZSINT32 cont_y);
ZVOID    scrollwnd_make_pos_visible (HWND hWnd, PSWDATA pswdata, ZSINT32 pos_x, ZSINT32 pos_y);
ZVOID    scrollwnd_refresh_container (HWND hWnd, PSWDATA pswdata);
ZVOID    scrollwnd_set_scrollval (PSWDATA pswdata, ZSINT32 hval, ZSINT32 vval);
ZVOID    scrollwnd_set_scrollpageval (PSWDATA pswdata, ZSINT32 hval, ZSINT32 vval);
ZBOOL    RegisterScrollWndControl (ZVOID);

static  __inline ZSINT32 scrollwnd_get_contwidth (PSWDATA pswdata)
{
    return pswdata->scrdata.nContWidth;
}

static __inline  HWND scrollwnd_get_window (HWND hcontainer)
{
    return GetParent (GetParent (hcontainer));
}

static __inline  ZVOID scrollwnd_refresh_content(PSWDATA pswdata)
{
    InvalidateRect(pswdata->hContainer, NULL, TRUE);
}

static __inline WNDPROC scrollwnd_set_container_proc (PSWDATA pswdata, WNDPROC newproc)
{
    return (WNDPROC)SetWindowCallbackProc (pswdata->hContainer, newproc);
}

#ifdef __cplusplus
}
#endif  

#endif  

