#ifndef _EFFECT_BLUR_H
#define _EFFECT_BLUR_H

#ifdef __cplusplus
extern "C"
{
#endif

/*
********************************************************************************
*                                      ͷļ
********************************************************************************
*/	
#include "EffectEngine.h"
#include "zcore_type.h"

/*
********************************************************************************
*                                      
********************************************************************************
*/
#define MAX_GAUSSIAN_RADIUS     (2.0)                        /* ˹ģ뾶*/
#define GAUSSIAN_ARRY_RADIUS (2)                             /* а뾶     */   
#define GAUSSIAN_ARRY_LENGTH (2*GAUSSIAN_ARRY_RADIUS +1)     /* г     */

/*
********************************************************************************
*                                      ݽṹ
********************************************************************************
*/
typedef struct
{
    ZUINT32 r;
    ZUINT32 g;
    ZUINT32 b;
}T_BlurColor;


typedef struct
{
    ZUINT32 factor;           /*ϵ                     */
    ZSINT32 templateRadius;            /*ֵӦΪGAUSSIAN_MATRIX_RADIUS           */
    ZDOUBLE r;                      /*˹뾶[0.1-250]                        */
    ZUINT32 template[GAUSSIAN_ARRY_LENGTH];
}T_GaussianInfo;

typedef struct
{   
    // õĸ˹Ϣ
    T_GaussianInfo *pGaussian;     /*ָ˹Ϣָ                       */

    // ģϢ
    EngineRect blurRect;           /*ģ                             */
    EngineRect winRect;            /*(ģ)       */
    EngineRect clipRect[4];        /*ģ򱻵й() */
    ZSINT32 num;                       /*ģйĸ           */

    // 漰Ļָ
    ZCHAR *pBlurDst;                /*ģĿڴָ                         */
    ZCHAR *pBlurSrc;                /*ģԴڴָ(ԭʼָ)           */
    ZCHAR *pEndData;                /*ָ                         */
    ZCHAR *pInstanceData;           /*ʵָ                             */

    // Ϣ
    ZUINT32 bytes;            /*ÿռֽ                       */
    ZUINT32 pitch;            /*ÿռֽ                           */
    ZUINT32 width;            /*                                 */
    ZUINT32 height;           /*߶                                 */

    // ˢ
    EngineRect freshRect;          /*Ϊģ͵Ĳ             */
}T_EngineBlur;


/*
********************************************************************************
*                                      ȫֺ
********************************************************************************
*/

/*
********************************************************************************
* : EngineBlurEffectInit
* : ʼģЧ
* ˵: (IN) pInstance: ʵָ 
*           (IN/OUT)pData: ޸Чָ
*           (IN)pRect: ģ
* ֵ  : ENGINE_INVALID_PARA: Ƿ
*           ENGINE_MEM_ERROR: ڴ
*           ENGINE_SUCCESS: ɹ
* ˵:
********************************************************************************
*/
EngineResult EngineBlurEffectInit(EngineInstance *pInstance, EngineData *pData, EngineRect *pRect);
/*
********************************************************************************
* : EngineBlurEffectDesgroy
* : ģЧ
* ˵: (CHANGE)pData: ޸Чָ
* ֵ  : ENGINE_INVALID_PARA: Ƿ
*           ENGINE_SUCCESS: ɹ
* ˵:
********************************************************************************
*/
EngineResult EngineBlurEffectDestroy(EngineData * pData);

/*
********************************************************************************
* : EngineBlurEffectRender
* : ģЧ
* ˵: (IN)pData: ָ
*           (CHANGE)pInstance: ʵָ
* ֵ  : ENGINE_INVALID_PARA: Ƿ
*           ENGINE_SUCCESS: ɹ
* ˵:
********************************************************************************
*/
EngineBool EngineBlurEffectRender(EngineData *pData, EngineInstance *pInstance);

/*
********************************************************************************
*                                      ȫֱ
********************************************************************************
*/


#ifdef __cplusplus
}
#endif

#endif
