#ifndef _EFFECT_FADE_H
#define _EFFECT_FADE_H

#include "zcore_type.h"
#include "EffectEngine.h"


#define MAX_32_SCALE 32
#define MAX_FULL_SCALE 256

typedef enum
{
    QUICK_WAY,
	NORMAL_WAY
}AlphaMixStyle;

typedef enum
{
    CROSS_FADE,
	COLOR_FADE
}FadeStyle;

typedef struct
{
    AlphaMixStyle  eAlphaMix;
	FadeStyle      eFadeStyle;
	EffectColor   ColorFadeTo;
	ZSINT32   nStartAlpha;  //(range from 0 to 32 or 0 to 255)
	ZSINT32   nEndAlpha;    //(range from 0 to 32 or 0 to 255)
}EffectFadePrivateData;


typedef ZVOID (*pEngineFadeRender)(EngineData *pEngineData, EngineInstance *pInstance,ZUINT32 alpha);


EngineResult EngineFadeEffectInit(EngineData *pEngineData, EffectFadePrivateData *pInitData);

EngineResult EngineFadeEffectDestroy(EngineData *pData);

EngineResult EngineFadeEffectRender(EngineData *pEngineData, EngineInstance *pInstance);

#endif
