#ifndef _ZCORE_GUI_ENDIAN_RW_H_
#define _ZCORE_GUI_ENDIAN_RW_H_
#include "zcore_type.h"
#ifdef __cplusplus
extern "C" {
#endif


#define RWAREA_TYPE_UNKNOWN 0
#define RWAREA_TYPE_STDIO   1
#define RWAREA_TYPE_MEM     2
#define RWAREA_TYPE_STDIO_BUFFER    3

typedef struct _MG_RWops {
	ZSINT32 (*seek) (struct _MG_RWops *context, ZSINT32 offset, ZSINT32 whence);

	ZSINT32 (*read) (struct _MG_RWops *context, ZVOID *ptr, ZSINT32 objsize, ZSINT32 num);

	ZSINT32 (*write) (struct _MG_RWops *context, const ZVOID *ptr, ZSINT32 objsize,
	                  ZSINT32 num);

#ifdef _USE_OWN_STDIO
	ZSINT32 (*ungetc) (struct _MG_RWops *context, ZUINT8 c);
#endif

	ZSINT32 (*close) (struct _MG_RWops *context);

	ZSINT32 (*eof) (struct _MG_RWops *context);

	ZUINT32 type;

	union {
		struct {
			ZSINT32 autoclose;
			ZSINT32 buffer_len;
			ZSINT32 read_pos;
			FILE *fp;
			ZUINT8 *buffer;
		} stdio_buffer;

		struct {
			ZSINT32 autoclose;
			FILE *fp;
		} stdio;
		struct {
			ZUINT8 *base;
			ZUINT8 *here;
			ZUINT8 *stop;
		} mem;
		struct {
			ZVOID *data1;
		} unknown;
	} hidden;
} MG_RWops;

MG_EXPORT MG_RWops* MGUI_RWFromFile (const ZCHAR *file, const ZCHAR *mode);

MG_EXPORT MG_RWops* MGUI_RWFromFP (FILE *fp, ZSINT32 autoclose);
MG_EXPORT MG_RWops* MGUI_RWFromFP_Buf (FILE *fp, ZSINT32 autoclose);

MG_EXPORT MG_RWops* MGUI_RWFromMem (ZVOID *mem, ZSINT32 size);

MG_EXPORT ZVOID MGUI_InitMemRW (MG_RWops* area, ZVOID *mem, ZSINT32 size);

MG_EXPORT MG_RWops* MGUI_AllocRW (ZVOID);

MG_EXPORT ZVOID MGUI_FreeRW (MG_RWops *area);

#define MGUI_RWseek(ctx, offset, whence)    (ctx)->seek(ctx, offset, whence)

#define MGUI_RWtell(ctx)                    (ctx)->seek(ctx, 0, SEEK_CUR)

#define MGUI_RWread(ctx, ptr, size, n)      (ctx)->read(ctx, ptr, size, n)

#define MGUI_RWwrite(ctx, ptr, size, n)     (ctx)->write(ctx, ptr, size, n)

#define MGUI_RWclose(ctx)                   (ctx)->close(ctx)

#define MGUI_RWeof(ctx)                     (ctx)->eof(ctx)

MG_EXPORT ZSINT32 MGUI_RWgetc (MG_RWops* area);


#ifdef linux
#include <endian.h>
#ifdef __arch__swab16
#define ArchSwap16  __arch__swab16
#endif
#ifdef __arch__swab32
#define ArchSwap32  __arch__swab32
#endif
#endif /* linux */

#ifndef ArchSwap16
static inline ZUINT16 ArchSwap16 (ZUINT16 value)
{
	return ( (value << 8) | (value >> 8));
}
#endif
#ifndef ArchSwap32
static inline ZUINT32 ArchSwap32 (ZUINT32 value)
{
	return ( (value << 24) | ( (value << 8) & 0x00FF0000) | ( (value >> 8) & 0x0000FF00) | (value >> 24));
}
#endif

#ifdef MGUI_HAS_64BIT_TYPE

#ifndef ArchSwap64
static inline Uint64 ArchSwap64 (Uint64 value)
{
	ZUINT32 hi, lo;

	lo = (ZUINT32) (value & 0xFFFFFFFF);
	value >>= 32;
	hi = (ZUINT32) (value & 0xFFFFFFFF);
	value = ArchSwap32 (lo);
	value <<= 32;
	value |= ArchSwap32 (hi);
	return (value);
}
#endif  /* ArchSwap64 */

#else

#ifndef ArchSwap64
#define ArchSwap64(X) (X)
#endif

#endif /* MGUI_HAS_64BIT_TYPE */


#if MGUI_BYTEORDER == MGUI_LIL_ENDIAN
#define ArchSwapLE16(X)        (X)
#define ArchSwapLE32(X)        (X)
#define ArchSwapLE64(X)        (X)
#define ArchSwapBE16(X)        ArchSwap16(X)
#define ArchSwapBE32(X)        ArchSwap32(X)
#define ArchSwapBE64(X)        ArchSwap64(X)
#else
#define ArchSwapLE16(X)        ArchSwap16(X)
#define ArchSwapLE32(X)        ArchSwap32(X)
#define ArchSwapLE64(X)        ArchSwap64(X)
#define ArchSwapBE16(X)        (X)
#define ArchSwapBE32(X)        (X)
#define ArchSwapBE64(X)        (X)
#endif

extern ZUINT16 MGUI_ReadLE16 (MG_RWops *src);

extern ZUINT16 MGUI_ReadBE16 (MG_RWops *src);

extern ZUINT32 MGUI_ReadLE32 (MG_RWops *src);

extern ZUINT32 MGUI_ReadBE32 (MG_RWops *src);

extern Uint64 MGUI_ReadLE64 (MG_RWops *src);

extern Uint64 MGUI_ReadBE64 (MG_RWops *src);

extern ZSINT32 MGUI_WriteLE16 (MG_RWops *dst, ZUINT16 value);

extern ZSINT32 MGUI_WriteBE16 (MG_RWops *dst, ZUINT16 value);

extern ZSINT32 MGUI_WriteLE32 (MG_RWops *dst, ZUINT32 value);

extern ZSINT32 MGUI_WriteBE32 (MG_RWops *dst, ZUINT32 value);

extern ZSINT32 MGUI_WriteLE64 (MG_RWops *dst, Uint64 value);

extern ZSINT32 MGUI_WriteBE64 (MG_RWops *dst, Uint64 value);

extern ZUINT16 MGUI_ReadLE16FP (FILE *src);

extern ZUINT32 MGUI_ReadLE32FP (FILE *src);

extern ZSINT32 MGUI_WriteLE16FP (FILE *dst, ZUINT16 value);

extern ZSINT32 MGUI_WriteLE32FP (FILE *dst, ZUINT32 value);

static inline ZUINT16 MGUI_ReadLE16Mem (const ZUINT8** pdata)
{
	ZUINT16 h1, h2;

	h1 = * (*pdata);
	(*pdata)++;
	h2 = * (*pdata);
	(*pdata)++;
	return ( (h2 << 8) | h1);
}

static inline ZUINT32 MGUI_ReadLE32Mem (const ZUINT8** pdata)
{
	ZUINT32 q1, q2, q3, q4;

	q1 = * (*pdata);
	(*pdata)++;
	q2 = * (*pdata);
	(*pdata)++;
	q3 = * (*pdata);
	(*pdata)++;
	q4 = * (*pdata);
	(*pdata)++;
	return ( (q4 << 24) | (q3 << 16) | (q2 << 8) | (q1));
}

static inline ZUINT16 MGUI_ReadBE16Mem (const ZUINT8** pdata)
{
	ZUINT16 h1, h2;

	h1 = * (*pdata);
	(*pdata)++;
	h2 = * (*pdata);
	(*pdata)++;
	return ( (h1 << 8) | h2);
}

static inline ZUINT32 MGUI_ReadBE32Mem (const ZUINT8** pdata)
{
	ZUINT32 q1, q2, q3, q4;

	q1 = * (*pdata);
	(*pdata)++;
	q2 = * (*pdata);
	(*pdata)++;
	q3 = * (*pdata);
	(*pdata)++;
	q4 = * (*pdata);
	(*pdata)++;
	return ( (q1 << 24) | (q2 << 16) | (q3 << 8) | (q4));
}

/* Ends C function definitions when using C++ */
#ifdef __cplusplus
}
#endif

#endif /* _ZCORE_GUI_ENDIAN_RW_H_ */

