#ifndef EXT_ANIMATION_H
#define EXT_ANIMATION_H
#include "zcore_type.h"
#ifdef  __cplusplus
extern "C" {
#endif

/**************************************************************************
 *                                                                *
 **************************************************************************/
/** ֡ṹ嶨 */
typedef struct _ANIMATIONFRAME
{
    /* л֡ʱĴʽ (Gif89aĵ):
     *   0 κ⴦
     *   1 κ⴦
     *  2 ǰһη֡ͼλΪɫ
     *  3 ǰ֡ǵΪǰһ֡ͼ
    */
    ZSINT32 disposal;
    /* ֡ͼõx */
    ZSINT32 off_x;
    /* ֡ͼõy */
    ZSINT32 off_y;
    /* ֡ͼ */
    ZUINT32 width;
    /* ֡ͼĸ߶ */
    ZUINT32 height;

    /* ֡ӳʱ */
    ZUINT32 delay_time;
#if 1//def _USE_NEWGAL
    /* gif֡ͼļڴDC */
    HDC mem_dc;
    /* λͼ */
    ZUINT8* bits;
#else
    /* λͼ */
    BITMAP bmp;
#endif

    /* һ֡ͼ */
    struct _ANIMATIONFRAME* next;
    /* ǰһ֡ͼ */
    struct _ANIMATIONFRAME* prev;
} ANIMATIONFRAME;

/** ṹ嶨*/
typedef struct _ANIMATION
{
    /* ֡ͼĿ */
    ZUINT32 width;
    /* ֡ͼĸ߶ */
    ZUINT32 height;

    /* ɫֵ */
    RGB bk;

    /* ֡ */
    ZSINT32 nr_frames;
    /* һ֡ͼӳʱ䵥λΪ10ms */
    ZSINT32 time_unit;
    /* ֡*/
    ANIMATIONFRAME* frames;
} ANIMATION;

/**************************************************************************
 *                        ӿ                                      *
 **************************************************************************/
 /**
 * : CreateAnimationFromGIF89aFile
 * 
 * : úԴһļлȡGIF89aͼݣҲһANIMATION
 *           
 *
 * : 
 *         1.hdc: 豸ľӶ֡ͼлȡλͼϢʱʹ
 *         2.file: ļ·
 *
 * : 
 *         ɹ: һ
 *         ʧ: NULL
 */
MGEXT_EXPORT ANIMATION* CreateAnimationFromGIF89aFile (HDC hdc, const ZCHAR* file);


 /**
 * : CreateAnimationFromGIF89aMem
 * 
 * : úԴڴмGIF89aʽͼݣҲһANIMATION
 *           
 *
 * : 
 *         1.hdc: 豸ľӶ֡ͼлȡλͼϢʱʹ
 *         2.mem: ڴָ
 *         3.size: ڴС
 *
 * : 
 *         ɹ: һ
 *         ʧ: NULL
 */
MGEXT_EXPORT ANIMATION* CreateAnimationFromGIF89aMem (HDC hdc, const ZVOID* mem, ZSINT32 size);

 /**
 * : DestroyAnimation
 * 
 * : úɾ
 *
 * : 
 *         1.anim: 
 *         2.free_it: ڴͷ񣨸òĿǰûã
 *
 * ˵: ýӿڹ붯ӿCreateAnimationFromGIF89aFileȶӦϲӦñƥʹ
 */
MGEXT_EXPORT ZVOID DestroyAnimation (ANIMATION* anim, ZBOOL free_it);

/**************************************************************************
 *                                                                    *
 **************************************************************************/

/** ؼĿؼ **/
#define CTRL_ANIMATION                  ("Animation")

/** ؼķֵ **/
#define ANIMATION_OKAY                  0
#define ANIMATION_ERR                   -1

/**************************************************************************
 *                         궨                                         *
 **************************************************************************/

/**ؼи÷ʱԽԶ**/
#define ANS_AUTOLOOP                    0x0001L

/**ؼи÷ʱŶڴС**/
#define ANS_SCALED                      0x0002L

/**ؼи÷ʱڳߴС**/
#define ANS_FITTOANI                    0x0004L

/**ֶŶڷ**/
#define ANS_MANUALPLAY                  0x0008L

/**ÿһ֡򸸴ڷ֪ͨϢ**/
#define ANS_NOTIFYPARENT                0x0010L

/**
 * öϢ
 *
 * Ӧ÷͸Ϣжؼá
 *
 *:
 * 		wParam = 0;
 * 		lParam = ANIMATION *pAnimate;
 *
 *ֵ:
 *      ɹؾɶ, ûپɶ
 *      ʧܣ-1
 **/
#define ANM_SETANIMATION                0xF110

/**
 * ȡϢ
 *
 * Ӧ÷͸ϢȡؼϢ
 *
 *:
 * 		wParam = 0;
 * 		lParam = 0;
 *
 *ֵ:
 *      ɹضָ
 *      ʧܣNULL
 **/
#define ANM_GETANIMATION                0xF111

/**
 * ʼŶϢ
 *
 * Ӧ÷͸Ϣš
 *
 *:
 * 		wParam = 0;
 * 		lParam = 0;
 *
 *ֵ:
 *      ɹ0
 *      ʧܣʧܷ-1
 **/
#define ANM_STARTPLAY                   0xF112

/**
 * ͣŶϢ
 *
 * Ӧ÷͸ϢжϻŶ
 *
 *:
 * 		wParam = 0;
 * 		lParam = 0;
 *
 *ֵ:
 *      ɹ0
 *      ʧܣʧܷ-1
 **/
#define ANM_PAUSE_RESUME                0xF113

/**
 * ֹͣϢ
 *
 * Ӧÿͨ򶯻ؼANM_STOPPLAYϢʹֹͣʾĵһ֡.
 *
 *:
 * 		wParam = 0;
 * 		lParam = 0;
 *
 *ֵ:Ƿ0
 **/
#define ANM_STOPPLAY                    0xF114

#define ANM_PAINT_OVER                  0xF115
#define ANM_MSGMAX                      0xF120



#ifdef  __cplusplus
}
#endif

#endif /* EXT_ANIMATION_H */

