#ifndef EXT_ICONVIEW_H
#define EXT_ICONVIEW_H
#include "zcore_type.h"
#ifdef  __cplusplus
extern "C" {
#endif


#define CTRL_ICONVIEW       ("IconView")

/** Iconview return value */
#define IV_OKAY                 0
#define IV_ERR                  (-1)
#define IV_ERRSPACE             (-2)

typedef GHANDLE HIVITEM;

typedef struct _IVITEMINFO
{
    ZSINT32 nItem;
    PBITMAP bmp;
    const ZCHAR *label;
    DWORD addData;
    DWORD dwFlags;
} IVITEMINFO;
typedef IVITEMINFO* PIVITEMINFO;

#define IVFLAG_BITMAP	0x0001
#define IVFLAG_ICON	0x0002


MGEXT_EXPORT ZSINT32 iconview_is_item_hilight (HWND hWnd, GHANDLE hivi);
MGEXT_EXPORT PBITMAP iconview_get_item_bitmap (GHANDLE hivi);
MGEXT_EXPORT const ZCHAR* iconview_get_item_label (GHANDLE hivi);
MGEXT_EXPORT DWORD iconview_get_item_adddata (GHANDLE hivi);

#define IVS_NOTIFY              SVS_NOTIFY
#define IVS_UPNOTIFY            SVS_UPNOTIFY
#define IVS_AUTOSORT            SVS_AUTOSORT
#define IVS_LOOP                SVS_LOOP


#define IVM_ADDITEM            0xF300
#define IVM_SETITEMSIZE           0xF436


#define IVM_RESETCONTENT        SVM_RESETCONTENT
#define IVM_DELITEM             SVM_DELITEM
#define IVM_SETITEMDRAW         SVM_SETITEMDRAW
#define IVM_SETCONTWIDTH        SVM_SETCONTWIDTH
#define IVM_SETCONTHEIGHT       SVM_SETCONTHEIGHT
#define IVM_SETITEMOPS          SVM_SETITEMOPS
#define IVM_GETMARGINS          SVM_GETMARGINS
#define IVM_SETMARGINS          SVM_SETMARGINS
#define IVM_GETLEFTMARGIN       SVM_GETLEFTMARGIN
#define IVM_GETTOPMARGIN        SVM_GETTOPMARGIN
#define IVM_GETRIGHTMARGIN      SVM_GETRIGHTMARGIN
#define IVM_GETBOTTOMMARGIN     SVM_GETBOTTOMMARGIN
#define IVM_GETVISIBLEWIDTH     SVM_GETVISIBLEWIDTH
#define IVM_GETVISIBLEHEIGHT    SVM_GETVISIBLEHEIGHT
#define IVM_GETCONTWIDTH        SVM_GETCONTWIDTH
#define IVM_GETCONTHEIGHT       SVM_GETCONTHEIGHT
#define IVM_SETCONTRANGE        SVM_SETCONTRANGE
#define IVM_GETCONTENTX         SVM_GETCONTENTX
#define IVM_GETCONTENTY         SVM_GETCONTENTY
#define IVM_SETCONTPOS          SVM_SETCONTPOS
#define IVM_GETCURSEL           SVM_GETCURSEL
#define IVM_SELECTITEM          SVM_SELECTITEM
#define IVM_SHOWITEM            SVM_SHOWITEM
#define IVM_CHOOSEITEM          SVM_CHOOSEITEM
#define IVM_SETCURSEL           SVM_SETCURSEL
#define IVM_SETITEMINIT         SVM_SETITEMINIT
#define IVM_SETITEMDESTROY      SVM_SETITEMDESTROY
#define IVM_SETITEMCMP          SVM_SETITEMCMP
#define IVM_MAKEPOSVISIBLE      SVM_MAKEPOSVISIBLE
#define IVM_GETHSCROLLVAL       SVM_GETHSCROLLVAL
#define IVM_GETVSCROLLVAL       SVM_GETVSCROLLVAL
#define IVM_GETHSCROLLPAGEVAL   SVM_GETHSCROLLPAGEVAL
#define IVM_GETVSCROLLPAGEVAL   SVM_GETVSCROLLPAGEVAL
#define IVM_SETSCROLLVAL        SVM_SETSCROLLVAL
#define IVM_SETSCROLLPAGEVAL    SVM_SETSCROLLPAGEVAL
#define IVM_SORTITEMS           SVM_SORTITEMS
#define IVM_GETITEMCOUNT        SVM_GETITEMCOUNT
#define IVM_GETITEMADDDATA      SVM_GETITEMADDDATA
#define IVM_SETITEMADDDATA      SVM_SETITEMADDDATA
#define IVM_REFRESHITEM         SVM_REFRESHITEM
#define IVM_GETFIRSTVISIBLEITEM SVM_GETFIRSTVISIBLEITEM

#define IVN_CLICKED            SVN_CLICKED
#define IVN_SELCHANGED         SVN_SELCHANGED

#ifdef  __cplusplus
}
#endif

#endif /* EXT_ICONVIEW_H */

