#ifndef _ZCORE_GUI_GIF_H_
#define _ZCORE_GUI_GIF_H_

#include "zcore_type.h"
#define GIF_GLOBAL_SIZE 13
#define GIF_PALETTE_SIZE 768
#define GIF_LOCAL_SIZE   9

typedef struct tagGlobal {
    ZCHAR magic_word[3];
    ZCHAR version[3];
    ZSINT16 width;
    ZSINT16 height;
    ZUINT8 flag;
    ZUINT8 bg_color;
    ZUINT8 aspect;
}gif_global_t;

typedef struct tagPalette {
    ZUINT8 palette[768];
}gif_palette_t;

typedef struct tagLocal {
    ZSINT16 x;
    ZSINT16 y;
    ZSINT16 width;
    ZSINT16 height;
    ZUINT8 flag;
}gif_local_t;

typedef struct tagCode {
    ZCHAR first;
    ZCHAR last;
    ZSINT32  prefix;
}gif_code_t;

typedef struct tagGifInfo {
	gif_global_t  gif_global;
	gif_local_t   gif_local;
	gif_palette_t gif_global_palette;
	gif_palette_t gif_local_palette;

	ZSINT32 gif_buffer_length;
	ZUINT8* gif_buffer;
	ZUINT8* gif_cur_buffer;

	gif_code_t code_table[4096];
	ZUINT8 code_string[1024];

	ZSINT32 code_limit;

	ZSINT32 b_local_palette;
	ZSINT32 b_interlaced;

	ZSINT32 request_bits;
	ZSINT32 first_ch;

	ZSINT32 pass;

	ZSINT32 code;
	ZSINT32 prefix;

	ZSINT32 free_code;
	ZSINT32 EOI,CLEAR;

    ZSINT32 remain_bytes;
    ZSINT32 remain_bits;
    ZCHAR unsigned data;

	ZUINT8* gif_surface;
	ZSINT32 gif_x;
	ZSINT32 gif_y;
}gif_info_t;

extern ZSINT32 unpack_gif(gif_info_t*);
extern ZSINT32 unpack_local_image(gif_info_t*);
extern ZSINT32 unpack_image_data(gif_info_t*);

extern ZVOID clear_code_table(gif_info_t*,ZSINT32);
extern ZVOID insert_code_table(gif_info_t*,ZSINT32,ZSINT32);
extern ZVOID output_code(gif_info_t*,ZSINT32);
extern ZVOID output_pixel(gif_info_t*,ZUINT8); 
extern ZSINT32  get_code(gif_info_t*);
extern ZVOID draw_pixel(gif_info_t*,ZSINT32,ZSINT32,ZSINT32);
extern ZVOID destroy_gif(gif_info_t*);
 
#endif

