#ifndef _ZCORE_INTERNALS_WIND_H_
#define _ZCORE_INTERNALS_WIND_H_
#include "zcore_type.h"
#include "internals_msg.h"

/******************** Handle type and child type. ***************************/
#define TYPE_HWND           0x0ABCDEF1
#define TYPE_MAINWIN    0x1ABCDEF1
#define TYPE_CONTROL    0x1ABCDEF2
#define TYPE_ROOTWIN    0x1ABCDEF3
#define TYPE_HMENU          0x02
#define TYPE_MENUBAR    0x21
#define TYPE_PPPMENU    0x22
#define TYPE_NMLMENU    0x23
#define TYPE_HACCEL         0x03
#define TYPE_HCURSOR        0x05
#define TYPE_HICON          0x07
#define TYPE_HDC            0x08
#define TYPE_SCRDC      0x81
#define TYPE_GENDC      0x82
#define TYPE_MEMDC      0x83
#define TYPE_INVALIDA      0xAA


#define MG_IS_WINDOW(hwnd)              \
            (hwnd &&                    \
             hwnd != HWND_INVALID &&    \
             ((PMAINWIN)hwnd)->DataType == TYPE_HWND)
             
#define MG_GET_WINDOW_PTR(hwnd)   ((PMAINWIN)hwnd)
#define MG_GET_CONTROL_PTR(hwnd)  ((PCONTROL)hwnd)

#define MG_IS_NORMAL_WINDOW(hwnd)       \
        (hwnd != HWND_DESKTOP && MG_IS_WINDOW(hwnd))

#define MG_IS_DESTROYED_WINDOW(hwnd)    \
        (hwnd &&                        \
         (hwnd != HWND_INVALID) &&      \
        (((PMAINWIN)hwnd)->DataType == TYPE_INVALIDA))

#define MG_CHECK_RET(condition, ret) \
            if (!(condition)) return ret

#define MG_CHECK(condition) \
            if (!(condition)) return
				
#define MG_IS_MAIN_WINDOW(hwnd)         \
        (MG_IS_WINDOW(hwnd) && ((PMAINWIN)hwnd)->WinType == TYPE_MAINWIN)

#define MG_IS_NORMAL_MAIN_WINDOW(hwnd)  \
        (hwnd != HWND_DESKTOP && MG_IS_MAIN_WINDOW(hwnd))

typedef struct _ZORDERNODE
{
	HWND hWnd;			// Handle of window

	struct _ZORDERNODE* pNext;	// Next window
} ZORDERNODE;
typedef ZORDERNODE* PZORDERNODE;

typedef struct _ZORDERINFO
{
	ZSINT32 nNumber;    // Number of windows

	HWND hWnd;			// Handle of host window

	PZORDERNODE pTopMost;	// the top most Z order node
} ZORDERINFO;

typedef ZORDERINFO* PZORDERINFO;


typedef struct _CARETINFO {
	ZSINT32     x;          // position of caret
	ZSINT32     y;
	ZVOID*   pNormal;       // normal bitmap.
	ZVOID*   pXored;        // bit-Xored bitmap.

	PBITMAP pBitmap;        // user defined caret bitmap.

	ZSINT32     nWidth;     // original size of caret
	ZSINT32     nHeight;
	ZSINT32     nBytesNr;   // number of bitmap bytes.
	ZSINT32     nEffWidth;  // effective width
	ZSINT32     nEffHeight; // effective height;
	ZBOOL    fBlink;        // does blink?
	ZBOOL    fShow;         // show or hide currently.

	HWND    hOwner;         // the window owns the caret.
	ZUINT    uTime;         // the blink time.
	ZBOOL (*get_visRect) (HWND, RECT *);

} CARETINFO;
typedef CARETINFO* PCARETINFO;
typedef struct _SCROLLWINDOWINFO
{
	ZSINT32 iOffx;
	ZSINT32 iOffy;
	const RECT* rc1;
	const RECT* rc2;
} SCROLLWINDOWINFO;
typedef SCROLLWINDOWINFO* PSCROLLWINDOWINFO;

#define SBS_NORMAL      0x00
#define SBS_DISABLED    0x01
#define SBS_HIDE        0x02
typedef struct _SCROLLBARINFO {
	ZSINT32  minPos;     // min value of scroll range.
	ZSINT32  maxPos;     // max value of scroll range.
	ZSINT32  curPos;     // current scroll pos.
	ZSINT32  pageStep;   // steps per page.
	ZSINT32  barStart;   // start pixel of bar.
	ZSINT32  barLen;     // length of bar.
	ZBYTE status;        // status of scroll bar.
} SCROLLBARINFO;
typedef SCROLLBARINFO* PSCROLLBARINFO;


#define CLIPRECT(heap, size)    InitBlockDataHeap (heap, sizeof (CLIPRECT), size)

//typedef T_REGION_BLOCKHEAP BLOCKHEAP; //wangdesuo
//typedef T_REGION_CLIPRGN CLIPRGN;

struct _wnd_element_data;

typedef struct _THREADINFO THREADINFO;



#ifndef _TYPE_NOTIFPROC
#define _TYPE_NOTIFPROC
typedef ZVOID (* NOTIFPROC) (HWND hwnd, ZSINT32 id, ZSINT32 nc, ZDWORD add_data);//òֿwindow.h wm_g.hظ
#endif

// this struct is an internal struct
#define VERIFY_STRUCT_MAGIC  0x1234ABCD
typedef struct _MAINWIN
{
	ZUINT32 DataType;		// ͣתΪ
	ZUINT32 WinType;		// 
	ZSINT32 left, top;		// λ
	ZSINT32 right, bottom;
	ZSINT32 cl, ct;			// ͻ
	ZSINT32 cr, cb;
	ZDWORD dwStyle;		// ʽ.
	ZDWORD dwExStyle;   // ʽ.
	ZSINT32 iBkColor;   // ɫ
	ZSINT32 iFrColor;   /* ǰɫ*/
	ZVOID *pBkPicture;	/* ͼ*/
	HICON hIcon;		//ͼ꣬title.
	HMENU hMenu;		//handle of menu.
	HCURSOR hCursor;	//handle of cursor.
	PCARETINFO pCaretInfo;// pointer to system caret info struct.
	PLOGFONT pLogFont;  //߼.
	INVRGN InvRgn;      //Чˢ.
	PGCRINFO pGCRInfo;  //Ϣָ룬һָGCRInfo
	PZORDERNODE pZOrderNode; // Z orderڵ.
	ZDWORD dwAddData;    // .
	ZDWORD dwAddData2;   // 丽
	ZSINT32 (*MainWindowProc) (HWND, ZSINT32, WPARAM, LPARAM); // Ϣ
	ZCHAR* spCaption;    // ַ
	ZSINT32   id;        // id
	SCROLLBARINFO vscroll;
	SCROLLBARINFO hscroll;

	struct _MAINWIN* pMainWin;
	HWND hParent;       // ھ
	HWND hFirstChild;	// the handle of first child window.
	HWND hActiveChild;  // the currently active child window.
	HWND hOldUnderPointer;// the old child window under pointer.
	HWND hPrimitive;    // the premitive child of mouse event.
	NOTIFPROC NotifProc;// the notification callback procedure.
	struct _wnd_element_data* wed;//ڸ

	struct _MAINWIN* pHosting; // йܴڵĴָ
	struct _MAINWIN* pFirstHosted; // йڴڵĴͷ.
	struct _MAINWIN* pNextHosted; //ͬе¸ֵָܴ.

	PMSGQUEUE pMessages; // Ϣ
	GCRINFO GCRInfo; // Ϣ

	ZSINT32  th;//the thread which creates this main window.

	HMENU hSysMenu;      // handle of system menu.
	THREADINFO *thinfo;
	HDC   privCDC;       // the private client DC.

	GCRINFO lGCRInfo;    //˽мϢ
	ZSINT32 layerID;
	ZSINT32 rotation;    //ڵתǶ
	ZVOID *surface;      //surface
	ZVOID *priv;         //layerص˽Ϣ

	ZUINT32 verifyflag_end;
} MAINWIN;
typedef MAINWIN* PMAINWIN;


#endif //_ZCORE_INTERNALS_WIND_H_

