#ifndef _ZCORE_GUI_RECT_H_
#define _ZCORE_GUI_RECT_H_
#include "zcore_type.h"
/**
 * \def RECTWP(prc)
 * \brief Gets the width of a RECT object by using the pointer to it.
 */
#define RECTWP(prc)  (prc->right - prc->left)
/**
 * \def RECTHP(prc)
 * \brief Gets the height of a RECT object by using the pointer to it.
 */
#define RECTHP(prc)  (prc->bottom - prc->top)
/**
 * \def RECTW(rc)
 * \brief Gets the width of a RECT object.
 */
#define RECTW(rc)    (rc.right - rc.left)
/**
 * \def RECTH(rc)
 * \brief Gets the height of a RECT object.
 */
#define RECTH(rc)    (rc.bottom - rc.top)


/*******************************ṹ嶨*******************************/

/*******************************ԭ*******************************/
extern	ZBOOL Rect_SetRect (RECT *pRect, ZSINT32 left, ZSINT32 top, ZSINT32 right, ZSINT32 bottom);
extern	ZBOOL Rect_CopyRect (RECT *pdrc,  RECT *psrc);
extern	ZBOOL Rect_IsEqual(RECT *prc1, RECT *prc2);
extern	ZBOOL Rect_IsCovered (RECT *prc1, RECT *prc2);
extern	ZBOOL Rect_IsEmpty (RECT *pRect);
extern	ZBOOL Rect_DoesIntersect (RECT *psrc1, RECT *psrc2);
extern	ZBOOL Rect_IntersectRect (RECT *pdrc, RECT *psrc1, RECT *psrc2);
extern  ZBOOL Rect_GetBoundRect (RECT *pdrc,  RECT *psrc1, RECT *psrc2);
extern  ZSINT32  Rect_SubtractRect (RECT *rc, RECT *psrc1, RECT *psrc2);
extern  ZBOOL Rect_OffsetRect (RECT *prc, ZSINT32 iX, ZSINT32 iY);
extern  ZBOOL Rect_InflateRect (RECT *prc, ZSINT32 iX, ZSINT32 iY);
extern  ZBOOL Rect_InflateRectToPt (RECT *prc, ZSINT32 iX, ZSINT32 iY);
extern	ZBOOL Rect_PtInRect (RECT *prc, ZSINT32 iX, ZSINT32 iY);
extern 	ZBOOL Rect_SetRectEmpty (RECT *pRect);
extern	ZBOOL Rect_NormalizeRect (RECT *pRect);
extern 	ZBOOL Rect_GetBoundsRect (HDC hdc, RECT *prc);
extern	ZBOOL  Rect_RectVisible (HDC hdc,  RECT* pRect);

#define	SetRect(prc, left, top, right, bottom)	Rect_SetRect((RECT*) prc, (ZSINT32) left, (ZSINT32) top, (ZSINT32) right, (ZSINT32) bottom)
#define	CopyRect(pdrc, psrc)					Rect_CopyRect((RECT*) pdrc,  (RECT*)psrc)
#define	OffsetRect(prc, iX, iY)					Rect_OffsetRect((RECT*)prc, (ZSINT32) iX, (ZSINT32) iY)
#define	InflateRect(prc, cx, cy)				Rect_InflateRect((RECT*)prc, (ZSINT32) cx, (ZSINT32) cy)
#define	PtInRect(prc, x, y)						Rect_PtInRect((RECT*)prc, (ZSINT32) x, (ZSINT32) y)
#define	SetRectEmpty(prc)						Rect_SetRectEmpty((RECT*)prc)
extern	 ZBOOL  EqualRect (const RECT* prc1, const RECT* prc2);
extern	 ZBOOL  IsCovered (const RECT* prc1, const RECT* prc2);
extern	 ZBOOL  IsRectEmpty (const RECT* prc);
extern	 ZBOOL  DoesIntersect (const RECT* psrc1, const RECT* psrc2);
extern	 ZBOOL  IntersectRect (RECT* pdrc, const RECT* psrc1, const RECT* psrc2);
extern   ZVOID  GetBoundRect (PRECT pdrc, const RECT* psrc1, const RECT* psrc2);
extern   ZSINT32  SubtractRect (RECT* rc, const RECT* psrc1, const RECT* psrc2);
extern	 ZVOID  NormalizeRect (RECT* pRect);
extern 	 ZVOID  GetBoundsRect (HDC hdc, RECT* pRect);
extern	 ZBOOL  RectVisible (HDC hdc, const RECT* pRect);

#endif //_ZCORE_GUI_RECT_H_
