#ifndef Z3D_ENGINE_MATH_H
#define Z3D_ENGINE_MATH_H

#ifdef __cplusplus
extern "C" {
#endif

/********************************************************************************
    Include File                  ͷļ
********************************************************************************/

/********************************************************************************
    Macro                           궨
********************************************************************************/

// ֵ
#undef  MAX_FLOAT
#define MAX_FLOAT    3.4028234e+38f

// log2
#undef  log2
#define log2(x)    (log(x) * 1.442695040888963) // log2(x) = log(x) / log(2)  log(2)ln2  1/ln2 == 1.442695040888963

// PIصĳ
#undef  PI
#define PI          3.141592653589793 // ȸ8λЧ֣˫ȸ16λЧ

#undef  PI2
#define PI2         6.283185307179586 // PI * 2

#undef  PI_DIV_2
#define PI_DIV_2    1.570796326794897 // PI / 2

#undef  PI_DIV_4
#define PI_DIV_4    0.7853981633974483 // PI / 4

#undef  PI_INV
#define PI_INV      0.3183098861837907 // 1/PI

// 붨صĳ
#undef  FIXP16_SHIFT
#define FIXP16_SHIFT       16         // λ16.16ʽ

#undef  FIXP22_SHIFT
#define FIXP22_SHIFT       22         // λ10.22ʽ

#undef  FIXP28_SHIFT
#define FIXP28_SHIFT       28         // λ4.28ʽ

#undef  FIXP16_MAG
#define FIXP16_MAG         65536      // ڶ븡ת

#undef  FIXP16_WP_MASK
#define FIXP16_WP_MASK     0xffff0000 // ȡ

#undef  FIXP16_DP_MASK
#define FIXP16_DP_MASK     0x0000ffff // ȡС

#undef  FIXP16_ROUND_UP
#define FIXP16_ROUND_UP    0x00008000 // ൱ڸ0.5

// ڷǳСֵĳ
#undef  EPSILON_E3
#define EPSILON_E3    (1e-3f)

#undef  EPSILON_E4
#define EPSILON_E4    (1e-4f)

#undef  EPSILON_E5
#define EPSILON_E5    (1e-5f)

#undef  EPSILON_E6
#define EPSILON_E6    (1e-6f)

// ȽϣǷ
#undef  FLOAT_COMPARE
#define FLOAT_COMPARE(a, b)    ((fabs(a-b) < EPSILON_E3) ? 1 : 0)

// ʽнϴͽСһ
#undef  MIN
#define MIN(a, b)    (((a) < (b)) ? (a) : (b))

#undef  MAX
#define MAX(a, b)    (((a) > (b)) ? (a) : (b))

// ֵ
#undef  SWAP
#define SWAP(a ,b, t)    do {t = a; a = b; b = t;} while(0)

// תΪ
#undef  DEGREE_TO_RADIAN_DOUBLE
#define DEGREE_TO_RADIAN_DOUBLE(degree)    ((degree) * 0.01745329251994330) // PI / 180 = 0.01745329251994330

// תΪ
#undef  DEGREE_TO_RADIAN_FLOAT
#define DEGREE_TO_RADIAN_FLOAT(degree)    ((degree) * 0.017453293f) // PI / 180 = 0.01745329251994330

// תΪ
#undef  RADIAN_TO_DEGREE_DOUBLE
#define RADIAN_TO_DEGREE_DOUBLE(radian)    ((radian) * 57.29577951308232) // 180.0 / PI = 57.29577951308232

// תΪ
#undef  RADIAN_TO_DEGREE_FLOAT
#define RADIAN_TO_DEGREE_FLOAT(radian)    ((radian) * 57.295780f) // 180.0 / PI = 57.29577951308232

// ȡ[x,y]֮
#undef  RAND_RANGE
#define RAND_RANGE(f, y)    ((f) + (rand() % ((y) - (f) + 1)))

// 16.16ʽĶȡֺС
#undef  FIXP16_WP
#define FIXP16_WP(fp)    ((fp) >> FIXP16_SHIFT)

#undef  FIXP16_DP
#define FIXP16_DP(fp)    ((fp) && FIXP16_DP_MASK)

// ͸תΪ16.16ʽĶ
#undef  INT_TO_FIXP16
#define INT_TO_FIXP16(i)      ((i) << FIXP16_SHIFT)

#undef  FLOAT_TO_FIXP16
#define FLOAT_TO_FIXP16(f)    ((f) * FIXP16_MAG + 0.5f)

// 16.16ʽĶתΪ
#undef  FIXP16_TO_FLOAT
#define FIXP16_TO_FLOAT(fp)    ((fp) / FIXP16_MAG)

// 
#undef  FIXP16
#define FIXP16    unsigned int

#undef  FIXP16_PTR
#define FIXP16_PTR    (unsigned int*)

// λ
#undef  SET_BIT
#define SET_BIT(target, bitFlag)      ((target) = ((target) | (bitFlag)))

#undef  RESET_BIT
#define RESET_BIT(target, bitFlag)    ((target) = ((target) & (~bitFlag)))

/********************************************************************************
    Struct                       ݽṹ
********************************************************************************/

// 2D
typedef struct POLAR_2D_TYPE
{
    float r,     // 뾶
          theta; // Ƕ

} POLAR_2D, *POLAR_2D_PTR;

// 3D
typedef struct CYLINDRICAL_3D_TYPE
{
    float r,     // 뾶
          theta, // zļн
          z;     // z

} CYLINDRICAL_3D, *CYLINDRICAL_3D_PTR;

// 3D
typedef struct SPHERICAL_3D_TYPE
{
    float p,     // ԭľ
          theta, // ߶o->pzļн
          phi;   // ߶o->px-yƽϵͶӰxļн

} SPHERICAL_3D, *SPHERICAL_3D_PTR;

// w2D͵
typedef union VECTOR_2D_TYPE
{
    float M[2]; // 洢ʽ

    // ṹ洢ʽ
    struct VECTOR_2D_STRUCT
    {
        float x, y;
    }structa;

} VECTOR_2D, POINT_2D, *VECTOR_2D_PTR, *POINT_2D_PTR;

// w3D͵
typedef union VECTOR_3D_TYPE
{
    float M[3]; // 洢ʽ

    // ṹ洢ʽ
    struct VECTOR_3D_STRUCT
    {
        float x, y, z;
    }structa;

} VECTOR_3D, POINT_3D, *VECTOR_3D_PTR, *POINT_3D_PTR;

// w4D͵
typedef union VECTOR_4D_TYPE
{
    float M[4]; // 洢ʽ

    // ṹ洢ʽ
    struct VECTOR_4D_STRUCT
    {
        float x, y, z, w;
    }structa;

} VECTOR_4D, POINT_4D, *VECTOR_4D_PTR, *POINT_4D_PTR;

// 2x2 
typedef union MATRIX_2X2_TYPE
{
    float M[2][2]; // 洢ʽ

    // к˳Ľṹ洢ʽ
    struct MATRIX_2X2_STRUCT
    {
        float M00, M01,
              M10, M11;
    }structa;

} MATRIX_2X2, *MATRIX_2X2_PTR;

// 3x3 
typedef union MATRIX_3X3_TYPE
{
    float M[3][3]; // 洢ʽ

    // к˳Ľṹ洢ʽ
    struct MATRIX_3X3_STRUCT
    {
        float M00, M01, M02,
              M10, M11, M12,
              M20, M21, M22;
    }structa;

} MATRIX_3X3, *MATRIX_3X3_PTR;

// 4x4 
typedef union MATRIX_4X4_TYPE
{
    float M[4][4]; // 洢ʽ

    // к˳Ľṹ洢ʽ
    struct MATRIX_4X4_STRUCT
    {
        float M00, M01, M02, M03,
              M10, M11, M12, M13,
              M20, M21, M22, M23,
              M30, M31, M32, M33;
    }structa;

} MATRIX_4X4, *MATRIX_4X4_PTR;

/********************************************************************************
    Manifest Constant              
********************************************************************************/

/********************************************************************************
    Global Variable                ȫֱ
********************************************************************************/

/********************************************************************************
    Global Function Prototype    ȫֺ
********************************************************************************/

/********************************************************************************
                             16.16 ʽĶ
********************************************************************************/

// 16.16ʽ
FIXP16 z3dMulFixedPoint16(const FIXP16 fixedPointA, const FIXP16 fixedPointB);

// 16.16ʽ
FIXP16 z3dDivFixedPoint16(const FIXP16 fixedPointA, const FIXP16 fixedPointB);

/********************************************************************************
                                    Ǻ
********************************************************************************/

// ǶȺСǶȵ
float z3dSin(float theta);

// ǶȺСǶȵ
float z3dCos(float theta);

// ǶȺСǶȵ
float z3dTan(float theta);

// ȡά֮ת
double z3dGetRotateAngle(VECTOR_2D_PTR pVector2DA, VECTOR_2D_PTR pVector2DB);

/********************************************************************************
                                    ѧ
********************************************************************************/

// ʹ̩ռƼ2ƽ3.5%
float z3dSqrt2(const float x, const float y);

// ʹ̩ռƼ3ƽ8%
float z3dSqrt3(const float x, const float y, const float z);

/********************************************************************************
                                  2D꺯
********************************************************************************/

// 2DתΪ2Dֱ
void z3dPolar2DToPoint2D(const POLAR_2D_PTR pPolar2D, POINT_2D_PTR pPoint2D);

// 2DתΪ2DֱXY
void z3dPolar2DToPoint2DXY(const POLAR_2D_PTR pPolar2D, float *pX, float *pY);

// 2DֱתΪ2D
void z3dPoint2DToPolar2D(const POINT_2D_PTR pPoint2D, POLAR_2D_PTR pPolar2D);

// 2DֱתΪ2Dİ뾶Ƕ
void z3dPoint2DToPolar2DRTh(const POINT_2D_PTR pPoint2D, float *pRadius, float *pTheta);

/********************************************************************************
                                 3D꺯
********************************************************************************/

// 3DתΪ3Dֱ
void z3dCylindrical3DToPoint3D(const CYLINDRICAL_3D_PTR pCylindrical3D, POINT_3D_PTR pPoint3D);

// 3DתΪ3DXYZ
void z3dCylindrical3DToPoint3DXYZ(const CYLINDRICAL_3D_PTR pCylindrical3D, float *pX, float *pY, float *pZ);

// 3DֱתΪ3D
void Point3DToCylindrical3D(const POINT_3D_PTR pPoint3D, CYLINDRICAL_3D_PTR pCylindrical3D);

// 3DֱתΪ3Dİ뾶ZļнǡZ
void z3dPoint3DToCylindrical3DRThZ(const POINT_3D_PTR pPoint3D, float *pRadius, float *pTheta, float *pZ);

/********************************************************************************
                                 3D꺯
********************************************************************************/

// 3DתΪ3Dֱ
void z3dSpherical3DToPoint3D(const SPHERICAL_3D_PTR pSpherical3D, POINT_3D_PTR pPoint3D);

// 3DתΪ3DֱXYX
void z3dSpherical3DToPoint3DXYZ(const SPHERICAL_3D_PTR pSpherical3D, float *pX, float *pY, float *pZ);

// 3DֱתΪ3D
void z3dPoint3DToSpherical3D(const POINT_3D_PTR pPoint3D, SPHERICAL_3D_PTR pSpherical3D);

// 3DֱתΪ3Dpthetaphi
void z3dPoint3DToSpherical3DPThPh(const POINT_3D_PTR pPoint3D, float *pP, float *pTheta, float *pPhi);

/********************************************************************************
                                    2D㺯
********************************************************************************/

// 2D
void z3dCopyPoint2D(const POINT_2D_PTR pSrcPoint2D, POINT_2D_PTR pDestPoint2D);

/********************************************************************************
                                    3D㺯
********************************************************************************/

// 3D
void z3dCopyPoint3D(const POINT_3D_PTR pSrcPoint3D, POINT_3D_PTR pDestPoint3D);

/********************************************************************************
                                    4D㺯
********************************************************************************/

// 4D
void z3dCopyPoint4D(const POINT_4D_PTR pSrcPoint4D, POINT_4D_PTR pDestPoint4D);

/********************************************************************************
                                   2D
********************************************************************************/

// ʹòʼ2D
void z3dInitXYVector2D(const float x, const float y, VECTOR_2D_PTR pVector2D);

// 2Dֵ
void z3dZeroVector2D(VECTOR_2D_PTR pVector2D);

// 2D
void z3dCopyVector2D(const VECTOR_2D_PTR pSrcVector2D, VECTOR_2D_PTR pDestVector2D);

// 2D
void z3dAddVector2D(const VECTOR_2D_PTR pVector2DA, const VECTOR_2D_PTR pVector2DB, VECTOR_2D_PTR pAddVector2D);

// 2D
void z3dSubVector2D(const VECTOR_2D_PTR pVector2DA, const VECTOR_2D_PTR pVector2DB, VECTOR_2D_PTR pSubVector2D);

// ʹӶ2D
void z3dScaleVector2D(const float scalingFactor, const VECTOR_2D_PTR pVector2D, VECTOR_2D_PTR pScaledVector2D);

// 2DĵA . B
float z3dDotVector2D(const VECTOR_2D_PTR pVector2DA, const VECTOR_2D_PTR pVector2DB);

// ʹƽ͵ƽ2D
float z3dLengthVector2D(const VECTOR_2D_PTR pVector2D);

// ʹ̩ռƼ2Dȣ3.5%LengthVector2D()10
float z3dLengthFastVector2D(const VECTOR_2D_PTR pVector2D);

// 2Dһԭ2D
void z3dNormalizeVector2D(VECTOR_2D_PTR pVector2D);

// ʹ2D㴴2D
void z3dCreateVector2D(const POINT_2D_PTR pStartPoint2D, const POINT_2D_PTR pEndPoint2D, VECTOR_2D_PTR pVector2D);

// 2D֮нǵ
float z3dCosVector2D(const VECTOR_2D_PTR pVector2DA, const VECTOR_2D_PTR pVector2DB);

/********************************************************************************
                                   3D
********************************************************************************/

// ʹòʼ3D
void z3dInitXYZVector3D(const float x, const float y, const float z, VECTOR_3D_PTR pVector3D);

// 3Dֵ
void z3dZeroVector3D(VECTOR_3D_PTR pVector3D);

// 3D
void z3dCopyVector3D(const VECTOR_3D_PTR pSrcVector3D, VECTOR_3D_PTR pDestVector3D);

// 3D
void z3dAddVector3D(const VECTOR_3D_PTR pVector3DA, const VECTOR_3D_PTR pVector3DB, VECTOR_3D_PTR pAddVector3D);

// 3D
void z3dSubVector3D(const VECTOR_3D_PTR pVector3DA, const VECTOR_3D_PTR pVector3DB, VECTOR_3D_PTR pSubVector3D);

// ʹӶ3D
void z3dScaleVector3D(const float scalingFactor, const VECTOR_3D_PTR pVector3D, VECTOR_3D_PTR pScaledVector3D);

// 3DĵA . B
float z3dDotVector3D(const VECTOR_3D_PTR pVector3DA, const VECTOR_3D_PTR pVector3DB);

// 3DĲA x B
void z3dCrossVector3D(const VECTOR_3D_PTR pVector3DA, const VECTOR_3D_PTR pVector3DB, VECTOR_3D_PTR pCrossVector3D);

// ʹ͵3D
float z3dLengthVector3D(const VECTOR_3D_PTR pVector3D);

// ʹ̩ռƼ3Dȣ8%LengthVector3D()10
float z3dLengthFastVector3D(const VECTOR_3D_PTR pVector3D);

// 3Dһԭ3D
void z3dNormalizeVector3D(VECTOR_3D_PTR pVector3D);

// ʹ3D㴴3D
void z3dCreateVector3D(const POINT_3D_PTR pStartPoint3D, const POINT_3D_PTR pEndPoint3D, VECTOR_3D_PTR pVector3D);

// 3D֮нǵ
float z3dCosVector3D(const VECTOR_3D_PTR pVector3DA, const VECTOR_3D_PTR pVector3DB);

/********************************************************************************
                                   4D
********************************************************************************/

// ʹòʼ4D
void z3dInitXYZVector4D(const float x, const float y, const float z, VECTOR_4D_PTR pVector4D);

// 4Dֵ
void z3dZeroVector4D(VECTOR_4D_PTR pVector4D);

// 4D
void z3dCopyVector4D(const VECTOR_4D_PTR pSrcVector4D, VECTOR_4D_PTR pDestVector4D);

// 4DתΪ4D
void z3dVector4DDivW(VECTOR_4D_PTR pVector4D);

// 4DתΪ3D
void z3dVector4DDivWVector3D(const VECTOR_4D_PTR pVector4D, VECTOR_3D_PTR pVector3D);

// 4D
void z3dAddVector4D(const VECTOR_4D_PTR pVector4DA, const VECTOR_4D_PTR pVector4DB, VECTOR_4D_PTR pAddVector4D);

// 4D
void z3dSubVector4D(const VECTOR_4D_PTR pVector4DA, const VECTOR_4D_PTR pVector4DB, VECTOR_4D_PTR pSubVector4D);

// ʹӶ4D
void z3dScaleVector4D(const float scalingFactor, const VECTOR_4D_PTR pVector4D, VECTOR_4D_PTR pScaledVector4D);

// 4DĵA . B
float z3dDotVector4D(const VECTOR_4D_PTR pVector4DA, const VECTOR_4D_PTR pVector4DB);

// 4DĲA x B
void z3dCrossVector4D(const VECTOR_4D_PTR pVector4DA, const VECTOR_4D_PTR pVector4DB, VECTOR_4D_PTR pCrossVector4D);

// ʹ͵4D
float z3dLengthVector4D(const VECTOR_4D_PTR pVector4D);

// ʹ̩ռƼ4Dȣ8%LengthVector4D()10
float z3dLengthFastVector4D(const VECTOR_4D_PTR pVector4D);

// 4Dһԭ4D
void z3dNormalizeVector4D(VECTOR_4D_PTR pVector4D);

// ʹ4D㴴4D
void z3dCreateVector4D(const POINT_4D_PTR pStartPoint4D, const POINT_4D_PTR pEndPoint4D, VECTOR_4D_PTR pVector4D);

// 4D֮нǵ
float z3dCosVector4D(const VECTOR_4D_PTR pVector4DA, const VECTOR_4D_PTR pVector4DB);

/********************************************************************************
                                  2X2 
********************************************************************************/

// ʹָĸке˳ʼ2X2
void z3dInitMatrix2X2(const float m00, const float m01,
                             const float m10, const float m11,
                             MATRIX_2X2_PTR pMatrix2X2);

// 2X2ֵ
void z3dZeroMatrix2X2(MATRIX_2X2_PTR pMatrix2X2);

// 2X2Ϊλ
void z3dIdentityMatrix2X2(MATRIX_2X2_PTR pMatrix2X2);

// 2X2
void z3dCopyMatrix2X2(const MATRIX_2X2_PTR pSrcMatrix2X2, MATRIX_2X2_PTR pDestMatrix2X2);

// 2X2ת
void z3dTransposeMatrix2X2(const MATRIX_2X2_PTR pSrcMatrix2X2, MATRIX_2X2_PTR pDestMatrix2X2);

// 2X2ĳ滻1X2
void z3dSwapColumnMatrix2X2(const int column, const VECTOR_2D_PTR pVector2D, MATRIX_2X2_PTR pMatrix2X2);

// 2X2
void z3dAddMatrix2X2(const MATRIX_2X2_PTR pMatrix2X2A, const MATRIX_2X2_PTR pMatrix2X2B, MATRIX_2X2_PTR pAddMatrix2X2);

// 1X22X2
void z3dMulVector2DMatrix2X2(const VECTOR_2D_PTR pVector2D, const MATRIX_2X2_PTR pMatrix2X2, VECTOR_2D_PTR pMulVector2D);

// 2X2
void z3dMulMatrix2X2(const MATRIX_2X2_PTR pMatrix2X2A, const MATRIX_2X2_PTR pMatrix2X2B, MATRIX_2X2_PTR pMulMatrix2X2);

// 2X2ʽ
float z3dDetMatrix2X2(const MATRIX_2X2_PTR pMatrix2X2);

// 2X2
int z3dInverseMatrix2X2(const MATRIX_2X2_PTR pMatrix2X2, MATRIX_2X2_PTR pInverseMatrix2X2);

/********************************************************************************
                                  3X3 
********************************************************************************/

// ʹָĸке˳ʼ3X3
void z3dInitMatrix3X3(const float m00, const float m01, const float m02,
                             const float m10, const float m11, const float m12,
                             const float m20, const float m21, const float m22,
                             MATRIX_3X3_PTR pMatrix3X3);

// 3X3ֵ
void z3dZeroMatrix3X3(MATRIX_3X3_PTR pMatrix3X3);

// 3X3Ϊλ
void z3dIdentityMatrix3X3(MATRIX_3X3_PTR pMatrix3X3);

// 3X3
void z3dCopyMatrix3X3(const MATRIX_3X3_PTR pSrcMatrix3X3, MATRIX_3X3_PTR pDestMatrix3X3);

// 3X3ת
void z3dTransposeMatrix3X3(const MATRIX_3X3_PTR pSrcMatrix3X3, MATRIX_3X3_PTR pDestMatrix3X3);

// 3X3ĳ滻1X3
void z3dSwapColumnMatrix3X3(const int column, const VECTOR_3D_PTR pVector3D, MATRIX_3X3_PTR pMatrix3X3);

// 3X3
void z3dAddMatrix3X3(const MATRIX_3X3_PTR pMatrix3X3A, const MATRIX_3X3_PTR pMatrix3X3B, MATRIX_3X3_PTR pAddMatrix3X3);

// 1X33X3
void z3dMulVector3DMatrix3X3(const VECTOR_3D_PTR pVector3D, const MATRIX_3X3_PTR pMatrix3X3, VECTOR_3D_PTR pMulVector3D);

// 3X3
void z3dMulMatrix3X3(const MATRIX_3X3_PTR pMatrix3X3A, const MATRIX_3X3_PTR pMatrix3X3B, MATRIX_3X3_PTR pMulMatrix3X3);

// 3X3ʽ
float z3dDetMatrix3X3(const MATRIX_3X3_PTR pMatrix3X3);

// 3X3
int z3dInverseMatrix3X3(const MATRIX_3X3_PTR pMatrix3X3, MATRIX_3X3_PTR pInverseMatrix3X3);

/********************************************************************************
                                  4X4 
********************************************************************************/

// ʹָĸке˳ʼ4X4
void z3dInitMatrix4X4(const float m00, const float m01, const float m02, const float m03,
                             const float m10, const float m11, const float m12, const float m13,
                             const float m20, const float m21, const float m22, const float m23,
                             const float m30, const float m31, const float m32, const float m33,
                             MATRIX_4X4_PTR pMatrix4X4);

// 4X4ֵ
void z3dZeroMatrix4X4(MATRIX_4X4_PTR pMatrix4X4);

// 4X4Ϊλ
void z3dIdentityMatrix4X4(MATRIX_4X4_PTR pMatrix4X4);

// 4X4
void z3dCopyMatrix4X4(const MATRIX_4X4_PTR pSrcMatrix4X4, MATRIX_4X4_PTR pDestMatrix4X4);

// 4X4ת
void z3dTransposeMatrix4X4(const MATRIX_4X4_PTR pSrcMatrix4X4, MATRIX_4X4_PTR pDestMatrix4X4);

// 4X4ĳ滻1X4
void z3dSwapColumnMatrix4X4(const int column, const VECTOR_4D_PTR pVector4D, MATRIX_4X4_PTR pMatrix4X4);

// 4X4
void z3dAddMatrix4X4(const MATRIX_4X4_PTR pMatrix4X4A, const MATRIX_4X4_PTR pMatrix4X4B, MATRIX_4X4_PTR pAddMatrix4X4);

// 1X44X4
void z3dMulVector4DMatrix4X4(const VECTOR_4D_PTR pVector4D, const MATRIX_4X4_PTR pMatrix4X4, VECTOR_4D_PTR pMulVector4D);

// 4X4
void z3dMulMatrix4X4(const MATRIX_4X4_PTR pMatrix4X4A, const MATRIX_4X4_PTR pMatrix4X4B, MATRIX_4X4_PTR pMulMatrix4X4);

// 4X4ʽ
float z3dDetMatrix4X4(const MATRIX_4X4_PTR pMatrix4X4A);

// 4X4
int z3dInverseMatrix4X4(const MATRIX_4X4_PTR pMatrix4X4, MATRIX_4X4_PTR pInverseMatrix4X4);

#ifdef __cplusplus
}
#endif

#endif
