#ifndef _Z_LAYER_H
#define _Z_LAYER_H

#ifdef __cplusplus
extern "C" {
#endif

/* Ԥͼ */
#define HLAYER_NULL      0x0
#define HLAYER_INVALID 0xFfFfFfFf

/* Ԥ */
#define LAYER_ERR_OK      0
#define LAYER_ERR_FAILED -1


/* ͼֵڸ/ȡͼʱָͼĳһ */
#define LAYER_ATTR_ID            0x0001 //ͼID
#define LAYER_ATTR_PIXEL_TYPE    0x0002 //ͼظʽ
#define LAYER_ATTR_OFFSET        0x0004 //ͼ X/Y ƫ
#define LAYER_ATTR_DIMENSION     0x0008 //ͼ߶
#define LAYER_ATTR_BITSPERPIXEL  0x0010 //ͼÿռñ
#define LAYER_ATTR_BYTESPERPIXEL 0x0020 //ͼÿռֽ
#define LAYER_ATTR_COLORKEY      0x0040 //ͼ͸ɫ
#define LAYER_ATTR_OPACITY       0x0080 //ͼ͸
#define LAYER_ATTR_MASK          0x0100 //ͼ͸ȱ
#define LAYER_ATTR_ROTATION      0x0200 //ͼתǶ
#define LAYER_ATTR_BUFFER        0x0400 //ͼ㻺
#define LAYER_ATTR_PITCH         0x0800 //ͼÿռֽ
#define LAYER_ATTR_CLIP_RECT     0x1000 //ͼü
#define LAYER_ATTR_ALL           0x1FFF //ͼֵ

/* ͼ */
typedef ZUINT32  HLAYER;

/* ͼԽṹ */
typedef struct _layerAttr
{
    ZUINT32 ID;            //ͼID
    ZUINT32 pixType;       //ͼظʽ
    ZSINT32 offsetX;       //ͼ X ƫ
    ZSINT32 offsetY;       //ͼ Y ƫ
    ZUINT32 width;         //ͼ
    ZUINT32 height;        //ͼ߶
    ZUINT32 bitsPerPixel;  //ͼÿռõı
    ZUINT32 bytesPerPixel; //ͼÿռõֽ
    ZUINT32 colorkey;      //ͼ͸ɫ(ؼɫ)
    ZUINT32 opacity;       //ͼ͸(ȫ͸ֵ)
    ZCHAR*  pMask;         //ͼģ(͸ȱ)
    ZUINT32 rotation;      //ͼתǶ
    ZCHAR*  pFrontBuf;     //ͼǰַ
    ZCHAR*  pBackBuf;      //ͼ󻺴ַ
    ZUINT32 uPitch;        //ͼ㻺ÿռõֽ
    RECT    clipRect;      //ͼü
}LAYERATTR;

/* ͼĿṹ */
typedef struct _LAYERBLENDINFO
{
    ZUINT32 width;        //Ŀ
    ZUINT32 height;       //Ŀ߶
    ZUINT32 bitsPerPixel; //Ŀÿռñ
    ZUINT32 bytesPerPixel;//Ŀÿռֽ
    ZUINT32 uPitch;       //Ŀÿռֽ
    ZCHAR*  pMemBuf;      //Ŀַ
    RECT    blendRect;    //ĿĴС
}LAYERBLENDINFO;




/**************************************************************************
* ƣ CreateLayer
*  һµĿɻͼ
* ˵ (IN)
*            (OUT)
*   ֵ ´Ŀɻͼ
* ˵ ѡ
**************************************************************************/
HLAYER CreateLayer(ZVOID);

/**************************************************************************
* ƣ CreateMemLayer
*  һɻڴͼ
* ˵ (IN)
*            (OUT)
*   ֵ ´Ŀɻڴͼ
* ˵ ѡ
**************************************************************************/
HLAYER CreateMemLayer(ZVOID);

/**************************************************************************
* ƣ DestroyLayer
*  ͷѴĿɻͼ
* ˵ (IN)
*            HLAYER hFreeLayer : ҪͷŵĿɻͼ
*            (OUT)
*   ֵ ɹ LAYER_ERR_OK ,򷵻 LAYER_ERR_FAILED .
* ˵ ѡ
**************************************************************************/
ZSINT32 DestroyLayer(HLAYER hFreeLayer);

/**************************************************************************
* ƣ SetActiveLayer
*  õǰĿɻͼ
* ˵ (IN)
*            HLAYER hLayer : ûָĿɻͼ
*            (OUT)
*   ֵ ɹ LAYER_ERR_OK ,򷵻 LAYER_ERR_FAILED .
* ˵ ѡ
**************************************************************************/
ZSINT32 SetActiveLayer(HLAYER hLayer);

/**************************************************************************
* ƣ GetActiveLayer
*  ȡǰĿɻͼ
* ˵ (IN)
*            (OUT)
*   ֵ صǰĿɻͼ
* ˵ ѡ
**************************************************************************/
HLAYER GetActiveLayer(ZVOID);

/**************************************************************************
* ƣ ResetActiveLayer
*  õǰͼΪĬͼ
* ˵ (IN)
*            (OUT)
*   ֵ 
* ˵ ϵͳĬͼΪͼ0
**************************************************************************/
ZSINT32 ResetActiveLayer(ZVOID);

/**************************************************************************
* ƣ IsMultiLayerEnabled
*  ȡϵͳãж϶ͼ㹦Ƿ
* ˵ (IN)
*            (OUT)
*   ֵ ͼ㹦ܿ÷TRUE,򷵻FALSE.
* ˵ ѡ
**************************************************************************/
ZBOOL IsMultiLayerEnabled(ZVOID);

/**************************************************************************
* ƣ GetLayerInfo
*  ȡͼϢ
* ˵ (IN)
*            HLAYER hLayer: õͼ
*            LAYERATTR* layerInfo:ͼϢָ
*            ZUINT32 attr:ȡͼϢĲ
*            (OUT)
*   ֵ ɹ:LAYER_ERR_OK;ʧ:LAYER_ERR_FAILED
* ˵ attr ȡͷļеͼԺ궨ֵһ򼸸"|"ֵ
**************************************************************************/
ZSINT32 GetLayerInfo(HLAYER hLayer, LAYERATTR* layerInfo, ZUINT32 attr);

/**************************************************************************
* ƣ SetLayerInfo
*  ͼϢ
* ˵ (IN)
*            HLAYER hLayer: õͼ
*            LAYERATTR* layerInfo:ͼϢָ
*            ZUINT32 attr:ȡͼϢĲ
*            (OUT)
*   ֵ ɹ:LAYER_ERR_OK;ʧ:LAYER_ERR_FAILED
* ˵ attr ȡͷļеͼԺ궨ֵһ򼸸"|"ֵ
**************************************************************************/
ZSINT32 SetLayerInfo(HLAYER hLayer, LAYERATTR* layerInfo, ZUINT32 attr);

/**************************************************************************
* ƣ UpdateLayerRect
*  ûָݵԴ
* ˵ (IN)
*            RECT *rct : ûָˢ
*            (OUT)
*   ֵ ɹ LAYER_ERR_OK ,򷵻 LAYER_ERR_FAILED .
* ˵ ѡ
**************************************************************************/
ZSINT32 UpdateLayerRect(RECT *rct);

/**************************************************************************
* ƣ BlendLayers
*  ָĶͼݲԴ
* ˵ (IN)
*            HLAYER *hLayer    : ϵͼַ
*            ZSINT32 layerSize : ϵͼ
*            RECT *rct : µС
*            (OUT)
*   ֵ ɹ LAYER_ERR_OK ,򷵻 LAYER_ERR_FAILED .
* ˵ ѡ
**************************************************************************/
ZSINT32 BlendLayers(HLAYER *hLayer, ZSINT32 layerSize, RECT *rct);

/**************************************************************************
* ƣ BlendLayersToBuffer
*  ָĶͼݲĿ껺
* ˵ (IN)
*            HLAYER *hLayer    : ϵͼַ
*            ZSINT32 layerSize : ϵͼ
*            LAYERBLENDINFO *dst :ͼϽĿ漰Ϣ
*            (OUT)
*   ֵ ɹ LAYER_ERR_OK ,򷵻 LAYER_ERR_FAILED .
* ˵ ѡ
**************************************************************************/
ZSINT32 BlendLayersToBuffer(HLAYER *hLayer, ZSINT32 layerSize, LAYERBLENDINFO *dst);

/**************************************************************************
* ƣ BlendLayersToLayer
*  ָĶͼݲĿͼ
* ˵ (IN)
*            HLAYER *hLayer    : ϵͼַ
*            ZSINT32 layerSize : ϵͼ
*            HLAYER  dstLayer  : ϵĿͼ
*            (OUT)
*   ֵ ɹ LAYER_ERR_OK ,򷵻 LAYER_ERR_FAILED .
* ˵ ѡ
**************************************************************************/
ZSINT32 BlendLayersToLayer(HLAYER *hLayer, ZSINT32 layerSize, HLAYER dstLayer);

#ifdef __cplusplus
}
#endif
#endif
