#ifndef _ZCORE_DLG_H
#define _ZCORE_DLG_H
#include "zcore_type.h"

/****Dialog codes*****/
/*Control wants arrow keys*/
#define DLGC_WANTARROWS     	0x0001
/*Control wants tab keys*/
#define DLGC_WANTTAB        	0x0002
/*Control wants all keys*/
#define DLGC_WANTALLKEYS    	0x0004
/*Control wants MSG_CHAR messages*/
#define DLGC_WANTCHARS      	0x0008
/*Control wants enter keys*/
#define DLGC_WANTENTER      	0x0010
/*Understands EM_SETSEL message*/
#define DLGC_HASSETSEL      	0x0080

/*Default pushbutton*/
#define DLGC_DEFPUSHBUTTON  	0x0100
/*Non-default pushbutton*/
#define DLGC_PUSHBUTTON     	0x0200
/*Radio button*/
#define DLGC_RADIOBUTTON    	0x0400
/*3 States button item*/
#define DLGC_3STATE         	0x0800
/*Static item: don't include*/
#define DLGC_STATIC         	0x1000
/*Button item: can be checked*/
#define DLGC_BUTTON         	0x2000

/*defines a control.*/
typedef struct _CTRLDATA
{
    /*class name of the control*/
    const ZCHAR* class_name;
    /*style*/
    ZDWORD       dwStyle;
    /*control position in dialog*/
    ZSINT32         x, y, w, h;
    /*identifier*/
    ZSINT32         id;
    /*caption*/
    const ZCHAR* caption;
    /*additional data*/
    ZDWORD       dwAddData;
    /*extended style*/
    ZDWORD       dwExStyle;
} CTRLDATA;
typedef CTRLDATA* PCTRLDATA;

/*defines a dialogbox.*/
typedef struct _DLGTEMPLATE
{
    /*dialog box style*/
    ZDWORD       dwStyle;
    /*dialog box extended style*/
    ZDWORD       dwExStyle;
    /*dialog box position*/
    ZSINT32         x, y, w, h;
    /*dialog box caption*/
    const ZCHAR* caption;
    /*dialog box icon*/
    HICON       hIcon;
    /*dialog box menu*/
    HMENU       hMenu;
    /*number of controls*/
    ZSINT32         controlnr;
    PCTRLDATA   controls;
    /*addtional data, must be zero*/
    ZDWORD       dwAddData;
} DLGTEMPLATE;
typedef DLGTEMPLATE* PDLGTEMPLATE;

/*Uses a dialog template to create a modeless main window and controls in it, and pass
  a parameter to the window procedure.*/
HWND CreateMainWindowIndirectParam (PDLGTEMPLATE pDlgTemplate, HWND hOwner, WNDPROC WndProc, LPARAM lParam);

#define CreateMainWindowIndirect(pDlgTemplate, hOwner, WndProc) \
            CreateMainWindowIndirectParam(pDlgTemplate, hOwner, WndProc, 0)

/*Uses a dialog template to create a modeless main window and controls in it, and pass
  a parameter to the window procedure.*/
HWND CreateMainWindowIndirectParamAndRotation (PDLGTEMPLATE pDlgTemplate, HWND hOwner, WNDPROC WndProc, LPARAM lParam, SINT32 Rotation);

#ifdef _TOUCHWIZ_EFFECTS
/* Իģ崰ڣʾ*/
HWND CreateMainWindowIndirectParamEX (PDLGTEMPLATE pDlgTemplate, HWND hOwner, WNDPROC WndProc, LPARAM lParam);
#endif

/*Destroys a main window created*/
ZBOOL DestroyMainWindowIndirect (HWND hMainWin);

/*Creates a modal dialog box from a dialog box template in memory.*/
ZSINT32 DialogBoxIndirectParam (PDLGTEMPLATE pDlgTemplate, HWND hOwner, WNDPROC DlgProc, LPARAM lParam);

/*Destroys a modal dialog box, causing GUI to end any processing for the dialog box.*/
ZBOOL EndDialog (HWND hDlg, ZSINT32 endCode);

/*Destroys all controls in a window.*/
ZVOID DestroyAllControls (HWND hWnd);

/*default dialog box procedure.*/
ZSINT32 DefaultDialogProc (HWND hWnd, ZSINT32 message, WPARAM wParam, LPARAM lParam);

/*Gets the default push button control in a window.*/
HWND GetDlgDefPushButton (HWND hWnd);

/*Gets the integer identifier of a control.*/
ZSINT32 GetDlgCtrlID (HWND hwndCtl);

/*Retrives the handle to a control in a dialog box.*/
HWND GetDlgItem (HWND hDlg, ZSINT32 nIDDlgItem);

/*Retrieves the title or text associated with a control in a dialog box.*/
ZSINT32 GetDlgItemText (HWND hDlg, ZSINT32 nIDDlgItem, ZCHAR* lpString, ZSINT32 nMaxCount);

/*Sends a message to the specified control in a dialog box.*/
ZSINT32 SendDlgItemMessage ( HWND hDlg, ZSINT32 nIDDlgItem, ZSINT32 message, WPARAM wParam, LPARAM lParam);

/*Sets the title or text of a control in a dialog box.*/
ZBOOL SetDlgItemText (HWND hDlg, ZSINT32 nIDDlgItem, const ZCHAR* lpString);

/*Retrieves the handle to the first control that has the WS_TABSTOP style that precedes
  (or follows) the specified control.*/
HWND GetNextDlgTabItem (HWND hDlg, HWND hCtl, ZBOOL bPrevious);

HMENU CreateSystemMenu (HWND hwnd, ZDWORD dwStyle);

#endif//_ZCORE_DLG_H
